/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.templateLanguages;

import com.intellij.DynamicBundle;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.python.templateLanguages.PyTemplateLanguageRenderer;
import com.intellij.template.lang.core.templateLanguages.PyTemplatesBundle;
import com.intellij.template.lang.core.templateLanguages.PythonTemplateLanguage;
import com.intellij.template.lang.core.templateLanguages.TemplateSettingsHolder;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TemplateLanguagePanel
extends JPanel {
    private JTextField myTemplatesFolder;
    private JPanel myMainPanel;
    private JLabel myTemplatesFolderLabel;
    private JComboBox<PythonTemplateLanguage> myTemplateLanguage;
    private boolean myTemplateFolderModified;
    private static final String DEFAULT_TEMPLATES_FOLDER = "templates";

    public TemplateLanguagePanel(PythonTemplateLanguage ... supportedLanguages) {
        if (supportedLanguages == null) {
            TemplateLanguagePanel.$$$reportNull$$$0(0);
        }
        this(Arrays.asList(supportedLanguages));
    }

    public TemplateLanguagePanel(@NotNull Collection<? extends @Nullable PythonTemplateLanguage> supportedLanguages) {
        if (supportedLanguages == null) {
            TemplateLanguagePanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myTemplateFolderModified = false;
        this.$$$setupUI$$$();
        this.myTemplateLanguage.setRenderer(new PyTemplateLanguageRenderer());
        this.add((Component)this.myMainPanel, "Center");
        this.myTemplatesFolderLabel.setLabelFor(this.myTemplatesFolder);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.withTreeRootVisible(true);
        descriptor.setShowFileSystemRoots(true);
        for (PythonTemplateLanguage pythonTemplateLanguage : supportedLanguages) {
            this.myTemplateLanguage.addItem(pythonTemplateLanguage);
        }
        this.myTemplatesFolder.setText(DEFAULT_TEMPLATES_FOLDER);
        this.myTemplatesFolder.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                int dot = TemplateLanguagePanel.this.myTemplatesFolder.getCaret().getDot();
                int index = TemplateLanguagePanel.this.myTemplatesFolder.getText().indexOf(File.separator);
                if (index >= dot) {
                    TemplateLanguagePanel.this.myTemplateFolderModified = true;
                }
            }
        });
    }

    public String getTemplatesFolder() {
        return this.myTemplatesFolder.getText();
    }

    @Nullable
    public PythonTemplateLanguage getTemplateLanguage() {
        return (PythonTemplateLanguage)((Object)this.myTemplateLanguage.getSelectedItem());
    }

    public void setTemplateLanguage(@Nullable PythonTemplateLanguage templateLanguage) {
        this.myTemplateLanguage.setSelectedItem((Object)templateLanguage);
    }

    public void saveSettings(TemplateSettingsHolder holder) {
        holder.setTemplatesFolder(this.getTemplatesFolder());
        PythonTemplateLanguage templateLanguage = this.getTemplateLanguage();
        holder.setTemplateLanguage(templateLanguage);
    }

    public void setTemplatesFolder(@NotNull String folder) {
        if (folder == null) {
            TemplateLanguagePanel.$$$reportNull$$$0(2);
        }
        this.myTemplatesFolder.setText(folder);
    }

    public void locationChanged(@NotNull String baseLocation) {
        String oldBase;
        String templatesFolder;
        int index;
        if (baseLocation == null) {
            TemplateLanguagePanel.$$$reportNull$$$0(3);
        }
        Object templateFolderName = (index = (templatesFolder = this.myTemplatesFolder.getText()).indexOf(File.separator)) >= 0 ? templatesFolder.substring(index) : File.separator + DEFAULT_TEMPLATES_FOLDER;
        String string = oldBase = index >= 0 ? templatesFolder.substring(0, index) : "";
        if (oldBase.equals(baseLocation)) {
            this.myTemplateFolderModified = false;
        }
        if (!this.myTemplateFolderModified) {
            this.myTemplatesFolder.setText(baseLocation + (String)templateFolderName);
        }
    }

    public Dimension getLabelSize() {
        return new JBLabel(PyTemplatesBundle.message("python.template.language.choose", new Object[0])).getPreferredSize();
    }

    public void registerValidators(final FacetValidatorsManager validatorsManager) {
        this.myTemplateLanguage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                validatorsManager.validate();
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JLabel jLabel;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myTemplateLanguage = jComboBox;
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/PyTemplatesBundle", TemplateLanguagePanel.class).getString("python.template.language.choose"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTemplatesFolderLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PyTemplatesBundle", TemplateLanguagePanel.class).getString("python.templates.folder"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTemplatesFolder = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedLanguages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLocation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/templateLanguages/TemplateLanguagePanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setTemplatesFolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "locationChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

