/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.file.singleFile;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileUtils;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0006J\u0016\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/jupyter/core/core/impl/file/singleFile/JupyterFileModelCache;", "", "<init>", "()V", "JUPYTER_NOTEBOOK_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "JUPYTER_PERSISTENT_COUNT", "Ljava/util/concurrent/atomic/AtomicInteger;", "getForFile", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "loadNotebook", "", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "customNotebook", "registryForDisposable", "disposable", "Lcom/intellij/openapi/Disposable;", "get", "updateLineSeparatorsIfRequired", "file", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterFileModelCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterFileModelCache.kt\ncom/intellij/jupyter/core/core/impl/file/singleFile/JupyterFileModelCache\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 UserDataHolderEx.kt\ncom/intellij/openapi/util/UserDataHolderExKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n25#2:105\n11#3:106\n12#3:108\n1#4:107\n*S KotlinDebug\n*F\n+ 1 JupyterFileModelCache.kt\ncom/intellij/jupyter/core/core/impl/file/singleFile/JupyterFileModelCache\n*L\n54#1:105\n59#1:106\n59#1:108\n59#1:107\n*E\n"})
public final class JupyterFileModelCache {
    @NotNull
    public static final JupyterFileModelCache INSTANCE = new JupyterFileModelCache();
    @NotNull
    private static final Key<JupyterNotebook> JUPYTER_NOTEBOOK_KEY = new Key("JUPYTER_NOTEBOOK_KEY");
    @NotNull
    private static final Key<AtomicInteger> JUPYTER_PERSISTENT_COUNT = new Key("JUPYTER_NOTEBOOK_USE_COUNT");

    private JupyterFileModelCache() {
    }

    @Nullable
    public final JupyterNotebook getForFile(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        return this.get(virtualFile2);
    }

    public final void loadNotebook(@NotNull BackedNotebookVirtualFile virtualFile2, @Nullable JupyterNotebook customNotebook) {
        JupyterNotebook newNotebook;
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        JupyterNotebook exists = (JupyterNotebook)virtualFile2.getFile().getUserData(JUPYTER_NOTEBOOK_KEY);
        JupyterNotebook jupyterNotebook = customNotebook;
        if (jupyterNotebook == null) {
            jupyterNotebook = newNotebook = (JupyterNotebook)JupyterFileUtils.INSTANCE.readNotebook(virtualFile2.getFile());
        }
        if (exists != null && !PlatformUtils.isJetBrainsClient()) {
            exists.getJson().removeAll();
            exists.getJson().setAll(newNotebook.getJson());
        } else {
            virtualFile2.getFile().putUserData(JUPYTER_NOTEBOOK_KEY, (Object)newNotebook);
        }
    }

    public static /* synthetic */ void loadNotebook$default(JupyterFileModelCache jupyterFileModelCache, BackedNotebookVirtualFile backedNotebookVirtualFile, JupyterNotebook jupyterNotebook, int n, Object object) {
        if ((n & 2) != 0) {
            jupyterNotebook = null;
        }
        jupyterFileModelCache.loadNotebook(backedNotebookVirtualFile, jupyterNotebook);
    }

    /*
     * WARNING - void declaration
     */
    public final void registryForDisposable(@NotNull BackedNotebookVirtualFile virtualFile2, @NotNull Disposable disposable) {
        Object object;
        void $this$getOrCreateUserData$iv;
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        if (virtualFile2.getNotebookOrNull() == null) {
            JupyterFileModelCache $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterFileModelCache.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Notebook is not loaded for " + virtualFile2.getFile().getPath());
            return;
        }
        VirtualFile file = virtualFile2.getFile();
        UserDataHolderEx userDataHolderEx = (UserDataHolderEx)file;
        Key<AtomicInteger> key$iv = JUPYTER_PERSISTENT_COUNT;
        boolean $i$f$getOrCreateUserData = false;
        Object object2 = $this$getOrCreateUserData$iv.getUserData(key$iv);
        if (object2 != null) {
            Object it$iv = object2;
            boolean bl = false;
            object = it$iv;
        } else {
            Key<AtomicInteger> key = key$iv;
            void var11_13 = $this$getOrCreateUserData$iv;
            boolean bl = false;
            AtomicInteger atomicInteger = new AtomicInteger(0);
            object = var11_13.putUserDataIfAbsent(key, (Object)atomicInteger);
        }
        AtomicInteger counter = (AtomicInteger)object;
        Disposer.register((Disposable)disposable, () -> JupyterFileModelCache.registryForDisposable$lambda$3(counter, file, virtualFile2));
        counter.incrementAndGet();
    }

    @Nullable
    public final JupyterNotebook get(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        return (JupyterNotebook)virtualFile2.getUserData(JUPYTER_NOTEBOOK_KEY);
    }

    private final void updateLineSeparatorsIfRequired(BackedNotebookVirtualFile virtualFile2, VirtualFile file) {
        String checked;
        String separator = LoadTextUtil.detectLineSeparator((VirtualFile)virtualFile2.getFile(), (boolean)false);
        if (separator == null && (checked = LoadTextUtil.detectLineSeparator((VirtualFile)virtualFile2.getFile(), (boolean)true)) == null) {
            file.setDetectedLineSeparator("\n");
        }
    }

    private static final Unit registryForDisposable$lambda$3$lambda$2$lambda$1(FileDocumentManager $fileDocumentManager, Document $cachedDocument) {
        $fileDocumentManager.saveDocument($cachedDocument);
        return Unit.INSTANCE;
    }

    private static final Unit registryForDisposable$lambda$3$lambda$2(FileDocumentManager $fileDocumentManager, Document $cachedDocument) {
        ActionsKt.runWriteAction(() -> JupyterFileModelCache.registryForDisposable$lambda$3$lambda$2$lambda$1($fileDocumentManager, $cachedDocument));
        return Unit.INSTANCE;
    }

    private static final void registryForDisposable$lambda$3(AtomicInteger $counter, VirtualFile $file, BackedNotebookVirtualFile $virtualFile) {
        int count = $counter.decrementAndGet();
        if (count == 0) {
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
            FileDocumentManager fileDocumentManager2 = fileDocumentManager;
            Document cachedDocument = fileDocumentManager2.getCachedDocument($file);
            if (cachedDocument != null) {
                INSTANCE.updateLineSeparatorsIfRequired($virtualFile, $file);
                ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.nonModal(), () -> JupyterFileModelCache.registryForDisposable$lambda$3$lambda$2(fileDocumentManager2, cachedDocument));
            }
            RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)$file), JUPYTER_NOTEBOOK_KEY);
        }
    }
}

