/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.codeInsight.PyCustomMemberUtils;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElsePart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatementPart;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypeParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyResolveResultRater;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.impl.references.PyReferenceImpl;
import com.jetbrains.python.psi.resolve.CompletionVariantsProcessor;
import com.jetbrains.python.psi.resolve.ImportedResolveResult;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveProcessor;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassMembersProvider;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyOverridingAncestorsClassMembersProvider;
import com.jetbrains.python.psi.types.PyOverridingClassMembersProvider;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.refactoring.PyDefUseUtil;
import com.jetbrains.python.toolbox.Maybe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyClassTypeImpl
extends UserDataHolderBase
implements PyClassType {
    @NotNull
    protected final PyClass myClass;
    protected final boolean myIsDefinition;
    private static final Key<Set<PyClassType>> CTX_VISITED = Key.create((String)"PyClassType.Visited");
    public static final Key<Boolean> CTX_SUPPRESS_PARENTHESES = Key.create((String)"PyFunction.SuppressParentheses");

    public PyClassTypeImpl(@NotNull PyClass source, boolean isDefinition) {
        if (source == null) {
            PyClassTypeImpl.$$$reportNull$$$0(0);
        }
        PyClass originalElement = (PyClass)CompletionUtilCoreImpl.getOriginalElement((PsiElement)source);
        this.myClass = originalElement != null ? originalElement : source;
        this.myIsDefinition = isDefinition;
    }

    public <T> PyClassTypeImpl withUserData(Key<T> key, T value) {
        this.putUserData(key, value);
        return this;
    }

    @Override
    @NotNull
    public PyClass getPyClass() {
        PyClass pyClass = this.myClass;
        if (pyClass == null) {
            PyClassTypeImpl.$$$reportNull$$$0(1);
        }
        return pyClass;
    }

    @Override
    @NotNull
    public PyQualifiedNameOwner getDeclarationElement() {
        PyClass pyClass = this.getPyClass();
        if (pyClass == null) {
            PyClassTypeImpl.$$$reportNull$$$0(2);
        }
        return pyClass;
    }

    @Override
    public boolean isDefinition() {
        return this.myIsDefinition;
    }

    @Override
    @NotNull
    public PyClassType toInstance() {
        PyClassTypeImpl pyClassTypeImpl = this.myIsDefinition ? this.withUserDataCopy(new PyClassTypeImpl(this.myClass, false)) : this;
        if (pyClassTypeImpl == null) {
            PyClassTypeImpl.$$$reportNull$$$0(3);
        }
        return pyClassTypeImpl;
    }

    @Override
    @NotNull
    public PyClassLikeType toClass() {
        return this.myIsDefinition ? this : new PyClassTypeImpl(this.myClass, true);
    }

    @NotNull
    final <T extends PyClassTypeImpl> T withUserDataCopy(@NotNull T newInstance) {
        if (newInstance == null) {
            PyClassTypeImpl.$$$reportNull$$$0(4);
        }
        newInstance.setUserMap(this.getUserMap());
        T t = newInstance;
        if (t == null) {
            PyClassTypeImpl.$$$reportNull$$$0(5);
        }
        return t;
    }

    @Override
    @Nullable
    public String getClassQName() {
        return this.myClass.getQualifiedName();
    }

    @Override
    @NotNull
    public List<PyClassLikeType> getSuperClassTypes(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(6);
        }
        List<PyClassLikeType> list = this.myClass.getSuperClassTypes(context);
        if (list == null) {
            PyClassTypeImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name2, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        if (name2 == null) {
            PyClassTypeImpl.$$$reportNull$$$0(8);
        }
        if (direction == null) {
            PyClassTypeImpl.$$$reportNull$$$0(9);
        }
        if (resolveContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(10);
        }
        return this.resolveMember(name2, location, direction, resolveContext, true);
    }

    @Override
    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name2, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext, boolean inherited) {
        if (name2 == null) {
            PyClassTypeImpl.$$$reportNull$$$0(11);
        }
        if (direction == null) {
            PyClassTypeImpl.$$$reportNull$$$0(12);
        }
        if (resolveContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(13);
        }
        return (List)RecursionManager.doPreventingRecursion(resolveContext.allowProperties() ? Arrays.asList(this, name2, location, direction, resolveContext) : Arrays.asList(this, name2, location, resolveContext), (boolean)false, () -> this.doResolveMember(name2, location, direction, resolveContext, inherited));
    }

    @Nullable
    private List<? extends RatedResolveResult> doResolveMember(@NotNull String name2, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext, boolean inherited) {
        List<? extends RatedResolveResult> typeMembers;
        PyType first_arg_type;
        PyExpression first_arg;
        Ref<ResolveResultList> resultRef;
        if (name2 == null) {
            PyClassTypeImpl.$$$reportNull$$$0(14);
        }
        if (direction == null) {
            PyClassTypeImpl.$$$reportNull$$$0(15);
        }
        if (resolveContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(16);
        }
        TypeEvalContext context = resolveContext.getTypeEvalContext();
        PsiElement classMember = PyClassTypeImpl.resolveByOverridingMembersProviders(this, name2, (PsiElement)location, resolveContext);
        if (classMember != null) {
            return ResolveResultList.to(classMember);
        }
        if (resolveContext.allowProperties() && (resultRef = this.findProperty(name2, direction, false, resolveContext.getTypeEvalContext())) != null) {
            return (List)resultRef.get();
        }
        if ("super".equals(this.getClassQName()) && this.isBuiltin() && location instanceof PyCallExpression && (first_arg = (PyExpression)((PyCallExpression)location).getArgument(0, PyExpression.class)) != null && (first_arg_type = context.getType(first_arg)) instanceof PyClassType) {
            PyClass derived_class = ((PyClassType)first_arg_type).getPyClass();
            Iterator<PyClass> base_it = derived_class.getAncestorClasses(context).iterator();
            if (base_it.hasNext()) {
                return new PyClassTypeImpl(base_it.next(), true).resolveMember(name2, location, direction, resolveContext);
            }
            return null;
        }
        List<? extends RatedResolveResult> classMembers = PyClassTypeImpl.resolveInner(this.myClass, this.myIsDefinition, name2, location, context);
        if (!classMembers.isEmpty()) {
            return classMembers;
        }
        classMember = PyClassTypeImpl.resolveByOverridingAncestorsMembersProviders(this, name2, location, resolveContext);
        if (classMember != null) {
            ResolveResultList list = new ResolveResultList();
            int rate = 0;
            for (PyResolveResultRater rater : PyResolveResultRater.EP_NAME.getExtensionList()) {
                rate += rater.getMemberRate(classMember, this, context);
            }
            list.poke(classMember, rate);
            return list;
        }
        if (inherited) {
            for (PyClassLikeType type2 : this.myClass.getAncestorTypes(context)) {
                List<? extends RatedResolveResult> results;
                if (type2 instanceof PyClassType) {
                    List<? extends RatedResolveResult> superMembers;
                    if (!this.myIsDefinition) {
                        type2 = (PyClassLikeType)type2.toInstance();
                    }
                    if (!(superMembers = PyClassTypeImpl.resolveInner(((PyClassType)type2).getPyClass(), this.myIsDefinition, name2, location, context)).isEmpty()) {
                        return superMembers;
                    }
                }
                if (type2 == null || (results = type2.resolveMember(name2, location, direction, resolveContext, false)) == null || results.isEmpty()) continue;
                return results;
            }
        }
        if (inherited && !"__init__".equals(name2) && !"__new__".equals(name2) && (typeMembers = this.resolveMetaClassMember(name2, location, direction, resolveContext)) != null) {
            return typeMembers;
        }
        if (inherited) {
            classMember = PyClassTypeImpl.resolveByMembersProviders(this, name2, (PsiElement)location, resolveContext);
        }
        if (classMember != null) {
            return ResolveResultList.to(classMember);
        }
        if (inherited) {
            for (PyClassLikeType type2 : this.myClass.getAncestorTypes(context)) {
                PyClass pyClass;
                PsiElement superMember;
                if (!(type2 instanceof PyClassType) || (superMember = PyClassTypeImpl.resolveByMembersProviders(new PyClassTypeImpl(pyClass = ((PyClassType)type2).getPyClass(), this.isDefinition()), name2, (PsiElement)location, resolveContext)) == null) continue;
                return ResolveResultList.to(superMember);
            }
        }
        return Collections.emptyList();
    }

    @Nullable
    private List<? extends RatedResolveResult> resolveMetaClassMember(@NotNull String name2, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        List typeInstanceAttributesWithSpecifiedName;
        List<PyTargetExpression> typeInstanceAttributes;
        TypeEvalContext context;
        if (name2 == null) {
            PyClassTypeImpl.$$$reportNull$$$0(17);
        }
        if (direction == null) {
            PyClassTypeImpl.$$$reportNull$$$0(18);
        }
        if (resolveContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(19);
        }
        if (!this.myClass.isNewStyleClass(context = resolveContext.getTypeEvalContext())) {
            return null;
        }
        PyClassLikeType typeType = this.getMetaClassType(context, true);
        if (typeType == null) {
            return null;
        }
        if (this.isDefinition()) {
            List<? extends RatedResolveResult> typeMembers = typeType.resolveMember(name2, location, direction, resolveContext);
            if (!ContainerUtil.isEmpty(typeMembers)) {
                return typeMembers;
            }
            List<? extends RatedResolveResult> typeInstanceMembers = ((PyClassLikeType)typeType.toInstance()).resolveMember(name2, location, direction, resolveContext);
            if (!ContainerUtil.isEmpty(typeInstanceMembers)) {
                return typeInstanceMembers;
            }
        } else if (typeType instanceof PyClassType && !ContainerUtil.isEmpty(typeInstanceAttributes = ((PyClassType)typeType).getPyClass().getInstanceAttributes()) && !(typeInstanceAttributesWithSpecifiedName = typeInstanceAttributes.stream().filter(member -> name2.equals(member.getName())).map(member -> new RatedResolveResult(PyReferenceImpl.getRate(member, context), (PsiElement)member)).collect(Collectors.toList())).isEmpty()) {
            return typeInstanceAttributesWithSpecifiedName;
        }
        return null;
    }

    private Ref<ResolveResultList> findProperty(String name2, AccessDirection direction, boolean inherited, @Nullable TypeEvalContext context) {
        Maybe<PyCallable> accessor;
        Ref resultRef = null;
        Property property = this.myClass.findProperty(name2, inherited, context);
        if (property != null && (accessor = property.getByDirection(direction)).isDefined()) {
            PyTargetExpression site;
            PyCallable accessor_code = accessor.value();
            ResolveResultList ret = new ResolveResultList();
            if (accessor_code != null) {
                ret.poke((PsiElement)accessor_code, 0);
            }
            if ((site = property.getDefinitionSite()) != null) {
                ret.poke(site, -1000);
            }
            resultRef = !ret.isEmpty() ? Ref.create((Object)ret) : Ref.create();
        }
        return resultRef;
    }

    @Override
    @Nullable
    public PyClassLikeType getMetaClassType(@NotNull TypeEvalContext context, boolean inherited) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(20);
        }
        return this.myClass.getMetaClassType(inherited, context);
    }

    @Override
    public boolean isCallable() {
        if (this.isDefinition()) {
            return true;
        }
        if (PyClassTypeImpl.isMethodType(this)) {
            return true;
        }
        PyClass cls = this.getPyClass();
        return PyABCUtil.isSubclass(cls, "Callable", null);
    }

    @Override
    @Nullable
    public List<PyCallableParameter> getParameters(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(21);
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext(context);
        return StreamEx.of(PyUtil.filterTopPriorityElements(PyCallExpressionHelper.resolveImplicitlyInvokedMethods(this, null, resolveContext))).select(PyCallable.class).map(callable -> callable.getParameters(context)).findFirst().filter(parameters -> !parameters.isEmpty()).map(parameters -> ContainerUtil.subList((List)parameters, (int)1)).orElse(null);
    }

    private static boolean isMethodType(@NotNull PyClassType type2) {
        PyBuiltinCache builtinCache;
        if (type2 == null) {
            PyClassTypeImpl.$$$reportNull$$$0(22);
        }
        return type2.equals((builtinCache = PyBuiltinCache.getInstance(type2.getPyClass())).getClassMethodType()) || type2.equals(builtinCache.getStaticMethodType()) || type2.equals(builtinCache.getObjectType("function"));
    }

    @Override
    @Nullable
    public PyType getReturnType(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(23);
        }
        return this.getPossibleCallType(context, null);
    }

    @Override
    @Nullable
    public PyType getCallType(@NotNull TypeEvalContext context, @NotNull PyCallSiteExpression callSite) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(24);
        }
        if (callSite == null) {
            PyClassTypeImpl.$$$reportNull$$$0(25);
        }
        return this.getPossibleCallType(context, callSite);
    }

    @Nullable
    private PyType getPossibleCallType(@NotNull TypeEvalContext context, @Nullable PyCallSiteExpression callSite) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(26);
        }
        if (!this.isDefinition()) {
            return PyUtil.getReturnTypeOfMember(this, "__call__", callSite, context);
        }
        return this.withUserDataCopy(new PyClassTypeImpl(this.getPyClass(), false));
    }

    @Override
    @NotNull
    public List<PyClassLikeType> getAncestorTypes(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(27);
        }
        List list = this.myClass.getAncestorTypes(context);
        if (list == null) {
            PyClassTypeImpl.$$$reportNull$$$0(28);
        }
        return list;
    }

    @Nullable
    private static PsiElement resolveByMembersProviders(PyClassType aClass, String name2, @Nullable PsiElement location, @NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(29);
        }
        for (PyClassMembersProvider provider : PyClassMembersProvider.EP_NAME.getExtensionList()) {
            PsiElement resolveResult = provider.resolveMember(aClass, name2, location, resolveContext);
            if (resolveResult == null) continue;
            return resolveResult;
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveByOverridingMembersProviders(PyClassType aClass, String name2, @Nullable PsiElement location, @NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(30);
        }
        for (PyClassMembersProvider provider : PyClassMembersProvider.EP_NAME.getExtensionList()) {
            PsiElement resolveResult;
            if (!(provider instanceof PyOverridingClassMembersProvider) || (resolveResult = provider.resolveMember(aClass, name2, location, resolveContext)) == null) continue;
            return resolveResult;
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveByOverridingAncestorsMembersProviders(PyClassType type2, String name2, @Nullable PyExpression location, @NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyClassTypeImpl.$$$reportNull$$$0(31);
        }
        for (PyClassMembersProvider provider : PyClassMembersProvider.EP_NAME.getExtensionList()) {
            PsiElement resolveResult;
            if (!(provider instanceof PyOverridingAncestorsClassMembersProvider) || (resolveResult = provider.resolveMember(type2, name2, (PsiElement)location, resolveContext)) == null) continue;
            return resolveResult;
        }
        return null;
    }

    @NotNull
    private static List<? extends RatedResolveResult> resolveInner(@NotNull PyClass cls, boolean isDefinition, @NotNull String name2, @Nullable PyExpression location, @NotNull TypeEvalContext context) {
        if (cls == null) {
            PyClassTypeImpl.$$$reportNull$$$0(32);
        }
        if (name2 == null) {
            PyClassTypeImpl.$$$reportNull$$$0(33);
        }
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(34);
        }
        PyAttributesProcessor processor2 = new PyAttributesProcessor(name2, location);
        if (isDefinition || cls.processInstanceLevelDeclarations(processor2, (PsiElement)location)) {
            cls.processClassObjectAttributes(processor2, (PsiElement)location);
        }
        Map<PsiElement, PyImportedNameDefiner> results = processor2.getResults();
        List list = EntryStream.of(results).mapKeyValue((element, definer) -> {
            int rate = PyReferenceImpl.getRate(element, context);
            return definer != null ? new ImportedResolveResult((PsiElement)element, rate, (PyImportedNameDefiner)definer) : new RatedResolveResult(rate, (PsiElement)element);
        }).toList();
        if (list == null) {
            PyClassTypeImpl.$$$reportNull$$$0(35);
        }
        return list;
    }

    @Override
    public Object @NotNull [] getCompletionVariants(String prefix, PsiElement location, @NotNull ProcessingContext context) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(36);
        }
        if (this.isRecursive(context)) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                PyClassTypeImpl.$$$reportNull$$$0(37);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        Set<String> visited = PyClassTypeImpl.visitedNames(context);
        PsiFile origin = location != null ? CompletionUtilCoreImpl.getOriginalOrSelf((PsiElement)location).getContainingFile() : null;
        TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion(this.myClass.getProject(), origin);
        boolean withinOurClass = PyClassTypeImpl.withinClass(this.getPyClass(), location);
        Condition nameFilter = name2 -> {
            if (!withinOurClass && PyUtil.isClassPrivateName(name2)) {
                return false;
            }
            if (!withinOurClass && PyClassTypeImpl.isClassProtected(name2) && prefix == null) {
                return false;
            }
            return visited.add((String)name2);
        };
        CompletionVariantsProcessor processor2 = new CompletionVariantsProcessor(location, null, (Condition<String>)nameFilter, false, context.get(CTX_SUPPRESS_PARENTHESES) != null);
        this.processMembers(processor2, () -> processor2.setAllowedNames(this.myClass.getSlots(typeEvalContext)));
        ArrayList<LookupElement> result2 = new ArrayList<LookupElement>(processor2.getResultList());
        this.processOwnSlots((Processor<? super String>)((Processor)slot -> {
            if (visited.add((String)slot)) {
                result2.add((LookupElement)LookupElementBuilder.create((String)slot));
            }
            return true;
        }), typeEvalContext);
        this.processProvidedMembers((Processor<? super PyCustomMember>)((Processor)member -> {
            if (visited.add(member.getName())) {
                result2.add((LookupElement)PyCustomMemberUtils.toLookUpElement(member, this.getName()));
            }
            return true;
        }), location, typeEvalContext);
        this.prepareTypesForProcessingMembers(this.getSuperClassTypes(typeEvalContext)).flatArray(type2 -> type2.getCompletionVariants(prefix, location, context)).into(result2);
        this.processMetaClassMembers(typeType -> ContainerUtil.addAll((Collection)result2, (Object[])typeType.getCompletionVariants(prefix, location, context)), (Processor<? super PyTargetExpression>)((Processor)typeInstanceAttribute -> {
            result2.add((LookupElement)LookupElementBuilder.create((PsiNamedElement)typeInstanceAttribute));
            return true;
        }), typeEvalContext);
        Object[] objectArray = result2.toArray();
        if (objectArray == null) {
            PyClassTypeImpl.$$$reportNull$$$0(38);
        }
        return objectArray;
    }

    private boolean isRecursive(@NotNull ProcessingContext context) {
        HashSet<PyClassTypeImpl> types;
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(39);
        }
        if ((types = (HashSet<PyClassTypeImpl>)context.get(CTX_VISITED)) == null) {
            types = new HashSet<PyClassTypeImpl>();
            context.put(CTX_VISITED, types);
        }
        return !types.add(this);
    }

    @NotNull
    private static Set<String> visitedNames(@NotNull ProcessingContext context) {
        HashSet<String> names;
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(40);
        }
        if ((names = (HashSet<String>)context.get(CTX_NAMES)) == null) {
            names = new HashSet<String>();
            context.put(CTX_NAMES, names);
        }
        HashSet<String> hashSet = names;
        if (hashSet == null) {
            PyClassTypeImpl.$$$reportNull$$$0(41);
        }
        return hashSet;
    }

    private static boolean withinClass(@NotNull PyClass cls, @Nullable PsiElement location) {
        PyClass containingClass;
        if (cls == null) {
            PyClassTypeImpl.$$$reportNull$$$0(42);
        }
        if ((containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)location, PyClass.class)) != null) {
            containingClass = (PyClass)CompletionUtilCoreImpl.getOriginalElement((PsiElement)containingClass);
        }
        return containingClass == PyiUtil.getOriginalElementOrLeaveAsIs(cls, PyClass.class) || PyClassTypeImpl.isInSuperCall(location);
    }

    @Override
    public void visitMembers(@NotNull Processor<? super PsiElement> processor2, boolean inherited, @NotNull TypeEvalContext context) {
        if (processor2 == null) {
            PyClassTypeImpl.$$$reportNull$$$0(43);
        }
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(44);
        }
        this.processMembers(processor2);
        if (inherited) {
            this.prepareTypesForProcessingMembers(this.getAncestorTypes(context)).forEach(type2 -> type2.visitMembers(processor2, false, context));
            this.processMetaClassMembers(typeType -> typeType.visitMembers(processor2, true, context), processor2, context);
        }
    }

    @Override
    @NotNull
    public Set<String> getMemberNames(boolean inherited, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(45);
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        this.processMembers((Processor<? super PsiElement>)((Processor)element -> {
            if (element instanceof PsiNamedElement) {
                ContainerUtil.addIfNotNull((Collection)result2, (Object)((PsiNamedElement)element).getName());
            }
            return true;
        }));
        this.processOwnSlots((Processor<? super String>)((Processor)slot -> {
            result2.add((String)slot);
            return true;
        }), context);
        this.processProvidedMembers((Processor<? super PyCustomMember>)((Processor)member -> {
            result2.add(member.getName());
            return true;
        }), null, context);
        if (inherited) {
            this.prepareTypesForProcessingMembers(this.getAncestorTypes(context)).flatCollection(type2 -> type2.getMemberNames(false, context)).into(result2);
            this.processMetaClassMembers(typeType -> result2.addAll(typeType.getMemberNames(true, context)), (Processor<? super PyTargetExpression>)((Processor)instanceTypeAttribute -> {
                ContainerUtil.addIfNotNull((Collection)result2, (Object)instanceTypeAttribute.getName());
                return true;
            }), context);
        }
        LinkedHashSet<String> linkedHashSet = result2;
        if (linkedHashSet == null) {
            PyClassTypeImpl.$$$reportNull$$$0(46);
        }
        return linkedHashSet;
    }

    private void processMembers(final @NotNull Processor<? super PsiElement> processor2) {
        if (processor2 == null) {
            PyClassTypeImpl.$$$reportNull$$$0(47);
        }
        PsiScopeProcessor scopeProcessor = new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                return processor2.process((Object)element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/psi/types/PyClassTypeImpl$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.processMembers(scopeProcessor, EmptyRunnable.getInstance());
    }

    private void processMembers(@NotNull PsiScopeProcessor scopeProcessor, @NotNull Runnable afterClassLevelBeforeInstanceLevel) {
        if (scopeProcessor == null) {
            PyClassTypeImpl.$$$reportNull$$$0(48);
        }
        if (afterClassLevelBeforeInstanceLevel == null) {
            PyClassTypeImpl.$$$reportNull$$$0(49);
        }
        this.myClass.processClassObjectAttributes(scopeProcessor, null);
        if (!this.isDefinition()) {
            afterClassLevelBeforeInstanceLevel.run();
            this.myClass.processInstanceLevelDeclarations(scopeProcessor, null);
        }
    }

    private void processOwnSlots(@NotNull Processor<? super String> processor2, @NotNull TypeEvalContext context) {
        if (processor2 == null) {
            PyClassTypeImpl.$$$reportNull$$$0(50);
        }
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(51);
        }
        if (this.myClass.isNewStyleClass(context)) {
            for (String slot : ContainerUtil.notNullize(this.myClass.getOwnSlots())) {
                if (processor2.process((Object)slot)) continue;
                return;
            }
        }
    }

    private void processProvidedMembers(@NotNull Processor<? super PyCustomMember> processor2, @Nullable PsiElement location, @NotNull TypeEvalContext context) {
        if (processor2 == null) {
            PyClassTypeImpl.$$$reportNull$$$0(52);
        }
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(53);
        }
        for (PyClassMembersProvider provider : PyClassMembersProvider.EP_NAME.getExtensionList()) {
            for (PyCustomMember member : provider.getMembers(this, location, context)) {
                if (processor2.process((Object)member)) continue;
                return;
            }
        }
    }

    @NotNull
    private StreamEx<PyClassLikeType> prepareTypesForProcessingMembers(@NotNull List<PyClassLikeType> types) {
        if (types == null) {
            PyClassTypeImpl.$$$reportNull$$$0(54);
        }
        StreamEx streamEx = StreamEx.of(types).nonNull().map(type2 -> this.isDefinition() ? (PyClassLikeType)type2.toClass() : (PyClassLikeType)type2.toInstance());
        if (streamEx == null) {
            PyClassTypeImpl.$$$reportNull$$$0(55);
        }
        return streamEx;
    }

    private void processMetaClassMembers(@NotNull Consumer<? super PyClassLikeType> typeTypeConsumer, @NotNull Processor<? super PyTargetExpression> instanceTypeAttributesProcessor, @NotNull TypeEvalContext context) {
        if (typeTypeConsumer == null) {
            PyClassTypeImpl.$$$reportNull$$$0(56);
        }
        if (instanceTypeAttributesProcessor == null) {
            PyClassTypeImpl.$$$reportNull$$$0(57);
        }
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(58);
        }
        if (!this.myClass.isNewStyleClass(context)) {
            return;
        }
        PyClassLikeType typeType = this.getMetaClassType(context, true);
        if (typeType == null) {
            return;
        }
        if (this.isDefinition()) {
            typeTypeConsumer.accept((PyClassLikeType)typeType.toInstance());
        } else if (typeType instanceof PyClassType) {
            for (PyTargetExpression attribute : ((PyClassType)typeType).getPyClass().getInstanceAttributes()) {
                if (instanceTypeAttributesProcessor.process((Object)attribute)) continue;
                return;
            }
        }
    }

    private static boolean isInSuperCall(PsiElement hook) {
        if (hook instanceof PyReferenceExpression) {
            PyExpression qualifier = ((PyReferenceExpression)hook).getQualifier();
            return qualifier instanceof PyCallExpression && ((PyCallExpression)qualifier).isCalleeText(new String[]{"super"});
        }
        return false;
    }

    private static boolean isClassProtected(@NotNull String lookupString2) {
        if (lookupString2 == null) {
            PyClassTypeImpl.$$$reportNull$$$0(59);
        }
        return lookupString2.startsWith("_") && !lookupString2.startsWith("__");
    }

    @Override
    @Nullable
    public String getName() {
        return this.getPyClass().getName();
    }

    @Override
    public boolean isBuiltin() {
        return PyBuiltinCache.getInstance(this.myClass).isBuiltin(this.myClass);
    }

    @Override
    public void assertValid(String message) {
        if (!this.myClass.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)this.myClass, this.myClass.getClass().toString() + ": " + message);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyClassTypeImpl classType = (PyClassTypeImpl)o;
        if (this.myIsDefinition != classType.myIsDefinition) {
            return false;
        }
        return this.myClass.equals(classType.myClass);
    }

    public int hashCode() {
        int result2 = this.myClass.hashCode();
        result2 = 31 * result2 + (this.myIsDefinition ? 1 : 0);
        return result2;
    }

    public String toString() {
        return (this.isValid() ? "" : "[INVALID] ") + "PyClassType: " + this.getClassQName();
    }

    @Override
    public boolean isValid() {
        return this.myClass.isValid();
    }

    @Override
    public boolean isAttributeWritable(@NotNull String name2, @NotNull TypeEvalContext context) {
        if (name2 == null) {
            PyClassTypeImpl.$$$reportNull$$$0(60);
        }
        if (context == null) {
            PyClassTypeImpl.$$$reportNull$$$0(61);
        }
        PyClass cls = this.getPyClass();
        if (this.isDefinition() || PyUtil.isObjectClass(cls)) {
            return true;
        }
        List<String> slots = cls.getSlots(context);
        Condition isDefinedTarget = target -> name2.equals(target.getName()) && target.hasAssignedValue();
        return slots == null || slots.contains(name2) && !ContainerUtil.exists(cls.getClassAttributesInherited(context), (Condition)isDefinedTarget) || cls.findProperty(name2, true, context) != null;
    }

    @Nullable
    public static PyClassTypeImpl createTypeByQName(@NotNull PsiElement anchor, @NotNull String classQualifiedName, boolean isDefinition) {
        PyClass pyClass;
        if (anchor == null) {
            PyClassTypeImpl.$$$reportNull$$$0(62);
        }
        if (classQualifiedName == null) {
            PyClassTypeImpl.$$$reportNull$$$0(63);
        }
        if ((pyClass = PyPsiFacade.getInstance(anchor.getProject()).createClassByQName(classQualifiedName, anchor)) == null) {
            return null;
        }
        return new PyClassTypeImpl(pyClass, isDefinition);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 7, 28, 35, 37, 38, 41, 46, 55 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 28: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 46: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyClassTypeImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInstance";
                break;
            }
            case 6: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 51: 
            case 53: 
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 33: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 32: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 43: 
            case 47: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeProcessor";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterClassLevelBeforeInstanceLevel";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeTypeConsumer";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceTypeAttributesProcessor";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupString";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyClassTypeImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPyClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withUserDataCopy";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClassTypes";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestorTypes";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionVariants";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "visitedNames";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberNames";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareTypesForProcessingMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 28: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 46: 
            case 55: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withUserDataCopy";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassTypes";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doResolveMember";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveMetaClassMember";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getMetaClassType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getParameters";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isMethodType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleCallType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAncestorTypes";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "resolveByMembersProviders";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "resolveByOverridingMembersProviders";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "resolveByOverridingAncestorsMembersProviders";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "resolveInner";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionVariants";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isRecursive";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "visitedNames";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "withinClass";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "visitMembers";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getMemberNames";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "processMembers";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "processOwnSlots";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "processProvidedMembers";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "prepareTypesForProcessingMembers";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "processMetaClassMembers";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isClassProtected";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isAttributeWritable";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createTypeByQName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 7, 28, 35, 37, 38, 41, 46, 55 -> new IllegalStateException(string);
        };
    }

    private static final class PyAttributesProcessor
    extends PyResolveProcessor {
        @Nullable
        private final PyExpression myLocation;

        PyAttributesProcessor(@NotNull String name2, @Nullable PyExpression location) {
            if (name2 == null) {
                PyAttributesProcessor.$$$reportNull$$$0(0);
            }
            super(name2);
            this.myLocation = location;
        }

        @Override
        protected boolean tryAddResult(@Nullable PsiElement element, @Nullable PyImportedNameDefiner definer) {
            PyImportedNameDefiner psiElement;
            PyImportedNameDefiner pyImportedNameDefiner = psiElement = definer != null ? definer : element;
            if (element instanceof PyTypeParameter) {
                return false;
            }
            if (PyAttributesProcessor.inSameScope((PsiElement)psiElement, (PsiElement)this.myLocation)) {
                if (PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)this.myLocation, (boolean)false) || PyDefUseUtil.isDefinedBefore((PsiElement)psiElement, (PsiElement)this.myLocation) || PyAttributesProcessor.inDifferentBranchesOfSameIfStatement((PsiElement)psiElement, (PsiElement)this.myLocation)) {
                    if (this.myOwner == null) {
                        this.myOwner = ScopeUtil.getScopeOwner((PsiElement)psiElement);
                    }
                    this.addResult(element, definer);
                }
                return true;
            }
            return super.tryAddResult(element, definer);
        }

        private static boolean inSameScope(@Nullable PsiElement e1, @Nullable PsiElement e2) {
            if (e1 == null || e2 == null) {
                return false;
            }
            ScopeOwner o1 = ScopeUtil.getScopeOwner(e1);
            ScopeOwner o2 = ScopeUtil.getScopeOwner(e2);
            return o1 != null && o1 == o2;
        }

        private static boolean inDifferentBranchesOfSameIfStatement(@NotNull PsiElement e1, @NotNull PsiElement e2) {
            PyStatementPart p2;
            PyIfStatement ifStatement;
            if (e1 == null) {
                PyAttributesProcessor.$$$reportNull$$$0(1);
            }
            if (e2 == null) {
                PyAttributesProcessor.$$$reportNull$$$0(2);
            }
            if ((ifStatement = (PyIfStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.findCommonParent((PsiElement)e1, (PsiElement)e2), PyIfStatement.class)) == null) {
                return false;
            }
            List<PyStatementPart> parts = PyAttributesProcessor.getIfStatementParts(ifStatement);
            PyStatementPart p1 = PyAttributesProcessor.findIfStatementPartByElement(e1, parts);
            return p1 != (p2 = PyAttributesProcessor.findIfStatementPartByElement(e2, parts));
        }

        @Nullable
        private static PyStatementPart findIfStatementPartByElement(@NotNull PsiElement element, @NotNull List<PyStatementPart> parts) {
            if (element == null) {
                PyAttributesProcessor.$$$reportNull$$$0(3);
            }
            if (parts == null) {
                PyAttributesProcessor.$$$reportNull$$$0(4);
            }
            return (PyStatementPart)ContainerUtil.find(parts, part -> PsiTreeUtil.isAncestor((PsiElement)part, (PsiElement)element, (boolean)true));
        }

        @NotNull
        private static List<PyStatementPart> getIfStatementParts(@NotNull PyIfStatement statement) {
            if (statement == null) {
                PyAttributesProcessor.$$$reportNull$$$0(5);
            }
            ArrayList<PyStatementPart> parts = new ArrayList<PyStatementPart>();
            parts.add(statement.getIfPart());
            parts.addAll(Arrays.asList(statement.getElifParts()));
            PyElsePart elsePart = statement.getElsePart();
            if (elsePart != null) {
                parts.add(elsePart);
            }
            ArrayList<PyStatementPart> arrayList = parts;
            if (arrayList == null) {
                PyAttributesProcessor.$$$reportNull$$$0(6);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parts";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/types/PyClassTypeImpl$PyAttributesProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/types/PyClassTypeImpl$PyAttributesProcessor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIfStatementParts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "inDifferentBranchesOfSameIfStatement";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findIfStatementPartByElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getIfStatementParts";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }
    }
}

