/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.BigQueryExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.dialects.BigQueryIntermediateFacade;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.database.remote.jdbc.impl.UnparsedValueKind;
import com.intellij.openapi.util.text.StringUtilRt;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BigQueryJdbcHelper
extends JdbcHelperImpl {
    boolean triedToFindClasses = false;
    private Class<?> myColumMetaDataClass;
    private Class<?> myRsMetaDataClass;
    private Field myColumnMetaDataField;
    private Method myGetNestedTypes;

    public BigQueryJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("BIGQUERY", version, connection);
    }

    public BigQueryJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return BigQueryJdbcHelper.extractVersion(version);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection) {
        return new BigQueryJdbcHelper(version, connection);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull JdbcConnectionProvider ds) {
        if (ds == null) {
            BigQueryJdbcHelper.$$$reportNull$$$0(0);
        }
        return new BigQueryIntermediateFacade(ds, BigQueryExceptionRecognizer.INSTANCE, this);
    }

    @Override
    protected void setTimestamp(@NotNull RemotePreparedStatement statement, int idx, Timestamp timestamp) throws Exception {
        if (statement == null) {
            BigQueryJdbcHelper.$$$reportNull$$$0(1);
        }
        statement.setTimestamp(idx, timestamp);
    }

    @Override
    protected void setTime(@NotNull RemotePreparedStatement statement, int idx, Time time) throws RemoteException, SQLException {
        if (statement == null) {
            BigQueryJdbcHelper.$$$reportNull$$$0(2);
        }
        statement.setTime(idx, time);
    }

    @Override
    public boolean supportsEscape() {
        return false;
    }

    @Override
    public char getEscapeChar() {
        return '\\';
    }

    @Override
    @NotNull
    protected String getCharsToEscape() {
        return "%_\\";
    }

    @Override
    @Nullable
    public JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer, @Nullable JdbcHelperImpl connectHelper) throws Exception {
        if (!JdbcNativeUtil.detectString(product, "BigQuery")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return BigQueryJdbcHelper.create(delegate, productVer);
    }

    @NotNull
    private static JdbcHelperImpl create(@Nullable Connection delegate, @Nullable String productVer) throws Exception {
        String versionStr = delegate == null ? productVer : delegate.getMetaData().getDriverVersion();
        JdbcNativeUtil.logInfo("release_version: " + versionStr);
        return new BigQueryJdbcHelper(BigQueryJdbcHelper.extractVersion(versionStr), delegate);
    }

    @Override
    protected void setDriverLogLevel(Driver driver, Properties properties, Level level, String logPath) {
        super.setDriverLogLevel(driver, properties, level, logPath);
        BigQueryJdbcHelper.configureSimbaLogging(properties, level, logPath);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            BigQueryJdbcHelper.$$$reportNull$$$0(3);
        }
        return BigQueryJdbcHelper.classNameContains(driver, "googlebigquery");
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            BigQueryJdbcHelper.$$$reportNull$$$0(4);
        }
        e.length = -1;
    }

    @Override
    protected Object createInfoIfNeeded(@NotNull JdbcRemoteObject exporter, @Nullable RemoteResultSet.DataRetrievingOptions options, @NotNull ResultSetMetaData metaData, int index, Object o) throws Exception {
        String typeName;
        if (exporter == null) {
            BigQueryJdbcHelper.$$$reportNull$$$0(5);
        }
        if (metaData == null) {
            BigQueryJdbcHelper.$$$reportNull$$$0(6);
        }
        return StringUtilRt.equal((CharSequence)"array", (CharSequence)(typeName = metaData.getColumnTypeName(index)), (boolean)false) || StringUtilRt.equal((CharSequence)"struct", (CharSequence)typeName, (boolean)false) ? o : super.createInfoIfNeeded(exporter, options, metaData, index, o);
    }

    @Override
    @Nullable
    public UnparsedValueKind detectUnparsedValueKind(@Nullable String typeName, int jdbcType) {
        if (jdbcType == 93) {
            return UnparsedValueKind.TIMESTAMP;
        }
        return super.detectUnparsedValueKind(typeName, jdbcType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getColumnTypeName(@NotNull ResultSetMetaData delegate, int idx) throws SQLException {
        String typeName;
        if (delegate == null) {
            BigQueryJdbcHelper.$$$reportNull$$$0(7);
        }
        if (!"ARRAY".equals(typeName = delegate.getColumnTypeName(idx)) && !"STRUCT".equals(typeName)) {
            return super.getColumnTypeName(delegate, idx);
        }
        try {
            if (this.triedToFindClasses && this.myRsMetaDataClass == null) {
                String string = super.getColumnTypeName(delegate, idx);
                return string;
            }
            this.myRsMetaDataClass = this.myRsMetaDataClass != null ? this.myRsMetaDataClass : this.classForName("com.simba.googlebigquery.jdbc.common.SResultSetMetaData");
            this.myColumnMetaDataField = this.myColumnMetaDataField != null ? this.myColumnMetaDataField : this.myRsMetaDataClass.getDeclaredField("m_columnMetaData");
            this.myColumnMetaDataField.setAccessible(true);
            Object metaData = this.myColumnMetaDataField.get(delegate);
            if (!(metaData instanceof List) || idx - 1 >= ((List)metaData).size()) {
                String string = super.getColumnTypeName(delegate, idx);
                return string;
            }
            Object columnMetaData = ((List)metaData).get(idx - 1);
            String nestedType = this.getNestedType(columnMetaData);
            String string = nestedType == null ? typeName : ("ARRAY".equals(typeName) ? typeName + "<STRUCT<" + nestedType + ">>" : typeName + "<" + nestedType + ">");
            return string;
        }
        catch (Throwable throwable) {
        }
        finally {
            this.triedToFindClasses = true;
        }
        return super.getColumnTypeName(delegate, idx);
    }

    @Nullable
    private String getNestedType(Object columnMetaData) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        this.myColumMetaDataClass = this.myColumMetaDataClass != null ? this.myColumMetaDataClass : this.classForName("com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQColumnMetadata");
        Method method = this.myGetNestedTypes = this.myGetNestedTypes != null ? this.myGetNestedTypes : this.myColumMetaDataClass.getMethod("getNestedTypes", new Class[0]);
        if (!this.myColumMetaDataClass.isInstance(columnMetaData)) {
            return null;
        }
        Object nestedTypes = this.myGetNestedTypes.invoke(columnMetaData, new Object[0]);
        if (!(nestedTypes instanceof List)) {
            return null;
        }
        return BigQueryJdbcHelper.getNestedType((List)nestedTypes);
    }

    @Nullable
    private static String getNestedType(@NotNull List<?> nestedTypes) {
        if (nestedTypes == null) {
            BigQueryJdbcHelper.$$$reportNull$$$0(8);
        }
        StringBuilder sb = new StringBuilder();
        for (Object t : nestedTypes) {
            Map typeSchema = BigQueryJdbcHelper.tryCast(t, Map.class);
            if (typeSchema == null) continue;
            String mode = BigQueryJdbcHelper.tryCast(typeSchema.get("mode"), String.class);
            String name = BigQueryJdbcHelper.tryCast(typeSchema.get("name"), String.class);
            String type = BigQueryJdbcHelper.tryCast(typeSchema.get("type"), String.class);
            if ("FLOAT".equals(type)) {
                type = "FLOAT64";
            }
            List fields = BigQueryJdbcHelper.tryCast(typeSchema.get("fields"), List.class);
            if (mode == null || name == null || type == null) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(name).append(" ");
            boolean array = "REPEATED".equals(mode);
            if (array) {
                sb.append("ARRAY<");
            }
            if (fields != null) {
                sb.append("STRUCT<").append(BigQueryJdbcHelper.getNestedType(fields)).append(">");
            } else {
                sb.append(type);
            }
            if (!array) continue;
            sb.append(">");
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    @Nullable
    public static <T> T tryCast(@Nullable Object obj, @NotNull Class<T> clazz) {
        if (clazz == null) {
            BigQueryJdbcHelper.$$$reportNull$$$0(9);
        }
        return clazz.isInstance(obj) ? (T)clazz.cast(obj) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exporter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nestedTypes";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/BigQueryJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createFacade";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setTimestamp";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setTime";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createInfoIfNeeded";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getColumnTypeName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getNestedType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "tryCast";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

