/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.debugger.impl.frontend;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.debugger.impl.frontend.FrontendXValueMarkersService;
import com.intellij.platform.debugger.impl.frontend.evaluate.quick.FrontendXValue;
import com.intellij.ui.JBColor;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import java.awt.Color;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\"\u0010\u000e\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u001a\u0010\u0012\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u001a\u0010\u0013\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/debugger/impl/frontend/FrontendXValueMarkers;", "V", "Lcom/intellij/xdebugger/frame/XValue;", "M", "Lcom/intellij/xdebugger/impl/frame/XValueMarkers;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getMarkup", "Lcom/intellij/xdebugger/impl/ui/tree/ValueMarkup;", "value", "canMarkValue", "", "markValue", "Lorg/jetbrains/concurrency/Promise;", "", "markup", "unmarkValue", "getAllMarkers", "", "clear", "", "intellij.platform.debugger.impl.frontend"})
@SourceDebugExtension(value={"SMAP\nFrontendXValueMarkers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendXValueMarkers.kt\ncom/intellij/platform/debugger/impl/frontend/FrontendXValueMarkers\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,68:1\n31#2,2:69\n31#2,2:71\n*S KotlinDebug\n*F\n+ 1 FrontendXValueMarkers.kt\ncom/intellij/platform/debugger/impl/frontend/FrontendXValueMarkers\n*L\n33#1:69,2\n37#1:71,2\n*E\n"})
public final class FrontendXValueMarkers<V extends XValue, M>
extends XValueMarkers<V, M> {
    @NotNull
    private final Project project;

    public FrontendXValueMarkers(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Nullable
    public ValueMarkup getMarkup(@NotNull XValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        FrontendXValue frontendXValue = value instanceof FrontendXValue ? (FrontendXValue)value : null;
        if (frontendXValue == null || (frontendXValue = frontendXValue.getMarkerDto()) == null) {
            return null;
        }
        FrontendXValue markerDto = frontendXValue;
        String string = markerDto.getText();
        Color color = markerDto.getColor();
        if (color == null) {
            color = (Color)JBColor.RED;
        }
        return new ValueMarkup(string, color, markerDto.getTooltipText());
    }

    public boolean canMarkValue(@NotNull XValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return true;
    }

    @Nullable
    public Promise<? super Object> markValue(@NotNull XValue value, @NotNull ValueMarkup markup) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)markup, (String)"markup");
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<FrontendXValueMarkersService> serviceClass$iv = FrontendXValueMarkersService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((FrontendXValueMarkersService)object).markValue(value, markup);
    }

    @Nullable
    public Promise<? super Object> unmarkValue(@NotNull XValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<FrontendXValueMarkersService> serviceClass$iv = FrontendXValueMarkersService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((FrontendXValueMarkersService)object).unmarkValue(value);
    }

    @Nullable
    public Map<M, ValueMarkup> getAllMarkers() {
        return MapsKt.emptyMap();
    }

    public void clear() {
    }
}

