/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.activity;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.activity.NextJsConfigStatsCollector;
import com.intellij.javascript.debugger.activity.NextJsPackageJsonUtilKt;
import com.intellij.javascript.debugger.activity.NextJsPropertiesComponentKt;
import com.intellij.javascript.debugger.activity.NextJsRunConfigKind;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.JavascriptDebugConfigurationType;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\r\u001a\u0004\u0018\u00010\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0002R\u0019\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/javascript/debugger/activity/NextJsCreateClientRunConfigurationActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDebugUri", "", "port", "", "normalizeUri", "uri", "configType", "Lcom/intellij/javascript/debugger/execution/JavascriptDebugConfigurationType;", "Lorg/jetbrains/annotations/NotNull;", "getConfigType", "()Lcom/intellij/javascript/debugger/execution/JavascriptDebugConfigurationType;", "intellij.javascript.debugger"})
public final class NextJsCreateClientRunConfigurationActivity
implements ProjectActivity {
    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        if (NextJsPropertiesComponentKt.isNextJsRunConfigCreated(project, NextJsRunConfigKind.Client)) {
            return Unit.INSTANCE;
        }
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
        if (virtualFile == null) {
            return Unit.INSTANCE;
        }
        VirtualFile virtualFile2 = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)virtualFile);
        if (virtualFile2 == null) {
            return Unit.INSTANCE;
        }
        VirtualFile packageJsonFile = virtualFile2;
        Object object = CoroutinesKt.readAction(() -> NextJsCreateClientRunConfigurationActivity.execute$lambda$0(project, packageJsonFile, this), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final String getDebugUri(int port) {
        return "http://localhost:" + port + "/";
    }

    private final String normalizeUri(String uri) {
        String host;
        if (uri == null) {
            return null;
        }
        URI u = new URI(uri);
        String string = u.getScheme();
        if (string == null) {
            string = "http";
        }
        String scheme = string;
        String string2 = host = u.getHost() == null || Intrinsics.areEqual((Object)u.getHost(), (Object)"127.0.0.1") || Intrinsics.areEqual((Object)u.getHost(), (Object)"[::1]") ? "localhost" : u.getHost();
        if (u.getPort() == -1) {
            return null;
        }
        return scheme + "://" + host + ":" + u.getPort() + "/";
    }

    private final JavascriptDebugConfigurationType getConfigType() {
        JavascriptDebugConfigurationType javascriptDebugConfigurationType = JavascriptDebugConfigurationType.getTypeInstance();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)javascriptDebugConfigurationType), (String)"getTypeInstance(...)");
        return javascriptDebugConfigurationType;
    }

    private static final Unit execute$lambda$0(Project $project, VirtualFile $packageJsonFile, NextJsCreateClientRunConfigurationActivity this$0) {
        if ($project.isDisposed()) {
            return Unit.INSTANCE;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)$project).findFile($packageJsonFile);
        JsonFile jsonFile = psiFile instanceof JsonFile ? (JsonFile)psiFile : null;
        if (jsonFile == null) {
            return Unit.INSTANCE;
        }
        JsonFile packageJson = jsonFile;
        if (!NextJsPackageJsonUtilKt.hasNextJsDependency(packageJson)) {
            return Unit.INSTANCE;
        }
        JsonStringLiteral jsonStringLiteral = NextJsPackageJsonUtilKt.findDevScriptBodyPsi(packageJson);
        if (jsonStringLiteral == null) {
            return Unit.INSTANCE;
        }
        JsonStringLiteral devScriptBody = jsonStringLiteral;
        String string = devScriptBody.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        Integer n = NextJsPackageJsonUtilKt.getNextJsDevPort(string);
        if (n == null) {
            return Unit.INSTANCE;
        }
        int port = n;
        String debugUri = this$0.getDebugUri(port);
        String string2 = JSDebuggerBundle.message("runConfig.nextJs.client.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String configName = string2;
        List existingConfigs = RunManager.Companion.getInstance($project).getConfigurationSettingsList((ConfigurationType)this$0.getConfigType());
        for (RunnerAndConfigurationSettings config : existingConfigs) {
            JavaScriptDebugConfiguration jsDebugConf;
            RunConfiguration runConfiguration = config.getConfiguration();
            JavaScriptDebugConfiguration javaScriptDebugConfiguration = runConfiguration instanceof JavaScriptDebugConfiguration ? (JavaScriptDebugConfiguration)runConfiguration : null;
            if (javaScriptDebugConfiguration == null || !Intrinsics.areEqual((Object)(jsDebugConf = javaScriptDebugConfiguration).getName(), (Object)configName) && !Intrinsics.areEqual((Object)this$0.normalizeUri(jsDebugConf.getUri()), (Object)debugUri)) continue;
            return Unit.INSTANCE;
        }
        RunnerAndConfigurationSettings newConf = RunManager.Companion.getInstance($project).createConfiguration(configName, (ConfigurationFactory)this$0.getConfigType());
        RunConfiguration runConfiguration = newConf.getConfiguration();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration");
        JavaScriptDebugConfiguration jsDebugConf = (JavaScriptDebugConfiguration)runConfiguration;
        jsDebugConf.setUri(debugUri);
        RunManager.Companion.getInstance($project).addConfiguration(newConf);
        NextJsConfigStatsCollector.clientConfigCreated.log();
        NextJsPropertiesComponentKt.setNextJsRunConfigCreated($project, NextJsRunConfigKind.Client);
        return Unit.INSTANCE;
    }
}

