/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.collaboration.api.graphql.CachingGraphQLQueryLoader;
import com.intellij.collaboration.api.graphql.GraphQLQueryLoader;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/api/GHGQLQueryLoader;", "Lcom/intellij/collaboration/api/graphql/GraphQLQueryLoader;", "<init>", "()V", "delegate", "Lcom/intellij/collaboration/api/graphql/CachingGraphQLQueryLoader;", "findAllQueries", "", "", "loadQuery", "queryPath", "intellij.vcs.github"})
@ApiStatus.Internal
public final class GHGQLQueryLoader
implements GraphQLQueryLoader {
    @NotNull
    public static final GHGQLQueryLoader INSTANCE = new GHGQLQueryLoader();
    @NotNull
    private static final CachingGraphQLQueryLoader delegate = new CachingGraphQLQueryLoader(GHGQLQueryLoader::delegate$lambda$0, null, null, null, null, 30, null);

    private GHGQLQueryLoader() {
    }

    @VisibleForTesting
    @NotNull
    public final List<String> findAllQueries() {
        URL uRL = GHGQLQueryLoader.class.getClassLoader().getResource("graphql/query");
        Intrinsics.checkNotNull((Object)uRL);
        URL url = uRL;
        Path directory = Paths.get(url.toURI());
        List<String> list = Files.walk(directory, new FileVisitOption[0]).filter(arg_0 -> GHGQLQueryLoader.findAllQueries$lambda$2(GHGQLQueryLoader::findAllQueries$lambda$1, arg_0)).map(arg_0 -> GHGQLQueryLoader.findAllQueries$lambda$4(GHGQLQueryLoader::findAllQueries$lambda$3, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
        return list;
    }

    @NotNull
    public String loadQuery(@NotNull String queryPath) {
        Intrinsics.checkNotNullParameter((Object)queryPath, (String)"queryPath");
        return delegate.loadQuery(queryPath);
    }

    private static final InputStream delegate$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return GHGQLQueryLoader.class.getClassLoader().getResourceAsStream(it);
    }

    private static final boolean findAllQueries$lambda$1(Path it) {
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return !Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final boolean findAllQueries$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String findAllQueries$lambda$3(Path it) {
        return "graphql/query/" + it.getFileName();
    }

    private static final String findAllQueries$lambda$4(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

