/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.settings.exclude;

import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.settings.exclude.TypeScriptExcludeManager;
import com.intellij.lang.typescript.settings.exclude.TypeScriptStartupActivity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptGeneratedFilesListener
implements AsyncFileListener {
    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        ExcludeState providers;
        if (events == null) {
            TypeScriptGeneratedFilesListener.$$$reportNull$$$0(0);
        }
        return (providers = TypeScriptGeneratedFilesListener.getFilesToExclude(events)) != null ? new AsyncFileListener.ChangeApplier(){

            public void afterVfsChange() {
                Project[] projects;
                List excluded = (List)StreamEx.of(providers.excludedFiles.values()).map(Supplier::get).nonNull().collect(Collectors.toList());
                for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
                    ProjectFileIndex index = ProjectFileIndex.getInstance((Project)project);
                    List excludedFiles = ((StreamEx)StreamEx.of((Collection)excluded).filter(el -> el.isValid() && index.isInContent(el))).toList();
                    if (excludedFiles.isEmpty() && providers.unExcludedFiles.isEmpty()) continue;
                    TypeScriptExcludeManager generatedFilesManager = TypeScriptExcludeManager.getInstance(project);
                    Collection intersection = ContainerUtil.intersection(generatedFilesManager.getExcludedPaths(), providers.unExcludedFiles);
                    if (!intersection.isEmpty()) {
                        generatedFilesManager.removeFiles(providers.unExcludedFiles);
                        VirtualFileManager fileManager = VirtualFileManager.getInstance();
                        List fileToIndex = ContainerUtil.mapNotNull((Collection)intersection, arg_0 -> ((VirtualFileManager)fileManager).findFileByUrl(arg_0));
                        TypeScriptStartupActivity.updateProject(project, generatedFilesManager, fileToIndex);
                        continue;
                    }
                    if (!generatedFilesManager.addFiles(excludedFiles)) continue;
                    TypeScriptStartupActivity.updateProject(project, generatedFilesManager, Collections.emptyList());
                }
            }
        } : null;
    }

    @Nullable
    private static ExcludeState getFilesToExclude(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            TypeScriptGeneratedFilesListener.$$$reportNull$$$0(1);
        }
        ExcludeState state = null;
        for (VFileEvent vFileEvent : events) {
            VirtualFile parent;
            VFilePropertyChangeEvent vFilePropertyChangeEvent;
            VirtualFile file;
            Collection<Object> toExclude = Collections.emptyList();
            Collection<Object> unExclude = Collections.emptyList();
            if (vFileEvent instanceof VFileCreateEvent) {
                toExclude = TypeScriptGeneratedFilesListener.processCreateEvent(vFileEvent);
            } else if (vFileEvent instanceof VFileCopyEvent) {
                toExclude = TypeScriptGeneratedFilesListener.processCopyEvent(vFileEvent);
            } else if (vFileEvent instanceof VFileDeleteEvent) {
                unExclude = TypeScriptGeneratedFilesListener.processDeleteEvent(vFileEvent);
            } else if (vFileEvent instanceof VFileMoveEvent) {
                VFileMoveEvent moveEvent = (VFileMoveEvent)vFileEvent;
                file = moveEvent.getFile();
                VirtualFile oldParent = moveEvent.getOldParent();
                String fileName = file.getName();
                if (oldParent != null) {
                    unExclude = TypeScriptGeneratedFilesListener.getSiblingFilesToUnExclude(fileName, oldParent);
                }
                VirtualFile newParent = moveEvent.getNewParent();
                toExclude = TypeScriptGeneratedFilesListener.getSiblingFilesToExclude(fileName, newParent);
            } else if (vFileEvent instanceof VFilePropertyChangeEvent && (vFilePropertyChangeEvent = (VFilePropertyChangeEvent)vFileEvent).isRename() && (parent = (file = vFilePropertyChangeEvent.getFile()).getParent()) != null) {
                String oldName = (String)vFilePropertyChangeEvent.getOldValue();
                String newName = (String)vFilePropertyChangeEvent.getNewValue();
                unExclude = TypeScriptGeneratedFilesListener.getSiblingFilesToUnExclude(oldName, parent);
                toExclude = TypeScriptGeneratedFilesListener.getSiblingFilesToExclude(newName, parent);
            }
            if (!toExclude.isEmpty()) {
                if (state == null) {
                    state = new ExcludeState();
                }
                for (ExcludedFile excludedFile : toExclude) {
                    if (excludedFile.myNotTsSource && state.unExcludedFiles.contains(excludedFile.myPath)) continue;
                    state.excludedFiles.put(excludedFile.myPath, excludedFile.myFile);
                    state.unExcludedFiles.remove(excludedFile.myPath);
                }
            }
            if (unExclude.isEmpty()) continue;
            if (state == null) {
                state = new ExcludeState();
            }
            for (String string : unExclude) {
                state.unExcludedFiles.add(string);
                state.excludedFiles.remove(string);
            }
        }
        return state;
    }

    private static Collection<String> processDeleteEvent(VFileEvent event) {
        VirtualFile tsCandidate = event.getFile();
        if (tsCandidate != null) {
            return TypeScriptGeneratedFilesListener.getSiblingFilesToUnExclude(tsCandidate.getName(), tsCandidate.getParent());
        }
        return Collections.emptyList();
    }

    @NotNull
    private static Collection<ExcludedFile> processCopyEvent(@NotNull VFileEvent event) {
        VirtualFile parent;
        String name;
        if (event == null) {
            TypeScriptGeneratedFilesListener.$$$reportNull$$$0(2);
        }
        if (TypeScriptGeneratedFilesListener.shouldExcludeFile(name = ((VFileCopyEvent)event).getNewChildName(), parent = ((VFileCopyEvent)event).getNewParent())) {
            String path2 = event.getPath();
            VirtualFileSystem system = event.getFileSystem();
            List<ExcludedFile> list = Collections.singletonList(new ExcludedFile(() -> system.findFileByPath(path2), path2, true));
            if (list == null) {
                TypeScriptGeneratedFilesListener.$$$reportNull$$$0(3);
            }
            return list;
        }
        return TypeScriptGeneratedFilesListener.getSiblingFilesToExclude(name, parent);
    }

    @NotNull
    private static Collection<ExcludedFile> processCreateEvent(@NotNull VFileEvent event) {
        VirtualFile parent;
        String name;
        if (event == null) {
            TypeScriptGeneratedFilesListener.$$$reportNull$$$0(4);
        }
        if (TypeScriptGeneratedFilesListener.shouldExcludeFile(name = ((VFileCreateEvent)event).getChildName(), parent = ((VFileCreateEvent)event).getParent())) {
            Set<ExcludedFile> set = Collections.singleton(new ExcludedFile(() -> event.getFile(), event.getPath(), true));
            if (set == null) {
                TypeScriptGeneratedFilesListener.$$$reportNull$$$0(5);
            }
            return set;
        }
        return TypeScriptGeneratedFilesListener.getSiblingFilesToExclude(name, parent);
    }

    @NotNull
    private static List<ExcludedFile> getSiblingFilesToExclude(@NotNull String tsFileName, @Nullable VirtualFile directory) {
        if (tsFileName == null) {
            TypeScriptGeneratedFilesListener.$$$reportNull$$$0(6);
        }
        if (directory == null) {
            List<ExcludedFile> list = Collections.emptyList();
            if (list == null) {
                TypeScriptGeneratedFilesListener.$$$reportNull$$$0(7);
            }
            return list;
        }
        String tsExtension = JSFileReferencesUtil.findExtension(tsFileName, TypeScriptUtil.TYPESCRIPT_EXTENSIONS_WITHOUT_DECLARATIONS);
        if (tsExtension == null) {
            List<ExcludedFile> list = Collections.emptyList();
            if (list == null) {
                TypeScriptGeneratedFilesListener.$$$reportNull$$$0(8);
            }
            return list;
        }
        String fileNameWithoutExtension = JSFileReferencesUtil.trimExistingExtension(tsFileName, tsExtension);
        SmartList objects = new SmartList();
        for (String ext : TypeScriptStartupActivity.Holder.JS_DTS_MAP_EXTENSIONS) {
            VirtualFile child = directory.findChild(String.valueOf(fileNameWithoutExtension) + ext);
            if (child == null) continue;
            String path2 = child.getPath();
            objects.add((Object)new ExcludedFile(() -> directory.findChild(String.valueOf(fileNameWithoutExtension) + ext), path2, false));
        }
        SmartList smartList = objects;
        if (smartList == null) {
            TypeScriptGeneratedFilesListener.$$$reportNull$$$0(9);
        }
        return smartList;
    }

    @NotNull
    private static List<String> getSiblingFilesToUnExclude(@NotNull String tsFileName, @Nullable VirtualFile directory) {
        if (tsFileName == null) {
            TypeScriptGeneratedFilesListener.$$$reportNull$$$0(10);
        }
        if (directory == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                TypeScriptGeneratedFilesListener.$$$reportNull$$$0(11);
            }
            return list;
        }
        String tsExtension = JSFileReferencesUtil.findExtension(tsFileName, TypeScriptUtil.TYPESCRIPT_EXTENSIONS_WITHOUT_DECLARATIONS);
        if (tsExtension == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                TypeScriptGeneratedFilesListener.$$$reportNull$$$0(12);
            }
            return list;
        }
        String fileNameWithoutExtension = JSFileReferencesUtil.trimExistingExtension(tsFileName, tsExtension);
        ArrayList<String> objects = new ArrayList<String>(TypeScriptStartupActivity.Holder.JS_DTS_MAP_EXTENSIONS.length);
        String directoryString = TypeScriptExcludeManager.mapToString(directory);
        for (String ext : TypeScriptStartupActivity.Holder.JS_DTS_MAP_EXTENSIONS) {
            objects.add(directoryString + "/" + String.valueOf(fileNameWithoutExtension) + ext);
        }
        ArrayList<String> arrayList = objects;
        if (arrayList == null) {
            TypeScriptGeneratedFilesListener.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    public static boolean shouldExcludeFile(@NotNull String name, @Nullable VirtualFile directory) {
        if (name == null) {
            TypeScriptGeneratedFilesListener.$$$reportNull$$$0(14);
        }
        if (directory == null) {
            return false;
        }
        String jsExtension = JSFileReferencesUtil.findExtension(name, TypeScriptStartupActivity.Holder.JS_DTS_MAP_EXTENSIONS);
        if (jsExtension == null) {
            return false;
        }
        String jsFileNameWithoutExtension = JSFileReferencesUtil.trimExistingExtension(name, jsExtension);
        for (String ext : TypeScriptUtil.TYPESCRIPT_EXTENSIONS_WITHOUT_DECLARATIONS) {
            VirtualFile child = directory.findChild(String.valueOf(jsFileNameWithoutExtension) + ext);
            if (child == null) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7, 8, 9, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesListener";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsFileName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "processCopyEvent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "processCreateEvent";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiblingFilesToExclude";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiblingFilesToUnExclude";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareChange";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToExclude";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processCopyEvent";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processCreateEvent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingFilesToExclude";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingFilesToUnExclude";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "shouldExcludeFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7, 8, 9, 11, 12, 13 -> new IllegalStateException(string);
        };
    }

    private static final class ExcludeState {
        Map<String, Supplier<VirtualFile>> excludedFiles = new LinkedHashMap<String, Supplier<VirtualFile>>();
        Collection<String> unExcludedFiles = new LinkedHashSet<String>();

        private ExcludeState() {
        }
    }

    static final class ExcludedFile {
        private final Supplier<VirtualFile> myFile;
        private final String myPath;
        private final boolean myNotTsSource;

        ExcludedFile(@NotNull Supplier<VirtualFile> file, @NotNull String path2, boolean notTsSource) {
            if (file == null) {
                ExcludedFile.$$$reportNull$$$0(0);
            }
            if (path2 == null) {
                ExcludedFile.$$$reportNull$$$0(1);
            }
            this.myFile = file;
            this.myPath = path2;
            this.myNotTsSource = notTsSource;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesListener$ExcludedFile";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

