/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSQualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JavaScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.psi.util.JSFindFirstResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ES6QualifiedNameResolver
extends JSQualifiedNameResolver {
    private final boolean myResolveGlobals;
    private final boolean myIsFromJSDoc;

    public ES6QualifiedNameResolver(@NotNull PsiElement context2) {
        if (context2 == null) {
            ES6QualifiedNameResolver.$$$reportNull$$$0(0);
        }
        this(context2, false);
    }

    public ES6QualifiedNameResolver(@NotNull PsiElement context2, boolean acceptObjectScopes) {
        if (context2 == null) {
            ES6QualifiedNameResolver.$$$reportNull$$$0(1);
        }
        this(context2, acceptObjectScopes, false);
    }

    public ES6QualifiedNameResolver(@NotNull PsiElement context2, boolean acceptObjectScopes, boolean resolveGlobals) {
        if (context2 == null) {
            ES6QualifiedNameResolver.$$$reportNull$$$0(2);
        }
        this(context2, acceptObjectScopes, resolveGlobals, false);
    }

    public ES6QualifiedNameResolver(@NotNull PsiElement context2, boolean acceptObjectScopes, boolean resolveGlobals, boolean isFromJSDoc) {
        if (context2 == null) {
            ES6QualifiedNameResolver.$$$reportNull$$$0(3);
        }
        super(context2, acceptObjectScopes);
        this.myResolveGlobals = resolveGlobals;
        this.myIsFromJSDoc = isFromJSDoc;
    }

    @Override
    @NotNull
    protected JSQualifiedNameResolver createNestedResolver(@NotNull PsiElement newContext) {
        if (newContext == null) {
            ES6QualifiedNameResolver.$$$reportNull$$$0(4);
        }
        return new ES6QualifiedNameResolver(newContext, this.myAcceptableObjectScope);
    }

    @Override
    @NotNull
    protected Collection<PsiElement> getTopLevelForModulePrefix(@NotNull String name) {
        if (name == null) {
            ES6QualifiedNameResolver.$$$reportNull$$$0(5);
        }
        String moduleNameWithoutPrefix = name.substring("module:".length());
        Collection<PsiElement> collection = CommonJSUtil.resolveJSDocCommentModules(this.myContext, moduleNameWithoutPrefix);
        if (collection == null) {
            ES6QualifiedNameResolver.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<PsiElement> getTopLevelElementsWalkUp(@NotNull String topLevelName, boolean isContainer) {
        List<PsiElement> elements;
        PsiElement context2;
        if (topLevelName == null) {
            ES6QualifiedNameResolver.$$$reportNull$$$0(7);
        }
        for (context2 = this.myContext; context2 != null && JSDocTokenTypes.ALL.contains(ES6QualifiedNameResolver.getElementType(context2)); context2 = context2.getContext()) {
        }
        JSDocComment docComment = null;
        if (context2 instanceof JSDocComment) {
            docComment = (JSDocComment)context2;
            PsiElement element = JSStubBasedPsiTreeUtil.findAssociatedElement(docComment);
            context2 = element != null ? element.getContext() : context2.getContext();
        }
        if (!(elements = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(topLevelName, (PsiElement)ObjectUtils.notNull((Object)context2, (Object)this.myContext))).isEmpty()) {
            List<PsiElement> list = elements;
            if (list == null) {
                ES6QualifiedNameResolver.$$$reportNull$$$0(8);
            }
            return list;
        }
        if (this.isFromJSDoc() && docComment != null && !JSStubBasedPsiTreeUtil.hasStub((PsiElement)docComment)) {
            JSFindFirstResolveProcessor processor = new JSFindFirstResolveProcessor(topLevelName, false);
            JSResolveUtil.processDeclarationsInScopeAndUp((PsiElement)docComment, processor);
            if (processor.getResult() != null) {
                List<PsiElement> list = Collections.singletonList(processor.getResult());
                if (list == null) {
                    ES6QualifiedNameResolver.$$$reportNull$$$0(9);
                }
                return list;
            }
        }
        if (this.myResolveGlobals) {
            if (JSCorePredefinedLibrariesProvider.isLibraryElement(this.myContext)) {
                return new SmartList(JavaScriptQualifiedItemProcessor.resolveGlobalTypeElementsByName(topLevelName, this.myContext));
            }
            JSElement moduleScope = ES6PsiUtil.getNonStrictExportScope(this.myContext);
            JSElement place = moduleScope == null ? this.myContext : moduleScope;
            ResolveResult[] results = JSReferenceExpressionResolver.resolveGlobalReference(topLevelName, (PsiElement)place, false, true);
            List<PsiElement> list = JSResolveResult.toElements(results, true);
            if (list == null) {
                ES6QualifiedNameResolver.$$$reportNull$$$0(10);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            ES6QualifiedNameResolver.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Nullable
    private static IElementType getElementType(@NotNull PsiElement element) {
        if (element == null) {
            ES6QualifiedNameResolver.$$$reportNull$$$0(12);
        }
        if (element instanceof StubBasedPsiElement) {
            return ((StubBasedPsiElement)element).getElementType();
        }
        if (element instanceof ASTNode) {
            return ((ASTNode)element).getElementType();
        }
        return null;
    }

    @Override
    protected boolean isFromJSDoc() {
        return this.myIsFromJSDoc || super.isFromJSDoc();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/ES6QualifiedNameResolver";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/ES6QualifiedNameResolver";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelForModulePrefix";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelElementsWalkUp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNestedResolver";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelForModulePrefix";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelElementsWalkUp";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getElementType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

