/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.index.gist.JSStubElementGist;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.impl.JSDefinitionExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPropertyImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.stubs.JSTypeOwnerStub;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSCachingTypeOwner
extends JSTypeOwner,
PsiElement {
    public static final Key<ParameterizedCachedValue<JSType, JSCachingTypeOwner>> TYPE_KEY = Key.create((String)"js.element.type");
    public static final Key<JSStubElementImpl.StubBuildCachedValue<JSType>> STUB_BUILDING_TYPE_KEY = Key.create((String)"js.stub.building.element.type");
    public static final ParameterizedCachedValueProvider<JSType, JSCachingTypeOwner> TYPE_PROVIDER = psi -> {
        JSType type2;
        if (psi instanceof JSVariableBaseImpl || psi instanceof JSPropertyImpl || psi instanceof JSDefinitionExpressionImpl) {
            JSType type3;
            JSStubElementGist gistService = JSStubElementGist.getInstance(psi.getProject());
            JSType jSType = psi instanceof JSVariableBaseImpl ? gistService.getData((JSVariableBaseImpl)psi).getJSType((PsiElement)psi) : (type3 = psi instanceof JSDefinitionExpressionImpl ? gistService.getData((JSDefinitionExpressionImpl)psi).getJSType((PsiElement)psi) : gistService.getData((JSPropertyImpl)psi).getJSType((PsiElement)psi));
            if (type3 == null) {
                type3 = psi.calculateDeclarationTypeStubSafe();
            }
            return new CachedValueProvider.Result((Object)type3, new Object[]{psi});
        }
        JSTypeOwnerStub stub = (JSTypeOwnerStub)((StubBasedPsiElementBase)psi).getGreenStub();
        if (stub != null) {
            String typeString = stub.getSerializedTypeString();
            if (typeString == null) {
                type2 = psi.calculateDeclarationTypeStubSafe();
            } else {
                JSDocComment docComment;
                Object sourceElement = psi;
                if (stub.isTypeFromJSDoc() && (docComment = JSStubBasedPsiTreeUtil.findOwnDocComment(psi)) != null) {
                    sourceElement = docComment;
                }
                type2 = JSTypeParser.parseSerializedType(sourceElement.getProject(), typeString, JSTypeSourceFactory.createTypeSource((PsiElement)sourceElement, stub.isTypeStrict()));
            }
        } else {
            type2 = psi.calculateType();
            type2 = JSCachingTypeOwner.unifyPsiAndStubBased(type2, psi);
        }
        return CachedValueProvider.Result.create((Object)type2, (Object[])new Object[]{psi});
    };

    @Contract(value="null, _ -> null; !null, _ -> !null")
    @Nullable
    public static JSType unifyPsiAndStubBased(@Nullable JSType type2, @NotNull PsiElement source) {
        if (source == null) {
            JSCachingTypeOwner.$$$reportNull$$$0(0);
        }
        if (type2 != null && !(type2.getSource().getSourceElement() instanceof JSDocComment) && !(type2.getSource().getSourceElement() instanceof JSTypeDeclaration) && DialectDetector.isJavaScript(source)) {
            return type2.withNewSource(JSTypeSourceFactory.createTypeSource(source, type2.isSourceStrict()));
        }
        return type2;
    }

    @Nullable
    public JSType calculateType();

    default public boolean shouldSerializeType() {
        return true;
    }

    @Nullable
    default public JSType calculateDeclarationTypeStubSafe() {
        return null;
    }

    @Override
    @Nullable
    default public JSType getJSType() {
        return JSStubElementImpl.getCachedValueStubBuildOptimized(this, TYPE_KEY, STUB_BUILDING_TYPE_KEY, TYPE_PROVIDER, this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/impl/JSCachingTypeOwner", "unifyPsiAndStubBased"));
    }
}

