/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSNodeModuleStructure {
    @NotNull
    public final VirtualFile directoryToCalcModuleName;
    @NotNull
    public final VirtualFile moduleDirectory;
    @NotNull
    public final VirtualFile nodeModules;

    @Nullable
    public static JSNodeModuleStructure getStructure(@NotNull Project project, @NotNull VirtualFile fileToImport) {
        Pair<VirtualFile, VirtualFile> directories;
        if (project == null) {
            JSNodeModuleStructure.$$$reportNull$$$0(0);
        }
        if (fileToImport == null) {
            JSNodeModuleStructure.$$$reportNull$$$0(1);
        }
        if ((directories = JSNodeModuleStructure.findParentNodeModules(project, fileToImport)) == null) {
            return null;
        }
        VirtualFile moduleDirectory = (VirtualFile)directories.first;
        if (moduleDirectory == null) {
            return null;
        }
        VirtualFile nodeModules = (VirtualFile)directories.second;
        VirtualFile directoryToCalcModuleName = JSNodeModuleStructure.getDirectoryToCalcModuleNameInNodeModules(moduleDirectory);
        if (directoryToCalcModuleName == null) {
            return null;
        }
        return new JSNodeModuleStructure(moduleDirectory, directoryToCalcModuleName, nodeModules);
    }

    @Nullable
    private static Pair<VirtualFile, VirtualFile> findParentNodeModules(@NotNull Project project, @NotNull VirtualFile dstFile) {
        if (project == null) {
            JSNodeModuleStructure.$$$reportNull$$$0(2);
        }
        if (dstFile == null) {
            JSNodeModuleStructure.$$$reportNull$$$0(3);
        }
        ProgressManager.checkCanceled();
        VirtualFile prevDirectory = dstFile.isDirectory() ? dstFile : null;
        VirtualFile prevDirectoryWithPackageJson = null;
        VirtualFile contentRoot = JSLibraryUtil.getContentRootForFile(project, dstFile);
        for (VirtualFile currentDirectory = dstFile.getParent(); currentDirectory != null; currentDirectory = currentDirectory.getParent()) {
            if (ArrayUtil.contains((String)currentDirectory.getName(), (String[])new String[]{"node_modules"})) {
                VirtualFile module = prevDirectoryWithPackageJson == null ? prevDirectory : prevDirectoryWithPackageJson;
                return module == null ? null : Pair.create((Object)module, (Object)currentDirectory);
            }
            if (Objects.equals(contentRoot, currentDirectory)) break;
            if (null != currentDirectory.findChild("package.json")) {
                prevDirectoryWithPackageJson = currentDirectory;
            }
            prevDirectory = currentDirectory;
        }
        return null;
    }

    @Nullable
    private static VirtualFile getDirectoryToCalcModuleNameInNodeModules(@NotNull VirtualFile moduleDirectory) {
        VirtualFile directoryToCalcModuleName;
        if (moduleDirectory == null) {
            JSNodeModuleStructure.$$$reportNull$$$0(4);
        }
        VirtualFile current = moduleDirectory;
        VirtualFile nodeModulesDirectory = null;
        Object object = directoryToCalcModuleName = NodeModuleUtil.isTypesDir(current) ? current : null;
        while (current != null) {
            if ((current = current.getParent()) == null) continue;
            if (NodeModuleUtil.isTypesDir(current)) {
                directoryToCalcModuleName = current;
                continue;
            }
            if (!"node_modules".equals(current.getName())) continue;
            nodeModulesDirectory = current;
            break;
        }
        if (nodeModulesDirectory == null) {
            return null;
        }
        if (directoryToCalcModuleName == null) {
            directoryToCalcModuleName = nodeModulesDirectory;
        }
        return directoryToCalcModuleName;
    }

    public JSNodeModuleStructure(@NotNull VirtualFile moduleDirectory, @NotNull VirtualFile directoryToCalcName, @NotNull VirtualFile nodeModules) {
        if (moduleDirectory == null) {
            JSNodeModuleStructure.$$$reportNull$$$0(5);
        }
        if (directoryToCalcName == null) {
            JSNodeModuleStructure.$$$reportNull$$$0(6);
        }
        if (nodeModules == null) {
            JSNodeModuleStructure.$$$reportNull$$$0(7);
        }
        this.directoryToCalcModuleName = directoryToCalcName;
        this.moduleDirectory = moduleDirectory;
        this.nodeModules = nodeModules;
    }

    @NotNull
    public String getPackageName() {
        VirtualFile parent = this.moduleDirectory.getParent();
        Object object = parent.equals(this.nodeModules) ? this.moduleDirectory.getName() : parent.getName() + "/" + this.moduleDirectory.getName();
        if (object == null) {
            JSNodeModuleStructure.$$$reportNull$$$0(8);
        }
        return object;
    }

    @NotNull
    public String getOriginalPackageName() {
        VirtualFile parent = this.moduleDirectory.getParent();
        if (NodeModuleUtil.isTypesDir(parent)) {
            String string = ES6CreateImportUtil.convertScopedTypesName(this.moduleDirectory.getName());
            if (string == null) {
                JSNodeModuleStructure.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = this.getPackageName();
        if (string == null) {
            JSNodeModuleStructure.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean isFromTypes() {
        return NodeModuleUtil.isTypesDir(this.moduleDirectory.getParent());
    }

    @NotNull
    public String getNodeModulePath(@NotNull VirtualFile moduleOrFileToImport) {
        String path2;
        if (moduleOrFileToImport == null) {
            JSNodeModuleStructure.$$$reportNull$$$0(11);
        }
        if ((path2 = VfsUtilCore.findRelativePath((VirtualFile)this.directoryToCalcModuleName, (VirtualFile)moduleOrFileToImport, (char)'/')) == null || !this.isFromTypes()) {
            String string = StringUtil.notNullize((String)path2);
            if (string == null) {
                JSNodeModuleStructure.$$$reportNull$$$0(12);
            }
            return string;
        }
        String name = this.moduleDirectory.getName();
        if (!path2.startsWith(name)) {
            String string = path2;
            if (string == null) {
                JSNodeModuleStructure.$$$reportNull$$$0(13);
            }
            return string;
        }
        String convertedName = ES6CreateImportUtil.convertScopedTypesName(name);
        if (convertedName.equals(name)) {
            String string = path2;
            if (string == null) {
                JSNodeModuleStructure.$$$reportNull$$$0(14);
            }
            return string;
        }
        String subPath = path2.substring(name.length());
        String string = convertedName + subPath;
        if (string == null) {
            JSNodeModuleStructure.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 12, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToImport";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dstFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDirectory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryToCalcName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModules";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/JSNodeModuleStructure";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleOrFileToImport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/JSNodeModuleStructure";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalPackageName";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeModulePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStructure";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findParentNodeModules";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoryToCalcModuleNameInNodeModules";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNodeModulePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 12, 13, 14, 15 -> new IllegalStateException(string);
        };
    }
}

