/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt.execution;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.ui.SystemNotifications;
import com.intellij.util.Alarm;
import org.jetbrains.annotations.NotNull;

public class GruntNotifier {
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("Grunt Console");
    private final Project myProject;
    private final Alarm myAlarm;
    private boolean myPrevSuccess;

    public GruntNotifier(@NotNull Project project) {
        if (project == null) {
            GruntNotifier.$$$reportNull$$$0(0);
        }
        this.myPrevSuccess = true;
        this.myProject = project;
        this.myAlarm = new Alarm();
    }

    public void scheduleNotification(boolean success) {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> this.doNotify(success), 300, ModalityState.any());
    }

    private void doNotify(boolean success) {
        if (this.myProject.isDisposed()) {
            return;
        }
        NotificationGroup group = NOTIFICATION_GROUP;
        NotificationsConfiguration configuration = NotificationsConfiguration.getNotificationsConfiguration();
        NotificationDisplayType oldSetting = null;
        if (this.myPrevSuccess == success) {
            oldSetting = configuration.getDisplayType(group.getDisplayId());
            configuration.setDisplayType(group.getDisplayId(), NotificationDisplayType.NONE);
        }
        String message = GruntNotifier.formatMessage(success);
        Notification notification = group.createNotification(message, success ? MessageType.INFO : MessageType.ERROR);
        notification.notify(this.myProject);
        if (Registry.is((String)"js.grunt.show.system.notifications")) {
            SystemNotifications.getInstance().notify("Grunt Console", message, "");
        }
        if (oldSetting != null) {
            configuration.setDisplayType(group.getDisplayId(), oldSetting);
        }
        this.myPrevSuccess = success;
        GruntNotifier.synchronizeFS();
    }

    private static void synchronizeFS() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> LocalFileSystem.getInstance().refresh(true));
    }

    private static String formatMessage(boolean success) {
        if (success) {
            return "Task \"watch\" passed";
        }
        return "Task \"watch\" failed";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/execution/GruntNotifier", "<init>"));
    }
}

