/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.webTypes.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intellij.webSymbols.webTypes.json.Type;
import com.intellij.webSymbols.webTypes.json.TypeReference;
import java.io.IOException;
import java.util.List;

@JsonDeserialize(using=MyDeserializer.class)
public class HtmlValueType {
    private Object value;

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public static class MyDeserializer
    extends JsonDeserializer<HtmlValueType> {
        public HtmlValueType deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
            HtmlValueType result2 = new HtmlValueType();
            JsonToken token = parser.currentToken();
            if (token == JsonToken.VALUE_STRING) {
                result2.value = parser.readValueAs(String.class);
            } else if (token == JsonToken.START_OBJECT) {
                result2.value = parser.readValueAs(TypeReference.class);
            } else if (token == JsonToken.START_ARRAY) {
                result2.value = parser.getCodec().readValue(parser, (ResolvedType)deserializationContext.getTypeFactory().constructParametricType(List.class, new Class[]{Type.class}));
            } else {
                deserializationContext.handleUnexpectedToken(Object.class, parser);
            }
            return result2;
        }
    }
}

