/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomReferenceInjector;
import com.intellij.util.xml.EnumConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.Referencing;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.impl.ConvertContextFactory;
import com.intellij.util.xml.impl.ConverterManagerImpl;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.GenericDomValueReference;
import com.intellij.xml.util.XmlEnumeratedValueReferenceProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class GenericValueReferenceProvider
extends PsiReferenceProvider {
    private static final Logger LOG = Logger.getInstance(GenericValueReferenceProvider.class);

    public boolean acceptsHints(@NotNull PsiElement element, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PsiReferenceService.Hints hints) {
        if (element == null) {
            GenericValueReferenceProvider.$$$reportNull$$$0(0);
        }
        if (hints == null) {
            GenericValueReferenceProvider.$$$reportNull$$$0(1);
        }
        if (hints == PsiReferenceService.Hints.HIGHLIGHTED_REFERENCES) {
            return false;
        }
        return super.acceptsHints(element, hints);
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext context) {
        PsiReference[] references;
        Object converter;
        DomInvocationHandler handler2;
        if (psiElement == null) {
            GenericValueReferenceProvider.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GenericValueReferenceProvider.$$$reportNull$$$0(3);
        }
        DomManagerImpl domManager = DomManagerImpl.getDomManager(psiElement.getProject());
        if (psiElement instanceof XmlTag) {
            handler2 = domManager.getDomHandler((XmlElement)((XmlTag)psiElement));
        } else if (psiElement instanceof XmlAttributeValue && psiElement.getParent() instanceof XmlAttribute) {
            handler2 = domManager.getDomHandler((XmlElement)((XmlAttribute)psiElement.getParent()));
        } else {
            if (PsiReference.EMPTY_ARRAY == null) {
                GenericValueReferenceProvider.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (handler2 == null || !GenericDomValue.class.isAssignableFrom(handler2.getRawType())) {
            if (PsiReference.EMPTY_ARRAY == null) {
                GenericValueReferenceProvider.$$$reportNull$$$0(5);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)psiElement.getProject());
        if (psiElement instanceof XmlTag) {
            for (XmlText text : ((XmlTag)psiElement).getValue().getTextElements()) {
                if (!injectedLanguageManager.hasInjections((PsiElement)text)) continue;
                if (PsiReference.EMPTY_ARRAY == null) {
                    GenericValueReferenceProvider.$$$reportNull$$$0(6);
                }
                return PsiReference.EMPTY_ARRAY;
            }
        } else if (injectedLanguageManager.hasInjections(psiElement)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                GenericValueReferenceProvider.$$$reportNull$$$0(7);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        GenericDomValue domValue = (GenericDomValue)handler2.getProxy();
        Referencing referencing = handler2.getAnnotation(Referencing.class);
        if (referencing == null) {
            try (AccessToken ignored = ReferenceProvidersRegistry.suppressAssertNotContributingReferences();){
                converter = WrappingConverter.getDeepestConverter((Converter)domValue.getConverter(), (GenericDomValue)domValue);
            }
        } else {
            converter = ConverterManagerImpl.getOrCreateConverterInstance(referencing.value());
        }
        try (AccessToken ignored = ReferenceProvidersRegistry.suppressAssertNotContributingReferences();){
            references = GenericValueReferenceProvider.createReferences(domValue, (XmlElement)psiElement, converter, handler2, domManager);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            for (PsiReference reference : references) {
                if (reference.isSoft()) continue;
                LOG.error("dom reference should be soft: " + String.valueOf(reference) + " (created by " + String.valueOf(converter) + ")");
            }
        }
        if (references.length > 0) {
            if (converter instanceof EnumConverter && !((EnumConverter)((Object)converter)).isExhaustive()) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    GenericValueReferenceProvider.$$$reportNull$$$0(8);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            context.put(XmlEnumeratedValueReferenceProvider.SUPPRESS, (Object)Boolean.TRUE);
        }
        if (references == null) {
            GenericValueReferenceProvider.$$$reportNull$$$0(9);
        }
        return references;
    }

    private static PsiReference[] createReferences(GenericDomValue<?> domValue, XmlElement psiElement, Object converter, DomInvocationHandler handler2, DomManager domManager) {
        XmlFile file = handler2.getFile();
        DomFileDescription description = domManager.getDomFileDescription(file);
        if (description == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList result2 = new ArrayList();
        ConvertContext context = ConvertContextFactory.createConvertContext(domValue);
        List injectors = description.getReferenceInjectors();
        if (!injectors.isEmpty()) {
            String unresolvedText = ElementManipulators.getValueText((PsiElement)psiElement);
            for (DomReferenceInjector each : injectors) {
                Collections.addAll(result2, each.inject(unresolvedText, (PsiElement)psiElement, context));
            }
        }
        Collections.addAll(result2, GenericValueReferenceProvider.doCreateReferences(domValue, psiElement, converter, context));
        return result2.toArray(PsiReference.EMPTY_ARRAY);
    }

    private static PsiReference @NotNull [] doCreateReferences(GenericDomValue<?> domValue, XmlElement psiElement, Object converter, ConvertContext context) {
        PsiReference[] references;
        if (converter instanceof CustomReferenceConverter && ((references = ((CustomReferenceConverter)converter).createReferences(domValue, (PsiElement)psiElement, context)).length != 0 || !(converter instanceof ResolvingConverter))) {
            if (references == null) {
                GenericValueReferenceProvider.$$$reportNull$$$0(10);
            }
            return references;
        }
        if (converter instanceof ResolvingConverter) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new GenericDomValueReference(domValue)};
            if (psiReferenceArray == null) {
                GenericValueReferenceProvider.$$$reportNull$$$0(11);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            GenericValueReferenceProvider.$$$reportNull$$$0(12);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/impl/GenericValueReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/impl/GenericValueReferenceProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptsHints";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

