/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import java.io.File;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0010H\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0010H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/diagnostic/InMemoryHandler;", "Ljava/util/logging/Handler;", "outputPath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getOutputPath", "()Ljava/nio/file/Path;", "buildFailed", "", "getBuildFailed", "()Z", "setBuildFailed", "(Z)V", "messages", "", "", "publish", "", "record", "Ljava/util/logging/LogRecord;", "flush", "close", "removeOldFiles", "directoryPath", "removeOldFilesForTests", "Companion", "intellij.platform.util"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nInMemoryHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryHandler.kt\ncom/intellij/openapi/diagnostic/InMemoryHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,81:1\n1#2:82\n6180#3,2:83\n*S KotlinDebug\n*F\n+ 1 InMemoryHandler.kt\ncom/intellij/openapi/diagnostic/InMemoryHandler\n*L\n69#1:83,2\n*E\n"})
public final class InMemoryHandler
extends Handler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path outputPath;
    private boolean buildFailed;
    @NotNull
    private final List<String> messages;
    @NotNull
    public static final String FAILED_BUILD_LOG_FILE_NAME_PREFIX = "failed-build_";
    public static final int MAX_REPORT_NUMBER = 3;
    @NotNull
    public static final String IN_MEMORY_LOGGER_ADVANCED_SETTINGS_NAME = "compiler.inMemoryLogger";

    public InMemoryHandler(@NotNull Path outputPath) {
        Intrinsics.checkNotNullParameter(outputPath, "outputPath");
        this.outputPath = outputPath;
        this.messages = new ArrayList();
        this.removeOldFiles(((Object)this.outputPath.getParent()).toString());
    }

    @NotNull
    public final Path getOutputPath() {
        return this.outputPath;
    }

    public final boolean getBuildFailed() {
        return this.buildFailed;
    }

    public final void setBuildFailed(boolean bl) {
        this.buildFailed = bl;
    }

    @Override
    public void publish(@Nullable LogRecord record) {
        try {
            String string = this.getFormatter().format(record);
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (StringsKt.contains$default((CharSequence)it, "Compiled with errors", false, 2, null)) {
                    this.buildFailed = true;
                }
                this.messages.add(it);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        if (this.buildFailed) {
            File outputFile = new File(((Object)this.outputPath).toString());
            if (outputFile.exists()) {
                outputFile.delete();
            } else if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            outputFile.createNewFile();
            String it = CollectionsKt.joinToString$default(this.messages, "", null, null, 0, null, null, 62, null);
            boolean bl = false;
            FilesKt.appendText$default(outputFile, it, null, 2, null);
        }
        this.messages.clear();
        this.buildFailed = false;
    }

    private final void removeOldFiles(String directoryPath) {
        File[] logFiles;
        File file;
        File it = file = new File(directoryPath);
        boolean bl = false;
        if (!it.exists()) {
            return;
        }
        File directory = file;
        File[] it2 = bl = directory.listFiles(InMemoryHandler::removeOldFiles$lambda$3);
        boolean bl2 = false;
        Object object = it2.length > 3 ? bl : null;
        if (object == null) {
            return;
        }
        File[] it3 = logFiles = object;
        boolean bl3 = false;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss", Locale.getDefault());
        File[] $this$sortBy$iv = it3;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.length > 1) {
            ArraysKt.sortWith($this$sortBy$iv, new Comparator(dateFormat){
                final /* synthetic */ SimpleDateFormat $dateFormat$inlined;
                {
                    this.$dateFormat$inlined = simpleDateFormat;
                }

                public final int compare(T a, T b) {
                    File file = (File)a;
                    boolean bl = false;
                    String string = file.getName();
                    Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                    String datePart = StringsKt.removeSuffix(StringsKt.removePrefix(string, (CharSequence)"failed-build_"), (CharSequence)".log");
                    file = (File)b;
                    Comparable comparable = this.$dateFormat$inlined.parse(datePart);
                    bl = false;
                    String string2 = file.getName();
                    Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                    datePart = StringsKt.removeSuffix(StringsKt.removePrefix(string2, (CharSequence)"failed-build_"), (CharSequence)".log");
                    return ComparisonsKt.compareValues(comparable, (Comparable)this.$dateFormat$inlined.parse(datePart));
                }
            });
        }
        int n = it3.length - 3;
        for (int i = 0; i < n; ++i) {
            it3[i].delete();
        }
    }

    @TestOnly
    public final void removeOldFilesForTests(@NotNull String directoryPath) {
        Intrinsics.checkNotNullParameter(directoryPath, "directoryPath");
        this.removeOldFiles(directoryPath);
    }

    private static final boolean removeOldFiles$lambda$3(File file, String name) {
        Intrinsics.checkNotNull(name);
        return StringsKt.startsWith$default(name, FAILED_BUILD_LOG_FILE_NAME_PREFIX, false, 2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/diagnostic/InMemoryHandler$Companion;", "", "<init>", "()V", "FAILED_BUILD_LOG_FILE_NAME_PREFIX", "", "MAX_REPORT_NUMBER", "", "IN_MEMORY_LOGGER_ADVANCED_SETTINGS_NAME", "intellij.platform.util"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

