/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.java;

import com.intellij.ide.highlighter.ModuleFileType;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.api.BuildFileProvider;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.java.BuildFileProviderBase;
import com.intellij.packageChecker.java.JavaPackageUtilKt;
import com.intellij.packageChecker.java.JpsBuildFileProviderKt;
import com.intellij.packageChecker.java.ProjectDependenciesModels;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.package.Package;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0014\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011H\u0002J*\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J0\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00110\u001f2\u0006\u0010\f\u001a\u00020\r2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00160\u0011H\u0016J\"\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00110\u001f2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\u0006\u0010\u000f\u001a\u00020\u000bH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006#"}, d2={"Lcom/intellij/packageChecker/java/JpsBuildFileProvider;", "Lcom/intellij/packageChecker/java/BuildFileProviderBase;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "id", "", "getId", "()Ljava/lang/String;", "getModule", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/psi/PsiFile;", "moduleScript", "module", "declaredPackages", "", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "getJpsPackageDeclaration", "imlFile", "packages", "Lorg/jetbrains/security/package/Package;", "parseDependencyName", "Lkotlin/Pair;", "str", "isJar", "", "importedPackages", "supports", "getRoots", "", "pkgs", "findModuleForFile", "collectPackages", "intellij.packageChecker.java"})
@SourceDebugExtension(value={"SMAP\nJpsBuildFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsBuildFileProvider.kt\ncom/intellij/packageChecker/java/JpsBuildFileProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,166:1\n1#2:167\n774#3:168\n865#3,2:169\n774#3:171\n865#3,2:172\n1755#3,3:175\n1279#3,2:178\n1293#3,4:180\n25#4:174\n*S KotlinDebug\n*F\n+ 1 JpsBuildFileProvider.kt\ncom/intellij/packageChecker/java/JpsBuildFileProvider\n*L\n71#1:168\n71#1:169,2\n75#1:171\n75#1:172,2\n139#1:175,3\n147#1:178,2\n147#1:180,4\n131#1:174\n*E\n"})
public final class JpsBuildFileProvider
extends BuildFileProviderBase {
    @NotNull
    private final String id;

    public JpsBuildFileProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.id = "jps";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public Module getModule(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Module module = this.findModuleForFile(file);
        if (module == null) {
            JpsBuildFileProviderKt.access$getLogger$p().warn("Not a Jps module by file: " + file.getName());
        }
        return module;
    }

    @Override
    @Nullable
    public PsiFile moduleScript(@NotNull Module module) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        VirtualFile virtualFile = module.getModuleFile();
        if (virtualFile != null) {
            VirtualFile moduleFile = virtualFile;
            boolean bl = false;
            if (this.getProject().isDisposed() || !moduleFile.isValid()) {
                return null;
            }
            psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(moduleFile);
        } else {
            psiFile = null;
        }
        return psiFile;
    }

    @Override
    @NotNull
    public List<PackageDeclaration> declaredPackages(@Nullable PsiFile file, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (file == null) {
            return CollectionsKt.emptyList();
        }
        List<Package> jpsPackages = this.collectPackages(module);
        List<PackageDeclaration> jpsPackageDeclarations = this.getJpsPackageDeclaration(file, jpsPackages);
        if (JpsBuildFileProviderKt.access$getLogger$p().isDebugEnabled()) {
            JpsBuildFileProviderKt.access$getLogger$p().debug("found " + jpsPackages.size() + " jpsPackages and " + jpsPackageDeclarations.size() + " jpsPackageDeclarations");
        }
        return jpsPackageDeclarations;
    }

    private final List<PackageDeclaration> getJpsPackageDeclaration(PsiFile imlFile, List<Package> packages) {
        if (packages.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        PsiFile file = PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText("file.iml", (Language)XMLLanguage.INSTANCE, (CharSequence)imlFile.getText());
        PsiElement[] psiElementArray = file.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        List elements = ArraysKt.toMutableList((Object[])psiElementArray);
        List libraries = new ArrayList();
        while (!((Collection)elements).isEmpty()) {
            Object object = CollectionsKt.removeFirst((List)elements);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"removeFirst(...)");
            PsiElement element = (PsiElement)object;
            boolean isJar = element.textMatches((CharSequence)"type=\"module-library\"");
            if (element.textMatches((CharSequence)"type=\"library\"") || isJar) {
                Package pkg;
                Package package_;
                Object v5;
                Object it;
                String version;
                String artifactId;
                PsiElement jpsDependencyNameElement;
                block12: {
                    Pair<String, String> pair;
                    Object object2;
                    block11: {
                        PsiElement[] psiElementArray2 = element.getParent().getChildren();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray2, (String)"getChildren(...)");
                        for (Object object3 : (Object[])psiElementArray2) {
                            PsiElement it2 = (PsiElement)object3;
                            boolean bl = false;
                            String string = it2.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"name", (boolean)false, (int)2, null)) continue;
                            object2 = object3;
                            break block11;
                        }
                        object2 = null;
                    }
                    if ((PsiElement)object2 == null || this.parseDependencyName(jpsDependencyNameElement.getText(), isJar) == null) continue;
                    artifactId = (String)pair.component1();
                    version = (String)pair.component2();
                    Iterable iterable = packages;
                    for (Object e : iterable) {
                        it = (Package)e;
                        boolean bl2 = false;
                        boolean isVersionMatch = version != null ? Intrinsics.areEqual((Object)((Package)it).getVersion().getValue(), (Object)version) : true;
                        if (!(StringsKt.contains$default((CharSequence)artifactId, (CharSequence)(((Package)it).getNamespace() + ":" + ((Package)it).getName()), (boolean)false, (int)2, null) && isVersionMatch)) continue;
                        v5 = e;
                        break block12;
                    }
                    v5 = null;
                }
                Package foundByNamespaceNameAndVersion = v5;
                if (foundByNamespaceNameAndVersion == null) {
                    boolean bl;
                    Iterable $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = packages;
                    boolean bl2 = false;
                    it = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        Package it3 = (Package)element$iv$iv;
                        bl = false;
                        if (!StringsKt.contains$default((CharSequence)artifactId, (CharSequence)it3.getName(), (boolean)false, (int)2, null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Package package_2 = (Package)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                    package_ = package_2;
                    if (package_ == null) {
                        $this$filter$iv = packages;
                        boolean bl3 = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList();
                        $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            Package it2 = (Package)element$iv$iv;
                            bl = false;
                            String namespace = it2.getNamespace();
                            if (!(namespace != null && StringsKt.contains$default((CharSequence)artifactId, (CharSequence)namespace, (boolean)false, (int)2, null))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        package_ = (Package)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                    }
                } else {
                    package_ = foundByNamespaceNameAndVersion;
                }
                if ((pkg = package_) == null) {
                    Object[] objectArray = new Object[]{artifactId, version};
                    JpsBuildFileProviderKt.access$getLogger$p().debug("cannot find corresponding package by provided artifactId and version: ", objectArray);
                    continue;
                }
                libraries.add(new PackageDeclaration(pkg, jpsDependencyNameElement, jpsDependencyNameElement.getTextRange()));
                continue;
            }
            PsiElement[] psiElementArray3 = element.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray3, (String)"getChildren(...)");
            elements.addAll(0, ArraysKt.toList((Object[])psiElementArray3));
        }
        return libraries;
    }

    private final Pair<String, String> parseDependencyName(String str, boolean isJar) {
        Pair pair;
        if (str == null) {
            return null;
        }
        String text = StringsKt.substringAfter$default((String)str, (String)"name=", null, (int)2, null);
        if (StringsKt.contains$default((CharSequence)text, (CharSequence)"Maven:", (boolean)false, (int)2, null)) {
            String artifactId = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)StringsKt.substringAfter$default((String)text, (String)"Maven:", null, (int)2, null), (String)":", null, (int)2, null), (String)":", null, (int)2, null);
            String version = StringsKt.substringAfterLast$default((String)text, (String)":", null, (int)2, null);
            pair = new Pair((Object)StringsKt.replace$default((String)artifactId, (String)"\"", (String)"", (boolean)false, (int)4, null), (Object)StringsKt.replace$default((String)version, (String)"\"", (String)"", (boolean)false, (int)4, null));
        } else {
            String dependencyName = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)text, (String)"\"", null, (int)2, null), (String)"\"", null, (int)2, null);
            String artifactId = isJar ? StringsKt.substringBefore$default((String)dependencyName, (String)":", null, (int)2, null) : dependencyName;
            String version = isJar ? StringsKt.substringAfter$default((String)dependencyName, (String)":", null, (int)2, null) : null;
            pair = new Pair((Object)artifactId, (Object)version);
        }
        return pair;
    }

    @Override
    @NotNull
    public List<Package> importedPackages(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Module module = this.findModuleForFile(file);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        return this.collectPackages(module2);
    }

    @Override
    public boolean supports(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getFileType(), (Object)ModuleFileType.INSTANCE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean supports(@NotNull Module module) {
        boolean bl;
        String string;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (module.isDisposed()) return false;
        if (module.getModuleFile() == null) {
            return false;
        }
        try {
            string = ExternalSystemModulePropertyManager.Companion.getInstance(module).getExternalSystemId();
        }
        catch (Exception e) {
            JpsBuildFileProvider $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JpsBuildFileProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Can't get externalSystemId for module: " + module + ", module.isLoaded: " + module.isLoaded() + ", module.project: " + module.getProject() + ", module.file: " + module.getModuleFile(), (Throwable)e);
            return false;
        }
        String externalSystemId = string;
        if (Intrinsics.areEqual((Object)ProjectDependenciesModels.INSTANCE.getGRADLE_SYSTEM_ID().getId(), (Object)externalSystemId)) return false;
        Iterable $this$any$iv = BuildFileProvider.Companion.getEP_NAME().getExtensions((AreaInstance)this.getProject());
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            BuildFileProvider it = (BuildFileProvider)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)it.getId(), (Object)"maven") && it.supports(module)) {
                return false;
            }
            bl = false;
        } while (!bl);
        return false;
    }

    @Override
    @NotNull
    public Map<Package, List<Package>> getRoots(@NotNull PsiFile file, @NotNull List<Package> pkgs2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(pkgs2, (String)"pkgs");
        Module module = ModuleUtil.findModuleForFile((PsiFile)file);
        if (module == null) {
            return MapsKt.emptyMap();
        }
        Module module2 = module;
        return this.getRoots(module2);
    }

    @Override
    @NotNull
    public Map<Package, List<Package>> getRoots(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Iterable $this$associateWith$iv = this.collectPackages(module);
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Package package_ = (Package)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            List list = CollectionsKt.emptyList();
            map2.put(t, list);
        }
        return result$iv;
    }

    private final Module findModuleForFile(PsiFile file) {
        return ModuleUtil.findModuleForFile((PsiFile)file);
    }

    private final List<Package> collectPackages(Module module) {
        List packages = new ArrayList();
        if (module.isDisposed()) {
            return packages;
        }
        ModuleRootManager.getInstance((Module)module).orderEntries().forEachLibrary(arg_0 -> JpsBuildFileProvider.collectPackages$lambda$8(arg_0 -> JpsBuildFileProvider.collectPackages$lambda$7(packages, arg_0), arg_0));
        return packages;
    }

    private static final boolean collectPackages$lambda$7(List $packages, Library it) {
        Intrinsics.checkNotNull((Object)it);
        Package pkg = JavaPackageUtilKt.createPackage(it);
        if (pkg != null) {
            $packages.add(pkg);
        }
        return true;
    }

    private static final boolean collectPackages$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

