/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.syntax.InjectionNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.lexer.SyntaxMatchUtils;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateLexerState;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateSyntaxMatcher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.RegexFacade;
import org.jetbrains.plugins.textmate.regex.RegexFactory;
import org.jetbrains.plugins.textmate.regex.TextMateString;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JP\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0018\u00010\u0018j\u0004\u0018\u0001`\u0019H\u0016JH\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\t2\u000e\u0010\u0017\u001a\n\u0018\u00010\u0018j\u0004\u0018\u0001`\u0019H\u0016J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0016JR\u0010\"\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0010\b\u0002\u0010\u0017\u001a\n\u0018\u00010\u0018j\u0004\u0018\u0001`\u0019H\u0002J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\tH\u0002J\u0018\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\tH\u0002JH\u0010'\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0018\u00010\u0018j\u0004\u0018\u0001`\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateSyntaxMatcherImpl;", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateSyntaxMatcher;", "regexFactory", "Lorg/jetbrains/plugins/textmate/regex/RegexFactory;", "mySelectorWeigher", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorWeigher;", "<init>", "(Lorg/jetbrains/plugins/textmate/regex/RegexFactory;Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorWeigher;)V", "matchRule", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateLexerState;", "syntaxNodeDescriptor", "Lorg/jetbrains/plugins/textmate/language/syntax/SyntaxNodeDescriptor;", "string", "Lorg/jetbrains/plugins/textmate/regex/TextMateString;", "byteOffset", "", "matchBeginPosition", "", "matchBeginString", "priority", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateWeigh$Priority;", "currentScope", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateScope;", "checkCancelledCallback", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "matchStringRegex", "Lorg/jetbrains/plugins/textmate/regex/MatchData;", "keyName", "Lorg/jetbrains/plugins/textmate/Constants$StringKey;", "lexerState", "createStringToMatch", "s", "", "matchFirstChild", "hasBeginKey", "moreImportantState", "oldState", "newState", "matchInjections", "intellij.textmate.core"})
public final class TextMateSyntaxMatcherImpl
implements TextMateSyntaxMatcher {
    @NotNull
    private final RegexFactory regexFactory;
    @NotNull
    private final TextMateSelectorWeigher mySelectorWeigher;

    public TextMateSyntaxMatcherImpl(@NotNull RegexFactory regexFactory, @NotNull TextMateSelectorWeigher mySelectorWeigher) {
        Intrinsics.checkNotNullParameter((Object)regexFactory, (String)"regexFactory");
        Intrinsics.checkNotNullParameter((Object)mySelectorWeigher, (String)"mySelectorWeigher");
        this.regexFactory = regexFactory;
        this.mySelectorWeigher = mySelectorWeigher;
    }

    @Override
    @NotNull
    public TextMateLexerState matchRule(@NotNull SyntaxNodeDescriptor syntaxNodeDescriptor, @NotNull TextMateString string, int byteOffset, boolean matchBeginPosition, boolean matchBeginString, @NotNull TextMateWeigh.Priority priority, @NotNull TextMateScope currentScope, @Nullable Runnable checkCancelledCallback) {
        SyntaxNodeDescriptor child;
        Intrinsics.checkNotNullParameter((Object)syntaxNodeDescriptor, (String)"syntaxNodeDescriptor");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        Intrinsics.checkNotNullParameter((Object)currentScope, (String)"currentScope");
        TextMateLexerState resultState = TextMateLexerState.Companion.notMatched(syntaxNodeDescriptor);
        List<SyntaxNodeDescriptor> children = syntaxNodeDescriptor.getChildren();
        Iterator<SyntaxNodeDescriptor> iterator = children.iterator();
        while (iterator.hasNext() && (!(resultState = this.moreImportantState(resultState, TextMateSyntaxMatcherImpl.matchFirstChild$default(this, child = iterator.next(), string, byteOffset, matchBeginPosition, matchBeginString, priority, currentScope, null, 128, null))).getMatchData().getMatched() || MatchData.byteOffset$default(resultState.getMatchData(), 0, 1, null).getStart() != byteOffset)) {
        }
        return this.moreImportantState(resultState, this.matchInjections(syntaxNodeDescriptor, string, byteOffset, matchBeginPosition, matchBeginString, currentScope, checkCancelledCallback));
    }

    @Override
    @NotNull
    public MatchData matchStringRegex(@NotNull Constants.StringKey keyName, @NotNull TextMateString string, int byteOffset, boolean matchBeginPosition, boolean matchBeginString, @NotNull TextMateLexerState lexerState, @Nullable Runnable checkCancelledCallback) {
        Intrinsics.checkNotNullParameter((Object)((Object)keyName), (String)"keyName");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)lexerState, (String)"lexerState");
        CharSequence regex2 = lexerState.getSyntaxRule().getStringAttribute(keyName);
        if (regex2 == null) {
            return MatchData.Companion.getNOT_MATCHED();
        }
        CharSequence regexString = lexerState.getSyntaxRule().hasBackReference(keyName) ? (CharSequence)SyntaxMatchUtils.INSTANCE.replaceGroupsWithMatchDataInRegex(regex2, lexerState.getString(), lexerState.getMatchData()) : regex2;
        return this.regexFactory.regex(regexString).match(string, byteOffset, matchBeginPosition, matchBeginString, checkCancelledCallback);
    }

    @Override
    @NotNull
    public TextMateString createStringToMatch(@NotNull CharSequence s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return this.regexFactory.string(s);
    }

    private final TextMateLexerState matchFirstChild(SyntaxNodeDescriptor syntaxNodeDescriptor, TextMateString string, int byteOffset, boolean matchBeginPosition, boolean matchBeginString, TextMateWeigh.Priority priority, TextMateScope currentScope, Runnable checkCancelledCallback) {
        CharSequence match = syntaxNodeDescriptor.getStringAttribute(Constants.StringKey.MATCH);
        if (match != null) {
            RegexFacade regex2 = this.regexFactory.regex(match);
            MatchData matchData = regex2.match(string, byteOffset, matchBeginPosition, matchBeginString, checkCancelledCallback);
            return new TextMateLexerState(syntaxNodeDescriptor, matchData, priority, byteOffset, string);
        }
        CharSequence begin = syntaxNodeDescriptor.getStringAttribute(Constants.StringKey.BEGIN);
        if (begin != null) {
            RegexFacade regex3 = this.regexFactory.regex(begin);
            MatchData matchData = regex3.match(string, byteOffset, matchBeginPosition, matchBeginString, checkCancelledCallback);
            return new TextMateLexerState(syntaxNodeDescriptor, matchData, priority, byteOffset, string);
        }
        if (syntaxNodeDescriptor.getStringAttribute(Constants.StringKey.END) != null) {
            return TextMateLexerState.Companion.notMatched(syntaxNodeDescriptor);
        }
        return this.matchRule(syntaxNodeDescriptor, string, byteOffset, matchBeginPosition, matchBeginString, priority, currentScope, checkCancelledCallback);
    }

    static /* synthetic */ TextMateLexerState matchFirstChild$default(TextMateSyntaxMatcherImpl textMateSyntaxMatcherImpl, SyntaxNodeDescriptor syntaxNodeDescriptor, TextMateString textMateString, int n, boolean bl, boolean bl2, TextMateWeigh.Priority priority, TextMateScope textMateScope, Runnable runnable, int n2, Object object) {
        if ((n2 & 0x80) != 0) {
            runnable = null;
        }
        return textMateSyntaxMatcherImpl.matchFirstChild(syntaxNodeDescriptor, textMateString, n, bl, bl2, priority, textMateScope, runnable);
    }

    private final boolean hasBeginKey(TextMateLexerState lexerState) {
        return lexerState.getSyntaxRule().getStringAttribute(Constants.StringKey.BEGIN) != null;
    }

    private final TextMateLexerState moreImportantState(TextMateLexerState oldState, TextMateLexerState newState) {
        int oldScore;
        if (!newState.getMatchData().getMatched()) {
            return oldState;
        }
        if (!oldState.getMatchData().getMatched()) {
            return newState;
        }
        int newScore = MatchData.byteOffset$default(newState.getMatchData(), 0, 1, null).getStart();
        if ((newScore < (oldScore = MatchData.byteOffset$default(oldState.getMatchData(), 0, 1, null).getStart()) || newScore == oldScore && newState.getPriorityMatch().compareTo((Enum)oldState.getPriorityMatch()) > 0) && (!MatchData.byteOffset$default(newState.getMatchData(), 0, 1, null).isEmpty() || MatchData.byteOffset$default(oldState.getMatchData(), 0, 1, null).isEmpty() || this.hasBeginKey(newState))) {
            return newState;
        }
        return oldState;
    }

    private final TextMateLexerState matchInjections(SyntaxNodeDescriptor syntaxNodeDescriptor, TextMateString string, int byteOffset, boolean matchBeginPosition, boolean matchBeginString, TextMateScope currentScope, Runnable checkCancelledCallback) {
        TextMateLexerState resultState = TextMateLexerState.Companion.notMatched(syntaxNodeDescriptor);
        List<InjectionNodeDescriptor> injections = syntaxNodeDescriptor.getInjections();
        for (InjectionNodeDescriptor injection : injections) {
            TextMateLexerState injectionState;
            TextMateWeigh selectorWeigh = this.mySelectorWeigher.weigh(injection.getSelector(), currentScope);
            if (selectorWeigh.getWeigh() <= 0) continue;
            TextMateLexerState textMateLexerState = injectionState = this.matchRule(injection.getSyntaxNodeDescriptor(), string, byteOffset, matchBeginPosition, matchBeginString, selectorWeigh.getPriority(), currentScope, checkCancelledCallback);
            Intrinsics.checkNotNull((Object)textMateLexerState);
            resultState = this.moreImportantState(resultState, textMateLexerState);
        }
        return resultState;
    }
}

