/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class CaseNode
extends Node {
    private Node caseNode;
    private ListNode cases;
    private Node elseNode = null;

    public CaseNode(SourcePosition position, Node caseNode, ListNode cases) {
        super(position);
        assert (cases != null) : "caseBody is not null";
        this.caseNode = this.adopt(caseNode);
        this.cases = (ListNode)this.adopt(cases);
    }

    public void setElseNode(Node elseNode) {
        this.elseNode = elseNode;
    }

    public boolean isSame(Node node) {
        if (!super.isSame(node)) {
            return false;
        }
        CaseNode other = (CaseNode)node;
        if (this.getCase() == null && other.getCase() == null) {
            return true;
        }
        if (this.getCase() == null || other.getCase() == null) {
            return false;
        }
        return this.getCase().isSame(other.getCase());
    }

    public NodeType getNodeType() {
        return NodeType.CASENODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitCaseNode(this);
    }

    public Node getCase() {
        return this.caseNode;
    }

    @Deprecated
    public Node getCaseNode() {
        return this.getCase();
    }

    public ListNode getCases() {
        return this.cases;
    }

    public Node getElse() {
        return this.elseNode;
    }

    @Deprecated
    public Node getElseNode() {
        return this.getElse();
    }

    public Node getFirstWhen() {
        return this.cases;
    }

    @Deprecated
    public Node getFirstWhenNode() {
        return this.getFirstWhen();
    }
}

