/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.io.IOException;
import java.util.HashMap;
import sun.awt.X11.MotifDnDConstants;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDropTargetProtocolListener;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;
import sun.util.logging.PlatformLogger;

abstract class XDropTargetProtocol {
    private static final PlatformLogger logger = PlatformLogger.getLogger("sun.awt.X11.xembed.xdnd.XDropTargetProtocol");
    private final XDropTargetProtocolListener listener;
    public static final int EMBEDDER_ALREADY_REGISTERED = 0;
    public static final int UNKNOWN_MESSAGE = 0;
    public static final int ENTER_MESSAGE = 1;
    public static final int MOTION_MESSAGE = 2;
    public static final int LEAVE_MESSAGE = 3;
    public static final int DROP_MESSAGE = 4;
    private boolean motionPassedAlong = false;
    private final HashMap embedderRegistry = new HashMap();

    protected XDropTargetProtocol(XDropTargetProtocolListener xDropTargetProtocolListener) {
        if (xDropTargetProtocolListener == null) {
            throw new NullPointerException("Null XDropTargetProtocolListener");
        }
        this.listener = xDropTargetProtocolListener;
    }

    protected final XDropTargetProtocolListener getProtocolListener() {
        return this.listener;
    }

    public abstract String getProtocolName();

    public abstract void registerDropTarget(long var1);

    public abstract void unregisterDropTarget(long var1);

    public abstract void registerEmbedderDropSite(long var1);

    public abstract void unregisterEmbedderDropSite(long var1);

    public abstract void registerEmbeddedDropSite(long var1);

    public final void unregisterEmbeddedDropSite(long l) {
        this.removeEmbedderRegistryEntry(l);
    }

    public abstract boolean isProtocolSupported(long var1);

    public abstract int getMessageType(XClientMessageEvent var1);

    public final boolean processClientMessage(XClientMessageEvent xClientMessageEvent) {
        int n = this.getMessageType(xClientMessageEvent);
        boolean bl = this.processClientMessageImpl(xClientMessageEvent);
        this.postProcessClientMessage(xClientMessageEvent, bl, n);
        return bl;
    }

    protected abstract boolean processClientMessageImpl(XClientMessageEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean forwardClientMessageToToplevel(long l, XClientMessageEvent xClientMessageEvent) {
        EmbedderRegistryEntry embedderRegistryEntry = this.getEmbedderRegistryEntry(l);
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest("        entry={0}", embedderRegistryEntry);
        }
        if (embedderRegistryEntry == null) {
            return false;
        }
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest("        entry.isOverriden()={0}", embedderRegistryEntry.isOverriden());
        }
        if (!embedderRegistryEntry.isOverriden()) {
            return false;
        }
        this.adjustEventForForwarding(xClientMessageEvent, embedderRegistryEntry);
        long l2 = embedderRegistryEntry.getProxy();
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest("        proxy={0} toplevel={1}", l2, l);
        }
        if (l2 == 0L) {
            l2 = l;
        }
        xClientMessageEvent.set_window(l);
        XToolkit.awtLock();
        try {
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), l2, false, 0L, xClientMessageEvent.pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
        return true;
    }

    protected abstract void sendEnterMessageToToplevel(long var1, XClientMessageEvent var3);

    protected abstract void sendLeaveMessageToToplevel(long var1, XClientMessageEvent var3);

    private void postProcessClientMessage(XClientMessageEvent xClientMessageEvent, boolean bl, int n) {
        long l = xClientMessageEvent.get_window();
        if (this.getEmbedderRegistryEntry(l) != null) {
            if (!bl) {
                this.forwardClientMessageToToplevel(l, xClientMessageEvent);
            } else {
                boolean bl2 = xClientMessageEvent.get_message_type() == MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom();
                switch (n) {
                    case 2: {
                        if (!this.isDragOverComponent()) {
                            if (!this.motionPassedAlong && !bl2) {
                                this.sendEnterMessageToToplevel(l, xClientMessageEvent);
                            }
                            this.forwardClientMessageToToplevel(l, xClientMessageEvent);
                            this.motionPassedAlong = true;
                            break;
                        }
                        if (this.motionPassedAlong && !bl2) {
                            this.sendLeaveMessageToToplevel(l, xClientMessageEvent);
                        }
                        this.motionPassedAlong = false;
                        break;
                    }
                    case 4: {
                        if (!this.isDragOverComponent()) {
                            this.forwardClientMessageToToplevel(l, xClientMessageEvent);
                        }
                        this.motionPassedAlong = false;
                        break;
                    }
                    case 1: 
                    case 3: {
                        if (bl2) {
                            this.forwardClientMessageToToplevel(l, xClientMessageEvent);
                        }
                        this.motionPassedAlong = false;
                    }
                }
            }
        }
    }

    public abstract boolean sendResponse(long var1, int var3, int var4);

    public abstract Object getData(long var1, long var3) throws IllegalArgumentException, IOException;

    public abstract boolean sendDropDone(long var1, boolean var3, int var4);

    public abstract long getSourceWindow();

    public abstract void cleanup();

    public abstract boolean isDragOverComponent();

    public void adjustEventForForwarding(XClientMessageEvent xClientMessageEvent, EmbedderRegistryEntry embedderRegistryEntry) {
    }

    public abstract boolean forwardEventToEmbedded(long var1, long var3, int var5);

    public abstract boolean isXEmbedSupported();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void putEmbedderRegistryEntry(long l, boolean bl, int n, long l2) {
        XDropTargetProtocol xDropTargetProtocol = this;
        synchronized (xDropTargetProtocol) {
            this.embedderRegistry.put(l, new EmbedderRegistryEntry(bl, n, l2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final EmbedderRegistryEntry getEmbedderRegistryEntry(long l) {
        XDropTargetProtocol xDropTargetProtocol = this;
        synchronized (xDropTargetProtocol) {
            return (EmbedderRegistryEntry)this.embedderRegistry.get(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeEmbedderRegistryEntry(long l) {
        XDropTargetProtocol xDropTargetProtocol = this;
        synchronized (xDropTargetProtocol) {
            this.embedderRegistry.remove(l);
        }
    }

    protected static final class EmbedderRegistryEntry {
        private final boolean overriden;
        private final int version;
        private final long proxy;

        EmbedderRegistryEntry(boolean bl, int n, long l) {
            this.overriden = bl;
            this.version = n;
            this.proxy = l;
        }

        public boolean isOverriden() {
            return this.overriden;
        }

        public int getVersion() {
            return this.version;
        }

        public long getProxy() {
            return this.proxy;
        }
    }
}

