// Code generated by sdkgen. DO NOT EDIT.

// nolint
package ydb

import (
	"context"

	"google.golang.org/grpc"

	ydb "github.com/yandex-cloud/go-genproto/yandex/cloud/ydb/v1"
)

//revive:disable

// StorageTypeServiceClient is a ydb.StorageTypeServiceClient with
// lazy GRPC connection initialization.
type StorageTypeServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Get implements ydb.StorageTypeServiceClient
func (c *StorageTypeServiceClient) Get(ctx context.Context, in *ydb.GetStorageTypeRequest, opts ...grpc.CallOption) (*ydb.StorageType, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return ydb.NewStorageTypeServiceClient(conn).Get(ctx, in, opts...)
}

// List implements ydb.StorageTypeServiceClient
func (c *StorageTypeServiceClient) List(ctx context.Context, in *ydb.ListStorageTypesRequest, opts ...grpc.CallOption) (*ydb.ListStorageTypesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return ydb.NewStorageTypeServiceClient(conn).List(ctx, in, opts...)
}

type StorageTypeIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *StorageTypeServiceClient
	request *ydb.ListStorageTypesRequest

	items []*ydb.StorageType
}

func (c *StorageTypeServiceClient) StorageTypeIterator(ctx context.Context, req *ydb.ListStorageTypesRequest, opts ...grpc.CallOption) *StorageTypeIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &StorageTypeIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *StorageTypeIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.StorageTypes
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *StorageTypeIterator) Take(size int64) ([]*ydb.StorageType, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*ydb.StorageType

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *StorageTypeIterator) TakeAll() ([]*ydb.StorageType, error) {
	return it.Take(0)
}

func (it *StorageTypeIterator) Value() *ydb.StorageType {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *StorageTypeIterator) Error() error {
	return it.err
}
