// Code generated by sdkgen. DO NOT EDIT.

// nolint
package vpc

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	vpc "github.com/yandex-cloud/go-genproto/yandex/cloud/vpc/v1"
)

//revive:disable

// SecurityGroupServiceClient is a vpc.SecurityGroupServiceClient with
// lazy GRPC connection initialization.
type SecurityGroupServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements vpc.SecurityGroupServiceClient
func (c *SecurityGroupServiceClient) Create(ctx context.Context, in *vpc.CreateSecurityGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewSecurityGroupServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements vpc.SecurityGroupServiceClient
func (c *SecurityGroupServiceClient) Delete(ctx context.Context, in *vpc.DeleteSecurityGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewSecurityGroupServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements vpc.SecurityGroupServiceClient
func (c *SecurityGroupServiceClient) Get(ctx context.Context, in *vpc.GetSecurityGroupRequest, opts ...grpc.CallOption) (*vpc.SecurityGroup, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewSecurityGroupServiceClient(conn).Get(ctx, in, opts...)
}

// List implements vpc.SecurityGroupServiceClient
func (c *SecurityGroupServiceClient) List(ctx context.Context, in *vpc.ListSecurityGroupsRequest, opts ...grpc.CallOption) (*vpc.ListSecurityGroupsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewSecurityGroupServiceClient(conn).List(ctx, in, opts...)
}

type SecurityGroupIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *SecurityGroupServiceClient
	request *vpc.ListSecurityGroupsRequest

	items []*vpc.SecurityGroup
}

func (c *SecurityGroupServiceClient) SecurityGroupIterator(ctx context.Context, req *vpc.ListSecurityGroupsRequest, opts ...grpc.CallOption) *SecurityGroupIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &SecurityGroupIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *SecurityGroupIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.SecurityGroups
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *SecurityGroupIterator) Take(size int64) ([]*vpc.SecurityGroup, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*vpc.SecurityGroup

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *SecurityGroupIterator) TakeAll() ([]*vpc.SecurityGroup, error) {
	return it.Take(0)
}

func (it *SecurityGroupIterator) Value() *vpc.SecurityGroup {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *SecurityGroupIterator) Error() error {
	return it.err
}

// ListOperations implements vpc.SecurityGroupServiceClient
func (c *SecurityGroupServiceClient) ListOperations(ctx context.Context, in *vpc.ListSecurityGroupOperationsRequest, opts ...grpc.CallOption) (*vpc.ListSecurityGroupOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewSecurityGroupServiceClient(conn).ListOperations(ctx, in, opts...)
}

type SecurityGroupOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *SecurityGroupServiceClient
	request *vpc.ListSecurityGroupOperationsRequest

	items []*operation.Operation
}

func (c *SecurityGroupServiceClient) SecurityGroupOperationsIterator(ctx context.Context, req *vpc.ListSecurityGroupOperationsRequest, opts ...grpc.CallOption) *SecurityGroupOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &SecurityGroupOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *SecurityGroupOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *SecurityGroupOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *SecurityGroupOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *SecurityGroupOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *SecurityGroupOperationsIterator) Error() error {
	return it.err
}

// Move implements vpc.SecurityGroupServiceClient
func (c *SecurityGroupServiceClient) Move(ctx context.Context, in *vpc.MoveSecurityGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewSecurityGroupServiceClient(conn).Move(ctx, in, opts...)
}

// Update implements vpc.SecurityGroupServiceClient
func (c *SecurityGroupServiceClient) Update(ctx context.Context, in *vpc.UpdateSecurityGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewSecurityGroupServiceClient(conn).Update(ctx, in, opts...)
}

// UpdateRule implements vpc.SecurityGroupServiceClient
func (c *SecurityGroupServiceClient) UpdateRule(ctx context.Context, in *vpc.UpdateSecurityGroupRuleRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewSecurityGroupServiceClient(conn).UpdateRule(ctx, in, opts...)
}

// UpdateRules implements vpc.SecurityGroupServiceClient
func (c *SecurityGroupServiceClient) UpdateRules(ctx context.Context, in *vpc.UpdateSecurityGroupRulesRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewSecurityGroupServiceClient(conn).UpdateRules(ctx, in, opts...)
}
