// Code generated by sdkgen. DO NOT EDIT.

// nolint
package vpc

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	vpc "github.com/yandex-cloud/go-genproto/yandex/cloud/vpc/v1"
)

//revive:disable

// AddressServiceClient is a vpc.AddressServiceClient with
// lazy GRPC connection initialization.
type AddressServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements vpc.AddressServiceClient
func (c *AddressServiceClient) Create(ctx context.Context, in *vpc.CreateAddressRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewAddressServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements vpc.AddressServiceClient
func (c *AddressServiceClient) Delete(ctx context.Context, in *vpc.DeleteAddressRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewAddressServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements vpc.AddressServiceClient
func (c *AddressServiceClient) Get(ctx context.Context, in *vpc.GetAddressRequest, opts ...grpc.CallOption) (*vpc.Address, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewAddressServiceClient(conn).Get(ctx, in, opts...)
}

// GetByValue implements vpc.AddressServiceClient
func (c *AddressServiceClient) GetByValue(ctx context.Context, in *vpc.GetAddressByValueRequest, opts ...grpc.CallOption) (*vpc.Address, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewAddressServiceClient(conn).GetByValue(ctx, in, opts...)
}

// List implements vpc.AddressServiceClient
func (c *AddressServiceClient) List(ctx context.Context, in *vpc.ListAddressesRequest, opts ...grpc.CallOption) (*vpc.ListAddressesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewAddressServiceClient(conn).List(ctx, in, opts...)
}

type AddressIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *AddressServiceClient
	request *vpc.ListAddressesRequest

	items []*vpc.Address
}

func (c *AddressServiceClient) AddressIterator(ctx context.Context, req *vpc.ListAddressesRequest, opts ...grpc.CallOption) *AddressIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &AddressIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *AddressIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Addresses
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *AddressIterator) Take(size int64) ([]*vpc.Address, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*vpc.Address

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *AddressIterator) TakeAll() ([]*vpc.Address, error) {
	return it.Take(0)
}

func (it *AddressIterator) Value() *vpc.Address {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *AddressIterator) Error() error {
	return it.err
}

// ListOperations implements vpc.AddressServiceClient
func (c *AddressServiceClient) ListOperations(ctx context.Context, in *vpc.ListAddressOperationsRequest, opts ...grpc.CallOption) (*vpc.ListAddressOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewAddressServiceClient(conn).ListOperations(ctx, in, opts...)
}

type AddressOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *AddressServiceClient
	request *vpc.ListAddressOperationsRequest

	items []*operation.Operation
}

func (c *AddressServiceClient) AddressOperationsIterator(ctx context.Context, req *vpc.ListAddressOperationsRequest, opts ...grpc.CallOption) *AddressOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &AddressOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *AddressOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *AddressOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *AddressOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *AddressOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *AddressOperationsIterator) Error() error {
	return it.err
}

// Move implements vpc.AddressServiceClient
func (c *AddressServiceClient) Move(ctx context.Context, in *vpc.MoveAddressRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewAddressServiceClient(conn).Move(ctx, in, opts...)
}

// Update implements vpc.AddressServiceClient
func (c *AddressServiceClient) Update(ctx context.Context, in *vpc.UpdateAddressRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewAddressServiceClient(conn).Update(ctx, in, opts...)
}
