// Code generated by sdkgen. DO NOT EDIT.

// nolint
package organizationmanager

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	organizationmanager "github.com/yandex-cloud/go-genproto/yandex/cloud/organizationmanager/v1"
)

//revive:disable

// OsLoginServiceClient is a organizationmanager.OsLoginServiceClient with
// lazy GRPC connection initialization.
type OsLoginServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// CreateProfile implements organizationmanager.OsLoginServiceClient
func (c *OsLoginServiceClient) CreateProfile(ctx context.Context, in *organizationmanager.CreateOsLoginProfileRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return organizationmanager.NewOsLoginServiceClient(conn).CreateProfile(ctx, in, opts...)
}

// DeleteProfile implements organizationmanager.OsLoginServiceClient
func (c *OsLoginServiceClient) DeleteProfile(ctx context.Context, in *organizationmanager.DeleteOsLoginProfileRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return organizationmanager.NewOsLoginServiceClient(conn).DeleteProfile(ctx, in, opts...)
}

// GetProfile implements organizationmanager.OsLoginServiceClient
func (c *OsLoginServiceClient) GetProfile(ctx context.Context, in *organizationmanager.GetOsLoginProfileRequest, opts ...grpc.CallOption) (*organizationmanager.OsLoginProfile, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return organizationmanager.NewOsLoginServiceClient(conn).GetProfile(ctx, in, opts...)
}

// GetSettings implements organizationmanager.OsLoginServiceClient
func (c *OsLoginServiceClient) GetSettings(ctx context.Context, in *organizationmanager.GetOsLoginSettingsRequest, opts ...grpc.CallOption) (*organizationmanager.OsLoginSettings, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return organizationmanager.NewOsLoginServiceClient(conn).GetSettings(ctx, in, opts...)
}

// ListProfiles implements organizationmanager.OsLoginServiceClient
func (c *OsLoginServiceClient) ListProfiles(ctx context.Context, in *organizationmanager.ListOsLoginProfilesRequest, opts ...grpc.CallOption) (*organizationmanager.ListOsLoginProfilesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return organizationmanager.NewOsLoginServiceClient(conn).ListProfiles(ctx, in, opts...)
}

type OsLoginProfilesIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *OsLoginServiceClient
	request *organizationmanager.ListOsLoginProfilesRequest

	items []*organizationmanager.OsLoginProfile
}

func (c *OsLoginServiceClient) OsLoginProfilesIterator(ctx context.Context, req *organizationmanager.ListOsLoginProfilesRequest, opts ...grpc.CallOption) *OsLoginProfilesIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &OsLoginProfilesIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *OsLoginProfilesIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListProfiles(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Profiles
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *OsLoginProfilesIterator) Take(size int64) ([]*organizationmanager.OsLoginProfile, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*organizationmanager.OsLoginProfile

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *OsLoginProfilesIterator) TakeAll() ([]*organizationmanager.OsLoginProfile, error) {
	return it.Take(0)
}

func (it *OsLoginProfilesIterator) Value() *organizationmanager.OsLoginProfile {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *OsLoginProfilesIterator) Error() error {
	return it.err
}

// SetDefaultProfile implements organizationmanager.OsLoginServiceClient
func (c *OsLoginServiceClient) SetDefaultProfile(ctx context.Context, in *organizationmanager.SetDefaultOsLoginProfileRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return organizationmanager.NewOsLoginServiceClient(conn).SetDefaultProfile(ctx, in, opts...)
}

// UpdateProfile implements organizationmanager.OsLoginServiceClient
func (c *OsLoginServiceClient) UpdateProfile(ctx context.Context, in *organizationmanager.UpdateOsLoginProfileRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return organizationmanager.NewOsLoginServiceClient(conn).UpdateProfile(ctx, in, opts...)
}

// UpdateSettings implements organizationmanager.OsLoginServiceClient
func (c *OsLoginServiceClient) UpdateSettings(ctx context.Context, in *organizationmanager.UpdateOsLoginSettingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return organizationmanager.NewOsLoginServiceClient(conn).UpdateSettings(ctx, in, opts...)
}
