// Code generated by sdkgen. DO NOT EDIT.

// nolint
package organizationmanager

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	organizationmanager "github.com/yandex-cloud/go-genproto/yandex/cloud/organizationmanager/v1"
)

//revive:disable

// OrganizationServiceClient is a organizationmanager.OrganizationServiceClient with
// lazy GRPC connection initialization.
type OrganizationServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Get implements organizationmanager.OrganizationServiceClient
func (c *OrganizationServiceClient) Get(ctx context.Context, in *organizationmanager.GetOrganizationRequest, opts ...grpc.CallOption) (*organizationmanager.Organization, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return organizationmanager.NewOrganizationServiceClient(conn).Get(ctx, in, opts...)
}

// List implements organizationmanager.OrganizationServiceClient
func (c *OrganizationServiceClient) List(ctx context.Context, in *organizationmanager.ListOrganizationsRequest, opts ...grpc.CallOption) (*organizationmanager.ListOrganizationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return organizationmanager.NewOrganizationServiceClient(conn).List(ctx, in, opts...)
}

type OrganizationIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *OrganizationServiceClient
	request *organizationmanager.ListOrganizationsRequest

	items []*organizationmanager.Organization
}

func (c *OrganizationServiceClient) OrganizationIterator(ctx context.Context, req *organizationmanager.ListOrganizationsRequest, opts ...grpc.CallOption) *OrganizationIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &OrganizationIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *OrganizationIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Organizations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *OrganizationIterator) Take(size int64) ([]*organizationmanager.Organization, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*organizationmanager.Organization

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *OrganizationIterator) TakeAll() ([]*organizationmanager.Organization, error) {
	return it.Take(0)
}

func (it *OrganizationIterator) Value() *organizationmanager.Organization {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *OrganizationIterator) Error() error {
	return it.err
}

// ListAccessBindings implements organizationmanager.OrganizationServiceClient
func (c *OrganizationServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return organizationmanager.NewOrganizationServiceClient(conn).ListAccessBindings(ctx, in, opts...)
}

type OrganizationAccessBindingsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *OrganizationServiceClient
	request *access.ListAccessBindingsRequest

	items []*access.AccessBinding
}

func (c *OrganizationServiceClient) OrganizationAccessBindingsIterator(ctx context.Context, req *access.ListAccessBindingsRequest, opts ...grpc.CallOption) *OrganizationAccessBindingsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &OrganizationAccessBindingsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *OrganizationAccessBindingsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListAccessBindings(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.AccessBindings
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *OrganizationAccessBindingsIterator) Take(size int64) ([]*access.AccessBinding, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*access.AccessBinding

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *OrganizationAccessBindingsIterator) TakeAll() ([]*access.AccessBinding, error) {
	return it.Take(0)
}

func (it *OrganizationAccessBindingsIterator) Value() *access.AccessBinding {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *OrganizationAccessBindingsIterator) Error() error {
	return it.err
}

// ListOperations implements organizationmanager.OrganizationServiceClient
func (c *OrganizationServiceClient) ListOperations(ctx context.Context, in *organizationmanager.ListOrganizationOperationsRequest, opts ...grpc.CallOption) (*organizationmanager.ListOrganizationOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return organizationmanager.NewOrganizationServiceClient(conn).ListOperations(ctx, in, opts...)
}

type OrganizationOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *OrganizationServiceClient
	request *organizationmanager.ListOrganizationOperationsRequest

	items []*operation.Operation
}

func (c *OrganizationServiceClient) OrganizationOperationsIterator(ctx context.Context, req *organizationmanager.ListOrganizationOperationsRequest, opts ...grpc.CallOption) *OrganizationOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &OrganizationOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *OrganizationOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *OrganizationOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *OrganizationOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *OrganizationOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *OrganizationOperationsIterator) Error() error {
	return it.err
}

// SetAccessBindings implements organizationmanager.OrganizationServiceClient
func (c *OrganizationServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return organizationmanager.NewOrganizationServiceClient(conn).SetAccessBindings(ctx, in, opts...)
}

// Update implements organizationmanager.OrganizationServiceClient
func (c *OrganizationServiceClient) Update(ctx context.Context, in *organizationmanager.UpdateOrganizationRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return organizationmanager.NewOrganizationServiceClient(conn).Update(ctx, in, opts...)
}

// UpdateAccessBindings implements organizationmanager.OrganizationServiceClient
func (c *OrganizationServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return organizationmanager.NewOrganizationServiceClient(conn).UpdateAccessBindings(ctx, in, opts...)
}
