// Code generated by sdkgen. DO NOT EDIT.

// nolint
package dataproc

import (
	"context"

	"google.golang.org/grpc"

	dataproc "github.com/yandex-cloud/go-genproto/yandex/cloud/dataproc/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// JobServiceClient is a dataproc.JobServiceClient with
// lazy GRPC connection initialization.
type JobServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Cancel implements dataproc.JobServiceClient
func (c *JobServiceClient) Cancel(ctx context.Context, in *dataproc.CancelJobRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dataproc.NewJobServiceClient(conn).Cancel(ctx, in, opts...)
}

// Create implements dataproc.JobServiceClient
func (c *JobServiceClient) Create(ctx context.Context, in *dataproc.CreateJobRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dataproc.NewJobServiceClient(conn).Create(ctx, in, opts...)
}

// Get implements dataproc.JobServiceClient
func (c *JobServiceClient) Get(ctx context.Context, in *dataproc.GetJobRequest, opts ...grpc.CallOption) (*dataproc.Job, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dataproc.NewJobServiceClient(conn).Get(ctx, in, opts...)
}

// List implements dataproc.JobServiceClient
func (c *JobServiceClient) List(ctx context.Context, in *dataproc.ListJobsRequest, opts ...grpc.CallOption) (*dataproc.ListJobsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dataproc.NewJobServiceClient(conn).List(ctx, in, opts...)
}

type JobIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *JobServiceClient
	request *dataproc.ListJobsRequest

	items []*dataproc.Job
}

func (c *JobServiceClient) JobIterator(ctx context.Context, req *dataproc.ListJobsRequest, opts ...grpc.CallOption) *JobIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &JobIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *JobIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Jobs
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *JobIterator) Take(size int64) ([]*dataproc.Job, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*dataproc.Job

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *JobIterator) TakeAll() ([]*dataproc.Job, error) {
	return it.Take(0)
}

func (it *JobIterator) Value() *dataproc.Job {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *JobIterator) Error() error {
	return it.err
}

// ListLog implements dataproc.JobServiceClient
func (c *JobServiceClient) ListLog(ctx context.Context, in *dataproc.ListJobLogRequest, opts ...grpc.CallOption) (*dataproc.ListJobLogResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dataproc.NewJobServiceClient(conn).ListLog(ctx, in, opts...)
}
