// Code generated by sdkgen. DO NOT EDIT.

// nolint
package compute

import (
	"context"

	"google.golang.org/grpc"

	compute "github.com/yandex-cloud/go-genproto/yandex/cloud/compute/v1"
)

//revive:disable

// DiskTypeServiceClient is a compute.DiskTypeServiceClient with
// lazy GRPC connection initialization.
type DiskTypeServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Get implements compute.DiskTypeServiceClient
func (c *DiskTypeServiceClient) Get(ctx context.Context, in *compute.GetDiskTypeRequest, opts ...grpc.CallOption) (*compute.DiskType, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return compute.NewDiskTypeServiceClient(conn).Get(ctx, in, opts...)
}

// List implements compute.DiskTypeServiceClient
func (c *DiskTypeServiceClient) List(ctx context.Context, in *compute.ListDiskTypesRequest, opts ...grpc.CallOption) (*compute.ListDiskTypesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return compute.NewDiskTypeServiceClient(conn).List(ctx, in, opts...)
}

type DiskTypeIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *DiskTypeServiceClient
	request *compute.ListDiskTypesRequest

	items []*compute.DiskType
}

func (c *DiskTypeServiceClient) DiskTypeIterator(ctx context.Context, req *compute.ListDiskTypesRequest, opts ...grpc.CallOption) *DiskTypeIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &DiskTypeIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *DiskTypeIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.DiskTypes
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *DiskTypeIterator) Take(size int64) ([]*compute.DiskType, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*compute.DiskType

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *DiskTypeIterator) TakeAll() ([]*compute.DiskType, error) {
	return it.Take(0)
}

func (it *DiskTypeIterator) Value() *compute.DiskType {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *DiskTypeIterator) Error() error {
	return it.err
}
