// Code generated by sdkgen. DO NOT EDIT.

// nolint
package cdn

import (
	"context"

	"google.golang.org/grpc"

	cdn "github.com/yandex-cloud/go-genproto/yandex/cloud/cdn/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// ResourceServiceClient is a cdn.ResourceServiceClient with
// lazy GRPC connection initialization.
type ResourceServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements cdn.ResourceServiceClient
func (c *ResourceServiceClient) Create(ctx context.Context, in *cdn.CreateResourceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return cdn.NewResourceServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements cdn.ResourceServiceClient
func (c *ResourceServiceClient) Delete(ctx context.Context, in *cdn.DeleteResourceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return cdn.NewResourceServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements cdn.ResourceServiceClient
func (c *ResourceServiceClient) Get(ctx context.Context, in *cdn.GetResourceRequest, opts ...grpc.CallOption) (*cdn.Resource, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return cdn.NewResourceServiceClient(conn).Get(ctx, in, opts...)
}

// GetProviderCName implements cdn.ResourceServiceClient
func (c *ResourceServiceClient) GetProviderCName(ctx context.Context, in *cdn.GetProviderCNameRequest, opts ...grpc.CallOption) (*cdn.GetProviderCNameResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return cdn.NewResourceServiceClient(conn).GetProviderCName(ctx, in, opts...)
}

// List implements cdn.ResourceServiceClient
func (c *ResourceServiceClient) List(ctx context.Context, in *cdn.ListResourcesRequest, opts ...grpc.CallOption) (*cdn.ListResourcesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return cdn.NewResourceServiceClient(conn).List(ctx, in, opts...)
}

type ResourceIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *ResourceServiceClient
	request *cdn.ListResourcesRequest

	items []*cdn.Resource
}

func (c *ResourceServiceClient) ResourceIterator(ctx context.Context, req *cdn.ListResourcesRequest, opts ...grpc.CallOption) *ResourceIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &ResourceIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *ResourceIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Resources
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ResourceIterator) Take(size int64) ([]*cdn.Resource, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*cdn.Resource

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *ResourceIterator) TakeAll() ([]*cdn.Resource, error) {
	return it.Take(0)
}

func (it *ResourceIterator) Value() *cdn.Resource {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ResourceIterator) Error() error {
	return it.err
}

// Update implements cdn.ResourceServiceClient
func (c *ResourceServiceClient) Update(ctx context.Context, in *cdn.UpdateResourceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return cdn.NewResourceServiceClient(conn).Update(ctx, in, opts...)
}
