// Code generated by sdkgen. DO NOT EDIT.

// nolint
package backup

import (
	"context"

	"google.golang.org/grpc"

	backup "github.com/yandex-cloud/go-genproto/yandex/cloud/backup/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// BackupServiceClient is a backup.BackupServiceClient with
// lazy GRPC connection initialization.
type BackupServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Delete implements backup.BackupServiceClient
func (c *BackupServiceClient) Delete(ctx context.Context, in *backup.DeleteBackupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return backup.NewBackupServiceClient(conn).Delete(ctx, in, opts...)
}

// DeleteArchive implements backup.BackupServiceClient
func (c *BackupServiceClient) DeleteArchive(ctx context.Context, in *backup.DeleteArchiveRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return backup.NewBackupServiceClient(conn).DeleteArchive(ctx, in, opts...)
}

// Get implements backup.BackupServiceClient
func (c *BackupServiceClient) Get(ctx context.Context, in *backup.GetBackupRequest, opts ...grpc.CallOption) (*backup.Backup, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return backup.NewBackupServiceClient(conn).Get(ctx, in, opts...)
}

// List implements backup.BackupServiceClient
func (c *BackupServiceClient) List(ctx context.Context, in *backup.ListBackupsRequest, opts ...grpc.CallOption) (*backup.ListBackupsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return backup.NewBackupServiceClient(conn).List(ctx, in, opts...)
}

type BackupIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *BackupServiceClient
	request *backup.ListBackupsRequest

	items []*backup.Backup
}

func (c *BackupServiceClient) BackupIterator(ctx context.Context, req *backup.ListBackupsRequest, opts ...grpc.CallOption) *BackupIterator {
	var pageSize int64
	const defaultPageSize = 1000

	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &BackupIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *BackupIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started {
		return false
	}
	it.started = true

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Backups
	return len(it.items) > 0
}

func (it *BackupIterator) Take(size int64) ([]*backup.Backup, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*backup.Backup

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *BackupIterator) TakeAll() ([]*backup.Backup, error) {
	return it.Take(0)
}

func (it *BackupIterator) Value() *backup.Backup {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *BackupIterator) Error() error {
	return it.err
}

// ListArchives implements backup.BackupServiceClient
func (c *BackupServiceClient) ListArchives(ctx context.Context, in *backup.ListArchivesRequest, opts ...grpc.CallOption) (*backup.ListArchivesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return backup.NewBackupServiceClient(conn).ListArchives(ctx, in, opts...)
}

type BackupArchivesIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *BackupServiceClient
	request *backup.ListArchivesRequest

	items []*backup.Archive
}

func (c *BackupServiceClient) BackupArchivesIterator(ctx context.Context, req *backup.ListArchivesRequest, opts ...grpc.CallOption) *BackupArchivesIterator {
	var pageSize int64
	const defaultPageSize = 1000

	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &BackupArchivesIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *BackupArchivesIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started {
		return false
	}
	it.started = true

	response, err := it.client.ListArchives(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Archives
	return len(it.items) > 0
}

func (it *BackupArchivesIterator) Take(size int64) ([]*backup.Archive, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*backup.Archive

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *BackupArchivesIterator) TakeAll() ([]*backup.Archive, error) {
	return it.Take(0)
}

func (it *BackupArchivesIterator) Value() *backup.Archive {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *BackupArchivesIterator) Error() error {
	return it.err
}

// ListFiles implements backup.BackupServiceClient
func (c *BackupServiceClient) ListFiles(ctx context.Context, in *backup.ListFilesRequest, opts ...grpc.CallOption) (*backup.ListFilesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return backup.NewBackupServiceClient(conn).ListFiles(ctx, in, opts...)
}

type BackupFilesIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *BackupServiceClient
	request *backup.ListFilesRequest

	items []*backup.BackupFile
}

func (c *BackupServiceClient) BackupFilesIterator(ctx context.Context, req *backup.ListFilesRequest, opts ...grpc.CallOption) *BackupFilesIterator {
	var pageSize int64
	const defaultPageSize = 1000

	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &BackupFilesIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *BackupFilesIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started {
		return false
	}
	it.started = true

	response, err := it.client.ListFiles(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Files
	return len(it.items) > 0
}

func (it *BackupFilesIterator) Take(size int64) ([]*backup.BackupFile, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*backup.BackupFile

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *BackupFilesIterator) TakeAll() ([]*backup.BackupFile, error) {
	return it.Take(0)
}

func (it *BackupFilesIterator) Value() *backup.BackupFile {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *BackupFilesIterator) Error() error {
	return it.err
}

// StartFilesRecovery implements backup.BackupServiceClient
func (c *BackupServiceClient) StartFilesRecovery(ctx context.Context, in *backup.StartFilesRecoveryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return backup.NewBackupServiceClient(conn).StartFilesRecovery(ctx, in, opts...)
}

// StartRecovery implements backup.BackupServiceClient
func (c *BackupServiceClient) StartRecovery(ctx context.Context, in *backup.StartRecoveryRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return backup.NewBackupServiceClient(conn).StartRecovery(ctx, in, opts...)
}
