// Code generated by sdkgen. DO NOT EDIT.

// nolint
package apploadbalancer

import (
	"context"

	"google.golang.org/grpc"

	apploadbalancer "github.com/yandex-cloud/go-genproto/yandex/cloud/apploadbalancer/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// VirtualHostServiceClient is a apploadbalancer.VirtualHostServiceClient with
// lazy GRPC connection initialization.
type VirtualHostServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements apploadbalancer.VirtualHostServiceClient
func (c *VirtualHostServiceClient) Create(ctx context.Context, in *apploadbalancer.CreateVirtualHostRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return apploadbalancer.NewVirtualHostServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements apploadbalancer.VirtualHostServiceClient
func (c *VirtualHostServiceClient) Delete(ctx context.Context, in *apploadbalancer.DeleteVirtualHostRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return apploadbalancer.NewVirtualHostServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements apploadbalancer.VirtualHostServiceClient
func (c *VirtualHostServiceClient) Get(ctx context.Context, in *apploadbalancer.GetVirtualHostRequest, opts ...grpc.CallOption) (*apploadbalancer.VirtualHost, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return apploadbalancer.NewVirtualHostServiceClient(conn).Get(ctx, in, opts...)
}

// List implements apploadbalancer.VirtualHostServiceClient
func (c *VirtualHostServiceClient) List(ctx context.Context, in *apploadbalancer.ListVirtualHostsRequest, opts ...grpc.CallOption) (*apploadbalancer.ListVirtualHostsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return apploadbalancer.NewVirtualHostServiceClient(conn).List(ctx, in, opts...)
}

type VirtualHostIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *VirtualHostServiceClient
	request *apploadbalancer.ListVirtualHostsRequest

	items []*apploadbalancer.VirtualHost
}

func (c *VirtualHostServiceClient) VirtualHostIterator(ctx context.Context, req *apploadbalancer.ListVirtualHostsRequest, opts ...grpc.CallOption) *VirtualHostIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &VirtualHostIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *VirtualHostIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.VirtualHosts
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *VirtualHostIterator) Take(size int64) ([]*apploadbalancer.VirtualHost, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*apploadbalancer.VirtualHost

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *VirtualHostIterator) TakeAll() ([]*apploadbalancer.VirtualHost, error) {
	return it.Take(0)
}

func (it *VirtualHostIterator) Value() *apploadbalancer.VirtualHost {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *VirtualHostIterator) Error() error {
	return it.err
}

// RemoveRoute implements apploadbalancer.VirtualHostServiceClient
func (c *VirtualHostServiceClient) RemoveRoute(ctx context.Context, in *apploadbalancer.RemoveRouteRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return apploadbalancer.NewVirtualHostServiceClient(conn).RemoveRoute(ctx, in, opts...)
}

// Update implements apploadbalancer.VirtualHostServiceClient
func (c *VirtualHostServiceClient) Update(ctx context.Context, in *apploadbalancer.UpdateVirtualHostRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return apploadbalancer.NewVirtualHostServiceClient(conn).Update(ctx, in, opts...)
}

// UpdateRoute implements apploadbalancer.VirtualHostServiceClient
func (c *VirtualHostServiceClient) UpdateRoute(ctx context.Context, in *apploadbalancer.UpdateRouteRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return apploadbalancer.NewVirtualHostServiceClient(conn).UpdateRoute(ctx, in, opts...)
}
