// Code generated by sdkgen. DO NOT EDIT.

// nolint
package translate

import (
	"context"

	"google.golang.org/grpc"

	translate "github.com/yandex-cloud/go-genproto/yandex/cloud/ai/translate/v2"
)

//revive:disable

// TranslationServiceClient is a translate.TranslationServiceClient with
// lazy GRPC connection initialization.
type TranslationServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// DetectLanguage implements translate.TranslationServiceClient
func (c *TranslationServiceClient) DetectLanguage(ctx context.Context, in *translate.DetectLanguageRequest, opts ...grpc.CallOption) (*translate.DetectLanguageResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return translate.NewTranslationServiceClient(conn).DetectLanguage(ctx, in, opts...)
}

// ListLanguages implements translate.TranslationServiceClient
func (c *TranslationServiceClient) ListLanguages(ctx context.Context, in *translate.ListLanguagesRequest, opts ...grpc.CallOption) (*translate.ListLanguagesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return translate.NewTranslationServiceClient(conn).ListLanguages(ctx, in, opts...)
}

type TranslationLanguagesIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *TranslationServiceClient
	request *translate.ListLanguagesRequest

	items []*translate.Language
}

func (c *TranslationServiceClient) TranslationLanguagesIterator(ctx context.Context, req *translate.ListLanguagesRequest, opts ...grpc.CallOption) *TranslationLanguagesIterator {
	var pageSize int64
	const defaultPageSize = 1000

	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &TranslationLanguagesIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *TranslationLanguagesIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started {
		return false
	}
	it.started = true

	response, err := it.client.ListLanguages(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Languages
	return len(it.items) > 0
}

func (it *TranslationLanguagesIterator) Take(size int64) ([]*translate.Language, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*translate.Language

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *TranslationLanguagesIterator) TakeAll() ([]*translate.Language, error) {
	return it.Take(0)
}

func (it *TranslationLanguagesIterator) Value() *translate.Language {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *TranslationLanguagesIterator) Error() error {
	return it.err
}

// Translate implements translate.TranslationServiceClient
func (c *TranslationServiceClient) Translate(ctx context.Context, in *translate.TranslateRequest, opts ...grpc.CallOption) (*translate.TranslateResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return translate.NewTranslationServiceClient(conn).Translate(ctx, in, opts...)
}
