// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v3.21.12
// source: yandex/cloud/billing/v1/budget.proto

package billing

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type BudgetStatus int32

const (
	BudgetStatus_BUDGET_STATUS_UNSPECIFIED BudgetStatus = 0
	// The budget is being created.
	BudgetStatus_CREATING BudgetStatus = 1
	// The budget is active.
	BudgetStatus_ACTIVE BudgetStatus = 2
	// The budget is finished.
	BudgetStatus_FINISHED BudgetStatus = 3
)

// Enum value maps for BudgetStatus.
var (
	BudgetStatus_name = map[int32]string{
		0: "BUDGET_STATUS_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "FINISHED",
	}
	BudgetStatus_value = map[string]int32{
		"BUDGET_STATUS_UNSPECIFIED": 0,
		"CREATING":                  1,
		"ACTIVE":                    2,
		"FINISHED":                  3,
	}
)

func (x BudgetStatus) Enum() *BudgetStatus {
	p := new(BudgetStatus)
	*p = x
	return p
}

func (x BudgetStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BudgetStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_billing_v1_budget_proto_enumTypes[0].Descriptor()
}

func (BudgetStatus) Type() protoreflect.EnumType {
	return &file_yandex_cloud_billing_v1_budget_proto_enumTypes[0]
}

func (x BudgetStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BudgetStatus.Descriptor instead.
func (BudgetStatus) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_v1_budget_proto_rawDescGZIP(), []int{0}
}

type ResetPeriodType int32

const (
	ResetPeriodType_RESET_PERIOD_TYPE_UNSPECIFIED ResetPeriodType = 0
	// Reset budget every month.
	ResetPeriodType_MONTHLY ResetPeriodType = 1
	// Reset budget every quarter.
	ResetPeriodType_QUARTER ResetPeriodType = 2
	// Reset budget every year.
	ResetPeriodType_ANNUALLY ResetPeriodType = 3
)

// Enum value maps for ResetPeriodType.
var (
	ResetPeriodType_name = map[int32]string{
		0: "RESET_PERIOD_TYPE_UNSPECIFIED",
		1: "MONTHLY",
		2: "QUARTER",
		3: "ANNUALLY",
	}
	ResetPeriodType_value = map[string]int32{
		"RESET_PERIOD_TYPE_UNSPECIFIED": 0,
		"MONTHLY":                       1,
		"QUARTER":                       2,
		"ANNUALLY":                      3,
	}
)

func (x ResetPeriodType) Enum() *ResetPeriodType {
	p := new(ResetPeriodType)
	*p = x
	return p
}

func (x ResetPeriodType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResetPeriodType) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_billing_v1_budget_proto_enumTypes[1].Descriptor()
}

func (ResetPeriodType) Type() protoreflect.EnumType {
	return &file_yandex_cloud_billing_v1_budget_proto_enumTypes[1]
}

func (x ResetPeriodType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResetPeriodType.Descriptor instead.
func (ResetPeriodType) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_v1_budget_proto_rawDescGZIP(), []int{1}
}

// Define the unit of the [ThesholdRule.amount].
type ThresholdType int32

const (
	ThresholdType_THRESHOLD_TYPE_UNSPECIFIED ThresholdType = 0
	// Percent.
	ThresholdType_PERCENT ThresholdType = 1
	// The same as budget amount.
	ThresholdType_AMOUNT ThresholdType = 2
)

// Enum value maps for ThresholdType.
var (
	ThresholdType_name = map[int32]string{
		0: "THRESHOLD_TYPE_UNSPECIFIED",
		1: "PERCENT",
		2: "AMOUNT",
	}
	ThresholdType_value = map[string]int32{
		"THRESHOLD_TYPE_UNSPECIFIED": 0,
		"PERCENT":                    1,
		"AMOUNT":                     2,
	}
)

func (x ThresholdType) Enum() *ThresholdType {
	p := new(ThresholdType)
	*p = x
	return p
}

func (x ThresholdType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ThresholdType) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_billing_v1_budget_proto_enumTypes[2].Descriptor()
}

func (ThresholdType) Type() protoreflect.EnumType {
	return &file_yandex_cloud_billing_v1_budget_proto_enumTypes[2]
}

func (x ThresholdType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ThresholdType.Descriptor instead.
func (ThresholdType) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_v1_budget_proto_rawDescGZIP(), []int{2}
}

// A Budget resource. For more information, see [/docs/billing/concepts/budget].
type Budget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the budget.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the budget.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Creation timestamp.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// ID of the billing account that the budget belongs to.
	BillingAccountId string `protobuf:"bytes,4,opt,name=billing_account_id,json=billingAccountId,proto3" json:"billing_account_id,omitempty"`
	// Status of the budget.
	Status BudgetStatus `protobuf:"varint,5,opt,name=status,proto3,enum=yandex.cloud.billing.v1.BudgetStatus" json:"status,omitempty"`
	// Specification of the budget.
	//
	// Types that are assignable to BudgetSpec:
	//
	//	*Budget_CostBudget
	//	*Budget_ExpenseBudget
	//	*Budget_BalanceBudget
	BudgetSpec isBudget_BudgetSpec `protobuf_oneof:"budget_spec"`
}

func (x *Budget) Reset() {
	*x = Budget{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Budget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Budget) ProtoMessage() {}

func (x *Budget) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Budget.ProtoReflect.Descriptor instead.
func (*Budget) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_v1_budget_proto_rawDescGZIP(), []int{0}
}

func (x *Budget) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Budget) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Budget) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Budget) GetBillingAccountId() string {
	if x != nil {
		return x.BillingAccountId
	}
	return ""
}

func (x *Budget) GetStatus() BudgetStatus {
	if x != nil {
		return x.Status
	}
	return BudgetStatus_BUDGET_STATUS_UNSPECIFIED
}

func (m *Budget) GetBudgetSpec() isBudget_BudgetSpec {
	if m != nil {
		return m.BudgetSpec
	}
	return nil
}

func (x *Budget) GetCostBudget() *CostBudgetSpec {
	if x, ok := x.GetBudgetSpec().(*Budget_CostBudget); ok {
		return x.CostBudget
	}
	return nil
}

func (x *Budget) GetExpenseBudget() *ExpenseBudgetSpec {
	if x, ok := x.GetBudgetSpec().(*Budget_ExpenseBudget); ok {
		return x.ExpenseBudget
	}
	return nil
}

func (x *Budget) GetBalanceBudget() *BalanceBudgetSpec {
	if x, ok := x.GetBudgetSpec().(*Budget_BalanceBudget); ok {
		return x.BalanceBudget
	}
	return nil
}

type isBudget_BudgetSpec interface {
	isBudget_BudgetSpec()
}

type Budget_CostBudget struct {
	// Cost budget specification.
	CostBudget *CostBudgetSpec `protobuf:"bytes,6,opt,name=cost_budget,json=costBudget,proto3,oneof"`
}

type Budget_ExpenseBudget struct {
	// Expense budget specification.
	ExpenseBudget *ExpenseBudgetSpec `protobuf:"bytes,7,opt,name=expense_budget,json=expenseBudget,proto3,oneof"`
}

type Budget_BalanceBudget struct {
	// Balance budget specification.
	BalanceBudget *BalanceBudgetSpec `protobuf:"bytes,8,opt,name=balance_budget,json=balanceBudget,proto3,oneof"`
}

func (*Budget_CostBudget) isBudget_BudgetSpec() {}

func (*Budget_ExpenseBudget) isBudget_BudgetSpec() {}

func (*Budget_BalanceBudget) isBudget_BudgetSpec() {}

// Cost budget specification describes budget that can be used to control cost of cloud resources usage.
type CostBudgetSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Max cost threshold of the budget. Amount currency is the same as corresponding [yandex.cloud.billing.v1.BillingAccount.currency].
	Amount string `protobuf:"bytes,1,opt,name=amount,proto3" json:"amount,omitempty"`
	// IDs of the [yandex.cloud.iam.v1.UserAccount].
	// Specified users will be be notified if the budget exceeds.
	NotificationUserAccountIds []string `protobuf:"bytes,2,rep,name=notification_user_account_ids,json=notificationUserAccountIds,proto3" json:"notification_user_account_ids,omitempty"`
	// List of the [ThresholdRule].
	// Rules define intermediate cost thresholds of the budget.
	ThresholdRules []*ThresholdRule `protobuf:"bytes,3,rep,name=threshold_rules,json=thresholdRules,proto3" json:"threshold_rules,omitempty"`
	// Filter that can be used for specific resources selection. Only consumption cost of selected resources are used for the budget calculation.
	Filter *ConsumptionFilter `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Start type of the budget.
	//
	// Types that are assignable to StartType:
	//
	//	*CostBudgetSpec_ResetPeriod
	//	*CostBudgetSpec_StartDate
	StartType isCostBudgetSpec_StartType `protobuf_oneof:"start_type"`
	// End date of the budget.
	// Must be the last day of a month and must be formatted like YYYY-MM-DD.
	EndDate string `protobuf:"bytes,7,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
}

func (x *CostBudgetSpec) Reset() {
	*x = CostBudgetSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CostBudgetSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CostBudgetSpec) ProtoMessage() {}

func (x *CostBudgetSpec) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CostBudgetSpec.ProtoReflect.Descriptor instead.
func (*CostBudgetSpec) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_v1_budget_proto_rawDescGZIP(), []int{1}
}

func (x *CostBudgetSpec) GetAmount() string {
	if x != nil {
		return x.Amount
	}
	return ""
}

func (x *CostBudgetSpec) GetNotificationUserAccountIds() []string {
	if x != nil {
		return x.NotificationUserAccountIds
	}
	return nil
}

func (x *CostBudgetSpec) GetThresholdRules() []*ThresholdRule {
	if x != nil {
		return x.ThresholdRules
	}
	return nil
}

func (x *CostBudgetSpec) GetFilter() *ConsumptionFilter {
	if x != nil {
		return x.Filter
	}
	return nil
}

func (m *CostBudgetSpec) GetStartType() isCostBudgetSpec_StartType {
	if m != nil {
		return m.StartType
	}
	return nil
}

func (x *CostBudgetSpec) GetResetPeriod() ResetPeriodType {
	if x, ok := x.GetStartType().(*CostBudgetSpec_ResetPeriod); ok {
		return x.ResetPeriod
	}
	return ResetPeriodType_RESET_PERIOD_TYPE_UNSPECIFIED
}

func (x *CostBudgetSpec) GetStartDate() string {
	if x, ok := x.GetStartType().(*CostBudgetSpec_StartDate); ok {
		return x.StartDate
	}
	return ""
}

func (x *CostBudgetSpec) GetEndDate() string {
	if x != nil {
		return x.EndDate
	}
	return ""
}

type isCostBudgetSpec_StartType interface {
	isCostBudgetSpec_StartType()
}

type CostBudgetSpec_ResetPeriod struct {
	// Periodic start type that resets budget after specified period is finished.
	// First time budget is calculated in the current period, i.e. current month, quarter or year.
	ResetPeriod ResetPeriodType `protobuf:"varint,5,opt,name=reset_period,json=resetPeriod,proto3,enum=yandex.cloud.billing.v1.ResetPeriodType,oneof"`
}

type CostBudgetSpec_StartDate struct {
	// Custom start date of the budget.
	// Must be the first day of a month and must be formatted like YYYY-MM-DD.
	StartDate string `protobuf:"bytes,6,opt,name=start_date,json=startDate,proto3,oneof"`
}

func (*CostBudgetSpec_ResetPeriod) isCostBudgetSpec_StartType() {}

func (*CostBudgetSpec_StartDate) isCostBudgetSpec_StartType() {}

// Expense budget specification describes budget that can be used to control expense of cloud resources usage.
type ExpenseBudgetSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Max expense threshold of the budget. Amount currency is the same as corresponding [yandex.cloud.billing.v1.BillingAccount.currency].
	Amount string `protobuf:"bytes,1,opt,name=amount,proto3" json:"amount,omitempty"`
	// IDs of the [yandex.cloud.iam.v1.UserAccount].
	// Specified users will be be notified if the budget exceeds.
	NotificationUserAccountIds []string `protobuf:"bytes,2,rep,name=notification_user_account_ids,json=notificationUserAccountIds,proto3" json:"notification_user_account_ids,omitempty"`
	// List of the [ThresholdRule].
	// Rules define intermediate expense thresholds of the budget.
	ThresholdRules []*ThresholdRule `protobuf:"bytes,3,rep,name=threshold_rules,json=thresholdRules,proto3" json:"threshold_rules,omitempty"`
	// Filter that can be used for specific resources selection. Only consumption expense of selected resources are used for the budget calculation.
	Filter *ConsumptionFilter `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Start type of the budget.
	//
	// Types that are assignable to StartType:
	//
	//	*ExpenseBudgetSpec_ResetPeriod
	//	*ExpenseBudgetSpec_StartDate
	StartType isExpenseBudgetSpec_StartType `protobuf_oneof:"start_type"`
	// End date of the budget.
	// Must be the last day of a month and must be formatted like YYYY-MM-DD.
	EndDate string `protobuf:"bytes,7,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
}

func (x *ExpenseBudgetSpec) Reset() {
	*x = ExpenseBudgetSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExpenseBudgetSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExpenseBudgetSpec) ProtoMessage() {}

func (x *ExpenseBudgetSpec) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExpenseBudgetSpec.ProtoReflect.Descriptor instead.
func (*ExpenseBudgetSpec) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_v1_budget_proto_rawDescGZIP(), []int{2}
}

func (x *ExpenseBudgetSpec) GetAmount() string {
	if x != nil {
		return x.Amount
	}
	return ""
}

func (x *ExpenseBudgetSpec) GetNotificationUserAccountIds() []string {
	if x != nil {
		return x.NotificationUserAccountIds
	}
	return nil
}

func (x *ExpenseBudgetSpec) GetThresholdRules() []*ThresholdRule {
	if x != nil {
		return x.ThresholdRules
	}
	return nil
}

func (x *ExpenseBudgetSpec) GetFilter() *ConsumptionFilter {
	if x != nil {
		return x.Filter
	}
	return nil
}

func (m *ExpenseBudgetSpec) GetStartType() isExpenseBudgetSpec_StartType {
	if m != nil {
		return m.StartType
	}
	return nil
}

func (x *ExpenseBudgetSpec) GetResetPeriod() ResetPeriodType {
	if x, ok := x.GetStartType().(*ExpenseBudgetSpec_ResetPeriod); ok {
		return x.ResetPeriod
	}
	return ResetPeriodType_RESET_PERIOD_TYPE_UNSPECIFIED
}

func (x *ExpenseBudgetSpec) GetStartDate() string {
	if x, ok := x.GetStartType().(*ExpenseBudgetSpec_StartDate); ok {
		return x.StartDate
	}
	return ""
}

func (x *ExpenseBudgetSpec) GetEndDate() string {
	if x != nil {
		return x.EndDate
	}
	return ""
}

type isExpenseBudgetSpec_StartType interface {
	isExpenseBudgetSpec_StartType()
}

type ExpenseBudgetSpec_ResetPeriod struct {
	// Periodic start type that resets budget after specified period is finished.
	// First time budget is calculated in the current period, i.e. current month, quarter or year.
	ResetPeriod ResetPeriodType `protobuf:"varint,5,opt,name=reset_period,json=resetPeriod,proto3,enum=yandex.cloud.billing.v1.ResetPeriodType,oneof"`
}

type ExpenseBudgetSpec_StartDate struct {
	// Custom start date of the budget.
	// Must be the first day of a month and must be formatted like YYYY-MM-DD.
	StartDate string `protobuf:"bytes,6,opt,name=start_date,json=startDate,proto3,oneof"`
}

func (*ExpenseBudgetSpec_ResetPeriod) isExpenseBudgetSpec_StartType() {}

func (*ExpenseBudgetSpec_StartDate) isExpenseBudgetSpec_StartType() {}

// Balance budget specification describes budget that can be used to control [yandex.cloud.billing.v1.BillingAccount.balance].
type BalanceBudgetSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Max balance threshold of the budget. Amount currency is the same as corresponding [yandex.cloud.billing.v1.BillingAccount.currency].
	Amount string `protobuf:"bytes,1,opt,name=amount,proto3" json:"amount,omitempty"`
	// IDs of the [yandex.cloud.iam.v1.UserAccount].
	// Specified users will be be notified if the budget exceeds.
	NotificationUserAccountIds []string `protobuf:"bytes,2,rep,name=notification_user_account_ids,json=notificationUserAccountIds,proto3" json:"notification_user_account_ids,omitempty"`
	// List of the [ThresholdRule].
	// Rules define intermediate balance thresholds of the budget.
	ThresholdRules []*ThresholdRule `protobuf:"bytes,3,rep,name=threshold_rules,json=thresholdRules,proto3" json:"threshold_rules,omitempty"`
	// Start_date of the budget.
	// Must be the first day of a month and must be formatted like YYYY-MM-DD.
	StartDate string `protobuf:"bytes,4,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// End date of the budget.
	// Must be the last day of a month and must be formatted like YYYY-MM-DD.
	EndDate string `protobuf:"bytes,5,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
}

func (x *BalanceBudgetSpec) Reset() {
	*x = BalanceBudgetSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BalanceBudgetSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BalanceBudgetSpec) ProtoMessage() {}

func (x *BalanceBudgetSpec) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BalanceBudgetSpec.ProtoReflect.Descriptor instead.
func (*BalanceBudgetSpec) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_v1_budget_proto_rawDescGZIP(), []int{3}
}

func (x *BalanceBudgetSpec) GetAmount() string {
	if x != nil {
		return x.Amount
	}
	return ""
}

func (x *BalanceBudgetSpec) GetNotificationUserAccountIds() []string {
	if x != nil {
		return x.NotificationUserAccountIds
	}
	return nil
}

func (x *BalanceBudgetSpec) GetThresholdRules() []*ThresholdRule {
	if x != nil {
		return x.ThresholdRules
	}
	return nil
}

func (x *BalanceBudgetSpec) GetStartDate() string {
	if x != nil {
		return x.StartDate
	}
	return ""
}

func (x *BalanceBudgetSpec) GetEndDate() string {
	if x != nil {
		return x.EndDate
	}
	return ""
}

// Filter that can be used for specific resources selection.
type ConsumptionFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// IDs of the [yandex.cloud.billing.v1.Service].
	// Only consumption of resources corresponding to the given services is used for the budget calculation.
	// Empty sequence means no services filters.
	ServiceIds []string `protobuf:"bytes,1,rep,name=service_ids,json=serviceIds,proto3" json:"service_ids,omitempty"`
	// Cloud and folders consumption filter.
	// Only consumption within specified clouds and folders is used for the budget calculation.
	// Empty sequence means no cloud and folders filters.
	CloudFoldersFilters []*CloudFoldersConsumptionFilter `protobuf:"bytes,2,rep,name=cloud_folders_filters,json=cloudFoldersFilters,proto3" json:"cloud_folders_filters,omitempty"`
}

func (x *ConsumptionFilter) Reset() {
	*x = ConsumptionFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConsumptionFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConsumptionFilter) ProtoMessage() {}

func (x *ConsumptionFilter) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConsumptionFilter.ProtoReflect.Descriptor instead.
func (*ConsumptionFilter) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_v1_budget_proto_rawDescGZIP(), []int{4}
}

func (x *ConsumptionFilter) GetServiceIds() []string {
	if x != nil {
		return x.ServiceIds
	}
	return nil
}

func (x *ConsumptionFilter) GetCloudFoldersFilters() []*CloudFoldersConsumptionFilter {
	if x != nil {
		return x.CloudFoldersFilters
	}
	return nil
}

// Filter that can be used for specific cloud and its folders selection.
type CloudFoldersConsumptionFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the [yandex.cloud.resourcemanager.v1.Cloud].
	// Only consumption within specified cloud is used for the budget calculation.
	CloudId string `protobuf:"bytes,1,opt,name=cloud_id,json=cloudId,proto3" json:"cloud_id,omitempty"`
	// IDs of the [yandex.cloud.resourcemanager.v1.Folder].
	// Only consumption within specified folders of the given cloud is used for the budget calculation.
	// Empty sequence means no folders filters and the whole cloud consumption will be used.
	FolderIds []string `protobuf:"bytes,2,rep,name=folder_ids,json=folderIds,proto3" json:"folder_ids,omitempty"`
}

func (x *CloudFoldersConsumptionFilter) Reset() {
	*x = CloudFoldersConsumptionFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudFoldersConsumptionFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudFoldersConsumptionFilter) ProtoMessage() {}

func (x *CloudFoldersConsumptionFilter) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudFoldersConsumptionFilter.ProtoReflect.Descriptor instead.
func (*CloudFoldersConsumptionFilter) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_v1_budget_proto_rawDescGZIP(), []int{5}
}

func (x *CloudFoldersConsumptionFilter) GetCloudId() string {
	if x != nil {
		return x.CloudId
	}
	return ""
}

func (x *CloudFoldersConsumptionFilter) GetFolderIds() []string {
	if x != nil {
		return x.FolderIds
	}
	return nil
}

// Rules that define intermediate cost thresholds of the budget.
type ThresholdRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the rule.
	Type ThresholdType `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.billing.v1.ThresholdType" json:"type,omitempty"`
	// Amount of the rule.
	//   - Must be less than 100 if type is PERCENT.
	//   - Must be less than budget's amount if type is AMOUNT.
	Amount string `protobuf:"bytes,2,opt,name=amount,proto3" json:"amount,omitempty"`
	// IDs of the [yandex.cloud.iam.v1.UserAccount].
	// Specified users will be be notified if the threshold exceeds.
	NotificationUserAccountIds []string `protobuf:"bytes,3,rep,name=notification_user_account_ids,json=notificationUserAccountIds,proto3" json:"notification_user_account_ids,omitempty"`
}

func (x *ThresholdRule) Reset() {
	*x = ThresholdRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ThresholdRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ThresholdRule) ProtoMessage() {}

func (x *ThresholdRule) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ThresholdRule.ProtoReflect.Descriptor instead.
func (*ThresholdRule) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_v1_budget_proto_rawDescGZIP(), []int{6}
}

func (x *ThresholdRule) GetType() ThresholdType {
	if x != nil {
		return x.Type
	}
	return ThresholdType_THRESHOLD_TYPE_UNSPECIFIED
}

func (x *ThresholdRule) GetAmount() string {
	if x != nil {
		return x.Amount
	}
	return ""
}

func (x *ThresholdRule) GetNotificationUserAccountIds() []string {
	if x != nil {
		return x.NotificationUserAccountIds
	}
	return nil
}

var File_yandex_cloud_billing_v1_budget_proto protoreflect.FileDescriptor

var file_yandex_cloud_billing_v1_budget_proto_rawDesc = []byte{
	0x0a, 0x24, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1d, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xdf, 0x03, 0x0a, 0x06, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x39,
	0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x2c, 0x0a, 0x12, 0x62, 0x69, 0x6c,
	0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x3d, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x4a, 0x0a, 0x0b, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x62,
	0x75, 0x64, 0x67, 0x65, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x73, 0x74, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74,
	0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x0a, 0x63, 0x6f, 0x73, 0x74, 0x42, 0x75, 0x64, 0x67,
	0x65, 0x74, 0x12, 0x53, 0x0a, 0x0e, 0x65, 0x78, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x62, 0x75,
	0x64, 0x67, 0x65, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x6e, 0x73, 0x65, 0x42, 0x75, 0x64, 0x67,
	0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x0d, 0x65, 0x78, 0x70, 0x65, 0x6e, 0x73,
	0x65, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x12, 0x53, 0x0a, 0x0e, 0x62, 0x61, 0x6c, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63,
	0x65, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x0d, 0x62,
	0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x42, 0x13, 0x0a, 0x0b,
	0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x12, 0x04, 0xc0, 0xc1, 0x31,
	0x01, 0x22, 0xb4, 0x03, 0x0a, 0x0e, 0x43, 0x6f, 0x73, 0x74, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x1c, 0x0a, 0x06, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe8, 0xc7, 0x31, 0x01, 0x52, 0x06, 0x61, 0x6d, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x4a, 0x0a, 0x1d, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x07, 0x82, 0xc8, 0x31, 0x03, 0x3e,
	0x3d, 0x31, 0x52, 0x1a, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x64, 0x73, 0x12, 0x4f,
	0x0a, 0x0f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x5f, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x52, 0x75, 0x6c, 0x65, 0x52,
	0x0e, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12,
	0x42, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x4d, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x70, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x54,
	0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x65, 0x74, 0x50, 0x65, 0x72, 0x69,
	0x6f, 0x64, 0x12, 0x1f, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x44,
	0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe8, 0xc7, 0x31, 0x01, 0x52, 0x07, 0x65, 0x6e, 0x64,
	0x44, 0x61, 0x74, 0x65, 0x42, 0x12, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x04, 0xc0, 0xc1, 0x31, 0x01, 0x22, 0xb7, 0x03, 0x0a, 0x11, 0x45, 0x78, 0x70,
	0x65, 0x6e, 0x73, 0x65, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1c,
	0x0a, 0x06, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04,
	0xe8, 0xc7, 0x31, 0x01, 0x52, 0x06, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4a, 0x0a, 0x1d,
	0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x07, 0x82, 0xc8, 0x31, 0x03, 0x3e, 0x3d, 0x31, 0x52, 0x1a, 0x6e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x64, 0x73, 0x12, 0x4f, 0x0a, 0x0f, 0x74, 0x68, 0x72, 0x65,
	0x73, 0x68, 0x6f, 0x6c, 0x64, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x68, 0x72, 0x65,
	0x73, 0x68, 0x6f, 0x6c, 0x64, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x0e, 0x74, 0x68, 0x72, 0x65, 0x73,
	0x68, 0x6f, 0x6c, 0x64, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x42, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x4d, 0x0a,
	0x0c, 0x72, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x65, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52,
	0x0b, 0x72, 0x65, 0x73, 0x65, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x1f, 0x0a, 0x0a,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x44, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a,
	0x08, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x04, 0xe8, 0xc7, 0x31, 0x01, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x44, 0x61, 0x74, 0x65, 0x42, 0x12,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x12, 0x04, 0xc0, 0xc1,
	0x31, 0x01, 0x22, 0x8e, 0x02, 0x0a, 0x11, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x75,
	0x64, 0x67, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1c, 0x0a, 0x06, 0x61, 0x6d, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe8, 0xc7, 0x31, 0x01, 0x52, 0x06,
	0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4a, 0x0a, 0x1d, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x07, 0x82,
	0xc8, 0x31, 0x03, 0x3e, 0x3d, 0x31, 0x52, 0x1a, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49,
	0x64, 0x73, 0x12, 0x4f, 0x0a, 0x0f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x5f,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x52,
	0x75, 0x6c, 0x65, 0x52, 0x0e, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x52, 0x75,
	0x6c, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x44, 0x61,
	0x74, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe8, 0xc7, 0x31, 0x01, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x44,
	0x61, 0x74, 0x65, 0x22, 0xa0, 0x01, 0x0a, 0x11, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x73, 0x12, 0x6a, 0x0a, 0x15, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x5f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x52, 0x13, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x22, 0x59, 0x0a, 0x1d, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x49, 0x64,
	0x73, 0x22, 0xb2, 0x01, 0x0a, 0x0d, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x52,
	0x75, 0x6c, 0x65, 0x12, 0x40, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x68, 0x72, 0x65,
	0x73, 0x68, 0x6f, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x42, 0x04, 0xe8, 0xc7, 0x31, 0x01, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x06, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe8, 0xc7, 0x31, 0x01, 0x52, 0x06, 0x61, 0x6d, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x41, 0x0a, 0x1d, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x5f, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x1a, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x49, 0x64, 0x73, 0x2a, 0x55, 0x0a, 0x0c, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1d, 0x0a, 0x19, 0x42, 0x55, 0x44, 0x47, 0x45, 0x54,
	0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12,
	0x0c, 0x0a, 0x08, 0x46, 0x49, 0x4e, 0x49, 0x53, 0x48, 0x45, 0x44, 0x10, 0x03, 0x2a, 0x5c, 0x0a,
	0x0f, 0x52, 0x65, 0x73, 0x65, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x21, 0x0a, 0x1d, 0x52, 0x45, 0x53, 0x45, 0x54, 0x5f, 0x50, 0x45, 0x52, 0x49, 0x4f, 0x44,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x4c, 0x59, 0x10, 0x01,
	0x12, 0x0b, 0x0a, 0x07, 0x51, 0x55, 0x41, 0x52, 0x54, 0x45, 0x52, 0x10, 0x02, 0x12, 0x0c, 0x0a,
	0x08, 0x41, 0x4e, 0x4e, 0x55, 0x41, 0x4c, 0x4c, 0x59, 0x10, 0x03, 0x2a, 0x48, 0x0a, 0x0d, 0x54,
	0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x1a,
	0x54, 0x48, 0x52, 0x45, 0x53, 0x48, 0x4f, 0x4c, 0x44, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x50, 0x45, 0x52, 0x43, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x4d, 0x4f,
	0x55, 0x4e, 0x54, 0x10, 0x02, 0x42, 0x62, 0x0a, 0x1b, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x5a, 0x43, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6f,
	0x2d, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2f, 0x76,
	0x31, 0x3b, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_yandex_cloud_billing_v1_budget_proto_rawDescOnce sync.Once
	file_yandex_cloud_billing_v1_budget_proto_rawDescData = file_yandex_cloud_billing_v1_budget_proto_rawDesc
)

func file_yandex_cloud_billing_v1_budget_proto_rawDescGZIP() []byte {
	file_yandex_cloud_billing_v1_budget_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_billing_v1_budget_proto_rawDescData = protoimpl.X.CompressGZIP(file_yandex_cloud_billing_v1_budget_proto_rawDescData)
	})
	return file_yandex_cloud_billing_v1_budget_proto_rawDescData
}

var file_yandex_cloud_billing_v1_budget_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_yandex_cloud_billing_v1_budget_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_yandex_cloud_billing_v1_budget_proto_goTypes = []any{
	(BudgetStatus)(0),                     // 0: yandex.cloud.billing.v1.BudgetStatus
	(ResetPeriodType)(0),                  // 1: yandex.cloud.billing.v1.ResetPeriodType
	(ThresholdType)(0),                    // 2: yandex.cloud.billing.v1.ThresholdType
	(*Budget)(nil),                        // 3: yandex.cloud.billing.v1.Budget
	(*CostBudgetSpec)(nil),                // 4: yandex.cloud.billing.v1.CostBudgetSpec
	(*ExpenseBudgetSpec)(nil),             // 5: yandex.cloud.billing.v1.ExpenseBudgetSpec
	(*BalanceBudgetSpec)(nil),             // 6: yandex.cloud.billing.v1.BalanceBudgetSpec
	(*ConsumptionFilter)(nil),             // 7: yandex.cloud.billing.v1.ConsumptionFilter
	(*CloudFoldersConsumptionFilter)(nil), // 8: yandex.cloud.billing.v1.CloudFoldersConsumptionFilter
	(*ThresholdRule)(nil),                 // 9: yandex.cloud.billing.v1.ThresholdRule
	(*timestamppb.Timestamp)(nil),         // 10: google.protobuf.Timestamp
}
var file_yandex_cloud_billing_v1_budget_proto_depIdxs = []int32{
	10, // 0: yandex.cloud.billing.v1.Budget.created_at:type_name -> google.protobuf.Timestamp
	0,  // 1: yandex.cloud.billing.v1.Budget.status:type_name -> yandex.cloud.billing.v1.BudgetStatus
	4,  // 2: yandex.cloud.billing.v1.Budget.cost_budget:type_name -> yandex.cloud.billing.v1.CostBudgetSpec
	5,  // 3: yandex.cloud.billing.v1.Budget.expense_budget:type_name -> yandex.cloud.billing.v1.ExpenseBudgetSpec
	6,  // 4: yandex.cloud.billing.v1.Budget.balance_budget:type_name -> yandex.cloud.billing.v1.BalanceBudgetSpec
	9,  // 5: yandex.cloud.billing.v1.CostBudgetSpec.threshold_rules:type_name -> yandex.cloud.billing.v1.ThresholdRule
	7,  // 6: yandex.cloud.billing.v1.CostBudgetSpec.filter:type_name -> yandex.cloud.billing.v1.ConsumptionFilter
	1,  // 7: yandex.cloud.billing.v1.CostBudgetSpec.reset_period:type_name -> yandex.cloud.billing.v1.ResetPeriodType
	9,  // 8: yandex.cloud.billing.v1.ExpenseBudgetSpec.threshold_rules:type_name -> yandex.cloud.billing.v1.ThresholdRule
	7,  // 9: yandex.cloud.billing.v1.ExpenseBudgetSpec.filter:type_name -> yandex.cloud.billing.v1.ConsumptionFilter
	1,  // 10: yandex.cloud.billing.v1.ExpenseBudgetSpec.reset_period:type_name -> yandex.cloud.billing.v1.ResetPeriodType
	9,  // 11: yandex.cloud.billing.v1.BalanceBudgetSpec.threshold_rules:type_name -> yandex.cloud.billing.v1.ThresholdRule
	8,  // 12: yandex.cloud.billing.v1.ConsumptionFilter.cloud_folders_filters:type_name -> yandex.cloud.billing.v1.CloudFoldersConsumptionFilter
	2,  // 13: yandex.cloud.billing.v1.ThresholdRule.type:type_name -> yandex.cloud.billing.v1.ThresholdType
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_yandex_cloud_billing_v1_budget_proto_init() }
func file_yandex_cloud_billing_v1_budget_proto_init() {
	if File_yandex_cloud_billing_v1_budget_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_yandex_cloud_billing_v1_budget_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Budget); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_billing_v1_budget_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*CostBudgetSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_billing_v1_budget_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ExpenseBudgetSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_billing_v1_budget_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*BalanceBudgetSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_billing_v1_budget_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*ConsumptionFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_billing_v1_budget_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*CloudFoldersConsumptionFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_billing_v1_budget_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*ThresholdRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_yandex_cloud_billing_v1_budget_proto_msgTypes[0].OneofWrappers = []any{
		(*Budget_CostBudget)(nil),
		(*Budget_ExpenseBudget)(nil),
		(*Budget_BalanceBudget)(nil),
	}
	file_yandex_cloud_billing_v1_budget_proto_msgTypes[1].OneofWrappers = []any{
		(*CostBudgetSpec_ResetPeriod)(nil),
		(*CostBudgetSpec_StartDate)(nil),
	}
	file_yandex_cloud_billing_v1_budget_proto_msgTypes[2].OneofWrappers = []any{
		(*ExpenseBudgetSpec_ResetPeriod)(nil),
		(*ExpenseBudgetSpec_StartDate)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_yandex_cloud_billing_v1_budget_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_billing_v1_budget_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_billing_v1_budget_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_billing_v1_budget_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_billing_v1_budget_proto_msgTypes,
	}.Build()
	File_yandex_cloud_billing_v1_budget_proto = out.File
	file_yandex_cloud_billing_v1_budget_proto_rawDesc = nil
	file_yandex_cloud_billing_v1_budget_proto_goTypes = nil
	file_yandex_cloud_billing_v1_budget_proto_depIdxs = nil
}
