// Copyright 2022-2023 The sacloud/iaas-api-go Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// generated by 'github.com/sacloud/iaas-api-go/internal/tools/gen-api-result'; DO NOT EDIT

package iaas

// ArchiveFindResult represents the Result of API
type ArchiveFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	Archives []*Archive `json:",omitempty" mapconv:"[]Archives,omitempty,recursive"`
}

// Values returns find results
func (r *ArchiveFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.Archives {
		results = append(results, v)
	}
	return results
}

// archiveCreateResult represents the Result of API
type archiveCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Archive *Archive `json:",omitempty" mapconv:"Archive,omitempty,recursive"`
}

// archiveCreateBlankResult represents the Result of API
type archiveCreateBlankResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Archive   *Archive   `json:",omitempty" mapconv:"Archive,omitempty,recursive"`
	FTPServer *FTPServer `json:",omitempty" mapconv:"FTPServer,omitempty,recursive"`
}

// archiveReadResult represents the Result of API
type archiveReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Archive *Archive `json:",omitempty" mapconv:"Archive,omitempty,recursive"`
}

// archiveUpdateResult represents the Result of API
type archiveUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Archive *Archive `json:",omitempty" mapconv:"Archive,omitempty,recursive"`
}

// archiveOpenFTPResult represents the Result of API
type archiveOpenFTPResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	FTPServer *FTPServer `json:",omitempty" mapconv:"FTPServer,omitempty,recursive"`
}

// archiveShareResult represents the Result of API
type archiveShareResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	ArchiveShareInfo *ArchiveShareInfo `json:",omitempty" mapconv:"ArchiveShareInfo,omitempty,recursive"`
}

// archiveCreateFromSharedResult represents the Result of API
type archiveCreateFromSharedResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Archive *Archive `json:",omitempty" mapconv:"Archive,omitempty,recursive"`
}

// archiveTransferResult represents the Result of API
type archiveTransferResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Archive *Archive `json:",omitempty" mapconv:"Archive,omitempty,recursive"`
}

// authStatusReadResult represents the Result of API
type authStatusReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	AuthStatus *AuthStatus `json:",omitempty" mapconv:"AuthStatus,omitempty,recursive"`
}

// AutoBackupFindResult represents the Result of API
type AutoBackupFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	AutoBackups []*AutoBackup `json:",omitempty" mapconv:"[]CommonServiceItems,omitempty,recursive"`
}

// Values returns find results
func (r *AutoBackupFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.AutoBackups {
		results = append(results, v)
	}
	return results
}

// autoBackupCreateResult represents the Result of API
type autoBackupCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	AutoBackup *AutoBackup `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// autoBackupReadResult represents the Result of API
type autoBackupReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	AutoBackup *AutoBackup `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// autoBackupUpdateResult represents the Result of API
type autoBackupUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	AutoBackup *AutoBackup `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// autoBackupUpdateSettingsResult represents the Result of API
type autoBackupUpdateSettingsResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	AutoBackup *AutoBackup `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// AutoScaleFindResult represents the Result of API
type AutoScaleFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	AutoScale []*AutoScale `json:",omitempty" mapconv:"[]CommonServiceItems,omitempty,recursive"`
}

// Values returns find results
func (r *AutoScaleFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.AutoScale {
		results = append(results, v)
	}
	return results
}

// autoScaleCreateResult represents the Result of API
type autoScaleCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	AutoScale *AutoScale `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// autoScaleReadResult represents the Result of API
type autoScaleReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	AutoScale *AutoScale `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// autoScaleUpdateResult represents the Result of API
type autoScaleUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	AutoScale *AutoScale `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// autoScaleUpdateSettingsResult represents the Result of API
type autoScaleUpdateSettingsResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	AutoScale *AutoScale `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// autoScaleStatusResult represents the Result of API
type autoScaleStatusResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	AutoScaleStatus *AutoScaleStatus `json:",omitempty" mapconv:"AutoScale,omitempty,recursive"`
}

// BillByContractResult represents the Result of API
type BillByContractResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	Bills []*Bill `json:",omitempty" mapconv:"[]Bills,omitempty,recursive"`
}

// Values returns find results
func (r *BillByContractResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.Bills {
		results = append(results, v)
	}
	return results
}

// BillByContractYearResult represents the Result of API
type BillByContractYearResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	Bills []*Bill `json:",omitempty" mapconv:"[]Bills,omitempty,recursive"`
}

// Values returns find results
func (r *BillByContractYearResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.Bills {
		results = append(results, v)
	}
	return results
}

// BillByContractYearMonthResult represents the Result of API
type BillByContractYearMonthResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	Bills []*Bill `json:",omitempty" mapconv:"[]Bills,omitempty,recursive"`
}

// Values returns find results
func (r *BillByContractYearMonthResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.Bills {
		results = append(results, v)
	}
	return results
}

// BillReadResult represents the Result of API
type BillReadResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	Bills []*Bill `json:",omitempty" mapconv:"[]Bills,omitempty,recursive"`
}

// Values returns find results
func (r *BillReadResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.Bills {
		results = append(results, v)
	}
	return results
}

// BillDetailsResult represents the Result of API
type BillDetailsResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	BillDetails []*BillDetail `json:",omitempty" mapconv:"[]BillDetails,omitempty,recursive"`
}

// Values returns find results
func (r *BillDetailsResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.BillDetails {
		results = append(results, v)
	}
	return results
}

// billDetailsCSVResult represents the Result of API
type billDetailsCSVResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	BillDetailCSV *BillDetailCSV `json:",omitempty" mapconv:"CSV,omitempty,recursive"`
}

// BridgeFindResult represents the Result of API
type BridgeFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	Bridges []*Bridge `json:",omitempty" mapconv:"[]Bridges,omitempty,recursive"`
}

// Values returns find results
func (r *BridgeFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.Bridges {
		results = append(results, v)
	}
	return results
}

// bridgeCreateResult represents the Result of API
type bridgeCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Bridge *Bridge `json:",omitempty" mapconv:"Bridge,omitempty,recursive"`
}

// bridgeReadResult represents the Result of API
type bridgeReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Bridge *Bridge `json:",omitempty" mapconv:"Bridge,omitempty,recursive"`
}

// bridgeUpdateResult represents the Result of API
type bridgeUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Bridge *Bridge `json:",omitempty" mapconv:"Bridge,omitempty,recursive"`
}

// CDROMFindResult represents the Result of API
type CDROMFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	CDROMs []*CDROM `json:",omitempty" mapconv:"[]CDROMs,omitempty,recursive"`
}

// Values returns find results
func (r *CDROMFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.CDROMs {
		results = append(results, v)
	}
	return results
}

// cDROMCreateResult represents the Result of API
type cDROMCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	CDROM     *CDROM     `json:",omitempty" mapconv:"CDROM,omitempty,recursive"`
	FTPServer *FTPServer `json:",omitempty" mapconv:"FTPServer,omitempty,recursive"`
}

// cDROMReadResult represents the Result of API
type cDROMReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	CDROM *CDROM `json:",omitempty" mapconv:"CDROM,omitempty,recursive"`
}

// cDROMUpdateResult represents the Result of API
type cDROMUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	CDROM *CDROM `json:",omitempty" mapconv:"CDROM,omitempty,recursive"`
}

// cDROMOpenFTPResult represents the Result of API
type cDROMOpenFTPResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	FTPServer *FTPServer `json:",omitempty" mapconv:"FTPServer,omitempty,recursive"`
}

// CertificateAuthorityFindResult represents the Result of API
type CertificateAuthorityFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	CertificateAuthorities []*CertificateAuthority `json:",omitempty" mapconv:"[]CommonServiceItems,omitempty,recursive"`
}

// Values returns find results
func (r *CertificateAuthorityFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.CertificateAuthorities {
		results = append(results, v)
	}
	return results
}

// certificateAuthorityCreateResult represents the Result of API
type certificateAuthorityCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	CertificateAuthority *CertificateAuthority `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// certificateAuthorityReadResult represents the Result of API
type certificateAuthorityReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	CertificateAuthority *CertificateAuthority `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// certificateAuthorityUpdateResult represents the Result of API
type certificateAuthorityUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	CertificateAuthority *CertificateAuthority `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// certificateAuthorityDetailResult represents the Result of API
type certificateAuthorityDetailResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	CertificateAuthority *CertificateAuthorityDetail `json:",omitempty" mapconv:"CertificateAuthority,omitempty,recursive"`
}

// certificateAuthorityAddClientResult represents the Result of API
type certificateAuthorityAddClientResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	CertificateAuthority *CertificateAuthorityAddClientOrServerResult `json:",omitempty" mapconv:"CertificateAuthority,omitempty,recursive"`
}

// CertificateAuthorityListClientsResult represents the Result of API
type CertificateAuthorityListClientsResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	CertificateAuthority []*CertificateAuthorityClient `json:",omitempty" mapconv:"[]CertificateAuthority,omitempty,recursive"`
}

// Values returns find results
func (r *CertificateAuthorityListClientsResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.CertificateAuthority {
		results = append(results, v)
	}
	return results
}

// certificateAuthorityReadClientResult represents the Result of API
type certificateAuthorityReadClientResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	CertificateAuthority *CertificateAuthorityClient `json:",omitempty" mapconv:"CertificateAuthority,omitempty,recursive"`
}

// certificateAuthorityAddServerResult represents the Result of API
type certificateAuthorityAddServerResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	CertificateAuthority *CertificateAuthorityAddClientOrServerResult `json:",omitempty" mapconv:"CertificateAuthority,omitempty,recursive"`
}

// CertificateAuthorityListServersResult represents the Result of API
type CertificateAuthorityListServersResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	CertificateAuthority []*CertificateAuthorityServer `json:",omitempty" mapconv:"[]CertificateAuthority,omitempty,recursive"`
}

// Values returns find results
func (r *CertificateAuthorityListServersResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.CertificateAuthority {
		results = append(results, v)
	}
	return results
}

// certificateAuthorityReadServerResult represents the Result of API
type certificateAuthorityReadServerResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	CertificateAuthority *CertificateAuthorityServer `json:",omitempty" mapconv:"CertificateAuthority,omitempty,recursive"`
}

// ContainerRegistryFindResult represents the Result of API
type ContainerRegistryFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	ContainerRegistries []*ContainerRegistry `json:",omitempty" mapconv:"[]CommonServiceItems,omitempty,recursive"`
}

// Values returns find results
func (r *ContainerRegistryFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.ContainerRegistries {
		results = append(results, v)
	}
	return results
}

// containerRegistryCreateResult represents the Result of API
type containerRegistryCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	ContainerRegistry *ContainerRegistry `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// containerRegistryReadResult represents the Result of API
type containerRegistryReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	ContainerRegistry *ContainerRegistry `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// containerRegistryUpdateResult represents the Result of API
type containerRegistryUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	ContainerRegistry *ContainerRegistry `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// containerRegistryUpdateSettingsResult represents the Result of API
type containerRegistryUpdateSettingsResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	ContainerRegistry *ContainerRegistry `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// containerRegistryListUsersResult represents the Result of API
type containerRegistryListUsersResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	ContainerRegistryUsers *ContainerRegistryUsers `json:",omitempty" mapconv:"ContainerRegistry,omitempty,recursive"`
}

// CouponFindResult represents the Result of API
type CouponFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	Coupons []*Coupon `json:",omitempty" mapconv:"[]Coupon,omitempty,recursive"`
}

// Values returns find results
func (r *CouponFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.Coupons {
		results = append(results, v)
	}
	return results
}

// DatabaseFindResult represents the Result of API
type DatabaseFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	Databases []*Database `json:",omitempty" mapconv:"[]Appliances,omitempty,recursive"`
}

// Values returns find results
func (r *DatabaseFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.Databases {
		results = append(results, v)
	}
	return results
}

// databaseCreateResult represents the Result of API
type databaseCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Database *Database `json:",omitempty" mapconv:"Appliance,omitempty,recursive"`
}

// databaseReadResult represents the Result of API
type databaseReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Database *Database `json:",omitempty" mapconv:"Appliance,omitempty,recursive"`
}

// databaseUpdateResult represents the Result of API
type databaseUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Database *Database `json:",omitempty" mapconv:"Appliance,omitempty,recursive"`
}

// databaseUpdateSettingsResult represents the Result of API
type databaseUpdateSettingsResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Database *Database `json:",omitempty" mapconv:"Appliance,omitempty,recursive"`
}

// databaseMonitorCPUResult represents the Result of API
type databaseMonitorCPUResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	CPUTimeActivity *CPUTimeActivity `json:",omitempty" mapconv:"Data,omitempty,recursive"`
}

// databaseMonitorDiskResult represents the Result of API
type databaseMonitorDiskResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	DiskActivity *DiskActivity `json:",omitempty" mapconv:"Data,omitempty,recursive"`
}

// databaseMonitorInterfaceResult represents the Result of API
type databaseMonitorInterfaceResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	InterfaceActivity *InterfaceActivity `json:",omitempty" mapconv:"Data,omitempty,recursive"`
}

// databaseMonitorDatabaseResult represents the Result of API
type databaseMonitorDatabaseResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	DatabaseActivity *DatabaseActivity `json:",omitempty" mapconv:"Data,omitempty,recursive"`
}

// databaseStatusResult represents the Result of API
type databaseStatusResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	DatabaseStatus *DatabaseStatus `json:",omitempty" mapconv:"Appliance,omitempty,recursive"`
}

// databaseGetParameterResult represents the Result of API
type databaseGetParameterResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	DatabaseParameter *DatabaseParameter `json:",omitempty" mapconv:"Database,omitempty,recursive"`
}

// DiskFindResult represents the Result of API
type DiskFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	Disks []*Disk `json:",omitempty" mapconv:"[]Disks,omitempty,recursive"`
}

// Values returns find results
func (r *DiskFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.Disks {
		results = append(results, v)
	}
	return results
}

// diskCreateResult represents the Result of API
type diskCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Disk *Disk `json:",omitempty" mapconv:"Disk,omitempty,recursive"`
}

// diskCreateWithConfigResult represents the Result of API
type diskCreateWithConfigResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Disk *Disk `json:",omitempty" mapconv:"Disk,omitempty,recursive"`
}

// diskReadResult represents the Result of API
type diskReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Disk *Disk `json:",omitempty" mapconv:"Disk,omitempty,recursive"`
}

// diskUpdateResult represents the Result of API
type diskUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Disk *Disk `json:",omitempty" mapconv:"Disk,omitempty,recursive"`
}

// diskMonitorResult represents the Result of API
type diskMonitorResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	DiskActivity *DiskActivity `json:",omitempty" mapconv:"Data,omitempty,recursive"`
}

// diskMonitorDiskResult represents the Result of API
type diskMonitorDiskResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	DiskActivity *DiskActivity `json:",omitempty" mapconv:"Data,omitempty,recursive"`
}

// DiskPlanFindResult represents the Result of API
type DiskPlanFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	DiskPlans []*DiskPlan `json:",omitempty" mapconv:"[]DiskPlans,omitempty,recursive"`
}

// Values returns find results
func (r *DiskPlanFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.DiskPlans {
		results = append(results, v)
	}
	return results
}

// diskPlanReadResult represents the Result of API
type diskPlanReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	DiskPlan *DiskPlan `json:",omitempty" mapconv:"DiskPlan,omitempty,recursive"`
}

// DNSFindResult represents the Result of API
type DNSFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	DNS []*DNS `json:",omitempty" mapconv:"[]CommonServiceItems,omitempty,recursive"`
}

// Values returns find results
func (r *DNSFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.DNS {
		results = append(results, v)
	}
	return results
}

// dNSCreateResult represents the Result of API
type dNSCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	DNS *DNS `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// dNSReadResult represents the Result of API
type dNSReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	DNS *DNS `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// dNSUpdateResult represents the Result of API
type dNSUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	DNS *DNS `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// dNSUpdateSettingsResult represents the Result of API
type dNSUpdateSettingsResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	DNS *DNS `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// EnhancedDBFindResult represents the Result of API
type EnhancedDBFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	EnhancedDBs []*EnhancedDB `json:",omitempty" mapconv:"[]CommonServiceItems,omitempty,recursive"`
}

// Values returns find results
func (r *EnhancedDBFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.EnhancedDBs {
		results = append(results, v)
	}
	return results
}

// enhancedDBCreateResult represents the Result of API
type enhancedDBCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	EnhancedDB *EnhancedDB `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// enhancedDBReadResult represents the Result of API
type enhancedDBReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	EnhancedDB *EnhancedDB `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// enhancedDBUpdateResult represents the Result of API
type enhancedDBUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	EnhancedDB *EnhancedDB `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// enhancedDBGetConfigResult represents the Result of API
type enhancedDBGetConfigResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	EnhancedDBConfig *EnhancedDBConfig `json:",omitempty" mapconv:"EnhancedDB,omitempty,recursive"`
}

// ESMEFindResult represents the Result of API
type ESMEFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	ESME []*ESME `json:",omitempty" mapconv:"[]CommonServiceItems,omitempty,recursive"`
}

// Values returns find results
func (r *ESMEFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.ESME {
		results = append(results, v)
	}
	return results
}

// eSMECreateResult represents the Result of API
type eSMECreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	ESME *ESME `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// eSMEReadResult represents the Result of API
type eSMEReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	ESME *ESME `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// eSMEUpdateResult represents the Result of API
type eSMEUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	ESME *ESME `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// eSMESendMessageWithGeneratedOTPResult represents the Result of API
type eSMESendMessageWithGeneratedOTPResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	ESMESendMessageResult *ESMESendMessageResult `json:",omitempty" mapconv:"ESME,omitempty,recursive"`
}

// eSMESendMessageWithInputtedOTPResult represents the Result of API
type eSMESendMessageWithInputtedOTPResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	ESMESendMessageResult *ESMESendMessageResult `json:",omitempty" mapconv:"ESME,omitempty,recursive"`
}

// eSMELogsResult represents the Result of API
type eSMELogsResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Logs []*ESMELogs `json:",omitempty" mapconv:"[]ESME.Logs,omitempty,recursive"`
}

// GSLBFindResult represents the Result of API
type GSLBFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	GSLBs []*GSLB `json:",omitempty" mapconv:"[]CommonServiceItems,omitempty,recursive"`
}

// Values returns find results
func (r *GSLBFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.GSLBs {
		results = append(results, v)
	}
	return results
}

// gSLBCreateResult represents the Result of API
type gSLBCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	GSLB *GSLB `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// gSLBReadResult represents the Result of API
type gSLBReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	GSLB *GSLB `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// gSLBUpdateResult represents the Result of API
type gSLBUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	GSLB *GSLB `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// gSLBUpdateSettingsResult represents the Result of API
type gSLBUpdateSettingsResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	GSLB *GSLB `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// IconFindResult represents the Result of API
type IconFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	Icons []*Icon `json:",omitempty" mapconv:"[]Icons,omitempty,recursive"`
}

// Values returns find results
func (r *IconFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.Icons {
		results = append(results, v)
	}
	return results
}

// iconCreateResult represents the Result of API
type iconCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Icon *Icon `json:",omitempty" mapconv:"Icon,omitempty,recursive"`
}

// iconReadResult represents the Result of API
type iconReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Icon *Icon `json:",omitempty" mapconv:"Icon,omitempty,recursive"`
}

// iconUpdateResult represents the Result of API
type iconUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Icon *Icon `json:",omitempty" mapconv:"Icon,omitempty,recursive"`
}

// InterfaceFindResult represents the Result of API
type InterfaceFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	Interfaces []*Interface `json:",omitempty" mapconv:"[]Interfaces,omitempty,recursive"`
}

// Values returns find results
func (r *InterfaceFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.Interfaces {
		results = append(results, v)
	}
	return results
}

// interfaceCreateResult represents the Result of API
type interfaceCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Interface *Interface `json:",omitempty" mapconv:"Interface,omitempty,recursive"`
}

// interfaceReadResult represents the Result of API
type interfaceReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Interface *Interface `json:",omitempty" mapconv:"Interface,omitempty,recursive"`
}

// interfaceUpdateResult represents the Result of API
type interfaceUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Interface *Interface `json:",omitempty" mapconv:"Interface,omitempty,recursive"`
}

// interfaceMonitorResult represents the Result of API
type interfaceMonitorResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	InterfaceActivity *InterfaceActivity `json:",omitempty" mapconv:"Data,omitempty,recursive"`
}

// InternetFindResult represents the Result of API
type InternetFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	Internet []*Internet `json:",omitempty" mapconv:"[]Internet,omitempty,recursive"`
}

// Values returns find results
func (r *InternetFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.Internet {
		results = append(results, v)
	}
	return results
}

// internetCreateResult represents the Result of API
type internetCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Internet *Internet `json:",omitempty" mapconv:"Internet,omitempty,recursive"`
}

// internetReadResult represents the Result of API
type internetReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Internet *Internet `json:",omitempty" mapconv:"Internet,omitempty,recursive"`
}

// internetUpdateResult represents the Result of API
type internetUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Internet *Internet `json:",omitempty" mapconv:"Internet,omitempty,recursive"`
}

// internetUpdateBandWidthResult represents the Result of API
type internetUpdateBandWidthResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Internet *Internet `json:",omitempty" mapconv:"Internet,omitempty,recursive"`
}

// internetAddSubnetResult represents the Result of API
type internetAddSubnetResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Subnet *InternetSubnetOperationResult `json:",omitempty" mapconv:"Subnet,omitempty,recursive"`
}

// internetUpdateSubnetResult represents the Result of API
type internetUpdateSubnetResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Subnet *InternetSubnetOperationResult `json:",omitempty" mapconv:"Subnet,omitempty,recursive"`
}

// internetMonitorResult represents the Result of API
type internetMonitorResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	RouterActivity *RouterActivity `json:",omitempty" mapconv:"Data,omitempty,recursive"`
}

// internetMonitorRouterResult represents the Result of API
type internetMonitorRouterResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	RouterActivity *RouterActivity `json:",omitempty" mapconv:"Data,omitempty,recursive"`
}

// internetEnableIPv6Result represents the Result of API
type internetEnableIPv6Result struct {
	IsOk bool `json:",omitempty"` // is_ok

	IPv6Net *IPv6NetInfo `json:",omitempty" mapconv:"IPv6Net,omitempty,recursive"`
}

// InternetPlanFindResult represents the Result of API
type InternetPlanFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	InternetPlans []*InternetPlan `json:",omitempty" mapconv:"[]InternetPlans,omitempty,recursive"`
}

// Values returns find results
func (r *InternetPlanFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.InternetPlans {
		results = append(results, v)
	}
	return results
}

// internetPlanReadResult represents the Result of API
type internetPlanReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	InternetPlan *InternetPlan `json:",omitempty" mapconv:"InternetPlan,omitempty,recursive"`
}

// IPAddressListResult represents the Result of API
type IPAddressListResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	IPAddress []*IPAddress `json:",omitempty" mapconv:"[]IPAddress,omitempty,recursive"`
}

// Values returns find results
func (r *IPAddressListResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.IPAddress {
		results = append(results, v)
	}
	return results
}

// iPAddressReadResult represents the Result of API
type iPAddressReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	IPAddress *IPAddress `json:",omitempty" mapconv:"IPAddress,omitempty,recursive"`
}

// iPAddressUpdateHostNameResult represents the Result of API
type iPAddressUpdateHostNameResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	IPAddress *IPAddress `json:",omitempty" mapconv:"IPAddress,omitempty,recursive"`
}

// IPv6NetListResult represents the Result of API
type IPv6NetListResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	IPv6Nets []*IPv6Net `json:",omitempty" mapconv:"[]IPv6Nets,omitempty,recursive"`
}

// Values returns find results
func (r *IPv6NetListResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.IPv6Nets {
		results = append(results, v)
	}
	return results
}

// IPv6NetFindResult represents the Result of API
type IPv6NetFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	IPv6Nets []*IPv6Net `json:",omitempty" mapconv:"[]IPv6Nets,omitempty,recursive"`
}

// Values returns find results
func (r *IPv6NetFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.IPv6Nets {
		results = append(results, v)
	}
	return results
}

// iPv6NetReadResult represents the Result of API
type iPv6NetReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	IPv6Net *IPv6Net `json:",omitempty" mapconv:"IPv6Net,omitempty,recursive"`
}

// IPv6AddrFindResult represents the Result of API
type IPv6AddrFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	IPv6Addrs []*IPv6Addr `json:",omitempty" mapconv:"[]IPv6Addrs,omitempty,recursive"`
}

// Values returns find results
func (r *IPv6AddrFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.IPv6Addrs {
		results = append(results, v)
	}
	return results
}

// iPv6AddrCreateResult represents the Result of API
type iPv6AddrCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	IPv6Addr *IPv6Addr `json:",omitempty" mapconv:"IPv6Addr,omitempty,recursive"`
}

// iPv6AddrReadResult represents the Result of API
type iPv6AddrReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	IPv6Addr *IPv6Addr `json:",omitempty" mapconv:"IPv6Addr,omitempty,recursive"`
}

// iPv6AddrUpdateResult represents the Result of API
type iPv6AddrUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	IPv6Addr *IPv6Addr `json:",omitempty" mapconv:"IPv6Addr,omitempty,recursive"`
}

// LicenseFindResult represents the Result of API
type LicenseFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	Licenses []*License `json:",omitempty" mapconv:"[]Licenses,omitempty,recursive"`
}

// Values returns find results
func (r *LicenseFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.Licenses {
		results = append(results, v)
	}
	return results
}

// licenseCreateResult represents the Result of API
type licenseCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	License *License `json:",omitempty" mapconv:"License,omitempty,recursive"`
}

// licenseReadResult represents the Result of API
type licenseReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	License *License `json:",omitempty" mapconv:"License,omitempty,recursive"`
}

// licenseUpdateResult represents the Result of API
type licenseUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	License *License `json:",omitempty" mapconv:"License,omitempty,recursive"`
}

// LicenseInfoFindResult represents the Result of API
type LicenseInfoFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	LicenseInfo []*LicenseInfo `json:",omitempty" mapconv:"[]LicenseInfo,omitempty,recursive"`
}

// Values returns find results
func (r *LicenseInfoFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.LicenseInfo {
		results = append(results, v)
	}
	return results
}

// licenseInfoReadResult represents the Result of API
type licenseInfoReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	LicenseInfo *LicenseInfo `json:",omitempty" mapconv:"LicenseInfo,omitempty,recursive"`
}

// LoadBalancerFindResult represents the Result of API
type LoadBalancerFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	LoadBalancers []*LoadBalancer `json:",omitempty" mapconv:"[]Appliances,omitempty,recursive"`
}

// Values returns find results
func (r *LoadBalancerFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.LoadBalancers {
		results = append(results, v)
	}
	return results
}

// loadBalancerCreateResult represents the Result of API
type loadBalancerCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	LoadBalancer *LoadBalancer `json:",omitempty" mapconv:"Appliance,omitempty,recursive"`
}

// loadBalancerReadResult represents the Result of API
type loadBalancerReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	LoadBalancer *LoadBalancer `json:",omitempty" mapconv:"Appliance,omitempty,recursive"`
}

// loadBalancerUpdateResult represents the Result of API
type loadBalancerUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	LoadBalancer *LoadBalancer `json:",omitempty" mapconv:"Appliance,omitempty,recursive"`
}

// loadBalancerUpdateSettingsResult represents the Result of API
type loadBalancerUpdateSettingsResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	LoadBalancer *LoadBalancer `json:",omitempty" mapconv:"Appliance,omitempty,recursive"`
}

// loadBalancerMonitorCPUResult represents the Result of API
type loadBalancerMonitorCPUResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	CPUTimeActivity *CPUTimeActivity `json:",omitempty" mapconv:"Data,omitempty,recursive"`
}

// loadBalancerMonitorInterfaceResult represents the Result of API
type loadBalancerMonitorInterfaceResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	InterfaceActivity *InterfaceActivity `json:",omitempty" mapconv:"Data,omitempty,recursive"`
}

// LoadBalancerStatusResult represents the Result of API
type LoadBalancerStatusResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	Status []*LoadBalancerStatus `json:",omitempty" mapconv:"[]LoadBalancer,omitempty,recursive"`
}

// Values returns find results
func (r *LoadBalancerStatusResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.Status {
		results = append(results, v)
	}
	return results
}

// LocalRouterFindResult represents the Result of API
type LocalRouterFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	LocalRouters []*LocalRouter `json:",omitempty" mapconv:"[]CommonServiceItems,omitempty,recursive"`
}

// Values returns find results
func (r *LocalRouterFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.LocalRouters {
		results = append(results, v)
	}
	return results
}

// localRouterCreateResult represents the Result of API
type localRouterCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	LocalRouter *LocalRouter `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// localRouterReadResult represents the Result of API
type localRouterReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	LocalRouter *LocalRouter `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// localRouterUpdateResult represents the Result of API
type localRouterUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	LocalRouter *LocalRouter `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// localRouterUpdateSettingsResult represents the Result of API
type localRouterUpdateSettingsResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	LocalRouter *LocalRouter `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// localRouterHealthStatusResult represents the Result of API
type localRouterHealthStatusResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	LocalRouterHealth *LocalRouterHealth `json:",omitempty" mapconv:"LocalRouter,omitempty,recursive"`
}

// localRouterMonitorLocalRouterResult represents the Result of API
type localRouterMonitorLocalRouterResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	LocalRouterActivity *LocalRouterActivity `json:",omitempty" mapconv:"Data,omitempty,recursive"`
}

// MobileGatewayFindResult represents the Result of API
type MobileGatewayFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	MobileGateways []*MobileGateway `json:",omitempty" mapconv:"[]Appliances,omitempty,recursive"`
}

// Values returns find results
func (r *MobileGatewayFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.MobileGateways {
		results = append(results, v)
	}
	return results
}

// mobileGatewayCreateResult represents the Result of API
type mobileGatewayCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	MobileGateway *MobileGateway `json:",omitempty" mapconv:"Appliance,omitempty,recursive"`
}

// mobileGatewayReadResult represents the Result of API
type mobileGatewayReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	MobileGateway *MobileGateway `json:",omitempty" mapconv:"Appliance,omitempty,recursive"`
}

// mobileGatewayUpdateResult represents the Result of API
type mobileGatewayUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	MobileGateway *MobileGateway `json:",omitempty" mapconv:"Appliance,omitempty,recursive"`
}

// mobileGatewayUpdateSettingsResult represents the Result of API
type mobileGatewayUpdateSettingsResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	MobileGateway *MobileGateway `json:",omitempty" mapconv:"Appliance,omitempty,recursive"`
}

// mobileGatewayGetDNSResult represents the Result of API
type mobileGatewayGetDNSResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	SIMGroup *MobileGatewayDNSSetting `json:",omitempty" mapconv:"SIMGroup,omitempty,recursive"`
}

// mobileGatewayGetSIMRoutesResult represents the Result of API
type mobileGatewayGetSIMRoutesResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	SIMRoutes MobileGatewaySIMRoutes `json:",omitempty" mapconv:"[]SIMRoutes,omitempty,recursive"`
}

// mobileGatewayListSIMResult represents the Result of API
type mobileGatewayListSIMResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	SIM MobileGatewaySIMs `json:",omitempty" mapconv:"[]SIM,omitempty,recursive"`
}

// mobileGatewayLogsResult represents the Result of API
type mobileGatewayLogsResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Logs []*MobileGatewaySIMLogs `json:",omitempty" mapconv:"[]Logs,omitempty,recursive"`
}

// mobileGatewayGetTrafficConfigResult represents the Result of API
type mobileGatewayGetTrafficConfigResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	TrafficMonitoring *MobileGatewayTrafficControl `json:",omitempty" mapconv:"TrafficMonitoring,omitempty,recursive"`
}

// mobileGatewayTrafficStatusResult represents the Result of API
type mobileGatewayTrafficStatusResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	TrafficStatus *MobileGatewayTrafficStatus `json:",omitempty" mapconv:"TrafficStatus,omitempty,recursive"`
}

// mobileGatewayMonitorInterfaceResult represents the Result of API
type mobileGatewayMonitorInterfaceResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	InterfaceActivity *InterfaceActivity `json:",omitempty" mapconv:"Data,omitempty,recursive"`
}

// NFSFindResult represents the Result of API
type NFSFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	NFS []*NFS `json:",omitempty" mapconv:"[]Appliances,omitempty,recursive"`
}

// Values returns find results
func (r *NFSFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.NFS {
		results = append(results, v)
	}
	return results
}

// nFSCreateResult represents the Result of API
type nFSCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	NFS *NFS `json:",omitempty" mapconv:"Appliance,omitempty,recursive"`
}

// nFSReadResult represents the Result of API
type nFSReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	NFS *NFS `json:",omitempty" mapconv:"Appliance,omitempty,recursive"`
}

// nFSUpdateResult represents the Result of API
type nFSUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	NFS *NFS `json:",omitempty" mapconv:"Appliance,omitempty,recursive"`
}

// nFSMonitorCPUResult represents the Result of API
type nFSMonitorCPUResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	CPUTimeActivity *CPUTimeActivity `json:",omitempty" mapconv:"Data,omitempty,recursive"`
}

// nFSMonitorFreeDiskSizeResult represents the Result of API
type nFSMonitorFreeDiskSizeResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	FreeDiskSizeActivity *FreeDiskSizeActivity `json:",omitempty" mapconv:"Data,omitempty,recursive"`
}

// nFSMonitorInterfaceResult represents the Result of API
type nFSMonitorInterfaceResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	InterfaceActivity *InterfaceActivity `json:",omitempty" mapconv:"Data,omitempty,recursive"`
}

// NoteFindResult represents the Result of API
type NoteFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	Notes []*Note `json:",omitempty" mapconv:"[]Notes,omitempty,recursive"`
}

// Values returns find results
func (r *NoteFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.Notes {
		results = append(results, v)
	}
	return results
}

// noteCreateResult represents the Result of API
type noteCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Note *Note `json:",omitempty" mapconv:"Note,omitempty,recursive"`
}

// noteReadResult represents the Result of API
type noteReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Note *Note `json:",omitempty" mapconv:"Note,omitempty,recursive"`
}

// noteUpdateResult represents the Result of API
type noteUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Note *Note `json:",omitempty" mapconv:"Note,omitempty,recursive"`
}

// PacketFilterFindResult represents the Result of API
type PacketFilterFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	PacketFilters []*PacketFilter `json:",omitempty" mapconv:"[]PacketFilters,omitempty,recursive"`
}

// Values returns find results
func (r *PacketFilterFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.PacketFilters {
		results = append(results, v)
	}
	return results
}

// packetFilterCreateResult represents the Result of API
type packetFilterCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	PacketFilter *PacketFilter `json:",omitempty" mapconv:"PacketFilter,omitempty,recursive"`
}

// packetFilterReadResult represents the Result of API
type packetFilterReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	PacketFilter *PacketFilter `json:",omitempty" mapconv:"PacketFilter,omitempty,recursive"`
}

// packetFilterUpdateResult represents the Result of API
type packetFilterUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	PacketFilter *PacketFilter `json:",omitempty" mapconv:"PacketFilter,omitempty,recursive"`
}

// PrivateHostFindResult represents the Result of API
type PrivateHostFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	PrivateHosts []*PrivateHost `json:",omitempty" mapconv:"[]PrivateHosts,omitempty,recursive"`
}

// Values returns find results
func (r *PrivateHostFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.PrivateHosts {
		results = append(results, v)
	}
	return results
}

// privateHostCreateResult represents the Result of API
type privateHostCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	PrivateHost *PrivateHost `json:",omitempty" mapconv:"PrivateHost,omitempty,recursive"`
}

// privateHostReadResult represents the Result of API
type privateHostReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	PrivateHost *PrivateHost `json:",omitempty" mapconv:"PrivateHost,omitempty,recursive"`
}

// privateHostUpdateResult represents the Result of API
type privateHostUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	PrivateHost *PrivateHost `json:",omitempty" mapconv:"PrivateHost,omitempty,recursive"`
}

// PrivateHostPlanFindResult represents the Result of API
type PrivateHostPlanFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	PrivateHostPlans []*PrivateHostPlan `json:",omitempty" mapconv:"[]PrivateHostPlans,omitempty,recursive"`
}

// Values returns find results
func (r *PrivateHostPlanFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.PrivateHostPlans {
		results = append(results, v)
	}
	return results
}

// privateHostPlanReadResult represents the Result of API
type privateHostPlanReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	PrivateHostPlan *PrivateHostPlan `json:",omitempty" mapconv:"PrivateHostPlan,omitempty,recursive"`
}

// ProxyLBFindResult represents the Result of API
type ProxyLBFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	ProxyLBs []*ProxyLB `json:",omitempty" mapconv:"[]CommonServiceItems,omitempty,recursive"`
}

// Values returns find results
func (r *ProxyLBFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.ProxyLBs {
		results = append(results, v)
	}
	return results
}

// proxyLBCreateResult represents the Result of API
type proxyLBCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	ProxyLB *ProxyLB `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// proxyLBReadResult represents the Result of API
type proxyLBReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	ProxyLB *ProxyLB `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// proxyLBUpdateResult represents the Result of API
type proxyLBUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	ProxyLB *ProxyLB `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// proxyLBUpdateSettingsResult represents the Result of API
type proxyLBUpdateSettingsResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	ProxyLB *ProxyLB `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// proxyLBChangePlanResult represents the Result of API
type proxyLBChangePlanResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	ProxyLB *ProxyLB `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// proxyLBGetCertificatesResult represents the Result of API
type proxyLBGetCertificatesResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	ProxyLBCertificates *ProxyLBCertificates `json:",omitempty" mapconv:"ProxyLB,omitempty,recursive"`
}

// proxyLBSetCertificatesResult represents the Result of API
type proxyLBSetCertificatesResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	ProxyLBCertificates *ProxyLBCertificates `json:",omitempty" mapconv:"ProxyLB,omitempty,recursive"`
}

// proxyLBHealthStatusResult represents the Result of API
type proxyLBHealthStatusResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	ProxyLBHealth *ProxyLBHealth `json:",omitempty" mapconv:"ProxyLB,omitempty,recursive"`
}

// proxyLBMonitorConnectionResult represents the Result of API
type proxyLBMonitorConnectionResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	ConnectionActivity *ConnectionActivity `json:",omitempty" mapconv:"Data,omitempty,recursive"`
}

// RegionFindResult represents the Result of API
type RegionFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	Regions []*Region `json:",omitempty" mapconv:"[]Regions,omitempty,recursive"`
}

// Values returns find results
func (r *RegionFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.Regions {
		results = append(results, v)
	}
	return results
}

// regionReadResult represents the Result of API
type regionReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Region *Region `json:",omitempty" mapconv:"Region,omitempty,recursive"`
}

// ServerFindResult represents the Result of API
type ServerFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	Servers []*Server `json:",omitempty" mapconv:"[]Servers,omitempty,recursive"`
}

// Values returns find results
func (r *ServerFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.Servers {
		results = append(results, v)
	}
	return results
}

// serverCreateResult represents the Result of API
type serverCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Server *Server `json:",omitempty" mapconv:"Server,omitempty,recursive"`
}

// serverReadResult represents the Result of API
type serverReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Server *Server `json:",omitempty" mapconv:"Server,omitempty,recursive"`
}

// serverUpdateResult represents the Result of API
type serverUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Server *Server `json:",omitempty" mapconv:"Server,omitempty,recursive"`
}

// serverChangePlanResult represents the Result of API
type serverChangePlanResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Server *Server `json:",omitempty" mapconv:"Server,omitempty,recursive"`
}

// serverGetVNCProxyResult represents the Result of API
type serverGetVNCProxyResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	VNCProxyInfo *VNCProxyInfo `json:",omitempty" mapconv:"VNCProxyInfo,omitempty,recursive"`
}

// serverMonitorResult represents the Result of API
type serverMonitorResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	CPUTimeActivity *CPUTimeActivity `json:",omitempty" mapconv:"Data,omitempty,recursive"`
}

// serverMonitorCPUResult represents the Result of API
type serverMonitorCPUResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	CPUTimeActivity *CPUTimeActivity `json:",omitempty" mapconv:"Data,omitempty,recursive"`
}

// ServerPlanFindResult represents the Result of API
type ServerPlanFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	ServerPlans []*ServerPlan `json:",omitempty" mapconv:"[]ServerPlans,omitempty,recursive"`
}

// Values returns find results
func (r *ServerPlanFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.ServerPlans {
		results = append(results, v)
	}
	return results
}

// serverPlanReadResult represents the Result of API
type serverPlanReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	ServerPlan *ServerPlan `json:",omitempty" mapconv:"ServerPlan,omitempty,recursive"`
}

// ServiceClassFindResult represents the Result of API
type ServiceClassFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	ServiceClasses []*ServiceClass `json:",omitempty" mapconv:"[]ServiceClasses,omitempty,recursive"`
}

// Values returns find results
func (r *ServiceClassFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.ServiceClasses {
		results = append(results, v)
	}
	return results
}

// SIMFindResult represents the Result of API
type SIMFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	SIMs []*SIM `json:",omitempty" mapconv:"[]CommonServiceItems,omitempty,recursive"`
}

// Values returns find results
func (r *SIMFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.SIMs {
		results = append(results, v)
	}
	return results
}

// sIMCreateResult represents the Result of API
type sIMCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	SIM *SIM `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// sIMReadResult represents the Result of API
type sIMReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	SIM *SIM `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// sIMUpdateResult represents the Result of API
type sIMUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	SIM *SIM `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// SIMLogsResult represents the Result of API
type SIMLogsResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	Logs []*SIMLog `json:",omitempty" mapconv:"[]Logs,omitempty,recursive"`
}

// Values returns find results
func (r *SIMLogsResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.Logs {
		results = append(results, v)
	}
	return results
}

// sIMGetNetworkOperatorResult represents the Result of API
type sIMGetNetworkOperatorResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Configs []*SIMNetworkOperatorConfig `json:",omitempty" mapconv:"[]NetworkOperationConfigs,omitempty,recursive"`
}

// sIMMonitorSIMResult represents the Result of API
type sIMMonitorSIMResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	LinkActivity *LinkActivity `json:",omitempty" mapconv:"Data,omitempty,recursive"`
}

// sIMStatusResult represents the Result of API
type sIMStatusResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	SIM *SIMInfo `json:",omitempty" mapconv:"SIM,omitempty,recursive"`
}

// SimpleMonitorFindResult represents the Result of API
type SimpleMonitorFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	SimpleMonitors []*SimpleMonitor `json:",omitempty" mapconv:"[]CommonServiceItems,omitempty,recursive"`
}

// Values returns find results
func (r *SimpleMonitorFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.SimpleMonitors {
		results = append(results, v)
	}
	return results
}

// simpleMonitorCreateResult represents the Result of API
type simpleMonitorCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	SimpleMonitor *SimpleMonitor `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// simpleMonitorReadResult represents the Result of API
type simpleMonitorReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	SimpleMonitor *SimpleMonitor `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// simpleMonitorUpdateResult represents the Result of API
type simpleMonitorUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	SimpleMonitor *SimpleMonitor `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// simpleMonitorUpdateSettingsResult represents the Result of API
type simpleMonitorUpdateSettingsResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	SimpleMonitor *SimpleMonitor `json:",omitempty" mapconv:"CommonServiceItem,omitempty,recursive"`
}

// simpleMonitorMonitorResponseTimeResult represents the Result of API
type simpleMonitorMonitorResponseTimeResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	ResponseTimeSecActivity *ResponseTimeSecActivity `json:",omitempty" mapconv:"Data,omitempty,recursive"`
}

// simpleMonitorHealthStatusResult represents the Result of API
type simpleMonitorHealthStatusResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	SimpleMonitorHealthStatus *SimpleMonitorHealthStatus `json:",omitempty" mapconv:"SimpleMonitor,omitempty,recursive"`
}

// SSHKeyFindResult represents the Result of API
type SSHKeyFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	SSHKeys []*SSHKey `json:",omitempty" mapconv:"[]SSHKeys,omitempty,recursive"`
}

// Values returns find results
func (r *SSHKeyFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.SSHKeys {
		results = append(results, v)
	}
	return results
}

// sSHKeyCreateResult represents the Result of API
type sSHKeyCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	SSHKey *SSHKey `json:",omitempty" mapconv:"SSHKey,omitempty,recursive"`
}

// sSHKeyGenerateResult represents the Result of API
type sSHKeyGenerateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	SSHKeyGenerated *SSHKeyGenerated `json:",omitempty" mapconv:"SSHKey,omitempty,recursive"`
}

// sSHKeyReadResult represents the Result of API
type sSHKeyReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	SSHKey *SSHKey `json:",omitempty" mapconv:"SSHKey,omitempty,recursive"`
}

// sSHKeyUpdateResult represents the Result of API
type sSHKeyUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	SSHKey *SSHKey `json:",omitempty" mapconv:"SSHKey,omitempty,recursive"`
}

// SubnetFindResult represents the Result of API
type SubnetFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	Subnets []*Subnet `json:",omitempty" mapconv:"[]Subnets,omitempty,recursive"`
}

// Values returns find results
func (r *SubnetFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.Subnets {
		results = append(results, v)
	}
	return results
}

// subnetReadResult represents the Result of API
type subnetReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Subnet *Subnet `json:",omitempty" mapconv:"Subnet,omitempty,recursive"`
}

// SwitchFindResult represents the Result of API
type SwitchFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	Switches []*Switch `json:",omitempty" mapconv:"[]Switches,omitempty,recursive"`
}

// Values returns find results
func (r *SwitchFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.Switches {
		results = append(results, v)
	}
	return results
}

// switchCreateResult represents the Result of API
type switchCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Switch *Switch `json:",omitempty" mapconv:"Switch,omitempty,recursive"`
}

// switchReadResult represents the Result of API
type switchReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Switch *Switch `json:",omitempty" mapconv:"Switch,omitempty,recursive"`
}

// switchUpdateResult represents the Result of API
type switchUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Switch *Switch `json:",omitempty" mapconv:"Switch,omitempty,recursive"`
}

// SwitchGetServersResult represents the Result of API
type SwitchGetServersResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	Servers []*Server `json:",omitempty" mapconv:"[]Servers,omitempty,recursive"`
}

// Values returns find results
func (r *SwitchGetServersResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.Servers {
		results = append(results, v)
	}
	return results
}

// VPCRouterFindResult represents the Result of API
type VPCRouterFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	VPCRouters []*VPCRouter `json:",omitempty" mapconv:"[]Appliances,omitempty,recursive"`
}

// Values returns find results
func (r *VPCRouterFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.VPCRouters {
		results = append(results, v)
	}
	return results
}

// vPCRouterCreateResult represents the Result of API
type vPCRouterCreateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	VPCRouter *VPCRouter `json:",omitempty" mapconv:"Appliance,omitempty,recursive"`
}

// vPCRouterReadResult represents the Result of API
type vPCRouterReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	VPCRouter *VPCRouter `json:",omitempty" mapconv:"Appliance,omitempty,recursive"`
}

// vPCRouterUpdateResult represents the Result of API
type vPCRouterUpdateResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	VPCRouter *VPCRouter `json:",omitempty" mapconv:"Appliance,omitempty,recursive"`
}

// vPCRouterUpdateSettingsResult represents the Result of API
type vPCRouterUpdateSettingsResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	VPCRouter *VPCRouter `json:",omitempty" mapconv:"Appliance,omitempty,recursive"`
}

// vPCRouterMonitorCPUResult represents the Result of API
type vPCRouterMonitorCPUResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	CPUTimeActivity *CPUTimeActivity `json:",omitempty" mapconv:"Data,omitempty,recursive"`
}

// vPCRouterMonitorInterfaceResult represents the Result of API
type vPCRouterMonitorInterfaceResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	InterfaceActivity *InterfaceActivity `json:",omitempty" mapconv:"Data,omitempty,recursive"`
}

// vPCRouterStatusResult represents the Result of API
type vPCRouterStatusResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	VPCRouterStatus *VPCRouterStatus `json:",omitempty" mapconv:"Router,omitempty,recursive"`
}

// vPCRouterLogsResult represents the Result of API
type vPCRouterLogsResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	VPCRouterLog *VPCRouterLog `json:",omitempty" mapconv:"VPCRouter,omitempty,recursive"`
}

// vPCRouterPingResult represents the Result of API
type vPCRouterPingResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	VPCRouterPingResults *VPCRouterPingResults `json:",omitempty" mapconv:"VPCRouter,omitempty,recursive"`
}

// ZoneFindResult represents the Result of API
type ZoneFindResult struct {
	Total int `json:",omitempty"` // Total count of target resources
	From  int `json:",omitempty"` // Current page number
	Count int `json:",omitempty"` // Count of current page

	Zones []*Zone `json:",omitempty" mapconv:"[]Zones,omitempty,recursive"`
}

// Values returns find results
func (r *ZoneFindResult) Values() []interface{} {
	var results []interface{}
	for _, v := range r.Zones {
		results = append(results, v)
	}
	return results
}

// zoneReadResult represents the Result of API
type zoneReadResult struct {
	IsOk bool `json:",omitempty"` // is_ok

	Zone *Zone `json:",omitempty" mapconv:"Zone,omitempty,recursive"`
}
