// Copyright 2022-2023 The sacloud/iaas-api-go Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// generated by 'github.com/sacloud/iaas-api-go/internal/tools/gen-api-fake-data'; DO NOT EDIT

package fake

import (
	"github.com/sacloud/iaas-api-go"
	"github.com/sacloud/iaas-api-go/types"
)

var initArchives = map[string][]*iaas.Archive{
	"is1a": {
		{
			ID:                   types.ID(113201991639),
			Name:                 "CentOS Stream 8 (20201203) 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "distro-centos", "distro-ver-8-stream", "os-linux"},
			DisplayOrder:         100140509010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113201991639),
			Name:                 "CentOS Stream 8 (20201203) 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "distro-centos", "distro-ver-8-stream", "os-linux"},
			DisplayOrder:         100140509010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113202013807),
			Name:                 "CentOS 7.9 (2009) 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "centos-7-latest", "distro-centos", "distro-ver-7.9", "os-linux"},
			DisplayOrder:         100140709011,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113300996998),
			Name:                 "AlmaLinux 8.4 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "alma-8-latest", "arch-64bit", "centos-alternative-8", "current-stable", "distro-alma", "distro-ver-8.4", "os-linux"},
			DisplayOrder:         100240504010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113302037929),
			Name:                 "Rocky Linux 8.5",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "centos-alternative-8", "current-stable", "distro-rocky", "distro-ver-8.5", "os-linux", "rocky-8-latest"},
			DisplayOrder:         100241505010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301758831),
			Name:                 "Miracle Linux 8.4 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "centos-alternative-8", "current-stable", "distro-miracle", "distro-ver-8.4", "miracle-8-latest", "os-linux"},
			DisplayOrder:         100240501010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113400863432),
			Name:                 "Ubuntu Server 22.04 LTS 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "distro-ubuntu", "distro-ver-22.04", "os-linux", "ubuntu-22.04-latest"},
			DisplayOrder:         100442204010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113400863432),
			Name:                 "Ubuntu Server 22.04 LTS 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "distro-ubuntu", "distro-ver-22.04", "os-linux", "ubuntu-22.04-latest"},
			DisplayOrder:         100442204010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113201375319),
			Name:                 "Ubuntu Server 20.04.1 LTS 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "distro-ubuntu", "distro-ver-20.04.1", "os-linux", "ubuntu-20.04-latest"},
			DisplayOrder:         100442004110,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113201587117),
			Name:                 "Ubuntu Server 18.04.5 LTS 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "distro-ubuntu", "distro-ver-18.04.5", "os-linux", "ubuntu-18.04-latest"},
			DisplayOrder:         100441804510,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301863328),
			Name:                 "Debian GNU/Linux 11.1.0 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "debian-11-latest", "distro-debian", "distro-ver-11.1.0", "os-linux"},
			DisplayOrder:         100541101010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113201056524),
			Name:                 "Debian GNU/Linux 10.4.0 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "debian-10-latest", "distro-debian", "distro-ver-10.4.0", "os-linux"},
			DisplayOrder:         100541040010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301647121),
			Name:                 "Debian GNU/Linux 11.0.0 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "debian-11-latest", "distro-debian", "distro-ver-11.0.0", "os-linux"},
			DisplayOrder:         100541100010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113101599669),
			Name:                 "RancherOS v1.5.4 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@require-memory-gib>=2", "arch-64bit", "current-stable", "distro-rancheros", "distro-ver-1.5.4", "os-linux"},
			DisplayOrder:         200440154000,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113101835068),
			Name:                 "k3OS v0.5.0 amd64",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "distro-k3os", "distro-stable", "distro-ver-0.5.0", "os-linux"},
			DisplayOrder:         200490005000,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301417526),
			Name:                 "KUSANAGI 9.0",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "distro-ver-9.0", "os-linux", "pkg-kusanagi"},
			DisplayOrder:         310240000120,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
	},
	"is1b": {
		{
			ID:                   types.ID(113202012331),
			Name:                 "CentOS Stream 8 (20201203) 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "distro-centos", "distro-ver-8-stream", "os-linux"},
			DisplayOrder:         100140509010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113202012331),
			Name:                 "CentOS Stream 8 (20201203) 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "distro-centos", "distro-ver-8-stream", "os-linux"},
			DisplayOrder:         100140509010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113300112273),
			Name:                 "CentOS 7.9 (2009) 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "centos-7-latest", "distro-centos", "distro-ver-7.9", "os-linux"},
			DisplayOrder:         100140709011,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301078387),
			Name:                 "AlmaLinux 8.4 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "alma-8-latest", "arch-64bit", "centos-alternative-8", "current-stable", "distro-alma", "distro-ver-8.4", "os-linux"},
			DisplayOrder:         100240504010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113302064483),
			Name:                 "Rocky Linux 8.5",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "centos-alternative-8", "current-stable", "distro-rocky", "distro-ver-8.5", "os-linux", "rocky-8-latest"},
			DisplayOrder:         100241505010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301801349),
			Name:                 "Miracle Linux 8.4 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "centos-alternative-8", "current-stable", "distro-miracle", "distro-ver-8.4", "miracle-8-latest", "os-linux"},
			DisplayOrder:         100240501010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113400984159),
			Name:                 "Ubuntu Server 22.04 LTS 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "distro-ubuntu", "distro-ver-22.04", "os-linux", "ubuntu-22.04-latest"},
			DisplayOrder:         100442204010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113400984159),
			Name:                 "Ubuntu Server 22.04 LTS 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "distro-ubuntu", "distro-ver-22.04", "os-linux", "ubuntu-22.04-latest"},
			DisplayOrder:         100442204010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113201424329),
			Name:                 "Ubuntu Server 20.04.1 LTS 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "distro-ubuntu", "distro-ver-20.04.1", "os-linux", "ubuntu-20.04-latest"},
			DisplayOrder:         100442004110,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113201595227),
			Name:                 "Ubuntu Server 18.04.5 LTS 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "distro-ubuntu", "distro-ver-18.04.5", "os-linux", "ubuntu-18.04-latest"},
			DisplayOrder:         100441804510,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301924891),
			Name:                 "Debian GNU/Linux 11.1.0 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "debian-11-latest", "distro-debian", "distro-ver-11.1.0", "os-linux"},
			DisplayOrder:         100541101010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113201078539),
			Name:                 "Debian GNU/Linux 10.4.0 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "debian-10-latest", "distro-debian", "distro-ver-10.4.0", "os-linux"},
			DisplayOrder:         100541040010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301650930),
			Name:                 "Debian GNU/Linux 11.0.0 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "debian-11-latest", "distro-debian", "distro-ver-11.0.0", "os-linux"},
			DisplayOrder:         100541100010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113101599802),
			Name:                 "RancherOS v1.5.4 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@require-memory-gib>=2", "arch-64bit", "current-stable", "distro-rancheros", "distro-ver-1.5.4", "os-linux"},
			DisplayOrder:         200440154000,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113101835149),
			Name:                 "k3OS v0.5.0 amd64",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "distro-k3os", "distro-stable", "distro-ver-0.5.0", "os-linux"},
			DisplayOrder:         200490005000,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301758402),
			Name:                 "KUSANAGI 9.0",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "distro-ver-9.0", "os-linux", "pkg-kusanagi"},
			DisplayOrder:         310240000120,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
	},
	"tk1a": {
		{
			ID:                   types.ID(113202012325),
			Name:                 "CentOS Stream 8 (20201203) 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "distro-centos", "distro-ver-8-stream", "os-linux"},
			DisplayOrder:         100140509010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113202012325),
			Name:                 "CentOS Stream 8 (20201203) 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "distro-centos", "distro-ver-8-stream", "os-linux"},
			DisplayOrder:         100140509010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113300112270),
			Name:                 "CentOS 7.9 (2009) 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "centos-7-latest", "distro-centos", "distro-ver-7.9", "os-linux"},
			DisplayOrder:         100140709011,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301078385),
			Name:                 "AlmaLinux 8.4 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "alma-8-latest", "arch-64bit", "centos-alternative-8", "current-stable", "distro-alma", "distro-ver-8.4", "os-linux"},
			DisplayOrder:         100240504010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113302064486),
			Name:                 "Rocky Linux 8.5",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "centos-alternative-8", "current-stable", "distro-rocky", "distro-ver-8.5", "os-linux", "rocky-8-latest"},
			DisplayOrder:         100241505010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301801360),
			Name:                 "Miracle Linux 8.4 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "centos-alternative-8", "current-stable", "distro-miracle", "distro-ver-8.4", "miracle-8-latest", "os-linux"},
			DisplayOrder:         100240501010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113400984164),
			Name:                 "Ubuntu Server 22.04 LTS 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "distro-ubuntu", "distro-ver-22.04", "os-linux", "ubuntu-22.04-latest"},
			DisplayOrder:         100442204010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113400984164),
			Name:                 "Ubuntu Server 22.04 LTS 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "distro-ubuntu", "distro-ver-22.04", "os-linux", "ubuntu-22.04-latest"},
			DisplayOrder:         100442204010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113201424330),
			Name:                 "Ubuntu Server 20.04.1 LTS 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "distro-ubuntu", "distro-ver-20.04.1", "os-linux", "ubuntu-20.04-latest"},
			DisplayOrder:         100442004110,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113201595223),
			Name:                 "Ubuntu Server 18.04.5 LTS 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "distro-ubuntu", "distro-ver-18.04.5", "os-linux", "ubuntu-18.04-latest"},
			DisplayOrder:         100441804510,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301924892),
			Name:                 "Debian GNU/Linux 11.1.0 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "debian-11-latest", "distro-debian", "distro-ver-11.1.0", "os-linux"},
			DisplayOrder:         100541101010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113201078538),
			Name:                 "Debian GNU/Linux 10.4.0 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "debian-10-latest", "distro-debian", "distro-ver-10.4.0", "os-linux"},
			DisplayOrder:         100541040010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301650948),
			Name:                 "Debian GNU/Linux 11.0.0 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "debian-11-latest", "distro-debian", "distro-ver-11.0.0", "os-linux"},
			DisplayOrder:         100541100010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113101599801),
			Name:                 "RancherOS v1.5.4 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@require-memory-gib>=2", "arch-64bit", "current-stable", "distro-rancheros", "distro-ver-1.5.4", "os-linux"},
			DisplayOrder:         200440154000,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113101835147),
			Name:                 "k3OS v0.5.0 amd64",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "distro-k3os", "distro-stable", "distro-ver-0.5.0", "os-linux"},
			DisplayOrder:         200490005000,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301758423),
			Name:                 "KUSANAGI 9.0",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "distro-ver-9.0", "os-linux", "pkg-kusanagi"},
			DisplayOrder:         310240000120,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
	},
	"tk1b": {
		{
			ID:                   types.ID(113202012329),
			Name:                 "CentOS Stream 8 (20201203) 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "distro-centos", "distro-ver-8-stream", "os-linux"},
			DisplayOrder:         100140509010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113202012329),
			Name:                 "CentOS Stream 8 (20201203) 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "distro-centos", "distro-ver-8-stream", "os-linux"},
			DisplayOrder:         100140509010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113300112271),
			Name:                 "CentOS 7.9 (2009) 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "centos-7-latest", "distro-centos", "distro-ver-7.9", "os-linux"},
			DisplayOrder:         100140709011,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301078386),
			Name:                 "AlmaLinux 8.4 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "alma-8-latest", "arch-64bit", "centos-alternative-8", "current-stable", "distro-alma", "distro-ver-8.4", "os-linux"},
			DisplayOrder:         100240504010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113302064487),
			Name:                 "Rocky Linux 8.5",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "centos-alternative-8", "current-stable", "distro-rocky", "distro-ver-8.5", "os-linux", "rocky-8-latest"},
			DisplayOrder:         100241505010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301801366),
			Name:                 "Miracle Linux 8.4 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "centos-alternative-8", "current-stable", "distro-miracle", "distro-ver-8.4", "miracle-8-latest", "os-linux"},
			DisplayOrder:         100240501010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113400984165),
			Name:                 "Ubuntu Server 22.04 LTS 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "distro-ubuntu", "distro-ver-22.04", "os-linux", "ubuntu-22.04-latest"},
			DisplayOrder:         100442204010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113400984165),
			Name:                 "Ubuntu Server 22.04 LTS 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "distro-ubuntu", "distro-ver-22.04", "os-linux", "ubuntu-22.04-latest"},
			DisplayOrder:         100442204010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113201424331),
			Name:                 "Ubuntu Server 20.04.1 LTS 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "distro-ubuntu", "distro-ver-20.04.1", "os-linux", "ubuntu-20.04-latest"},
			DisplayOrder:         100442004110,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113201595226),
			Name:                 "Ubuntu Server 18.04.5 LTS 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "distro-ubuntu", "distro-ver-18.04.5", "os-linux", "ubuntu-18.04-latest"},
			DisplayOrder:         100441804510,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301924893),
			Name:                 "Debian GNU/Linux 11.1.0 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "debian-11-latest", "distro-debian", "distro-ver-11.1.0", "os-linux"},
			DisplayOrder:         100541101010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113201229109),
			Name:                 "Debian GNU/Linux 10.4.0 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "debian-10-latest", "distro-debian", "distro-ver-10.4.0", "os-linux"},
			DisplayOrder:         100541040010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301650951),
			Name:                 "Debian GNU/Linux 11.0.0 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "debian-11-latest", "distro-debian", "distro-ver-11.0.0", "os-linux"},
			DisplayOrder:         100541100010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113201230297),
			Name:                 "RancherOS v1.5.4 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@require-memory-gib>=2", "arch-64bit", "current-stable", "distro-rancheros", "distro-ver-1.5.4", "os-linux"},
			DisplayOrder:         200440154000,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113201230241),
			Name:                 "k3OS v0.5.0 amd64",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "distro-k3os", "distro-stable", "distro-ver-0.5.0", "os-linux"},
			DisplayOrder:         200490005000,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301758425),
			Name:                 "KUSANAGI 9.0",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "distro-ver-9.0", "os-linux", "pkg-kusanagi"},
			DisplayOrder:         310240000120,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
	},
	"tk1v": {
		{
			ID:                   types.ID(113202012336),
			Name:                 "CentOS Stream 8 (20201203) 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "distro-centos", "distro-ver-8-stream", "os-linux"},
			DisplayOrder:         100140509010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113202012336),
			Name:                 "CentOS Stream 8 (20201203) 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "distro-centos", "distro-ver-8-stream", "os-linux"},
			DisplayOrder:         100140509010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113300112275),
			Name:                 "CentOS 7.9 (2009) 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "centos-7-latest", "distro-centos", "distro-ver-7.9", "os-linux"},
			DisplayOrder:         100140709011,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301078388),
			Name:                 "AlmaLinux 8.4 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "alma-8-latest", "arch-64bit", "centos-alternative-8", "current-stable", "distro-alma", "distro-ver-8.4", "os-linux"},
			DisplayOrder:         100240504010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113302064489),
			Name:                 "Rocky Linux 8.5",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "centos-alternative-8", "current-stable", "distro-rocky", "distro-ver-8.5", "os-linux", "rocky-8-latest"},
			DisplayOrder:         100241505010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301801367),
			Name:                 "Miracle Linux 8.4 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "centos-alternative-8", "current-stable", "distro-miracle", "distro-ver-8.4", "miracle-8-latest", "os-linux"},
			DisplayOrder:         100240501010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113400984187),
			Name:                 "Ubuntu Server 22.04 LTS 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "distro-ubuntu", "distro-ver-22.04", "os-linux", "ubuntu-22.04-latest"},
			DisplayOrder:         100442204010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113400984187),
			Name:                 "Ubuntu Server 22.04 LTS 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "distro-ubuntu", "distro-ver-22.04", "os-linux", "ubuntu-22.04-latest"},
			DisplayOrder:         100442204010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113201424332),
			Name:                 "Ubuntu Server 20.04.1 LTS 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "distro-ubuntu", "distro-ver-20.04.1", "os-linux", "ubuntu-20.04-latest"},
			DisplayOrder:         100442004110,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113201595228),
			Name:                 "Ubuntu Server 18.04.5 LTS 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "distro-ubuntu", "distro-ver-18.04.5", "os-linux", "ubuntu-18.04-latest"},
			DisplayOrder:         100441804510,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301924894),
			Name:                 "Debian GNU/Linux 11.1.0 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "debian-11-latest", "distro-debian", "distro-ver-11.1.0", "os-linux"},
			DisplayOrder:         100541101010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113201078543),
			Name:                 "Debian GNU/Linux 10.4.0 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "debian-10-latest", "distro-debian", "distro-ver-10.4.0", "os-linux"},
			DisplayOrder:         100541040010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301650956),
			Name:                 "Debian GNU/Linux 11.0.0 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "debian-11-latest", "distro-debian", "distro-ver-11.0.0", "os-linux"},
			DisplayOrder:         100541100010,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113101599865),
			Name:                 "RancherOS v1.5.4 64bit",
			Description:          "fake",
			Tags:                 types.Tags{"@require-memory-gib>=2", "arch-64bit", "current-stable", "distro-rancheros", "distro-ver-1.5.4", "os-linux"},
			DisplayOrder:         200440154000,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113101835152),
			Name:                 "k3OS v0.5.0 amd64",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "distro-k3os", "distro-stable", "distro-ver-0.5.0", "os-linux"},
			DisplayOrder:         200490005000,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
		{
			ID:                   types.ID(113301758426),
			Name:                 "KUSANAGI 9.0",
			Description:          "fake",
			Tags:                 types.Tags{"@size-extendable", "arch-64bit", "current-stable", "distro-ver-9.0", "os-linux", "pkg-kusanagi"},
			DisplayOrder:         310240000120,
			Availability:         types.EAvailability("available"),
			Scope:                types.EScope("shared"),
			SizeMB:               20480,
			DiskPlanID:           types.ID(2),
			DiskPlanName:         "標準プラン",
			DiskPlanStorageClass: "iscsi1204",
		},
	},
}
