% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filesystem.R
\name{s3_bucket}
\alias{s3_bucket}
\title{Connect to an AWS S3 bucket}
\usage{
s3_bucket(bucket, ...)
}
\arguments{
\item{bucket}{string S3 bucket name or path}

\item{...}{Additional connection options, passed to \code{S3FileSystem$create()}}
}
\value{
A \code{SubTreeFileSystem} containing an \code{S3FileSystem} and the bucket's
relative path. Note that this function's success does not guarantee that you
are authorized to access the bucket's contents.
}
\description{
\code{s3_bucket()} is a convenience function to create an \code{S3FileSystem} object
that automatically detects the bucket's AWS region and holding onto the its
relative path.
}
\details{
By default, \code{\link{s3_bucket}} and other
\code{\link{S3FileSystem}} functions only produce output for fatal errors
or when printing their return values. When troubleshooting problems, it may
be useful to increase the log level. See the Notes section in
\code{\link{S3FileSystem}} for more information or see Examples below.
}
\examples{
\dontshow{if (FALSE) withAutoprint(\{ # examplesIf}
bucket <- s3_bucket("arrow-datasets")
\dontshow{\}) # examplesIf}
\dontshow{if (FALSE) withAutoprint(\{ # examplesIf}
# Turn on debug logging. The following line of code should be run in a fresh
# R session prior to any calls to `s3_bucket()` (or other S3 functions)
Sys.setenv("ARROW_S3_LOG_LEVEL" = "DEBUG")
bucket <- s3_bucket("arrow-datasets")
\dontshow{\}) # examplesIf}
}
