// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`DisableEnhancedMonitoring`](crate::operation::disable_enhanced_monitoring::builders::DisableEnhancedMonitoringFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stream_name(impl Into<String>)`](crate::operation::disable_enhanced_monitoring::builders::DisableEnhancedMonitoringFluentBuilder::stream_name) / [`set_stream_name(Option<String>)`](crate::operation::disable_enhanced_monitoring::builders::DisableEnhancedMonitoringFluentBuilder::set_stream_name):<br>required: **false**<br><p>The name of the Kinesis data stream for which to disable enhanced monitoring.</p><br>
    ///   - [`shard_level_metrics(MetricsName)`](crate::operation::disable_enhanced_monitoring::builders::DisableEnhancedMonitoringFluentBuilder::shard_level_metrics) / [`set_shard_level_metrics(Option<Vec::<MetricsName>>)`](crate::operation::disable_enhanced_monitoring::builders::DisableEnhancedMonitoringFluentBuilder::set_shard_level_metrics):<br>required: **true**<br><p>List of shard-level metrics to disable.</p> <p>The following are the valid shard-level metrics. The value "<code>ALL</code>" disables every metric.</p> <ul>  <li>   <p><code>IncomingBytes</code></p></li>  <li>   <p><code>IncomingRecords</code></p></li>  <li>   <p><code>OutgoingBytes</code></p></li>  <li>   <p><code>OutgoingRecords</code></p></li>  <li>   <p><code>WriteProvisionedThroughputExceeded</code></p></li>  <li>   <p><code>ReadProvisionedThroughputExceeded</code></p></li>  <li>   <p><code>IteratorAgeMilliseconds</code></p></li>  <li>   <p><code>ALL</code></p></li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the Amazon Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>.</p><br>
    ///   - [`stream_arn(impl Into<String>)`](crate::operation::disable_enhanced_monitoring::builders::DisableEnhancedMonitoringFluentBuilder::stream_arn) / [`set_stream_arn(Option<String>)`](crate::operation::disable_enhanced_monitoring::builders::DisableEnhancedMonitoringFluentBuilder::set_stream_arn):<br>required: **false**<br><p>The ARN of the stream.</p><br>
    /// - On success, responds with [`DisableEnhancedMonitoringOutput`](crate::operation::disable_enhanced_monitoring::DisableEnhancedMonitoringOutput) with field(s):
    ///   - [`stream_name(Option<String>)`](crate::operation::disable_enhanced_monitoring::DisableEnhancedMonitoringOutput::stream_name): <p>The name of the Kinesis data stream.</p>
    ///   - [`current_shard_level_metrics(Option<Vec::<MetricsName>>)`](crate::operation::disable_enhanced_monitoring::DisableEnhancedMonitoringOutput::current_shard_level_metrics): <p>Represents the current state of the metrics that are in the enhanced state before the operation.</p>
    ///   - [`desired_shard_level_metrics(Option<Vec::<MetricsName>>)`](crate::operation::disable_enhanced_monitoring::DisableEnhancedMonitoringOutput::desired_shard_level_metrics): <p>Represents the list of all the metrics that would be in the enhanced state after the operation.</p>
    ///   - [`stream_arn(Option<String>)`](crate::operation::disable_enhanced_monitoring::DisableEnhancedMonitoringOutput::stream_arn): <p>The ARN of the stream.</p>
    /// - On failure, responds with [`SdkError<DisableEnhancedMonitoringError>`](crate::operation::disable_enhanced_monitoring::DisableEnhancedMonitoringError)
    pub fn disable_enhanced_monitoring(&self) -> crate::operation::disable_enhanced_monitoring::builders::DisableEnhancedMonitoringFluentBuilder {
        crate::operation::disable_enhanced_monitoring::builders::DisableEnhancedMonitoringFluentBuilder::new(self.handle.clone())
    }
}
