// Copyright 2019 The Chromium Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include <stddef.h>
#include <stdint.h>

#include <tuple>

#include "../pki/crl.h"
#include "../pki/input.h"

extern "C" int LLVMFuzzerTestOneInput(const uint8_t* data, size_t size) {
  bssl::der::Input crl_der(data, size);

  bssl::der::Input tbs_cert_list_tlv;
  bssl::der::Input signature_algorithm_tlv;
  bssl::der::BitString signature_value;

  std::ignore = bssl::ParseCrlCertificateList(
      crl_der, &tbs_cert_list_tlv, &signature_algorithm_tlv, &signature_value);

  return 0;
}
