; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#define MyAppName "nomacs - Image Lounge"
#define MyAppDesc "nomacs - Image Lounge is a lightweight image viewer."
#define MyAppVersion "0.0.0.0"
#define MyAppURL "https://nomacs.org/"
#define MyAppExeName "bin\nomacs.exe"
#define MyAppBaseDir "."

[Setup]
; NOTE: The value of AppId uniquely identifies this application. Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
AppId={{70663c70-5bf6-4e90-8a4a-c2f167c017ad}
AppName={#MyAppName}
AppVersion={#MyAppVersion}
;AppVerName={#MyAppName} {#MyAppVersion}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
DefaultDirName={autopf}\{#MyAppName}
; DisableProgramGroupPage=yes
; The [Icons] "quicklaunchicon" entry uses {userappdata} but its [Tasks] entry has a proper IsAdminInstallMode Check.
;UsedUserAreasWarning=no
;PrivilegesRequired=admin
PrivilegesRequiredOverridesAllowed=dialog
OutputDir={#MyAppBaseDir}
OutputBaseFilename=nomacs-setup-x64
WizardImageFile={#MyAppBaseDir}\img\banner-thanks.bmp
;WizardSmallImageFile={#MyAppBaseDir}\img\nomacs.svg
SetupIconFile={#MyAppBaseDir}\img\nomacs.ico
UninstallDisplayIcon={app}\{#MyAppExeName}
Compression=lzma2/ultra64
SolidCompression=yes
WizardStyle=modern
ArchitecturesAllowed=x64
ArchitecturesInstallIn64BitMode=x64
ChangesAssociations=yes
CloseApplications=yes
DisableProgramGroupPage=yes

[Types]
Name: "full"; Description: "{code:GetMsgFullInstallation}"
Name: "compact"; Description: "{code:GetMsgCompactInstallation}"
Name: "custom"; Description: "{code:GetMsgCustomInstallation}"; Flags: iscustom

[Components]
Name: "main"; Description: "{#MyAppName} {#MyAppVersion}"; Types: full compact custom; Flags: fixed
Name: "setlanguage"; Description: "Set default language same as the installer"; Types: full custom
Name: "resetsettings"; Description: "Reset user configs for current user"; Types:
Name: "fa"; Description: "File associations"; Types: full custom
Name: "fa\3fr"; Description: ".3fr"; Types: full custom
Name: "fa\arw"; Description: ".arw"; Types: full custom
Name: "fa\avif"; Description: ".avif"; Types: full custom
Name: "fa\bmp"; Description: ".bmp"; Types: full custom
Name: "fa\cr2"; Description: ".cr2"; Types: full custom
Name: "fa\cr3"; Description: ".cr3"; Types: full custom
Name: "fa\crw"; Description: ".crw"; Types: full custom
Name: "fa\cur"; Description: ".cur"; Types: full custom
Name: "fa\dng"; Description: ".dng"; Types: full custom
Name: "fa\drif"; Description: ".drif"; Types: full custom
Name: "fa\gif"; Description: ".gif"; Types: full custom
Name: "fa\heic"; Description: ".heic"; Types: full custom
Name: "fa\heics"; Description: ".heics"; Types: full custom
Name: "fa\heif"; Description: ".heif"; Types: full custom
Name: "fa\heifs"; Description: ".heifs"; Types: full custom
Name: "fa\icns"; Description: ".icns"; Types: full custom
Name: "fa\iiq"; Description: ".iiq"; Types: full custom
Name: "fa\j2k"; Description: ".j2k"; Types: full custom
Name: "fa\jp2"; Description: ".jp2"; Types: full custom
Name: "fa\jpe"; Description: ".jpe"; Types: full custom
Name: "fa\jpeg"; Description: ".jpeg"; Types: full custom
Name: "fa\jpf"; Description: ".jpf"; Types: full custom
Name: "fa\jpg"; Description: ".jpg"; Types: full custom
Name: "fa\jpgx"; Description: ".jpgx"; Types: full custom
Name: "fa\jpm"; Description: ".jpm"; Types: full custom
Name: "fa\jps"; Description: ".jps"; Types: full custom
Name: "fa\jpx"; Description: ".jpx"; Types: full custom
Name: "fa\jxl"; Description: ".jxl"; Types: full custom
Name: "fa\mng"; Description: ".mng"; Types: full custom
Name: "fa\mos"; Description: ".mos"; Types: full custom
Name: "fa\mpo"; Description: ".mpo"; Types: full custom
Name: "fa\mrw"; Description: ".mrw"; Types: full custom
Name: "fa\nef"; Description: ".nef"; Types: full custom
Name: "fa\nrw"; Description: ".nrw"; Types: full custom
Name: "fa\orf"; Description: ".orf"; Types: full custom
Name: "fa\pbm"; Description: ".pbm"; Types: full custom
Name: "fa\pef"; Description: ".pef"; Types: full custom
Name: "fa\pgm"; Description: ".pgm"; Types: full custom
Name: "fa\png"; Description: ".png"; Types: full custom
Name: "fa\pns"; Description: ".pns"; Types: full custom
Name: "fa\ppm"; Description: ".ppm"; Types: full custom
Name: "fa\psb"; Description: ".psb"; Types: full custom
Name: "fa\psd"; Description: ".psd"; Types: full custom
Name: "fa\raf"; Description: ".raf"; Types: full custom
Name: "fa\raw"; Description: ".raw"; Types: full custom
Name: "fa\roh"; Description: ".roh"; Types: full custom
Name: "fa\rw2"; Description: ".rw2"; Types: full custom
Name: "fa\srw"; Description: ".srw"; Types: full custom
Name: "fa\svg"; Description: ".svg"; Types: full custom
Name: "fa\svgz"; Description: ".svgz"; Types: full custom
Name: "fa\tga"; Description: ".tga"; Types: full custom
Name: "fa\tif"; Description: ".tif"; Types: full custom
Name: "fa\tiff"; Description: ".tiff"; Types: full custom
Name: "fa\vec"; Description: ".vec"; Types: full custom
Name: "fa\wbmp"; Description: ".wbmp"; Types: full custom
Name: "fa\webp"; Description: ".webp"; Types: full custom
Name: "fa\x3f"; Description: ".x3f"; Types: full custom
Name: "fa\xbm"; Description: ".xbm"; Types: full custom
Name: "fa\xpm"; Description: ".xpm"; Types: full custom

; [Tasks]
; Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Components: main
; Name: "quicklaunchicon"; Description: "{cm:CreateQuickLaunchIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked; OnlyBelowVersion: 6.1; Check: not IsAdminInstallMode; Components: main

[Files]
Source: "{#MyAppBaseDir}\nomacs.x64\*"; DestDir: "{app}\bin"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: main
; Source: "{#MyAppBaseDir}\bin\settings.ini"; DestDir: "{app}\bin"; Flags: deleteafterinstall; Components: main
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[Icons]
Name: "{autoprograms}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"
;Name: "{autodesktop}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"; Tasks: desktopicon
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}";

[Ini]
Filename: "{app}\bin\default.ini"; Section: "General"; Key: "firstTime"; String: "false"; Components: setlanguage
Filename: "{app}\bin\default.ini"; Section: "AppSettings"; Key: "firstTime.nomacs.3"; String: "false"; Components: setlanguage
;Filename: "{app}\bin\default.ini"; Section: "AppSettings"; Key: "hideAllPanels"; String: "true"; Components: setlanguage
;Filename: "{app}\bin\default.ini"; Section: "DisplaySettings"; Key: "keepZoom"; String: "2"; Components: setlanguage
;Filename: "{app}\bin\default.ini"; Section: "DisplaySettings"; Key: "showScrollBars"; String: "true"; Components: setlanguage
Filename: "{app}\bin\default.ini"; Section: "GlobalSettings"; Key: "language"; String: "{language}"; Check: LanguageNotEnglish ; Components: setlanguage
;Filename: "{app}\bin\default.ini"; Section: "GlobalSettings"; Key: "askToSaveDeletedFiles"; String: "true"; Components: setlanguage
;Filename: "{app}\bin\default.ini"; Section: "SynchronizeSettings"; Key: "checkForUpdates"; String: "false"; Components: setlanguage
;Filename: "{app}\bin\default.ini"; Section: "SynchronizeSettings"; Key: "disableUpdateInteraction"; String: "false"; Components: setlanguage
;Filename: "{app}\bin\default.ini"; Section: "ResourceSettings"; Key: "filterRawImages"; String: "false"; Components: setlanguage
;Filename: "{app}\bin\default.ini"; Section: "ResourceSettings"; Key: "loadRawThumb"; String: "2"; Components: setlanguage

[InstallDelete]
Type: filesandordirs; Name: "{userappdata}\nomacs"; Components: resetsettings

[Languages]
; Name: "bg"; MessagesFile: "compiler:Languages\Bulgarian.isl"
; Name: "zh_CN"; MessagesFile: "compiler:Languages\ChineseSimplified.isl"
; Name: "zh_TW"; MessagesFile: "compiler:Languages\ChineseTraditional.isl"
; Name: "hr"; MessagesFile: "compiler:Languages\Croatian.isl"
; Name: "hu"; MessagesFile: "compiler:Languages\Hungarian.isl"
; Name: "id"; MessagesFile: "compiler:Languages\Indonesian.isl"
; Name: "ko"; MessagesFile: "compiler:Languages\Korean.isl"
; Name: "sr"; MessagesFile: "compiler:Languages\SerbianCyrillic.isl"
; Name: "sv"; MessagesFile: "compiler:Languages\Swedish.isl"
; Name: "sk"; MessagesFile: "compiler:Languages\Slovak.isl"
; Name: "uk"; MessagesFile: "compiler:Languages\Ukrainian.isl"

Name: "en"; MessagesFile: "compiler:Default.isl"
;Name: "afrikaans"; MessagesFile: "compiler:Languages\Afrikaans.isl"
;Name: "albanian"; MessagesFile: "compiler:Languages\Albanian.isl"
;Name: "ar"; MessagesFile: "compiler:Languages\Arabic.isl"
;Name: "armenian"; MessagesFile: "compiler:Languages\Armenian.isl"
;Name: "asturian"; MessagesFile: "compiler:Languages\Asturian.isl"
;Name: "basque"; MessagesFile: "compiler:Languages\Basque.isl"
;Name: "belarusian"; MessagesFile: "compiler:Languages\Belarusian.isl"
;Name: "bengali"; MessagesFile: "compiler:Languages\Bengali.islu"
;Name: "bs"; MessagesFile: "compiler:Languages\Bosnian.isl"
;Name: "brazilianportuguese"; MessagesFile: "compiler:Languages\BrazilianPortuguese.isl"
; Name: "bg"; MessagesFile: "compiler:Languages\Bulgarian.isl"
;Name: "catalan"; MessagesFile: "compiler:Languages\Catalan.isl"
; Name: "zh_CN"; MessagesFile: "compiler:Languages\ChineseSimplified.isl"
; Name: "zh_TW"; MessagesFile: "compiler:Languages\ChineseTraditional.isl"
;Name: "corsican"; MessagesFile: "compiler:Languages\Corsican.isl"
; Name: "hr"; MessagesFile: "compiler:Languages\Croatian.isl"
Name: "cs"; MessagesFile: "compiler:Languages\Czech.isl"
;Name: "danish"; MessagesFile: "compiler:Languages\Danish.isl"
;Name: "dutch"; MessagesFile: "compiler:Languages\Dutch.isl"
;Name: "englishbritish"; MessagesFile: "compiler:Languages\EnglishBritish.isl"
;Name: "esperanto"; MessagesFile: "compiler:Languages\Esperanto.isl"
;Name: "estonian"; MessagesFile: "compiler:Languages\Estonian.isl"
;Name: "farsi"; MessagesFile: "compiler:Languages\Farsi.isl"
Name: "fi"; MessagesFile: "compiler:Languages\Finnish.isl"
Name: "fr"; MessagesFile: "compiler:Languages\French.isl"
;Name: "galician"; MessagesFile: "compiler:Languages\Galician.isl"
;Name: "georgian"; MessagesFile: "compiler:Languages\Georgian.islu"
Name: "de"; MessagesFile: "compiler:Languages\German.isl"
;Name: "greek"; MessagesFile: "compiler:Languages\Greek.isl"
;Name: "hebrew"; MessagesFile: "compiler:Languages\Hebrew.isl"
;Name: "hindi"; MessagesFile: "compiler:Languages\Hindi.islu"
; Name: "hu"; MessagesFile: "compiler:Languages\Hungarian.isl"
;Name: "icelandic"; MessagesFile: "compiler:Languages\Icelandic.isl"
; Name: "id"; MessagesFile: "compiler:Languages\Indonesian.isl"
Name: "it"; MessagesFile: "compiler:Languages\Italian.isl"
Name: "ja"; MessagesFile: "compiler:Languages\Japanese.isl"
;Name: "kazakh"; MessagesFile: "compiler:Languages\Kazakh.islu"
; Name: "ko"; MessagesFile: "compiler:Languages\Korean.isl"
;Name: "kurdish"; MessagesFile: "compiler:Languages\Kurdish.isl"
;Name: "latvian"; MessagesFile: "compiler:Languages\Latvian.isl"
;Name: "ligurian"; MessagesFile: "compiler:Languages\Ligurian.isl"
;Name: "lithuanian"; MessagesFile: "compiler:Languages\Lithuanian.isl"
;Name: "luxemburgish"; MessagesFile: "compiler:Languages\Luxemburgish.isl"
;Name: "macedonian"; MessagesFile: "compiler:Languages\Macedonian.isl"
;Name: "malaysian"; MessagesFile: "compiler:Languages\Malaysian.isl"
;Name: "marathi"; MessagesFile: "compiler:Languages\Marathi.islu"
;Name: "mongolian"; MessagesFile: "compiler:Languages\Mongolian.isl"
;Name: "montenegrian"; MessagesFile: "compiler:Languages\Montenegrian.isl"
;Name: "nepali"; MessagesFile: "compiler:Languages\Nepali.islu"
;Name: "norwegian"; MessagesFile: "compiler:Languages\Norwegian.isl"
;Name: "norwegiannynorsk"; MessagesFile: "compiler:Languages\NorwegianNynorsk.isl"
;Name: "occitan"; MessagesFile: "compiler:Languages\Occitan.isl"
Name: "pl"; MessagesFile: "compiler:Languages\Polish.isl"
Name: "pt"; MessagesFile: "compiler:Languages\Portuguese.isl"
;Name: "romanian"; MessagesFile: "compiler:Languages\Romanian.isl"
Name: "ru"; MessagesFile: "compiler:Languages\Russian.isl"
;Name: "scottishgaelic"; MessagesFile: "compiler:Languages\ScottishGaelic.isl"
; Name: "sr"; MessagesFile: "compiler:Languages\SerbianCyrillic.isl"
;Name: "serbianlatin"; MessagesFile: "compiler:Languages\SerbianLatin.isl"
;Name: "sinhala"; MessagesFile: "compiler:Languages\Sinhala.islu"
; Name: "sk"; MessagesFile: "compiler:Languages\Slovak.isl"
;Name: "slovenian"; MessagesFile: "compiler:Languages\Slovenian.isl"
Name: "es"; MessagesFile: "compiler:Languages\Spanish.isl"
; Name: "sv"; MessagesFile: "compiler:Languages\Swedish.isl"
;Name: "tatar"; MessagesFile: "compiler:Languages\Tatar.isl"
;Name: "thai"; MessagesFile: "compiler:Languages\Thai.isl"
Name: "tr"; MessagesFile: "compiler:Languages\Turkish.isl"
; Name: "uk"; MessagesFile: "compiler:Languages\Ukrainian.isl"
;Name: "uyghur"; MessagesFile: "compiler:Languages\Uyghur.islu"
;Name: "uzbek"; MessagesFile: "compiler:Languages\Uzbek.isl"
;Name: "valencian"; MessagesFile: "compiler:Languages\Valencian.isl"
;Name: "vietnamese"; MessagesFile: "compiler:Languages\Vietnamese.isl"

[Registry]
Root: HKA; Subkey: "Software\Classes\.3fr"; ValueType: string; ValueName: ""; ValueData: "nomacs.3fr.3"; Flags: uninsdeletevalue; Components: fa\3fr
Root: HKA; Subkey: "Software\Classes\.arw"; ValueType: string; ValueName: ""; ValueData: "nomacs.arw.3"; Flags: uninsdeletevalue; Components: fa\arw
Root: HKA; Subkey: "Software\Classes\.avif"; ValueType: string; ValueName: ""; ValueData: "nomacs.avif.3"; Flags: uninsdeletevalue; Components: fa\avif
Root: HKA; Subkey: "Software\Classes\.bmp"; ValueType: string; ValueName: ""; ValueData: "nomacs.bmp.3"; Flags: uninsdeletevalue; Components: fa\bmp
Root: HKA; Subkey: "Software\Classes\.cr2"; ValueType: string; ValueName: ""; ValueData: "nomacs.crw.3"; Flags: uninsdeletevalue; Components: fa\cr2
Root: HKA; Subkey: "Software\Classes\.cr3"; ValueType: string; ValueName: ""; ValueData: "nomacs.crw.3"; Flags: uninsdeletevalue; Components: fa\cr3
Root: HKA; Subkey: "Software\Classes\.crw"; ValueType: string; ValueName: ""; ValueData: "nomacs.crw.3"; Flags: uninsdeletevalue; Components: fa\crw
Root: HKA; Subkey: "Software\Classes\.cur"; ValueType: string; ValueName: ""; ValueData: "nomacs.cur.3"; Flags: uninsdeletevalue; Components: fa\cur
Root: HKA; Subkey: "Software\Classes\.dng"; ValueType: string; ValueName: ""; ValueData: "nomacs.dng.3"; Flags: uninsdeletevalue; Components: fa\dng
Root: HKA; Subkey: "Software\Classes\.drif"; ValueType: string; ValueName: ""; ValueData: "nomacs.drif.3"; Flags: uninsdeletevalue; Components: fa\drif
Root: HKA; Subkey: "Software\Classes\.gif"; ValueType: string; ValueName: ""; ValueData: "nomacs.gif.3"; Flags: uninsdeletevalue; Components: fa\gif
Root: HKA; Subkey: "Software\Classes\.heic"; ValueType: string; ValueName: ""; ValueData: "nomacs.heic.3"; Flags: uninsdeletevalue; Components: fa\heic
Root: HKA; Subkey: "Software\Classes\.heics"; ValueType: string; ValueName: ""; ValueData: "nomacs.heics.3"; Flags: uninsdeletevalue; Components: fa\heics
Root: HKA; Subkey: "Software\Classes\.heif"; ValueType: string; ValueName: ""; ValueData: "nomacs.heif.3"; Flags: uninsdeletevalue; Components: fa\heif
Root: HKA; Subkey: "Software\Classes\.heifs"; ValueType: string; ValueName: ""; ValueData: "nomacs.heifs.3"; Flags: uninsdeletevalue; Components: fa\heifs
Root: HKA; Subkey: "Software\Classes\.icns"; ValueType: string; ValueName: ""; ValueData: "nomacs.icns.3"; Flags: uninsdeletevalue; Components: fa\icns
Root: HKA; Subkey: "Software\Classes\.iiq"; ValueType: string; ValueName: ""; ValueData: "nomacs.iiq.3"; Flags: uninsdeletevalue; Components: fa\iiq
Root: HKA; Subkey: "Software\Classes\.j2k"; ValueType: string; ValueName: ""; ValueData: "nomacs.jp2.3"; Flags: uninsdeletevalue; Components: fa\j2k
Root: HKA; Subkey: "Software\Classes\.jp2"; ValueType: string; ValueName: ""; ValueData: "nomacs.jp2.3"; Flags: uninsdeletevalue; Components: fa\jp2
Root: HKA; Subkey: "Software\Classes\.jpe"; ValueType: string; ValueName: ""; ValueData: "nomacs.jpg.3"; Flags: uninsdeletevalue; Components: fa\jpe
Root: HKA; Subkey: "Software\Classes\.jpeg"; ValueType: string; ValueName: ""; ValueData: "nomacs.jpg.3"; Flags: uninsdeletevalue; Components: fa\jpeg
Root: HKA; Subkey: "Software\Classes\.jpf"; ValueType: string; ValueName: ""; ValueData: "nomacs.jp2.3"; Flags: uninsdeletevalue; Components: fa\jpf
Root: HKA; Subkey: "Software\Classes\.jpg"; ValueType: string; ValueName: ""; ValueData: "nomacs.jpg.3"; Flags: uninsdeletevalue; Components: fa\jpg
Root: HKA; Subkey: "Software\Classes\.jpgx"; ValueType: string; ValueName: ""; ValueData: "nomacs.jp2.3"; Flags: uninsdeletevalue; Components: fa\jpgx
Root: HKA; Subkey: "Software\Classes\.jpm"; ValueType: string; ValueName: ""; ValueData: "nomacs.jp2.3"; Flags: uninsdeletevalue; Components: fa\jpm
Root: HKA; Subkey: "Software\Classes\.jps"; ValueType: string; ValueName: ""; ValueData: "nomacs.jps.3"; Flags: uninsdeletevalue; Components: fa\jps
Root: HKA; Subkey: "Software\Classes\.jpx"; ValueType: string; ValueName: ""; ValueData: "nomacs.jp2.3"; Flags: uninsdeletevalue; Components: fa\jpx
Root: HKA; Subkey: "Software\Classes\.jxl"; ValueType: string; ValueName: ""; ValueData: "nomacs.jxl.3"; Flags: uninsdeletevalue; Components: fa\jxl
Root: HKA; Subkey: "Software\Classes\.mng"; ValueType: string; ValueName: ""; ValueData: "nomacs.mng.3"; Flags: uninsdeletevalue; Components: fa\mng
Root: HKA; Subkey: "Software\Classes\.mos"; ValueType: string; ValueName: ""; ValueData: "nomacs.mos.3"; Flags: uninsdeletevalue; Components: fa\mos
Root: HKA; Subkey: "Software\Classes\.mpo"; ValueType: string; ValueName: ""; ValueData: "nomacs.mpo.3"; Flags: uninsdeletevalue; Components: fa\mpo
Root: HKA; Subkey: "Software\Classes\.mrw"; ValueType: string; ValueName: ""; ValueData: "nomacs.mrw.3"; Flags: uninsdeletevalue; Components: fa\mrw
Root: HKA; Subkey: "Software\Classes\.nef"; ValueType: string; ValueName: ""; ValueData: "nomacs.nef.3"; Flags: uninsdeletevalue; Components: fa\nef
Root: HKA; Subkey: "Software\Classes\.nrw"; ValueType: string; ValueName: ""; ValueData: "nomacs.nef.3"; Flags: uninsdeletevalue; Components: fa\nrw
Root: HKA; Subkey: "Software\Classes\.orf"; ValueType: string; ValueName: ""; ValueData: "nomacs.orf.3"; Flags: uninsdeletevalue; Components: fa\orf
Root: HKA; Subkey: "Software\Classes\.pbm"; ValueType: string; ValueName: ""; ValueData: "nomacs.pbm.3"; Flags: uninsdeletevalue; Components: fa\pbm
Root: HKA; Subkey: "Software\Classes\.pef"; ValueType: string; ValueName: ""; ValueData: "nomacs.pef.3"; Flags: uninsdeletevalue; Components: fa\pef
Root: HKA; Subkey: "Software\Classes\.pgm"; ValueType: string; ValueName: ""; ValueData: "nomacs.pgm.3"; Flags: uninsdeletevalue; Components: fa\pgm
Root: HKA; Subkey: "Software\Classes\.png"; ValueType: string; ValueName: ""; ValueData: "nomacs.png.3"; Flags: uninsdeletevalue; Components: fa\png
Root: HKA; Subkey: "Software\Classes\.pns"; ValueType: string; ValueName: ""; ValueData: "nomacs.pns.3"; Flags: uninsdeletevalue; Components: fa\pns
Root: HKA; Subkey: "Software\Classes\.ppm"; ValueType: string; ValueName: ""; ValueData: "nomacs.ppm.3"; Flags: uninsdeletevalue; Components: fa\ppm
Root: HKA; Subkey: "Software\Classes\.psb"; ValueType: string; ValueName: ""; ValueData: "nomacs.psb.3"; Flags: uninsdeletevalue; Components: fa\psb
Root: HKA; Subkey: "Software\Classes\.psd"; ValueType: string; ValueName: ""; ValueData: "nomacs.psd.3"; Flags: uninsdeletevalue; Components: fa\psd
Root: HKA; Subkey: "Software\Classes\.raf"; ValueType: string; ValueName: ""; ValueData: "nomacs.raf.3"; Flags: uninsdeletevalue; Components: fa\raf
Root: HKA; Subkey: "Software\Classes\.raw"; ValueType: string; ValueName: ""; ValueData: "nomacs.raw.3"; Flags: uninsdeletevalue; Components: fa\raw
Root: HKA; Subkey: "Software\Classes\.roh"; ValueType: string; ValueName: ""; ValueData: "nomacs.roh.3"; Flags: uninsdeletevalue; Components: fa\roh
Root: HKA; Subkey: "Software\Classes\.rw2"; ValueType: string; ValueName: ""; ValueData: "nomacs.raw.3"; Flags: uninsdeletevalue; Components: fa\rw2
Root: HKA; Subkey: "Software\Classes\.srw"; ValueType: string; ValueName: ""; ValueData: "nomacs.srw.3"; Flags: uninsdeletevalue; Components: fa\srw
Root: HKA; Subkey: "Software\Classes\.svg"; ValueType: string; ValueName: ""; ValueData: "nomacs.svg.3"; Flags: uninsdeletevalue; Components: fa\svg
Root: HKA; Subkey: "Software\Classes\.svgz"; ValueType: string; ValueName: ""; ValueData: "nomacs.svg.3"; Flags: uninsdeletevalue; Components: fa\svgz
Root: HKA; Subkey: "Software\Classes\.tga"; ValueType: string; ValueName: ""; ValueData: "nomacs.tga.3"; Flags: uninsdeletevalue; Components: fa\tga
Root: HKA; Subkey: "Software\Classes\.tif"; ValueType: string; ValueName: ""; ValueData: "nomacs.tif.3"; Flags: uninsdeletevalue; Components: fa\tif
Root: HKA; Subkey: "Software\Classes\.tiff"; ValueType: string; ValueName: ""; ValueData: "nomacs.tif.3"; Flags: uninsdeletevalue; Components: fa\tiff
Root: HKA; Subkey: "Software\Classes\.vec"; ValueType: string; ValueName: ""; ValueData: "nomacs.vec.3"; Flags: uninsdeletevalue; Components: fa\vec
Root: HKA; Subkey: "Software\Classes\.wbmp"; ValueType: string; ValueName: ""; ValueData: "nomacs.wbmp.3"; Flags: uninsdeletevalue; Components: fa\wbmp
Root: HKA; Subkey: "Software\Classes\.webp"; ValueType: string; ValueName: ""; ValueData: "nomacs.webp.3"; Flags: uninsdeletevalue; Components: fa\webp
Root: HKA; Subkey: "Software\Classes\.x3f"; ValueType: string; ValueName: ""; ValueData: "nomacs.x3f.3"; Flags: uninsdeletevalue; Components: fa\x3f
Root: HKA; Subkey: "Software\Classes\.xbm"; ValueType: string; ValueName: ""; ValueData: "nomacs.xbm.3"; Flags: uninsdeletevalue; Components: fa\xbm
Root: HKA; Subkey: "Software\Classes\.xpm"; ValueType: string; ValueName: ""; ValueData: "nomacs.xpm.3"; Flags: uninsdeletevalue; Components: fa\xpm

Root: HKA; Subkey: "Software\Classes\nomacs.3fr.3"; ValueType: string; ValueName: ""; ValueData: "Hasselblad Raw"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.arw.3"; ValueType: string; ValueName: ""; ValueData: "Sony Raw"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.avif.3"; ValueType: string; ValueName: ""; ValueData: "AV1 Image File Format"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.bmp.3"; ValueType: string; ValueName: ""; ValueData: "Windows Bitmap"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.crw.3"; ValueType: string; ValueName: ""; ValueData: "Canon Raw"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.cur.3"; ValueType: string; ValueName: ""; ValueData: "Windows Cursor Files"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.dng.3"; ValueType: string; ValueName: ""; ValueData: "Digital Negativ"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.drif.3"; ValueType: string; ValueName: ""; ValueData: "Developers Raw Image Format"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.gif.3"; ValueType: string; ValueName: ""; ValueData: "Graphic Interchange Format"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.heic.3"; ValueType: string; ValueName: ""; ValueData: "Image Format"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.heics.3"; ValueType: string; ValueName: ""; ValueData: "Image Format"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.heif.3"; ValueType: string; ValueName: ""; ValueData: "Image Format"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.heifs.3"; ValueType: string; ValueName: ""; ValueData: "Image Format"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.icns.3"; ValueType: string; ValueName: ""; ValueData: "Apple Icon Image"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.iiq.3"; ValueType: string; ValueName: ""; ValueData: "Phase One"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.jp2.3"; ValueType: string; ValueName: ""; ValueData: "JPEG 2000"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.jpg.3"; ValueType: string; ValueName: ""; ValueData: "JPEG"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.jps.3"; ValueType: string; ValueName: ""; ValueData: "JPEG Stereo"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.jxl.3"; ValueType: string; ValueName: ""; ValueData: "JPEG XL"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.mng.3"; ValueType: string; ValueName: ""; ValueData: "Multi-Image Network Graphics"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.mos.3"; ValueType: string; ValueName: ""; ValueData: "Leaf Raw"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.mpo.3"; ValueType: string; ValueName: ""; ValueData: "Multi Picture Object"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.mrw.3"; ValueType: string; ValueName: ""; ValueData: "Minolta Raw"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.nef.3"; ValueType: string; ValueName: ""; ValueData: "Nikon Raw"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.orf.3"; ValueType: string; ValueName: ""; ValueData: "Olympus Raw"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.pbm.3"; ValueType: string; ValueName: ""; ValueData: "Portable Bitmap"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.pef.3"; ValueType: string; ValueName: ""; ValueData: "Pentax Raw"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.pgm.3"; ValueType: string; ValueName: ""; ValueData: "Portable Graymap"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.png.3"; ValueType: string; ValueName: ""; ValueData: "PNG"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.pns.3"; ValueType: string; ValueName: ""; ValueData: "PNG Stereo"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.ppm.3"; ValueType: string; ValueName: ""; ValueData: "Portable Pixmap"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.psb.3"; ValueType: string; ValueName: ""; ValueData: "Large Document Format"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.psd.3"; ValueType: string; ValueName: ""; ValueData: "Adobe Photoshop"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.raf.3"; ValueType: string; ValueName: ""; ValueData: "Fujifilm Raw"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.raw.3"; ValueType: string; ValueName: ""; ValueData: "Panasonic Raw"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.roh.3"; ValueType: string; ValueName: ""; ValueData: "Rohkost"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.srw.3"; ValueType: string; ValueName: ""; ValueData: "Samsung Raw"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.svg.3"; ValueType: string; ValueName: ""; ValueData: "Scalable Vector Graphics"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.tga.3"; ValueType: string; ValueName: ""; ValueData: "Truvision Graphics Adapter"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.tif.3"; ValueType: string; ValueName: ""; ValueData: "TIFF"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.vec.3"; ValueType: string; ValueName: ""; ValueData: "OpenCV Haar Training"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.wbmp.3"; ValueType: string; ValueName: ""; ValueData: "Wireless Bitmap"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.webp.3"; ValueType: string; ValueName: ""; ValueData: "WebP"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.x3f.3"; ValueType: string; ValueName: ""; ValueData: "Sigma Raw"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.xbm.3"; ValueType: string; ValueName: ""; ValueData: "X11 Bitmap"; Flags: uninsdeletekey; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.xpm.3"; ValueType: string; ValueName: ""; ValueData: "X11 Pixmap"; Flags: uninsdeletekey; Components: fa

Root: HKA; Subkey: "Software\Classes\nomacs.3fr.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,5"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.arw.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,5"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.avif.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.bmp.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,4"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.crw.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,5"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.cur.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.dng.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,5"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.drif.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.gif.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,2"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.heic.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.heics.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.heif.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.heifs.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.icns.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.iiq.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,5"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.jp2.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.jpg.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,1"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.jps.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.jxl.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.mng.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,2"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.mos.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,5"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.mpo.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.mrw.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,5"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.nef.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,5"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.orf.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,5"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.pbm.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.pef.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,5"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.pgm.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,4"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.png.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,3"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.pns.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.ppm.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.psb.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.psd.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.raf.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,5"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.raw.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,5"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.roh.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.srw.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,5"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.svg.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.tga.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.tif.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,4"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.vec.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.wbmp.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.webp.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,4"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.x3f.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,5"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.xbm.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.xpm.3\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\bin\nomacs.exe,0"; Components: fa

Root: HKA; Subkey: "Software\Classes\nomacs.3fr.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.arw.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.avif.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.bmp.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.crw.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.cur.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.dng.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.drif.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.gif.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.heic.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.heics.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.heif.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.heifs.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.icns.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.iiq.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.jp2.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.jpg.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.jps.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.jxl.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.mng.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.mos.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.mpo.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.mrw.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.nef.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.orf.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.pbm.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.pef.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.pgm.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.png.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.pns.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.ppm.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.psb.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.psd.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.raf.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.raw.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.roh.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.srw.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.svg.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.tga.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.tif.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.vec.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.wbmp.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.webp.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.x3f.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.xbm.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa
Root: HKA; Subkey: "Software\Classes\nomacs.xpm.3\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\bin\nomacs.exe"" ""%1"""; Components: fa

[UninstallRun]
Filename: "{cmd}"; Parameters: "/C ""taskkill /im nomacs.exe /f /t"; Flags: runhidden

[Code]
function GetMsgFullInstallation(Value: string): string;
begin
  Result := SetupMessage(msgFullInstallation);
end;
function GetMsgCompactInstallation(Value: string): string;
begin
  Result := SetupMessage(msgCompactInstallation);
end;
function GetMsgCustomInstallation(Value: string): string;
begin
  Result := SetupMessage(msgCustomInstallation);
end;
function LanguageNotEnglish(): Boolean;
begin
  Result := ActiveLanguage <> 'en';
end;
procedure CurUninstallStepChanged(CurUninstallStep: TUninstallStep);
begin
  case CurUninstallStep of
    usUninstall:
      begin
        if DirExists(ExpandConstant('{userappdata}\nomacs')) then
          if MsgBox('Remove settings for current user?', mbConfirmation, MB_YESNO or MB_DEFBUTTON2) = IDYES then
             DelTree(ExpandConstant('{userappdata}\nomacs'), True, True, True);
      end;
  end;
end;
