RabbitMQ `3.8.35` is a maintenance release.
All users are recommended to upgrade to this release.

### Obtaining Packages

RabbitMQ releases are distributed via [GitHub](https://github.com/rabbitmq/rabbitmq-server/releases), [Cloudsmith](https://cloudsmith.io/~rabbitmq/repos/),
and [PackageCloud](https://packagecloud.io/rabbitmq).

### Erlang/OTP Compatibility Notes

This release [requires Erlang 23.2](https://www.rabbitmq.com/which-erlang.html) and [supports Erlang 24](https://blog.rabbitmq.com/posts/2021/03/erlang-24-support-roadmap/).

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision modern Erlang versions.


## Upgrade and Compatibility Notes

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

If upgrading from a `3.7.x` release, see [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0)
upgrade and compatibility notes first.

If upgrading from a `3.6.x` or older [release series](https://www.rabbitmq.com/versions.html), first upgrade
to [`3.7.27`](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.27) and then to this version.


## Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users)
and [RabbitMQ community Slack](https://rabbitmq-slack.herokuapp.com/).


## Changes Worth Mentioning

### Consul Peer Discovery Plugin

#### Enhancements

 * Consul peer discovery now supports client-side TLS options, much like its Kubernetes and etcd peers.

   ``` ini
   cluster_formation.consul.scheme = https
   # this assumes that Consul uses port 8501 for HTTPS clients
   cluster_formation.consul.port = 8501

   cluster_formation.consul.ssl_options.cacertfile = /path/to/consul/generated/ca_certificate.pem
   cluster_formation.consul.ssl_options.certfile = /path/to/client/certificate.pem
   cluster_formation.consul.ssl_options.keyfile = /path/to/client/client_key.pem
   ```

   GitHub issue: [#5116](https://github.com/rabbitmq/rabbitmq-server/issues/5116)


## Dependency Upgrades

None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.8.35.tar.xz`
instead of the source tarball produced by GitHub.

