/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DdlMapping;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@State(name="DdlMappings", storages={@Storage(value="sqlDataSources.xml")})
public final class DdlMappingsManager
implements PersistentStateComponent<Element> {
    private final Project myProject;
    private final List<DdlMapping> myMappings;

    public static DdlMappingsManager getInstance(@NotNull Project project) {
        if (project == null) {
            DdlMappingsManager.$$$reportNull$$$0(0);
        }
        return (DdlMappingsManager)project.getService(DdlMappingsManager.class);
    }

    public DdlMappingsManager(@NotNull Project project) {
        if (project == null) {
            DdlMappingsManager.$$$reportNull$$$0(1);
        }
        this.myMappings = new ArrayList<DdlMapping>();
        this.myProject = project;
    }

    public void update(@NotNull DdlMapping target) {
        DdlMapping existing;
        if (target == null) {
            DdlMappingsManager.$$$reportNull$$$0(2);
        }
        if ((existing = this.findById(target.getUniqueId())) == target) {
            return;
        }
        if (existing != null) {
            this.myMappings.remove(existing);
        }
        this.myMappings.add(target);
    }

    public void add(@NotNull DdlMapping mapping) {
        if (mapping == null) {
            DdlMappingsManager.$$$reportNull$$$0(3);
        }
        this.myMappings.add(mapping);
    }

    public void remove(@NotNull DdlMapping mapping) {
        if (mapping == null) {
            DdlMappingsManager.$$$reportNull$$$0(4);
        }
        this.myMappings.remove(mapping);
    }

    @NotNull
    public List<DdlMapping> getMappings() {
        List<DdlMapping> list = this.myMappings;
        if (list == null) {
            DdlMappingsManager.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public JBIterable<DdlMapping> iterateMappings() {
        JBIterable jBIterable = JBIterable.from(this.getMappings());
        if (jBIterable == null) {
            DdlMappingsManager.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    @Nullable
    public DdlMapping findById(@Nullable String id) {
        if (id != null) {
            for (DdlMapping mapping : this.myMappings) {
                if (!id.equals(mapping.getUniqueId())) continue;
                return mapping;
            }
        }
        return null;
    }

    @NotNull
    public JBIterable<DdlMapping> findByDataSourceId(@Nullable String id) {
        if (id == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DdlMappingsManager.$$$reportNull$$$0(7);
            }
            return jBIterable;
        }
        return DdlMappingsManager.findByDataSourceId(this.iterateMappings(), id);
    }

    @NotNull
    public JBIterable<DdlMapping> findByDdlDataSourceId(@Nullable String id) {
        if (id == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DdlMappingsManager.$$$reportNull$$$0(8);
            }
            return jBIterable;
        }
        return DdlMappingsManager.findByDdlDataSourceId(this.iterateMappings(), id);
    }

    @NotNull
    public JBIterable<DdlMapping> findByDataSources(@Nullable String dataSourceId, @Nullable String ddlDataSourceId) {
        if (dataSourceId == null || ddlDataSourceId == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DdlMappingsManager.$$$reportNull$$$0(9);
            }
            return jBIterable;
        }
        return DdlMappingsManager.findByDdlDataSourceId(DdlMappingsManager.findByDataSourceId(this.iterateMappings(), dataSourceId), ddlDataSourceId);
    }

    @NotNull
    public static JBIterable<DdlMapping> findByDataSourceId(JBIterable<DdlMapping> mappings, @NotNull String id) {
        if (id == null) {
            DdlMappingsManager.$$$reportNull$$$0(10);
        }
        JBIterable jBIterable = mappings.filter(m -> m.isDataSourceId(id));
        if (jBIterable == null) {
            DdlMappingsManager.$$$reportNull$$$0(11);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DdlMapping> findByDdlDataSourceId(JBIterable<DdlMapping> mappings, @NotNull String id) {
        if (id == null) {
            DdlMappingsManager.$$$reportNull$$$0(12);
        }
        JBIterable jBIterable = mappings.filter(m -> m.isDdlDataSourceId(id));
        if (jBIterable == null) {
            DdlMappingsManager.$$$reportNull$$$0(13);
        }
        return jBIterable;
    }

    public Element getState() {
        Element mappings = new Element("ddl-mappings");
        for (DdlMapping mapping : this.myMappings) {
            mappings.addContent(mapping.saveState(new Element("mapping")));
        }
        return mappings;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            DdlMappingsManager.$$$reportNull$$$0(14);
        }
        for (Element mapping : state.getChildren("mapping")) {
            this.add(DdlMapping.load(mapping));
        }
    }

    @TestOnly
    public void clear() {
        new ArrayList<DdlMapping>(this.getMappings()).forEach(this::remove);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DdlMappingsManager";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DdlMappingsManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateMappings";
                break;
            }
            case 7: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findByDataSourceId";
                break;
            }
            case 8: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findByDdlDataSourceId";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findByDataSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findByDataSourceId";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findByDdlDataSourceId";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 9, 11, 13 -> new IllegalStateException(string);
        };
    }
}

