/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.inspections.jam;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.semantic.SemService;
import com.intellij.spring.integration.SpringIntegrationBundle;
import com.intellij.spring.integration.inspections.jam.SpringIntegrationJamModelInspectionBase;
import com.intellij.spring.integration.model.jam.EnablePublisherComponent;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamMethodEndpoint;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamPoller;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamPollingMethodEndpoint;
import com.intellij.spring.integration.util.SpringIntegrationUtil;
import com.intellij.spring.model.SpringBeanPointer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnresolvedMessageChannelInspection
extends SpringIntegrationJamModelInspectionBase {
    @Override
    protected void checkClass(@NotNull PsiClass aClass, ProblemsHolder holder) {
        if (aClass == null) {
            UnresolvedMessageChannelInspection.$$$reportNull$$$0(0);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
        SemService semService = SemService.getSemService((Project)aClass.getProject());
        for (PsiMethod psiMethod : aClass.getMethods()) {
            List endpoints = semService.getSemElements(SpringIntegrationJamMethodEndpoint.CHANNEL_OWNER_JAM_KEY, (PsiElement)psiMethod);
            for (SpringIntegrationJamMethodEndpoint endpoint : endpoints) {
                UnresolvedMessageChannelInspection.checkMethodEndpoint(endpoint, module, holder);
            }
        }
        EnablePublisherComponent publisher = UnresolvedMessageChannelInspection.getEnablePublisher(JamService.getJamService((Project)aClass.getProject()), aClass);
        if (publisher != null) {
            UnresolvedMessageChannelInspection.checkChannelAttribute(holder, publisher.getValueAttr(), module);
        }
    }

    private static void checkMethodEndpoint(SpringIntegrationJamMethodEndpoint methodEndpoint, Module module, ProblemsHolder holder) {
        for (JamStringAttributeElement<SpringBeanPointer<?>> attributeElement : methodEndpoint.getChannelAttributes()) {
            UnresolvedMessageChannelInspection.checkChannelAttribute(holder, attributeElement, module);
        }
        if (methodEndpoint instanceof SpringIntegrationJamPollingMethodEndpoint) {
            for (SpringIntegrationJamPoller poller : ((SpringIntegrationJamPollingMethodEndpoint)methodEndpoint).getPollers()) {
                UnresolvedMessageChannelInspection.checkChannelAttribute(holder, poller.getErrorChannelAttribute(), module);
            }
        }
    }

    private static void checkChannelAttribute(ProblemsHolder holder, JamStringAttributeElement<SpringBeanPointer<?>> attributeElement, Module module) {
        PsiAnnotationMemberValue psiElement = attributeElement.getPsiElement();
        if (psiElement != null) {
            SpringBeanPointer springBeanPointer = (SpringBeanPointer)attributeElement.getValue();
            if (springBeanPointer == null) {
                holder.registerProblem((PsiElement)psiElement, SpringIntegrationBundle.message("UnresolvedMessageChannelWarningInspection.cannot.find.channel", new Object[0]), new LocalQuickFix[0]);
            } else if (!SpringIntegrationUtil.isMessageChannel(module, springBeanPointer)) {
                holder.registerProblem((PsiElement)psiElement, SpringIntegrationBundle.message("UnresolvedMessageChannelWarningInspection.bean.must.be.message.channel", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    @Nullable
    private static EnablePublisherComponent getEnablePublisher(@NotNull JamService jamService, @NotNull PsiClass psiClass) {
        if (jamService == null) {
            UnresolvedMessageChannelInspection.$$$reportNull$$$0(1);
        }
        if (psiClass == null) {
            UnresolvedMessageChannelInspection.$$$reportNull$$$0(2);
        }
        return (EnablePublisherComponent)jamService.getJamElement((PsiElement)psiClass, new JamMemberMeta[]{EnablePublisherComponent.META});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jamService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/integration/inspections/jam/UnresolvedMessageChannelInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnablePublisher";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

