/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.postcss.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.parsing.CssMathParser;
import com.intellij.psi.css.impl.parsing.CssParser2;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import org.intellij.plugins.postcss.PostCssElementTypes;
import org.intellij.plugins.postcss.PostCssStubElementTypes;
import org.intellij.plugins.postcss.lexer.PostCssTokenTypes;
import org.intellij.plugins.postcss.parser.PostCssMathParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PostCssParser
extends CssParser2 {
    private boolean myRulesetSeen;
    private boolean myAmpersandAllowed;
    private IElementType myAdditionalIdent;
    private final CssMathParser POST_CSS_MATH_PARSER = new PostCssMathParser(this);

    protected CssMathParser getMathParser() {
        return this.POST_CSS_MATH_PARSER;
    }

    protected IElementType getStylesheetLazyElementType() {
        return PostCssElementTypes.POST_CSS_LAZY_STYLESHEET;
    }

    protected IElementType getStylesheetElementType() {
        return PostCssStubElementTypes.POST_CSS_STYLESHEET;
    }

    protected TokenSet getCommentTokenTypes() {
        return PostCssTokenTypes.POST_CSS_COMMENTS;
    }

    protected boolean isSemicolonRequired() {
        return !this.myRulesetSeen && super.isSemicolonRequired();
    }

    protected boolean isSimpleSelectorStart() {
        return super.isSimpleSelectorStart() || this.getTokenType() == PostCssTokenTypes.AMPERSAND || this.getTokenType() == PostCssTokenTypes.POST_CSS_SIMPLE_VARIABLE_TOKEN;
    }

    protected void parseSimpleSelector() {
        if (this.getTokenType() == PostCssTokenTypes.POST_CSS_SIMPLE_VARIABLE_TOKEN) {
            PsiBuilder.Marker simpleSelector = this.createCompositeElement();
            this.parseSimpleVariable();
            simpleSelector.done(CssElementTypes.CSS_SIMPLE_SELECTOR);
        } else {
            super.parseSimpleSelector();
        }
    }

    protected boolean parseStylesheetItem() {
        return this.parseCustomSelectorAtRule() || this.parseCustomMediaAtRule() || this.parseAtRuleNesting() || this.parseVariableDeclaration() || super.parseStylesheetItem();
    }

    private boolean parseVariableDeclaration() {
        if (this.getTokenType() != PostCssTokenTypes.POST_CSS_SIMPLE_VARIABLE_TOKEN || this.lookAhead(1) != CssElementTypes.CSS_COLON) {
            return false;
        }
        PsiBuilder.Marker variableDeclaration = this.createCompositeElement();
        this.parseSimpleVariable();
        this.addTokenOrError(CssElementTypes.CSS_COLON, "':'");
        this.parseTermList(true, new IElementType[]{PostCssTokenTypes.POST_CSS_SIMPLE_VARIABLE_TOKEN});
        this.addTokenOrError(CssElementTypes.CSS_SEMICOLON, "';'");
        variableDeclaration.done(PostCssElementTypes.POST_CSS_SIMPLE_VARIABLE_DECLARATION);
        return true;
    }

    void parseSimpleVariable() {
        assert (this.getTokenType() == PostCssTokenTypes.POST_CSS_SIMPLE_VARIABLE_TOKEN);
        PsiBuilder.Marker term = this.createCompositeElement();
        this.addToken();
        term.done(PostCssElementTypes.POST_CSS_SIMPLE_VARIABLE);
    }

    protected void parsePropertyOfDeclaration() {
        if (this.getTokenType() == CssElementTypes.CSS_IDENT && this.rawLookup(1) == PostCssTokenTypes.POST_CSS_SIMPLE_VARIABLE_TOKEN) {
            this.addToken();
            this.parseSimpleVariable();
        } else {
            super.parsePropertyOfDeclaration();
        }
    }

    protected boolean _parseTerm(boolean strict, boolean nameValuePairSyntax) {
        if (this.getTokenType() == CssElementTypes.CSS_MINUS && this.lookAhead(1) == PostCssTokenTypes.POST_CSS_SIMPLE_VARIABLE_TOKEN || this.getTokenType() == PostCssTokenTypes.POST_CSS_SIMPLE_VARIABLE_TOKEN) {
            PsiBuilder.Marker term = this.createCompositeElement();
            if (this.getTokenType() == CssElementTypes.CSS_MINUS) {
                this.addToken();
            }
            this.parseSimpleVariable();
            term.done(CssElementTypes.CSS_TERM);
            return true;
        }
        return super._parseTerm(strict, nameValuePairSyntax);
    }

    protected boolean parseSingleDeclarationInBlock(boolean withPageMarginRules, boolean inlineCss, boolean requirePropertyValue, @NotNull IElementType elementType) {
        if (elementType == null) {
            PostCssParser.$$$reportNull$$$0(0);
        }
        if (withPageMarginRules && this.getTokenType() == CssElementTypes.CSS_ATKEYWORD) {
            return super.parseSingleDeclarationInBlock(true, inlineCss, requirePropertyValue, elementType);
        }
        if (elementType == CssElementTypes.CSS_MEDIA_FEATURE) {
            return super.parseSingleDeclarationInBlock(withPageMarginRules, inlineCss, requirePropertyValue, elementType);
        }
        this.myRulesetSeen = false;
        if (this.parseCustomMediaAtRule() || this.parseAtRuleNesting() || this.parseCustomSelectorAtRule()) {
            this.myRulesetSeen = true;
            return true;
        }
        return super.parseSingleDeclarationInBlock(withPageMarginRules, inlineCss, requirePropertyValue, elementType);
    }

    private boolean parseCustomMediaAtRule() {
        if (this.getTokenType() != PostCssTokenTypes.POST_CSS_CUSTOM_MEDIA_SYM) {
            return false;
        }
        PsiBuilder.Marker customMediaAtRule = this.createCompositeElement();
        this.addSingleToken();
        if (this.isIdent()) {
            PsiBuilder.Marker customMedia = this.createCompositeElement();
            this.addSingleToken();
            customMedia.done((IElementType)PostCssStubElementTypes.POST_CSS_CUSTOM_MEDIA);
        } else {
            this.createErrorElement(CssBundle.message((String)"parsing.error.identifier.expected", (Object[])new Object[0]));
        }
        this.parseMediumList();
        if (this.getTokenType() != CssElementTypes.CSS_RBRACE) {
            this.addSemicolonOrError();
        }
        customMediaAtRule.done(PostCssElementTypes.POST_CSS_CUSTOM_MEDIA_RULE);
        return true;
    }

    private boolean parseCustomSelectorAtRule() {
        if (this.getTokenType() != PostCssTokenTypes.POST_CSS_CUSTOM_SELECTOR_SYM) {
            return false;
        }
        PsiBuilder.Marker customSelectorRule = this.createCompositeElement();
        this.addSingleToken();
        this.parseCustomSelector();
        this.parseSelectorList();
        if (this.getTokenType() != CssElementTypes.CSS_RBRACE) {
            this.addSemicolonOrError();
        }
        customSelectorRule.done(PostCssElementTypes.POST_CSS_CUSTOM_SELECTOR_RULE);
        return true;
    }

    private void parseCustomSelector() {
        PsiBuilder.Marker customSelectorName = this.createCompositeElement();
        if (this.getTokenType() == CssElementTypes.CSS_COLON) {
            this.addSingleToken();
        }
        if (this.getTokenType() == CssElementTypes.CSS_IDENT) {
            this.addSingleToken();
        }
        customSelectorName.done((IElementType)PostCssStubElementTypes.POST_CSS_CUSTOM_SELECTOR);
    }

    private boolean parseAtRuleNesting() {
        if (this.getTokenType() != PostCssTokenTypes.POST_CSS_NEST_SYM) {
            return false;
        }
        PsiBuilder.Marker nest = this.createCompositeElement();
        this.addSingleToken();
        this.parseSelectorList();
        if (!this.parseDeclarationBlock() && this.getTokenType() != CssElementTypes.CSS_LBRACE) {
            this.createErrorElement(CssBundle.message((String)"parsing.error.opening.brace.expected", (Object[])new Object[0]));
        }
        nest.done(PostCssElementTypes.POST_CSS_NEST);
        return true;
    }

    protected boolean isRulesetStart() {
        return super.isRulesetStart() || this.getTokenType() == PostCssTokenTypes.HASH_SIGN;
    }

    protected boolean tryToParseRuleset() {
        boolean filterProperty;
        if (!this.isRulesetStart()) {
            return false;
        }
        if (this.getTokenType() == PostCssTokenTypes.AMPERSAND) {
            return this.parseRuleset();
        }
        PsiBuilder.Marker position = this.myBuilder.mark();
        IElementType prevTokenType = null;
        boolean first = true;
        String tokenText = this.getTokenText();
        boolean bl = filterProperty = this.getTokenType() == CssElementTypes.CSS_IDENT && tokenText != null && tokenText.endsWith("filter");
        while (!this.isDone() && (first || this.getTokenType() == CssElementTypes.CSS_HASH || this.getTokenType() == PostCssTokenTypes.HASH_SIGN || this.getTokenType() == CssElementTypes.CSS_IDENT || this.getTokenType() == CssElementTypes.CSS_PERIOD || this.getTokenType() == CssElementTypes.CSS_COLON || this.getTokenType() == CssElementTypes.CSS_COMMA || this.getTokenType() == CssElementTypes.CSS_PIPE || SELECTORS_HIERARCHY_TOKENS.contains(this.getTokenType()) || this.getTokenType() == PostCssTokenTypes.AMPERSAND || this.getTokenType() == CssElementTypes.CSS_BAD_CHARACTER || this.getTokenType() == CssElementTypes.CSS_RBRACKET || this.getTokenType() == CssElementTypes.CSS_EQ || this.getTokenType() == CssElementTypes.CSS_ASTERISK || this.getTokenType() == CssElementTypes.CSS_FUNCTION_TOKEN || this.getTokenType() == CssElementTypes.CSS_CONTAINS || this.getTokenType() == CssElementTypes.CSS_STRING_TOKEN)) {
            IElementType rawLookup1 = this.myBuilder.rawLookup(1);
            if (this.getTokenType() == CssElementTypes.CSS_COLON) {
                if ((rawLookup1 == CssElementTypes.CSS_FUNCTION_TOKEN || rawLookup1 == CssElementTypes.CSS_IDENT || rawLookup1 == PostCssTokenTypes.AMPERSAND || rawLookup1 == CssElementTypes.CSS_COLON) && this.parsePseudo()) {
                    if (first) {
                        position.rollbackTo();
                        return this.parseRuleset();
                    }
                    first = false;
                    continue;
                }
                position.rollbackTo();
                return false;
            }
            if (first && this.getTokenType() == CssElementTypes.CSS_HASH) {
                position.rollbackTo();
                return this.parseRuleset();
            }
            first = false;
            if (this.getTokenType() == CssElementTypes.CSS_GT || this.getTokenType() == PostCssTokenTypes.AMPERSAND || this.getTokenType() == CssElementTypes.CSS_PERIOD && !filterProperty) {
                position.rollbackTo();
                return this.parseRuleset();
            }
            if (this.getTokenType() == CssElementTypes.CSS_TILDA && prevTokenType == CssElementTypes.CSS_LPAREN) {
                position.rollbackTo();
                return this.parseRuleset();
            }
            prevTokenType = this.getTokenType();
            this.addSingleToken();
        }
        if ((this.getTokenType() == CssElementTypes.CSS_LBRACE || this.getTokenType() == CssElementTypes.CSS_LBRACKET) && prevTokenType != CssElementTypes.CSS_COLON) {
            position.rollbackTo();
            return this.parseRuleset();
        }
        if (prevTokenType == CssElementTypes.CSS_LPAREN && this.getTokenType() == CssElementTypes.CSS_TILDA) {
            position.rollbackTo();
            return this.parseRuleset();
        }
        position.rollbackTo();
        return false;
    }

    protected void parseSelectorList() {
        this.myAmpersandAllowed = true;
        super.parseSelectorList();
        this.myAmpersandAllowed = false;
    }

    public void addToken() {
        if (this.myAmpersandAllowed && this.isIdentOrAmpersand()) {
            this.addIdentOrAmpersandOrError();
        }
        super.addToken();
    }

    public boolean addIdentOrError() {
        return this.myAmpersandAllowed ? this.addIdentOrAmpersandOrError() : super.addIdentOrError();
    }

    public boolean isIdent(IElementType type) {
        return this.myAmpersandAllowed ? PostCssParser.isIdentOrAmpersand(type) : super.isIdent(type);
    }

    private boolean addIdentOrAmpersandOrError() {
        return this.addIdentOrAmpersandOrError(null, new IElementType[0]);
    }

    private boolean addIdentOrAmpersandOrError(@Nullable IElementType toCollapse, IElementType ... validTypes) {
        IElementType type;
        if (!this.isIdentOrAmpersand() && !ArrayUtil.contains((Object)this.getTokenType(), (Object[])validTypes)) {
            return super.addIdentOrError();
        }
        PsiBuilder.Marker ident = this.createCompositeElement();
        this.addSingleToken();
        boolean lastIsAdditionalType = false;
        while (!this.hasWhitespaceBefore() && !this.isDone() && (PostCssParser.isIdentOrAmpersand(type = this.getTokenType()) || type == CssElementTypes.CSS_NUMBER || toCollapse == null && type == this.myAdditionalIdent)) {
            this.addSingleToken();
            lastIsAdditionalType = type == this.myAdditionalIdent;
        }
        ident.collapse(toCollapse != null ? toCollapse : (this.myAdditionalIdent != null && lastIsAdditionalType ? this.myAdditionalIdent : CssElementTypes.CSS_IDENT));
        this.myAdditionalIdent = null;
        return true;
    }

    private boolean isIdentOrAmpersand() {
        return PostCssParser.isIdentOrAmpersand(this.getTokenType());
    }

    private static boolean isIdentOrAmpersand(IElementType type) {
        return type == CssElementTypes.CSS_IDENT || type == PostCssTokenTypes.AMPERSAND;
    }

    protected boolean parseIdSelector() {
        IElementType type = this.getTokenType();
        if (type != CssElementTypes.CSS_HASH && type != PostCssTokenTypes.HASH_SIGN) {
            return false;
        }
        PsiBuilder.Marker idSelector = this.createCompositeElement();
        this.addIdentOrAmpersandOrError(CssElementTypes.CSS_HASH, CssElementTypes.CSS_HASH, PostCssTokenTypes.HASH_SIGN);
        idSelector.done(CssElementTypes.CSS_ID_SELECTOR);
        return true;
    }

    protected boolean parsePseudo() {
        this.myAdditionalIdent = CssElementTypes.CSS_FUNCTION_TOKEN;
        boolean result = super.parsePseudo();
        this.myAdditionalIdent = null;
        return result;
    }

    protected boolean parsePseudoTerm() {
        IElementType tokenType = this.getTokenType();
        if (!this.isIdent(tokenType) && tokenType != CssElementTypes.CSS_HASH && tokenType != CssElementTypes.CSS_PERIOD && tokenType != CssElementTypes.CSS_COLON && tokenType != CssElementTypes.CSS_LBRACKET && tokenType != CssElementTypes.CSS_NUMBER && tokenType != CssElementTypes.CSS_PLUS && tokenType != CssElementTypes.CSS_ASTERISK && tokenType != CssElementTypes.CSS_STRING_TOKEN && tokenType != CssElementTypes.CSS_MINUS && tokenType != PostCssTokenTypes.AMPERSAND && tokenType != PostCssTokenTypes.HASH_SIGN) {
            return false;
        }
        PsiBuilder.Marker term = this.createCompositeElement();
        tokenType = this.getTokenType();
        if (!this.parsePseudoExpression()) {
            if (this.isIdent()) {
                this.addIdentOrError();
            } else if (this.isSimpleSelectorStart()) {
                this.addToken();
            } else if (tokenType == CssElementTypes.CSS_HASH || tokenType == PostCssTokenTypes.HASH_SIGN) {
                this.addIdentOrAmpersandOrError(CssElementTypes.CSS_HASH, CssElementTypes.CSS_HASH, PostCssTokenTypes.HASH_SIGN);
                this.parseAttribute();
            } else if (tokenType == CssElementTypes.CSS_STRING_TOKEN) {
                this.parseCssString();
            } else if (!(this.parseAttribute() || this.parsePseudo() || this.parseClass() || tokenType == null)) {
                this.createErrorElement(CssBundle.message((String)"parsing.error.unexpected.token", (Object[])new Object[0]));
                this.addToken();
            }
        }
        term.done(CssElementTypes.CSS_TERM);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/intellij/plugins/postcss/parser/PostCssParser", "parseSingleDeclarationInBlock"));
    }
}

