/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.interactive.dialog;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.Cell;
import com.intellij.ui.JBColor;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import git4idea.i18n.GitBundle;
import git4idea.rebase.interactive.GitRebaseTodoModel;
import git4idea.rebase.interactive.dialog.GitRebaseCommitIconTableCellRenderer;
import git4idea.rebase.interactive.dialog.GitRebaseCommitsTableModel;
import git4idea.rebase.interactive.dialog.NodeType;
import git4idea.rebase.interactive.dialog.SubjectRenderer;
import git4idea.rebase.interactive.dialog.view.CommitMessageCellEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0010\u0018\u0000 +2\u00020\u0001:\u0004+,-.B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u000fH\u0002J\b\u0010\u0019\u001a\u00020\u000fH\u0002J\b\u0010\u001a\u001a\u00020\u000fH\u0002J\"\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0017H\u0016J\b\u0010!\u001a\u00020\u000fH\u0014J\b\u0010\"\u001a\u00020\u000fH\u0016J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u000fH\u0014J\b\u0010'\u001a\u00020\u000fH\u0002J\u0015\u0010(\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b*R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;", "Lcom/intellij/ui/table/JBTable;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableModel;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableModel;Lcom/intellij/openapi/Disposable;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getModel", "()Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableModel;", "installUndoRedoActions", "", "installAnActionWithShortcut", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "shortcutActionId", "", "setSelectionMode", "selectionMode", "", "installSpeedSearch", "prepareCommitIconColumn", "adjustCommitIconColumnWidth", "prepareEditor", "Ljava/awt/Component;", "editor", "Ljavax/swing/table/TableCellEditor;", "row", "column", "onEditorCreate", "removeEditor", "columnMarginChanged", "e", "Ljavax/swing/event/ChangeEvent;", "onEditorRemove", "prepareSubjectColumn", "getDrawNodeType", "Lgit4idea/rebase/interactive/dialog/NodeType;", "getDrawNodeType$intellij_vcs_git", "Companion", "DisabledDuringRewordAction", "UndoAction", "RedoAction", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitRebaseCommitsTableView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRebaseCommitsTableView.kt\ngit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,351:1\n1#2:352\n*E\n"})
public class GitRebaseCommitsTableView
extends JBTable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final GitRebaseCommitsTableModel<?> model;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private static final JBColor GRAPH_COLOR;

    public GitRebaseCommitsTableView(@NotNull Project project, @NotNull GitRebaseCommitsTableModel<?> model, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        super((TableModel)model);
        this.project = project;
        this.model = model;
        this.disposable = disposable;
        this.setSelectionMode(2);
        this.columnModel.setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int index0, int index1) {
                int indexToForce = this.convertColumnIndexToView(1);
                super.setSelectionInterval(indexToForce, indexToForce);
            }
        });
        this.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.tableHeader = null;
        this.installSpeedSearch();
        this.prepareCommitIconColumn();
        this.prepareSubjectColumn();
        this.installUndoRedoActions();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final GitRebaseCommitsTableModel<?> getModel() {
        return this.model;
    }

    private final void installUndoRedoActions() {
        this.installAnActionWithShortcut((AnAction)new UndoAction(this), "$Undo");
        this.installAnActionWithShortcut((AnAction)new RedoAction(this), "$Redo");
    }

    private final void installAnActionWithShortcut(AnAction action, String shortcutActionId) {
        action.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)shortcutActionId), (JComponent)((Object)this));
    }

    public final void setSelectionMode(int selectionMode) {
        super.setSelectionMode(selectionMode);
    }

    private final void installSpeedSearch() {
        TableSpeedSearch.installOn((JTable)((JTable)((Object)this)), (arg_0, arg_1) -> GitRebaseCommitsTableView.installSpeedSearch$lambda$1(GitRebaseCommitsTableView::installSpeedSearch$lambda$0, arg_0, arg_1));
    }

    private final void prepareCommitIconColumn() {
        TableColumn commitIconColumn = this.columnModel.getColumn(0);
        commitIconColumn.setCellRenderer((TableCellRenderer)((Object)new GitRebaseCommitIconTableCellRenderer()));
        this.adjustCommitIconColumnWidth();
    }

    private final void adjustCommitIconColumnWidth() {
        int contentWidth = 2 * Companion.getGRAPH_NODE_WIDTH() + 10;
        TableColumn column = this.columnModel.getColumn(0);
        column.setMaxWidth(contentWidth);
        column.setPreferredWidth(contentWidth);
    }

    @NotNull
    public Component prepareEditor(@Nullable TableCellEditor editor2, int row, int column) {
        this.onEditorCreate();
        Component component2 = super.prepareEditor(editor2, row, column);
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"prepareEditor(...)");
        return component2;
    }

    protected void onEditorCreate() {
    }

    public void removeEditor() {
        Object cellValue;
        int editingRow = this.getEditingRow();
        TableCellEditor tableCellEditor = this.getCellEditor();
        Object object = cellValue = tableCellEditor != null ? tableCellEditor.getCellEditorValue() : null;
        if (editingRow != -1 && cellValue != null && !Intrinsics.areEqual((Object)this.model.getCommitMessage(editingRow), (Object)cellValue)) {
            String string = GitBundle.message((String)"rebase.interactive.dialog.cancel.reword.warning.title", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = GitBundle.message((String)"rebase.interactive.dialog.cancel.reword.warning.body", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            MessageDialogBuilder.YesNo yesNo = MessageDialogBuilder.Companion.yesNo(string, string2);
            String string3 = GitBundle.message((String)"rebase.interactive.dialog.cancel.reword.warning.cancel", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            MessageDialogBuilder.YesNo yesNo2 = (MessageDialogBuilder.YesNo)yesNo.yesText(string3);
            String string4 = GitBundle.message((String)"rebase.interactive.dialog.cancel.reword.warning.continue", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            boolean cancelEditing = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)yesNo2.noText(string4)).icon(Messages.getWarningIcon())).ask(this.project);
            if (!cancelEditing) {
                return;
            }
        }
        this.onEditorRemove();
        boolean bl = 0 <= editingRow ? editingRow < this.getRowCount() : false;
        if (bl) {
            this.setRowHeight(editingRow, Companion.getDEFAULT_CELL_HEIGHT());
        }
        super.removeEditor();
    }

    public void columnMarginChanged(@NotNull ChangeEvent e) {
        TableColumn resizingColumn;
        JTableHeader tableHeader;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JTableHeader jTableHeader = tableHeader = this.getTableHeader();
        TableColumn tableColumn = resizingColumn = jTableHeader != null ? jTableHeader.getResizingColumn() : null;
        if (resizingColumn != null && this.autoResizeMode == 0) {
            resizingColumn.setPreferredWidth(resizingColumn.getWidth());
        }
        this.resizeAndRepaint();
    }

    protected void onEditorRemove() {
    }

    private final void prepareSubjectColumn() {
        TableColumn subjectColumn = this.columnModel.getColumn(1);
        subjectColumn.setCellRenderer((TableCellRenderer)((Object)new SubjectRenderer()));
        subjectColumn.setCellEditor(new CommitMessageCellEditor(this.project, this, this.disposable));
    }

    @NotNull
    public final NodeType getDrawNodeType$intellij_vcs_git(int row) {
        return Intrinsics.areEqual((Object)this.model.getElement(row).getType(), (Object)GitRebaseTodoModel.Type.NonUnite.KeepCommit.Edit.INSTANCE) ? NodeType.EDIT : (!(this.model.getElement(row).getType() instanceof GitRebaseTodoModel.Type.NonUnite.KeepCommit) ? NodeType.NO_NODE : (this.model.getElement(row) instanceof GitRebaseTodoModel.Element.UniteRoot ? NodeType.DOUBLE_NODE : NodeType.SIMPLE_NODE));
    }

    private static final String installSpeedSearch$lambda$0(Object o, Cell cell) {
        String string;
        String it = string = o.toString();
        boolean bl = false;
        return cell.column == 1 ? string : null;
    }

    private static final String installSpeedSearch$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (String)$tmp0.invoke(p0, p1);
    }

    static {
        JBColor jBColor = JBColor.namedColor((String)"VersionControl.GitCommits.graphColor", (Color)((Color)new JBColor(new Color(174, 185, 192), new Color(135, 146, 154))));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        GRAPH_COLOR = jBColor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0016\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView$Companion;", "", "<init>", "()V", "GRAPH_LINE_WIDTH", "", "getGRAPH_LINE_WIDTH", "()F", "GRAPH_NODE_WIDTH", "", "getGRAPH_NODE_WIDTH", "()I", "DEFAULT_CELL_HEIGHT", "getDEFAULT_CELL_HEIGHT", "GRAPH_COLOR", "Lcom/intellij/ui/JBColor;", "Lorg/jetbrains/annotations/NotNull;", "getGRAPH_COLOR", "()Lcom/intellij/ui/JBColor;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public final float getGRAPH_LINE_WIDTH() {
            return JBUIScale.scale((float)1.5f);
        }

        public final int getGRAPH_NODE_WIDTH() {
            return JBUI.scale((int)8);
        }

        public final int getDEFAULT_CELL_HEIGHT() {
            return JBUI.scale((int)22);
        }

        @NotNull
        public final JBColor getGRAPH_COLOR() {
            return GRAPH_COLOR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView$DisabledDuringRewordAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "table", "Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;", "<init>", "(Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;)V", "getTable", "()Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
    private static abstract class DisabledDuringRewordAction
    extends DumbAwareAction {
        @NotNull
        private final GitRebaseCommitsTableView table;

        public DisabledDuringRewordAction(@NotNull GitRebaseCommitsTableView table) {
            Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
            this.table = table;
        }

        @NotNull
        protected final GitRebaseCommitsTableView getTable() {
            return this.table;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.update(e);
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
            Presentation presentation2 = presentation;
            presentation2.setEnabledAndVisible(true);
            if (this.table.editingRow != -1) {
                presentation2.setEnabledAndVisible(false);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView$RedoAction;", "Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView$DisabledDuringRewordAction;", "table", "Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;", "<init>", "(Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
    private static final class RedoAction
    extends DisabledDuringRewordAction {
        public RedoAction(@NotNull GitRebaseCommitsTableView table) {
            Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
            super(table);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.getTable().getModel().redo();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView$UndoAction;", "Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView$DisabledDuringRewordAction;", "table", "Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;", "<init>", "(Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
    private static final class UndoAction
    extends DisabledDuringRewordAction {
        public UndoAction(@NotNull GitRebaseCommitsTableView table) {
            Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
            super(table);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.getTable().getModel().undo();
        }
    }
}

