/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.javascript.types.TSNumberLiteralType;
import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNumberLiteralTypeImpl
extends JSNumberType
implements JSPrimitiveLiteralType<Double>,
TSNumberLiteralType {
    protected final double myLiteral;
    private final boolean myAllowWidening;
    @Nullable
    protected final String myValueAsString;

    /*
     * WARNING - void declaration
     */
    public JSNumberLiteralTypeImpl(double literal, boolean allowWidening, @NotNull JSTypeSource source, @Nullable String string) {
        void valueAsString;
        if (source == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(0);
        }
        super(true, source, JSTypeContext.INSTANCE);
        this.myLiteral = literal;
        this.myAllowWidening = allowWidening;
        this.myValueAsString = valueAsString;
    }

    public JSNumberLiteralTypeImpl(@NotNull JSTypeSource typeSource, @NotNull CharacterIterator inputStream) {
        if (typeSource == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(1);
        }
        if (inputStream == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(2);
        }
        super(typeSource, inputStream);
        this.myAllowWidening = JSTypeSerializer.readBoolean(inputStream);
        String value = JSTypeSerializer.readString(inputStream);
        Double aDouble = JSNumberParser.tryParseNumericValue(value, false);
        this.myLiteral = aDouble != null ? aDouble : 0.0;
        this.myValueAsString = value;
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(3);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeBoolean(this.myAllowWidening, outputStream);
        JSTypeSerializer.writeString(this.getValueAsString(), outputStream);
    }

    @Override
    @NotNull
    public String getValueAsString() {
        String string = this.myValueAsString != null ? this.myValueAsString : Double.toString(this.myLiteral);
        if (string == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public Double getLiteral() {
        Double d = this.myLiteral;
        if (d == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(5);
        }
        return d;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(6);
        }
        if (processingContext == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(7);
        }
        if (elementType instanceof JSNumberLiteralTypeImpl && this.isSourceStrict() && !this.myAllowWidening) {
            return this.myLiteral == ((JSNumberLiteralTypeImpl)elementType).myLiteral;
        }
        if (!this.myAllowWidening && elementType instanceof JSNumberType) {
            return this.isJavaScript();
        }
        if (!this.myAllowWidening && elementType instanceof JSResolvableType) {
            JSResolvedTypeInfo resolvedType = ((JSResolvableType)elementType).resolveType();
            if (resolvedType.isEnumLiteral()) {
                TypeScriptEnumField field = resolvedType.getDeclarationOfType(TypeScriptEnumField.class);
                if (field == null) {
                    return false;
                }
                EnumConstantValue value = field.getConstantValue();
                Double numericValue = value.getNumericValue();
                return numericValue != null && numericValue == this.myLiteral;
            }
            if (resolvedType.isEnum()) {
                return false;
            }
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(8);
        }
        return super.isEquivalentToWithSameClass(type, processingContext, allowResolve) && this.myLiteral == ((JSNumberLiteralTypeImpl)type).myLiteral;
    }

    @Override
    @NotNull
    protected JSNumberLiteralTypeImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(9);
        }
        return new JSNumberLiteralTypeImpl(this.getLiteral(), this.myAllowWidening, source, this.myValueAsString);
    }

    @Override
    public boolean allowWidening() {
        return this.myAllowWidening;
    }

    @Override
    @NotNull
    public JSLiteralType copyWithAllowWidening(boolean allowWidening) {
        if (this.myAllowWidening == allowWidening) {
            JSNumberLiteralTypeImpl jSNumberLiteralTypeImpl = this;
            if (jSNumberLiteralTypeImpl == null) {
                JSNumberLiteralTypeImpl.$$$reportNull$$$0(10);
            }
            return jSNumberLiteralTypeImpl;
        }
        return new JSNumberLiteralTypeImpl(this.myLiteral, allowWidening, this.getSource(), this.myValueAsString);
    }

    @Override
    @NotNull
    public String getDefaultValue() {
        String string = this.getValueAsString();
        if (string == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @Nullable
    public Number getValue() {
        return this.getLiteral();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSNumberLiteralTypeImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSNumberLiteralTypeImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAsString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteral";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithAllowWidening";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 10, 11 -> new IllegalStateException(string);
        };
    }
}

