/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.database.config.impl.urlParser;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseType;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseUrl;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseUrlParserKt;
import com.intellij.persistence.database.config.impl.urlParser.DatabasesKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0016J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JH\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006#"}, d2={"Lcom/intellij/persistence/database/config/impl/urlParser/H2TcpDatabaseUrl;", "Lcom/intellij/persistence/database/config/impl/urlParser/DatabaseUrl;", "host", "", "port", "", "pathToDb", "parameters", "databaseName", "<init>", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getHost", "()Ljava/lang/String;", "getPort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getPathToDb", "getParameters", "getDatabaseName", "toDbDialogUrl", "dataSourceItemName", "driverClass", "component1", "component2", "component3", "component4", "component5", "copy", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lcom/intellij/persistence/database/config/impl/urlParser/H2TcpDatabaseUrl;", "equals", "", "other", "", "hashCode", "toString", "intellij.javaee.persistence.impl"})
@SourceDebugExtension(value={"SMAP\nH2UrlParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 H2UrlParser.kt\ncom/intellij/persistence/database/config/impl/urlParser/H2TcpDatabaseUrl\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,124:1\n52#2:125\n52#2:126\n52#2:127\n52#2:128\n*S KotlinDebug\n*F\n+ 1 H2UrlParser.kt\ncom/intellij/persistence/database/config/impl/urlParser/H2TcpDatabaseUrl\n*L\n109#1:125\n110#1:126\n111#1:127\n112#1:128\n*E\n"})
final class H2TcpDatabaseUrl
extends DatabaseUrl {
    @NotNull
    private final String host;
    @Nullable
    private final Integer port;
    @Nullable
    private final String pathToDb;
    @Nullable
    private final String parameters;
    @Nullable
    private final String databaseName;

    public H2TcpDatabaseUrl(@NotNull String host, @Nullable Integer port, @Nullable String pathToDb, @Nullable String parameters, @Nullable String databaseName) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.host = host;
        this.port = port;
        this.pathToDb = pathToDb;
        this.parameters = parameters;
        this.databaseName = databaseName;
    }

    public /* synthetic */ H2TcpDatabaseUrl(String string, Integer n, String string2, String string3, String string4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        this(string, n, string2, string3, string4);
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    @Nullable
    public final Integer getPort() {
        return this.port;
    }

    @Nullable
    public final String getPathToDb() {
        return this.pathToDb;
    }

    @Nullable
    public final String getParameters() {
        return this.parameters;
    }

    @Nullable
    public final String getDatabaseName() {
        return this.databaseName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String toDbDialogUrl() {
        String string;
        String string2;
        String string3;
        String string4;
        void $this$applyIf$iv;
        String string5 = "jdbc:h2:tcp://" + this.host;
        boolean condition$iv22 = this.port != null;
        boolean $i$f$applyIf = false;
        if (condition$iv22) {
            void $this$toDbDialogUrl_u24lambda_u240 = $this$applyIf$iv;
            boolean bl = false;
            string4 = (String)$this$toDbDialogUrl_u24lambda_u240 + ":" + this.port;
        } else {
            string4 = $this$applyIf$iv;
        }
        $this$applyIf$iv = string4;
        CharSequence condition$iv22 = this.pathToDb;
        boolean condition$iv32 = !(condition$iv22 == null || condition$iv22.length() == 0);
        $i$f$applyIf = false;
        if (condition$iv32) {
            void $this$toDbDialogUrl_u24lambda_u241 = $this$applyIf$iv;
            boolean bl = false;
            String string6 = this.pathToDb;
            Intrinsics.checkNotNull((Object)string6);
            string3 = (String)$this$toDbDialogUrl_u24lambda_u241 + "/" + DatabaseUrlParserKt.removePrefixSlashes(string6);
        } else {
            string3 = $this$applyIf$iv;
        }
        $this$applyIf$iv = string3;
        CharSequence condition$iv32 = this.databaseName;
        boolean condition$iv = !(condition$iv32 == null || condition$iv32.length() == 0);
        $i$f$applyIf = false;
        if (condition$iv) {
            void $this$toDbDialogUrl_u24lambda_u242 = $this$applyIf$iv;
            boolean bl = false;
            string2 = (String)$this$toDbDialogUrl_u24lambda_u242 + this.databaseName;
        } else {
            string2 = $this$applyIf$iv;
        }
        $this$applyIf$iv = string2;
        condition$iv = this.parameters != null;
        $i$f$applyIf = false;
        if (condition$iv) {
            void $this$toDbDialogUrl_u24lambda_u243 = $this$applyIf$iv;
            boolean bl = false;
            string = (String)$this$toDbDialogUrl_u24lambda_u243 + this.parameters;
        } else {
            string = string5;
        }
        return string;
    }

    @Override
    @NotNull
    public String dataSourceItemName() {
        CharSequence charSequence = this.databaseName;
        String name = charSequence == null || charSequence.length() == 0 ? "h2-remote" : this.databaseName;
        return name + "@" + this.host;
    }

    @Override
    @Nullable
    public String driverClass() {
        DatabaseDriver databaseDriver = DatabasesKt.findDatabaseDriver(DatabaseType.H2);
        return databaseDriver != null ? databaseDriver.getDriverClass() : null;
    }

    @NotNull
    public final String component1() {
        return this.host;
    }

    @Nullable
    public final Integer component2() {
        return this.port;
    }

    @Nullable
    public final String component3() {
        return this.pathToDb;
    }

    @Nullable
    public final String component4() {
        return this.parameters;
    }

    @Nullable
    public final String component5() {
        return this.databaseName;
    }

    @NotNull
    public final H2TcpDatabaseUrl copy(@NotNull String host, @Nullable Integer port, @Nullable String pathToDb, @Nullable String parameters, @Nullable String databaseName) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return new H2TcpDatabaseUrl(host, port, pathToDb, parameters, databaseName);
    }

    public static /* synthetic */ H2TcpDatabaseUrl copy$default(H2TcpDatabaseUrl h2TcpDatabaseUrl, String string, Integer n, String string2, String string3, String string4, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = h2TcpDatabaseUrl.host;
        }
        if ((n2 & 2) != 0) {
            n = h2TcpDatabaseUrl.port;
        }
        if ((n2 & 4) != 0) {
            string2 = h2TcpDatabaseUrl.pathToDb;
        }
        if ((n2 & 8) != 0) {
            string3 = h2TcpDatabaseUrl.parameters;
        }
        if ((n2 & 0x10) != 0) {
            string4 = h2TcpDatabaseUrl.databaseName;
        }
        return h2TcpDatabaseUrl.copy(string, n, string2, string3, string4);
    }

    @NotNull
    public String toString() {
        return "H2TcpDatabaseUrl(host=" + this.host + ", port=" + this.port + ", pathToDb=" + this.pathToDb + ", parameters=" + this.parameters + ", databaseName=" + this.databaseName + ")";
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result = result * 31 + (this.port == null ? 0 : ((Object)this.port).hashCode());
        result = result * 31 + (this.pathToDb == null ? 0 : this.pathToDb.hashCode());
        result = result * 31 + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = result * 31 + (this.databaseName == null ? 0 : this.databaseName.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof H2TcpDatabaseUrl)) {
            return false;
        }
        H2TcpDatabaseUrl h2TcpDatabaseUrl = (H2TcpDatabaseUrl)other;
        if (!Intrinsics.areEqual((Object)this.host, (Object)h2TcpDatabaseUrl.host)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.port, (Object)h2TcpDatabaseUrl.port)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.pathToDb, (Object)h2TcpDatabaseUrl.pathToDb)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.parameters, (Object)h2TcpDatabaseUrl.parameters)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.databaseName, (Object)h2TcpDatabaseUrl.databaseName);
    }
}

