/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.diff;

import com.intellij.jpa.jpb.model.orm.jpa.JpaOrmFramework;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.ext.intellij.LiquibaseUtils;
import liquibase.ext.intellij.database.IntellijDatabase;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.ForeignKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J=\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lliquibase/ext/intellij/diff/UnexpectedForeignKeyChangeGenerator;", "Lliquibase/diff/output/changelog/core/UnexpectedForeignKeyChangeGenerator;", "<init>", "()V", "getPriority", "", "objectType", "Ljava/lang/Class;", "Lliquibase/structure/DatabaseObject;", "database", "Lliquibase/database/Database;", "fixUnexpected", "", "Lliquibase/change/Change;", "unexpectedObject", "control", "Lliquibase/diff/output/DiffOutputControl;", "referenceDatabase", "comparisonDatabase", "chain", "Lliquibase/diff/output/changelog/ChangeGeneratorChain;", "(Lliquibase/structure/DatabaseObject;Lliquibase/diff/output/DiffOutputControl;Lliquibase/database/Database;Lliquibase/database/Database;Lliquibase/diff/output/changelog/ChangeGeneratorChain;)[Lliquibase/change/Change;", "intellij.liquibase.common"})
public final class UnexpectedForeignKeyChangeGenerator
extends liquibase.diff.output.changelog.core.UnexpectedForeignKeyChangeGenerator {
    public int getPriority(@NotNull Class<? extends DatabaseObject> objectType, @Nullable Database database) {
        Intrinsics.checkNotNullParameter(objectType, (String)"objectType");
        if (ForeignKey.class.isAssignableFrom(objectType)) {
            return 50;
        }
        return -1;
    }

    @NotNull
    public Change[] fixUnexpected(@NotNull DatabaseObject unexpectedObject, @NotNull DiffOutputControl control, @NotNull Database referenceDatabase, @NotNull Database comparisonDatabase, @NotNull ChangeGeneratorChain chain) {
        Intrinsics.checkNotNullParameter((Object)unexpectedObject, (String)"unexpectedObject");
        Intrinsics.checkNotNullParameter((Object)control, (String)"control");
        Intrinsics.checkNotNullParameter((Object)referenceDatabase, (String)"referenceDatabase");
        Intrinsics.checkNotNullParameter((Object)comparisonDatabase, (String)"comparisonDatabase");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Database[] databaseArray = new Database[]{referenceDatabase, comparisonDatabase};
        IntellijDatabase intellijDatabase = LiquibaseUtils.getIntellijDatabase(databaseArray);
        if (intellijDatabase != null && !Intrinsics.areEqual((Object)intellijDatabase.getOrmFramework(), (Object)JpaOrmFramework.INSTANCE)) {
            ForeignKey foreignKey = unexpectedObject instanceof ForeignKey ? (ForeignKey)unexpectedObject : null;
            if (foreignKey == null) {
                return new Change[0];
            }
            ForeignKey fk = foreignKey;
            if (intellijDatabase.findOrmEntityByTableName(fk.getForeignKeyTable().getName()) != null || intellijDatabase.findOrmEntityByTableName(fk.getPrimaryKeyTable().getName()) != null) {
                return new Change[0];
            }
        }
        Change[] changeArray = super.fixUnexpected(unexpectedObject, control, referenceDatabase, comparisonDatabase, chain);
        Intrinsics.checkNotNullExpressionValue((Object)changeArray, (String)"fixUnexpected(...)");
        return changeArray;
    }
}

