/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.intellij.jpa.jpb.model.backend.ed.EntityDesignHelper;
import com.intellij.jpa.jpb.model.backend.ed.indexing.EntitySearch;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.liquibase.ns.PhysicalNamingStrategy;
import com.intellij.jpa.jpb.model.model.BaseEntity;
import com.intellij.jpa.jpb.model.model.CollectionTable;
import com.intellij.jpa.jpb.model.model.CollectionTableAttribute;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.DbIdentifierHelper;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityAttributePsi;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.model.ForeignKeyModel;
import com.intellij.jpa.jpb.model.model.Index;
import com.intellij.jpa.jpb.model.model.JoinTableAttribute;
import com.intellij.jpa.jpb.model.model.MapDatatype;
import com.intellij.jpa.jpb.model.model.MapKeyColumn;
import com.intellij.jpa.jpb.model.model.audit.AuditEntity;
import com.intellij.jpa.jpb.model.orm.jpa.JpaOrmFramework;
import com.intellij.jpa.jpb.model.orm.jpa.model.CustomJpaOrmEntityAttribute;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmEntityAttribute;
import com.intellij.jpa.jpb.model.reference.TableAttributesInfo;
import com.intellij.jpa.jpb.model.service.EnversService;
import com.intellij.jpa.jpb.model.service.JpabGeneratorManager;
import com.intellij.jpa.jpb.model.util.AttributeUtil;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.jpa.jpb.model.util.OrmUtil;
import com.intellij.jpa.jpb.model.util.annotation.JoinColumn;
import com.intellij.jpa.jpb.model.util.annotation.JoinTable;
import com.intellij.liquibase.common.JavaType;
import com.intellij.liquibase.common.LiquibaseElementsNamesHelper;
import com.intellij.liquibase.common.LiquibaseGenerationContext;
import com.intellij.liquibase.common.config.DatabaseMigrationConfig;
import com.intellij.liquibase.common.config.DatabaseMigrationState;
import com.intellij.liquibase.common.ddl.LiquibaseGenerator;
import com.intellij.liquibase.common.ddl.model.JForeignKey;
import com.intellij.liquibase.common.ddl.model.JIndex;
import com.intellij.liquibase.common.ddl.model.JTable;
import com.intellij.liquibase.common.orm.OrmDiffModelProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.util.containers.ContainerUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import liquibase.structure.core.ForeignKeyConstraintType;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiquibaseGeneratorImpl
implements LiquibaseGenerator {
    protected static final Logger log = Logger.getInstance(LiquibaseGeneratorImpl.class);
    public static final int HIBERNATE_LONG_LENGTH = 32600;
    public static final int DEFAULT_ZONE_OFFSET_LENGTH = 6;
    public static final int DEFAULT_INET_ADDRESS_LENGTH = 19;
    protected final Project project;
    protected final JpabGeneratorManager ddlGeneratorManager;
    private final DatabaseMigrationState dbMigrationState;
    protected final DbType dbType;
    protected final LiquibaseGenerationContext context;
    private final EntitySearch entitySearch;
    private final OrmDiffModelProvider ormDiffModelProvider;
    private final LiquibaseElementsNamesHelper liquibaseElementsNamesHelper;

    public LiquibaseGeneratorImpl(Project project, DbType dbType, LiquibaseGenerationContext context) {
        this.project = project;
        this.ddlGeneratorManager = JpabGeneratorManager.getInstance((Project)project);
        this.dbMigrationState = DatabaseMigrationConfig.getInstance(project).getState();
        this.context = context;
        this.dbType = dbType;
        this.entitySearch = EntitySearch.getInstance((Project)project);
        this.ormDiffModelProvider = OrmDiffModelProvider.Companion.getForFramework(context.getOrmFramework());
        this.liquibaseElementsNamesHelper = new LiquibaseElementsNamesHelper(context);
    }

    @Override
    public JavaType getJavaType(@Nullable OrmEntity ormEntity, @NotNull OrmEntityAttribute ormAttribute) {
        if (ormAttribute == null) {
            LiquibaseGeneratorImpl.$$$reportNull$$$0(0);
        }
        return this.ormDiffModelProvider.getJavaType(this.context, ormEntity, ormAttribute);
    }

    @Override
    public String getDefaultValue(@NotNull OrmEntityAttribute attribute) {
        if (attribute == null) {
            LiquibaseGeneratorImpl.$$$reportNull$$$0(1);
        }
        return this.ormDiffModelProvider.getDefaultValue(attribute);
    }

    @NotNull
    private PhysicalNamingStrategy getNamingStrategy() {
        PhysicalNamingStrategy physicalNamingStrategy = PhysicalNamingStrategy.getInstance((Project)this.project);
        if (physicalNamingStrategy == null) {
            LiquibaseGeneratorImpl.$$$reportNull$$$0(2);
        }
        return physicalNamingStrategy;
    }

    protected String toUnderscore(String str) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, str);
    }

    @Override
    public List<JForeignKey> generateCollectionTableConstraints(Entity entity, EntityAttribute attribute) {
        Entity mapKeyEntity;
        Datatype mapKeyType;
        EntityAttributePsi entityAttributePsi;
        if (attribute instanceof EntityAttributePsi && (entityAttributePsi = (EntityAttributePsi)attribute).getEntity().isPersistentEntity() && entityAttributePsi.getEntity().getInheritanceType() == Entity.InheritanceType.TABLE_PER_CLASS && EntityDesignHelper.existPersistentChild((Entity)entityAttributePsi.getEntity(), (Project)this.project)) {
            return Collections.emptyList();
        }
        if (Optional.ofNullable(attribute.getForeignKey()).map(ForeignKeyModel::getNoConstraintMode).orElse(false).booleanValue()) {
            return Collections.emptyList();
        }
        CollectionTable collectionTable = attribute.getCollectionTable(entity);
        if (collectionTable == null) {
            return Collections.emptyList();
        }
        List entityIdAttrs = entity.getIdAttributes();
        if (entityIdAttrs.isEmpty()) {
            return Collections.emptyList();
        }
        String collectionTableName = collectionTable.getName();
        String postfixConstrainName = this.toUnderscore(entity.getClassName());
        String constraintName = this.liquibaseElementsNamesHelper.foreignKeyConstraintName(collectionTableName, Collections.singletonList(postfixConstrainName), attribute);
        PhysicalNamingStrategy namingStrategy = this.getNamingStrategy();
        if (entity instanceof AuditEntity) {
            AuditEntity auditEntity = (AuditEntity)entity;
            return this.generateAuditTableConstraints(auditEntity, collectionTableName);
        }
        JForeignKey foreignKey = new JForeignKey(constraintName, JTable.create(this.project, entity), new JTable(collectionTableName, entity.getCatalog(), namingStrategy.toSchemaName(entity.getSchema())), LiquibaseGeneratorImpl.convertOnDeleteAction(attribute.getOnDeleteAction()));
        foreignKey.getForeignKeyColumns().addAll(ContainerUtil.map((Collection)collectionTable.getJoinColumns(), JoinColumn::getName));
        for (EntityAttribute entityIdAttr : entityIdAttrs) {
            foreignKey.getPrimaryKeyColumns().addAll(entity.getColumnNames(this.project, entityIdAttr));
        }
        ArrayList<JForeignKey> result = new ArrayList<JForeignKey>();
        result.add(foreignKey);
        MapKeyColumn mapKeyColumn = attribute.getMapKeyColumn();
        Datatype attributeType = attribute.getType();
        if (mapKeyColumn != null && attributeType instanceof MapDatatype && (mapKeyType = ((MapDatatype)attributeType).getKeyType()) instanceof Entity && !(mapKeyEntity = (Entity)mapKeyType).isEmbeddable()) {
            postfixConstrainName = this.toUnderscore(mapKeyType.getClassName());
            constraintName = this.liquibaseElementsNamesHelper.foreignKeyConstraintName(collectionTableName, Collections.singletonList(postfixConstrainName), attribute);
            JForeignKey mapKeyForeignKey = new JForeignKey(constraintName, JTable.create(this.project, mapKeyEntity), new JTable(collectionTableName, mapKeyEntity.getCatalog(), namingStrategy.toSchemaName(mapKeyEntity.getSchema())));
            mapKeyForeignKey.getForeignKeyColumns().add(mapKeyColumn.getName());
            for (EntityAttribute entityIdAttr : entityIdAttrs) {
                mapKeyForeignKey.getPrimaryKeyColumns().addAll(mapKeyEntity.getColumnNames(this.project, entityIdAttr));
            }
            result.add(mapKeyForeignKey);
        }
        return result;
    }

    @Override
    public List<JIndex> generateCollectionTableIndexes(String collectionTableName, Entity entity, EntityAttribute attribute) {
        CollectionTable collectionTable = attribute.getCollectionTable(entity);
        if (collectionTable == null) {
            return Collections.emptyList();
        }
        ArrayList<JIndex> result = new ArrayList<JIndex>();
        for (Index index : collectionTable.getIndexes()) {
            if (index.isUnique()) continue;
            result.add(new JIndex(index.getNameNN(collectionTableName), index.isUnique(), ContainerUtil.map((Collection)index.getAttributes(), a -> DbIdentifierHelper.trimEscapeQuotes((String)a, (boolean)false))));
        }
        return result;
    }

    @Override
    public List<JForeignKey> generateJoinTableConstraints(Entity entity, EntityAttribute attribute) {
        List inverseEntityIdAttrs;
        JoinTable joinTable = attribute.getJoinTable(entity);
        Datatype attrType = attribute.isGenericType() && attribute instanceof EntityAttributePsi && entity instanceof EntityPsi ? AttributeUtil.getResolvedGenericAttrType((PsiClass)((EntityPsi)entity).getPsiClass(), (PsiMember)((EntityAttributePsi)attribute).getMember()) : attribute.getType();
        if (!(attrType instanceof Entity)) {
            return Collections.emptyList();
        }
        Entity inverseEntity = (Entity)attrType;
        ArrayList<JForeignKey> constraints = new ArrayList<JForeignKey>();
        Map joinColumnNames = joinTable.getMapJoinColumns();
        PhysicalNamingStrategy namingStrategy = this.getNamingStrategy();
        String processedJoinTableName = namingStrategy.toTableName(joinTable.getName());
        String tableAcronym = processedJoinTableName == null || processedJoinTableName.length() < 10 ? joinTable.getName() : this.liquibaseElementsNamesHelper.getAcronym(LiquibaseGeneratorImpl.prepareJoinTableNameForConstraint(processedJoinTableName), 3);
        boolean itselfAssociation = Objects.equals(entity.getFqn(), inverseEntity.getFqn());
        ArrayList<String> postfixConstrainNames = itselfAssociation ? new ArrayList(joinColumnNames.keySet()) : Collections.singletonList(this.toUnderscore(entity.getClassName()));
        String constraintName = this.liquibaseElementsNamesHelper.foreignKeyConstraintName(tableAcronym, postfixConstrainNames, attribute);
        if (entity instanceof AuditEntity) {
            AuditEntity auditEntity = (AuditEntity)entity;
            return this.generateAuditTableConstraints(auditEntity, processedJoinTableName);
        }
        if (this.isOnlyOneTablePossible(entity) && (joinTable.getForeignKey() == null || !joinTable.getForeignKey().getNoConstraintMode())) {
            JForeignKey foreignKey = new JForeignKey(constraintName, JTable.create(this.project, entity), new JTable(joinTable.getName(), entity.getCatalog(), namingStrategy.toSchemaName(entity.getSchema())), LiquibaseGeneratorImpl.convertOnDeleteAction(attribute.getOnDeleteAction()));
            foreignKey.getForeignKeyColumns().addAll(joinColumnNames.keySet());
            foreignKey.getPrimaryKeyColumns().addAll(joinColumnNames.values());
            constraints.add(foreignKey);
        }
        if (!((inverseEntityIdAttrs = inverseEntity.getIdAttributes()).isEmpty() || !this.isOnlyOneTablePossible(inverseEntity) || joinTable.getInverseForeignKey() != null && joinTable.getInverseForeignKey().getNoConstraintMode())) {
            Map inverseJoinColumns = joinTable.getMapInverseJoinColumns();
            postfixConstrainNames = itselfAssociation ? new ArrayList(inverseJoinColumns.keySet()) : Collections.singletonList(this.toUnderscore(inverseEntity.getClassName()));
            constraintName = this.liquibaseElementsNamesHelper.foreignKeyConstraintName(tableAcronym, postfixConstrainNames, attribute);
            JForeignKey inverseForeignKey = new JForeignKey(constraintName, JTable.create(this.project, inverseEntity), new JTable(joinTable.getName(), entity.getCatalog(), namingStrategy.toSchemaName(entity.getSchema())));
            inverseForeignKey.getForeignKeyColumns().addAll(inverseJoinColumns.keySet());
            inverseForeignKey.getPrimaryKeyColumns().addAll(inverseJoinColumns.values());
            constraints.add(inverseForeignKey);
        }
        return constraints;
    }

    private static String prepareJoinTableNameForConstraint(String joinTableName) {
        String result = joinTableName;
        if (StringUtils.endsWithIgnoreCase((CharSequence)result, (CharSequence)"link")) {
            result = result.substring(0, result.length() - 5);
        }
        return result;
    }

    private List<JForeignKey> generateAuditTableConstraints(AuditEntity entity, String tableName) {
        EnversService enversService = EnversService.Companion.getInstance(this.project);
        String revisionFieldName = enversService.getActualEnversProperties().getRevisionFieldName();
        JForeignKey foreignKey = new JForeignKey(this.liquibaseElementsNamesHelper.foreignKeyConstraintName(tableName, Collections.singletonList(revisionFieldName), null), JTable.create(this.project, enversService.getRevisionEntity()), new JTable(tableName, entity.getCatalog(), this.getNamingStrategy().toSchemaName(entity.getSchema())));
        foreignKey.getPrimaryKeyColumns().add(enversService.getRevisionEntity().getIdAttribute().getColumn(enversService.getRevisionEntity()));
        foreignKey.getForeignKeyColumns().add(revisionFieldName);
        return Collections.singletonList(foreignKey);
    }

    private boolean isOnlyOneTablePossible(Entity entity) {
        if (EntityDesignHelper.getInheritanceType((Entity)entity) != Entity.InheritanceType.TABLE_PER_CLASS) {
            return true;
        }
        long childrenCount = this.entitySearch.getChildProjectEntities(entity.getFqn(), true).stream().filter(EntityUtil::isPersistentEntity).count();
        if (entity.isMappedSuperclass()) {
            return childrenCount == 1L;
        }
        return childrenCount < 1L;
    }

    @Override
    public List<JForeignKey> generateForeignKeysConstraints(@NotNull OrmEntity entity) {
        if (entity == null) {
            LiquibaseGeneratorImpl.$$$reportNull$$$0(3);
        }
        return this.ormDiffModelProvider.getForeignKeys(this.context, entity);
    }

    @Override
    public List<JIndex> generateIndexes(OrmEntity ormEntity) {
        Entity entity = OrmUtil.INSTANCE.getEntityByOrmEntity(ormEntity);
        if (entity == null || Strings.isNullOrEmpty((String)entity.getTable()) || !entity.isPersistentEntity()) {
            return Collections.emptyList();
        }
        ArrayList<JIndex> result = new ArrayList<JIndex>();
        for (Map.Entry<String, LinkedHashSet<String>> entry : LiquibaseGeneratorImpl.getAnnotationIndexes(entity).entrySet()) {
            result.add(new JIndex(entry.getKey(), false, new ArrayList<String>((Collection)entry.getValue())));
        }
        for (Map.Entry<String, LinkedHashSet<String>> entry : this.getUniqueIndexes(entity).entrySet()) {
            result.add(new JIndex(entry.getKey(), true, new ArrayList<String>((Collection)entry.getValue())));
        }
        if (this.dbMigrationState.isCreateIndexForFk() && !(entity instanceof AuditEntity)) {
            List attributes = EntityDesignHelper.getAttributesUseFromTablePerClass((Entity)entity);
            List hierarchyEntities = this.ddlGeneratorManager.getChildEntitiesHierarchyWithSingleTableStrategy(entity);
            for (Entity hierarchyEntity : hierarchyEntities) {
                attributes.addAll(hierarchyEntity.getAttributes());
            }
            attributes.addAll(EntityDesignHelper.getMappedSuperClassAttributes((Entity)entity));
            for (EntityAttribute attr : attributes) {
                if (!this.toCreateForeignKeyIndex(attr) && !attr.isEmbedded()) continue;
                result.addAll(this.generateForeignKeyIndex(entity, attr, null));
            }
        }
        return result;
    }

    private List<JIndex> generateForeignKeyIndex(Entity entity, EntityAttribute refAttr, @Nullable String columnName) {
        if (refAttr.isEmbedded()) {
            ArrayList<JIndex> embeddedIndexes = new ArrayList<JIndex>();
            Map embeddedAttrs = EntityDesignHelper.getInstance((Project)this.project).fetchEmbeddedAttributes(refAttr);
            for (Map.Entry entry : embeddedAttrs.entrySet()) {
                EntityAttribute embeddedAttr = ((EntityDesignHelper.AttributeOverrideStore)entry.getValue()).getAttribute();
                if (!this.toCreateForeignKeyIndex(embeddedAttr) && !embeddedAttr.isEmbedded()) continue;
                List<JIndex> indexes = this.generateForeignKeyIndex(entity, embeddedAttr, (String)entry.getKey());
                embeddedIndexes.addAll(indexes);
            }
            return embeddedIndexes;
        }
        Preconditions.checkNotNull((Object)entity.getTable(), (Object)("Table not found for " + entity.getFqn()));
        List<String> actualColumnNames = LiquibaseGeneratorImpl.getColumnNames(refAttr, columnName);
        String indexName = this.indexName(entity.getClearValidTable(), actualColumnNames).toUpperCase(Locale.ROOT);
        return Collections.singletonList(new JIndex(indexName, refAttr.isUnique(), actualColumnNames));
    }

    private String indexName(String tableName, List<String> columnNames) {
        return this.generateConstraintName("IDX", tableName, "ON", columnNames);
    }

    private static Map<String, LinkedHashSet<String>> getAnnotationIndexes(Entity entity) {
        HashMap<String, LinkedHashSet<String>> annotationIndexes = new HashMap<String, LinkedHashSet<String>>();
        if (StringUtils.isBlank((CharSequence)entity.getTable()) || entity instanceof BaseEntity) {
            return annotationIndexes;
        }
        for (Index idx : entity.getIndexes()) {
            if (idx.isUnique()) continue;
            LinkedHashSet processedAttrs = idx.getAttributes().stream().map(a -> DbIdentifierHelper.trimEscapeQuotes((String)a, (boolean)false)).collect(Collectors.toCollection(LinkedHashSet::new));
            String idxName = idx.getNameNN(entity);
            annotationIndexes.put(idxName, processedAttrs);
        }
        return annotationIndexes;
    }

    @Override
    public List<Index> getUniqueConstraints(String tableName, @Nullable OrmEntity ormEntity, List<OrmEntity> allEntities) {
        return this.ormDiffModelProvider.getUniqueConstraints(this.context, tableName, ormEntity, allEntities);
    }

    protected Map<String, LinkedHashSet<String>> getUniqueIndexes(Entity entity) {
        if (StringUtils.isBlank((CharSequence)entity.getTable())) {
            return Collections.emptyMap();
        }
        HashMap<String, LinkedHashSet<String>> uniqueIndexes = new HashMap<String, LinkedHashSet<String>>();
        boolean isBaseEntity = entity instanceof BaseEntity;
        if (!isBaseEntity) {
            for (Index uc : entity.getIndexes()) {
                if (!uc.isUnique()) continue;
                LinkedHashSet processedAttrs = uc.getAttributes().stream().map(a -> DbIdentifierHelper.trimEscapeQuotes((String)a, (boolean)false)).collect(Collectors.toCollection(LinkedHashSet::new));
                uniqueIndexes.put(uc.getNameNN(entity), processedAttrs);
            }
        }
        return uniqueIndexes;
    }

    @Override
    @Nullable
    public TableAttributesInfo getTableAttributes(@Nullable String schemaName, @NotNull String tableName, List<OrmEntity> entities) {
        OrmEntity entity;
        if (tableName == null) {
            LiquibaseGeneratorImpl.$$$reportNull$$$0(4);
        }
        if ((entity = this.findEntityByTable(schemaName, tableName, entities)) != null) {
            return new TableAttributesInfo(entity, this.ormDiffModelProvider.getColumnAttributes(this.context.getProject(), entity, this.dbType));
        }
        return this.ddlGeneratorManager.getJoinOrCollectionTableAttributesInfo(tableName, ContainerUtil.map(entities, arg_0 -> ((OrmUtil)OrmUtil.INSTANCE).getEntityByOrmEntity(arg_0)), true);
    }

    @Override
    public List<OrmEntityAttribute> getIdAttributes(@NotNull OrmEntity entity) {
        if (entity == null) {
            LiquibaseGeneratorImpl.$$$reportNull$$$0(5);
        }
        return this.ormDiffModelProvider.getIdAttributes(this.context.getProject(), entity);
    }

    @Nullable
    private OrmEntity findEntityByTable(@Nullable String schemaName, @NotNull String tableName, List<OrmEntity> entities) {
        OrmEntity foundEntityBySchema;
        if (tableName == null) {
            LiquibaseGeneratorImpl.$$$reportNull$$$0(6);
        }
        PhysicalNamingStrategy namingStrategy = PhysicalNamingStrategy.getInstance((Project)this.project);
        List theSameTableEntities = ContainerUtil.filter(entities, entity -> DbIdentifierHelper.compareIdentifier((String)tableName, (String)this.ormDiffModelProvider.getTableName((OrmEntity)entity)));
        if (theSameTableEntities.isEmpty()) {
            return null;
        }
        OrmEntity firstEntity = (OrmEntity)theSameTableEntities.iterator().next();
        if (theSameTableEntities.size() == 1) {
            return firstEntity;
        }
        if (this.isAllTablesHaveDiffSchema(namingStrategy, theSameTableEntities) && (foundEntityBySchema = (OrmEntity)StreamEx.of((Collection)theSameTableEntities).findFirst(entity -> {
            String entitySchema = this.ormDiffModelProvider.getSchemaName((OrmEntity)entity);
            if (StringUtil.isEmpty((String)schemaName)) {
                return StringUtil.isEmpty((String)entitySchema) || StringUtil.equalsIgnoreCase((CharSequence)entitySchema, (CharSequence)this.dbType.getDefaultSchema());
            }
            return namingStrategy.compareSchema(entitySchema, schemaName);
        }).orElse(null)) != null) {
            return foundEntityBySchema;
        }
        return StreamEx.of((Collection)theSameTableEntities).findFirst(rootEntity -> theSameTableEntities.stream().filter(childEntity -> {
            String rootFqn;
            String childFqn = Optional.ofNullable(LiquibaseGeneratorImpl.getPsiClassEvenForVirtualEntity(childEntity)).map(it -> it.getQualifiedName()).orElse(null);
            return !Objects.equals(childFqn, rootFqn = (String)Optional.ofNullable(LiquibaseGeneratorImpl.getPsiClassEvenForVirtualEntity(rootEntity)).map(it -> it.getQualifiedName()).orElse(null));
        }).allMatch(childEntity -> {
            PsiClass childPsiClass = LiquibaseGeneratorImpl.getPsiClassEvenForVirtualEntity(childEntity);
            PsiClass rootPsiClass = LiquibaseGeneratorImpl.getPsiClassEvenForVirtualEntity(rootEntity);
            return childPsiClass != null && rootPsiClass != null && childPsiClass.isInheritor(rootPsiClass, true);
        })).orElse(firstEntity);
    }

    private static PsiClass getPsiClassEvenForVirtualEntity(OrmEntity entity) {
        if (entity.getClassPsiPointer() != null) {
            return (PsiClass)entity.getClassPsiPointer().getElement();
        }
        Entity entity2 = OrmUtil.INSTANCE.getEntityByOrmEntity(entity);
        if (entity2 instanceof AuditEntity) {
            AuditEntity auditEntity = (AuditEntity)entity2;
            return auditEntity.getAuditedEntity().getPsiClass();
        }
        return null;
    }

    private boolean isAllTablesHaveDiffSchema(PhysicalNamingStrategy namingStrategy, Collection<OrmEntity> entities) {
        HashSet existSchemaNames = new HashSet();
        return ContainerUtil.and(entities, entity -> existSchemaNames.add(namingStrategy.toSchemaName(StringUtil.nullize((String)this.ormDiffModelProvider.getSchemaName((OrmEntity)entity), (boolean)true))));
    }

    @Override
    public OrmEntityAttribute getAttributeByColumnName(@Nullable OrmEntity ormEntity, Collection<OrmEntityAttribute> tableAttributes, String columnName) {
        if (this.ormDiffModelProvider.getFramework() == JpaOrmFramework.INSTANCE) {
            Entity entity = ormEntity != null ? OrmUtil.INSTANCE.getEntityByOrmEntity(ormEntity) : null;
            List attributes = ContainerUtil.map(tableAttributes, arg_0 -> ((OrmUtil)OrmUtil.INSTANCE).getEntityAttributeByOrmEntityAttributes(arg_0));
            EntityAttribute attribute = this.ddlGeneratorManager.findAttributeByColumnName(entity, (Collection)attributes, columnName);
            return attribute != null ? new CustomJpaOrmEntityAttribute(attribute) : null;
        }
        return this.ormDiffModelProvider.findAttributeByColumnName(this.context.getProject(), ormEntity, tableAttributes, columnName);
    }

    @Override
    @NotNull
    public String generateConstraintName(@Nullable String prefix, @NotNull String tableName, @Nullable String suffix, Collection<String> columnNames) {
        if (tableName == null) {
            LiquibaseGeneratorImpl.$$$reportNull$$$0(7);
        }
        String string = this.liquibaseElementsNamesHelper.generateConstraintName(prefix, tableName, suffix, columnNames);
        if (string == null) {
            LiquibaseGeneratorImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    protected boolean toCreateForeignKeyIndex(EntityAttribute attr) {
        EntityAttribute.Cardinality cardinality = attr.getCardinality();
        return !attr.isTransient() && !attr.isMapsId() && attr.isClass() && (cardinality == EntityAttribute.Cardinality.MANY_TO_ONE || cardinality == EntityAttribute.Cardinality.ONE_TO_ONE && attr.isOwner()) && (cardinality != EntityAttribute.Cardinality.ONE_TO_ONE || attr.getJoinTable() == JoinTable.NULL_ANNOTATION);
    }

    public static List<String> getColumnNames(EntityAttribute attribute, @Nullable String columnName) {
        if (columnName != null) {
            if (attribute != null && attribute.compareColumn(columnName)) {
                columnName = attribute.getDdlManipulationColumn();
            }
            return Collections.singletonList(columnName);
        }
        if (attribute.isCompKeyType()) {
            return new ArrayList<String>(attribute.getJoinColumns().keySet());
        }
        return Collections.singletonList(attribute.getDdlManipulationColumn());
    }

    @Override
    public Map<String, JoinTableAttribute> getJoinTables(Collection<? extends OrmEntity> entities) {
        return this.ormDiffModelProvider.getJoinTables(this.project, entities);
    }

    @Override
    public List<CollectionTableAttribute> getCollectionTables(Collection<? extends OrmEntity> entities) {
        return this.ormDiffModelProvider.getCollectionTables(this.project, entities);
    }

    @Override
    @Nullable
    public JoinTableAttribute findJoinTableAttribute(String tableName, List<OrmEntity> projectEntities) {
        if (this.context.getOrmFramework() == JpaOrmFramework.INSTANCE) {
            return this.ddlGeneratorManager.findJoinTableAttribute(tableName, ContainerUtil.map(projectEntities, arg_0 -> ((OrmUtil)OrmUtil.INSTANCE).getOrmEntityFqn(arg_0)), true);
        }
        return null;
    }

    @Override
    @Nullable
    public CollectionTableAttribute findCollectionTableAttribute(String tableName, List<OrmEntity> projectEntities) {
        if (this.context.getOrmFramework() == JpaOrmFramework.INSTANCE) {
            return this.ddlGeneratorManager.findCollectionTableAttribute(tableName, ContainerUtil.map(projectEntities, arg_0 -> ((OrmUtil)OrmUtil.INSTANCE).getEntityByOrmEntity(arg_0)));
        }
        return null;
    }

    @Override
    public List<EntityAttribute> getCollectionTableAttributes(CollectionTableAttribute tableAttribute) {
        return JpabGeneratorManager.getCollectionTableAttributes((CollectionTableAttribute)tableAttribute, (Project)this.project);
    }

    @Override
    public List<EntityAttribute> getJoinTableAttributes(@NotNull JoinTableAttribute joinTableAttribute) {
        if (joinTableAttribute == null) {
            LiquibaseGeneratorImpl.$$$reportNull$$$0(9);
        }
        return this.ddlGeneratorManager.getJoinTableAttributes(joinTableAttribute);
    }

    @Override
    @Nullable
    public String getColumnDefinition(@Nullable String schemaName, @NotNull String tableName, @NotNull String columnName, List<OrmEntity> entities) {
        TableAttributesInfo tableAttributes;
        if (tableName == null) {
            LiquibaseGeneratorImpl.$$$reportNull$$$0(10);
        }
        if (columnName == null) {
            LiquibaseGeneratorImpl.$$$reportNull$$$0(11);
        }
        if ((tableAttributes = this.getTableAttributes(schemaName, tableName, entities)) == null) {
            return null;
        }
        OrmEntity entity = tableAttributes.getOrmEntity();
        OrmEntityAttribute attribute = this.getAttributeByColumnName(entity, tableAttributes.getOrmAttributes(), columnName);
        if (attribute == null) {
            return null;
        }
        JavaType javaType = this.getJavaType(entity, attribute);
        return javaType.render(this.context);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            LiquibaseGeneratorImpl.$$$reportNull$$$0(12);
        }
        return project;
    }

    public static ForeignKeyConstraintType convertOnDeleteAction(EntityAttribute.OnDeleteAction entityAttributeAction) {
        EntityAttribute.OnDeleteAction onDeleteAction = entityAttributeAction;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"CASCADE", "RESTRICT", "SET_DEFAULT", "SET_NULL"}, (EntityAttribute.OnDeleteAction)onDeleteAction, n)) {
            case -1 -> null;
            case 0 -> ForeignKeyConstraintType.importedKeyCascade;
            case 1 -> ForeignKeyConstraintType.importedKeyRestrict;
            case 2 -> ForeignKeyConstraintType.importedKeySetDefault;
            case 3 -> ForeignKeyConstraintType.importedKeySetNull;
            default -> ForeignKeyConstraintType.importedKeyNoAction;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 8, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ormAttribute";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 2: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/liquibase/common/LiquibaseGeneratorImpl";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "joinTableAttribute";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/liquibase/common/LiquibaseGeneratorImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamingStrategy";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "generateConstraintName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getJavaType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValue";
                break;
            }
            case 2: 
            case 8: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generateForeignKeysConstraints";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTableAttributes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIdAttributes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findEntityByTable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateConstraintName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getJoinTableAttributes";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getColumnDefinition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 8, 12 -> new IllegalStateException(string);
        };
    }
}

