/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.re.ui;

import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityAttributeModel;
import com.intellij.jpa.jpb.model.model.EnumType;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.ui.entity.EntityAttributeContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.re.ui.AttrMappingType;
import com.intellij.re.ui.DbColumnTreeNode;
import com.intellij.re.ui.DbColumnsTable;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.PopupMenuListenerAdapter;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001a\u001a\u00020\u001bH\u0002J4\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0016J\u0012\u0010%\u001a\u00020!2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006("}, d2={"Lcom/intellij/re/ui/MappingTypeTableCellEditor;", "Ljavax/swing/DefaultCellEditor;", "entityPackageName", "", "myContext", "Lcom/intellij/jpa/jpb/model/ui/entity/EntityAttributeContext;", "<init>", "(Ljava/lang/String;Lcom/intellij/jpa/jpb/model/ui/entity/EntityAttributeContext;)V", "getEntityPackageName", "()Ljava/lang/String;", "getMyContext", "()Lcom/intellij/jpa/jpb/model/ui/entity/EntityAttributeContext;", "comboBox", "Ljavax/swing/JComboBox;", "dbColumn", "Lcom/intellij/re/ui/DbColumnTreeNode;", "getDbColumn", "()Lcom/intellij/re/ui/DbColumnTreeNode;", "setDbColumn", "(Lcom/intellij/re/ui/DbColumnTreeNode;)V", "table", "Ljavax/swing/JTable;", "getTable", "()Ljavax/swing/JTable;", "setTable", "(Ljavax/swing/JTable;)V", "updateJavaTypeValue", "", "getTableCellEditorComponent", "Ljava/awt/Component;", "value", "", "isSelected", "", "row", "", "column", "isPotentialEnumType", "attrType", "Lcom/intellij/jpa/jpb/model/model/Datatype;", "intellij.javaee.reverseEngineering"})
@SourceDebugExtension(value={"SMAP\nDbColumnsModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbColumnsModel.kt\ncom/intellij/re/ui/MappingTypeTableCellEditor\n+ 2 SSwingUtil.kt\ncom/intellij/jpa/jpb/model/ui/SSwingUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,801:1\n87#2,5:802\n1563#3:807\n1634#3,3:808\n*S KotlinDebug\n*F\n+ 1 DbColumnsModel.kt\ncom/intellij/re/ui/MappingTypeTableCellEditor\n*L\n565#1:802,5\n668#1:807\n668#1:808,3\n*E\n"})
public final class MappingTypeTableCellEditor
extends DefaultCellEditor {
    @NotNull
    private final String entityPackageName;
    @NotNull
    private final EntityAttributeContext myContext;
    @NotNull
    private final JComboBox<?> comboBox;
    @Nullable
    private DbColumnTreeNode dbColumn;
    @Nullable
    private JTable table;

    public MappingTypeTableCellEditor(@NotNull String entityPackageName, @NotNull EntityAttributeContext myContext) {
        Intrinsics.checkNotNullParameter((Object)entityPackageName, (String)"entityPackageName");
        Intrinsics.checkNotNullParameter((Object)myContext, (String)"myContext");
        super(new JComboBox((ComboBoxModel)new CollectionComboBoxModel(CollectionsKt.emptyList())));
        this.entityPackageName = entityPackageName;
        this.myContext = myContext;
        Component component = this.getComponent();
        Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JComboBox<*>");
        this.comboBox = (JComboBox)component;
        this.comboBox.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.cancelCellEditing();
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.cancelCellEditing();
            }
        });
        ItemSelectable $this$addItemSelectedListener$iv = this.comboBox;
        boolean $i$f$addItemSelectedListener = false;
        $this$addItemSelectedListener$iv.addItemListener(new ItemListener(this){
            final /* synthetic */ MappingTypeTableCellEditor this$0;
            {
                this.this$0 = mappingTypeTableCellEditor;
            }

            public final void itemStateChanged(ItemEvent it) {
                if (it.getStateChange() == 1) {
                    Intrinsics.checkNotNull((Object)it);
                    ItemEvent it2 = it;
                    boolean bl = false;
                    MappingTypeTableCellEditor.access$updateJavaTypeValue(this.this$0);
                }
            }
        });
    }

    @NotNull
    public final String getEntityPackageName() {
        return this.entityPackageName;
    }

    @NotNull
    public final EntityAttributeContext getMyContext() {
        return this.myContext;
    }

    @Nullable
    public final DbColumnTreeNode getDbColumn() {
        return this.dbColumn;
    }

    public final void setDbColumn(@Nullable DbColumnTreeNode dbColumnTreeNode) {
        this.dbColumn = dbColumnTreeNode;
    }

    @Nullable
    public final JTable getTable() {
        return this.table;
    }

    public final void setTable(@Nullable JTable jTable) {
        this.table = jTable;
    }

    private final void updateJavaTypeValue() {
        block8: {
            Object object;
            DbColumnTreeNode dbColumnTreeNode = this.dbColumn;
            if (dbColumnTreeNode == null) {
                return;
            }
            DbColumnTreeNode dbColumnNN = dbColumnTreeNode;
            EntityAttributeModel attribute = dbColumnNN.getAttribute();
            AttrMappingType prevType = dbColumnNN.getAttrMappingType();
            Object object2 = this.comboBox.getSelectedItem();
            AttrMappingType attrMappingType = object2 instanceof AttrMappingType ? (AttrMappingType)((Object)object2) : null;
            if (attrMappingType == null) {
                return;
            }
            AttrMappingType selectedType = attrMappingType;
            if (prevType == selectedType || prevType == null || prevType.isAssociation() && selectedType.isAssociation()) {
                return;
            }
            Datatype attrType = attribute.getType();
            if (selectedType == AttrMappingType.Basic) {
                EntityAttribute entityAttribute;
                object = attrType instanceof Entity ? ((entityAttribute = ((Entity)attrType).getIdAttributeOrNull()) != null && (entityAttribute = entityAttribute.getType()) != null ? entityAttribute.getFqn() : null) : (attrType instanceof EnumType ? (attribute.getEnumType() == EntityAttribute.EnumType.ORDINAL ? Datatypes.BasicDatatype.Integer.getFqn() : Datatypes.BasicDatatype.String.getFqn()) : attrType.getFqn());
            } else if (selectedType == AttrMappingType.Enum) {
                String string = StringUtil.capitalize((String)attribute.getName());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"capitalize(...)");
                Object enumClassName = string;
                if (!StringsKt.endsWith$default((String)enumClassName, (String)"Type", (boolean)false, (int)2, null)) {
                    enumClassName = (String)enumClassName + "Type";
                }
                object = this.entityPackageName + "." + (String)enumClassName;
            } else {
                AttrMappingType[] attrMappingTypeArray = new AttrMappingType[]{AttrMappingType.Reference, AttrMappingType.ManyToOne, AttrMappingType.OneToOne};
                object = CollectionsKt.listOf((Object[])attrMappingTypeArray).contains((Object)selectedType) && attrType instanceof Entity ? ((Entity)attrType).getFqn() : (selectedType.isCompositeId() ? dbColumnNN.getJavaType() : null);
            }
            String newJavaType = object;
            dbColumnNN.setJavaType(newJavaType);
            JTable jTable = this.table;
            if (jTable == null) break block8;
            jTable.updateUI();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Component getTableCellEditorComponent(@Nullable JTable table, @Nullable Object value, boolean isSelected, int row, int column) {
        Object object;
        Object object2 = table instanceof DbColumnsTable ? (DbColumnsTable)((Object)table) : null;
        if (object2 == null || (object2 = object2.getDbColumn(row)) == null) {
            return this.comboBox;
        }
        DbColumnsTable selectedColumn = object2;
        this.table = table;
        EntityAttributeModel attribute = ((DbColumnTreeNode)((Object)selectedColumn)).getAttribute();
        EntityAttribute.MappingType mappingType = attribute.getMappingType();
        EntityAttribute.Cardinality attrCardinality = attribute.getCardinality();
        Object joinColumnsHolder = attribute.getAdditionalProperties().get("joinColumns");
        if (attrCardinality == EntityAttribute.Cardinality.MANY_TO_MANY) {
            object = CollectionsKt.listOf((Object)((Object)AttrMappingType.ManyToMany));
        } else if (attrCardinality == EntityAttribute.Cardinality.ONE_TO_ONE && joinColumnsHolder != null) {
            object = CollectionsKt.listOf((Object)((Object)AttrMappingType.OneToOne));
        } else if (mappingType == EntityAttribute.MappingType.ASSOCIATION) {
            if (joinColumnsHolder == null) {
                AttrMappingType[] $this$getTableCellEditorComponent_u24lambda_u240 = var12_11 = (AttrMappingType[])new ArrayList();
                boolean bl = false;
                if (!attribute.isMapsId()) {
                    $this$getTableCellEditorComponent_u24lambda_u240.add(AttrMappingType.Basic);
                }
                if (this.myContext.getOrmFramework().getMappingFeatures().getSmartBasicTypeReference()) {
                    v2 = $this$getTableCellEditorComponent_u24lambda_u240.add(AttrMappingType.Reference);
                } else {
                    $this$getTableCellEditorComponent_u24lambda_u240.add(AttrMappingType.ManyToOne);
                    v2 = $this$getTableCellEditorComponent_u24lambda_u240.add(AttrMappingType.OneToOne);
                }
                $this$getTableCellEditorComponent_u24lambda_u240.add(AttrMappingType.Todo);
                object = var12_11;
            } else if (((DbColumnTreeNode)((Object)selectedColumn)).getHasRelatedAttr()) {
                object = CollectionsKt.listOf((Object)((Object)((DbColumnTreeNode)((Object)selectedColumn)).getAttrMappingType()));
            } else {
                var12_11 = new AttrMappingType[]{AttrMappingType.OneToMany, AttrMappingType.OneToOne};
                object = CollectionsKt.listOf((Object[])var12_11);
            }
        } else if (attribute.isId() && attribute.isEmbedded()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.myContext.getOrmFramework().getMappingFeatures().getCompositeId();
            boolean $i$f$map = false;
            Iterable bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                OrmFramework.CompositeIdType compositeIdType = (OrmFramework.CompositeIdType)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                    case 1 -> AttrMappingType.IdClass;
                    case 2 -> AttrMappingType.EmbeddedId;
                    default -> throw new NoWhenBranchMatchedException();
                });
            }
            object = (List)destination$iv$iv;
        } else if (attribute.getCollectionType() != null) {
            object = CollectionsKt.listOf((Object)((Object)AttrMappingType.Collection));
        } else if (attribute.isEmbedded()) {
            object = CollectionsKt.listOf((Object)((Object)AttrMappingType.Nested));
        } else {
            AttrMappingType[] $i$f$map = new AttrMappingType[]{AttrMappingType.Basic};
            List basicTypes = CollectionsKt.mutableListOf((Object[])$i$f$map);
            if (!attribute.isId()) {
                Datatype attrType = attribute.getType();
                if (this.isPotentialEnumType(attrType)) {
                    basicTypes.add(AttrMappingType.Enum);
                }
                basicTypes.add(AttrMappingType.Todo);
            }
            object = basicTypes;
        }
        AttrMappingType[] items = object;
        JComboBox<?> jComboBox = this.comboBox;
        Intrinsics.checkNotNull(jComboBox, (String)"null cannot be cast to non-null type javax.swing.JComboBox<com.intellij.re.ui.AttrMappingType>");
        jComboBox.setModel((ComboBoxModel)new CollectionComboBoxModel((List)items));
        Object object3 = value;
        if (object3 == null) {
            object3 = CollectionsKt.firstOrNull((List)items);
        }
        this.comboBox.setSelectedItem(object3);
        this.comboBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<AttrMappingType>(this){
            final /* synthetic */ MappingTypeTableCellEditor this$0;
            {
                this.this$0 = $receiver;
            }

            protected void customizeCellRenderer(JList<? extends AttrMappingType> list, AttrMappingType value, int index, boolean selected, boolean hasFocus) {
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Object object = value;
                if (object == null || (object = object.toLabel(this.this$0.getMyContext().getOrmFramework())) == null) {
                    object = "";
                }
                this.append((String)object);
            }
        });
        return this.comboBox;
    }

    private final boolean isPotentialEnumType(Datatype attrType) {
        if (!(attrType instanceof Datatypes.BasicDatatype)) {
            return false;
        }
        Datatype[] datatypeArray = new Datatype[]{Datatypes.BasicDatatype.String, Datatypes.BasicDatatype.Short, Datatypes.BasicDatatype.Locale, Datatypes.BasicDatatype.Integer, Datatypes.BasicDatatype.Long, Datatypes.BasicDatatype.BigInteger};
        return ((Datatypes.BasicDatatype)attrType).isSame(datatypeArray);
    }

    public static final /* synthetic */ void access$updateJavaTypeValue(MappingTypeTableCellEditor $this) {
        $this.updateJavaTypeValue();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OrmFramework.CompositeIdType.values().length];
            try {
                nArray[OrmFramework.CompositeIdType.FLAT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OrmFramework.CompositeIdType.EMBEDDED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

