/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DbConversionPoints;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.OraNumber2Domain;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.data.types.domain.UnknownDomain;
import com.intellij.database.data.types.domain.ZonedDomain;
import com.intellij.database.util.Version;
import com.intellij.database.util.VersionRange;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class OraDomains
extends BaseDomainRegistry {
    private static final int MAX_CHAR = 2000;
    private static final int MAX_RAW = 2000;
    private static final int MAX_PRECISION = 38;
    private static final int MAX_FRACTION = 9;
    private static final int MAX_VARCHAR = 4000;
    private static final VersionRange ORA_21 = VersionRange.after((Version)Version.of((int[])new int[]{21}));

    public OraDomains() {
        this.add((Domain)new BinaryDomain("raw", ConversionPoint.BINARY, 2000L, 2000L, true, true));
        this.add(new BinaryDomain("blob", ConversionPoint.BLOB, Integer.MAX_VALUE).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new BinaryDomain("long raw", ConversionPoint.BLOB, Integer.MAX_VALUE).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add((Domain)new BinaryDomain("urowid", ConversionPoint.BINARY_ID, 4000L));
        this.add((Domain)new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add((Domain)new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add((Domain)new OraNumber2Domain("number", ConversionPoint.BIG_DECIMAL, 38, 38, true));
        this.add((Domain)new OraNumber2Domain("numeric", ConversionPoint.BIG_DECIMAL, 38, 38, true));
        this.add((Domain)new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, (double)1.4E-45f, 3.4028234663852886E38));
        this.add((Domain)new FloatDomain(this, "binary_float", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38){

            @NotNull
            public Compatibility getCompatibility(@NotNull Domain domain) {
                if (domain == null) {
                    1.$$$reportNull$$$0(0);
                }
                Compatibility compatibility = !StringUtil.equalsIgnoreCase((CharSequence)this.simpleName(), (CharSequence)domain.simpleName()) ? Compatibility.incompatible() : super.getCompatibility(domain);
                if (compatibility == null) {
                    1.$$$reportNull$$$0(1);
                }
                return compatibility;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "domain";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dialects/oracle/OraDomains$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dialects/oracle/OraDomains$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCompatibility";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getCompatibility";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
        this.add((Domain)new FloatDomain(this, "binary_double", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE){

            @NotNull
            public Compatibility getCompatibility(@NotNull Domain domain) {
                if (domain == null) {
                    2.$$$reportNull$$$0(0);
                }
                Compatibility compatibility = !StringUtil.equalsIgnoreCase((CharSequence)this.simpleName(), (CharSequence)domain.simpleName()) ? Compatibility.incompatible() : super.getCompatibility(domain);
                if (compatibility == null) {
                    2.$$$reportNull$$$0(1);
                }
                return compatibility;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "domain";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dialects/oracle/OraDomains$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dialects/oracle/OraDomains$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCompatibility";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getCompatibility";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
        this.add((Domain)new FloatDomain("double precision", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add((Domain)new FloatDomain("float", ConversionPoint.SINGLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add((Domain)new FractionDomain("date", ConversionPoint.TIMESTAMP, 0, -1, false));
        this.add((Domain)new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, 9, 6, true));
        this.add((Domain)new ZonedDomain(new FractionDomain("timestamp with time zone", DbConversionPoints.TIMESTAMP_WITH_TIMEZONE, 9, 6, true), "timestamp"));
        this.add((Domain)new ZonedDomain(new FractionDomain("timestamp with local time zone", DbConversionPoints.TIMESTAMP_WITH_TIMEZONE, 9, 6, true), "timestamp", true));
        this.add(new TextDomain("clob", ConversionPoint.CLOB, Integer.MAX_VALUE).withOperationSupport(OperationSupport.SUPPORTS_LIKE_ONLY));
        this.add(new TextDomain("nclob", ConversionPoint.NTEXT, Integer.MAX_VALUE).withOperationSupport(OperationSupport.SUPPORTS_LIKE_ONLY));
        this.add(new TextDomain("long", ConversionPoint.CLOB, Integer.MAX_VALUE).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new TextDomain("rowid", ConversionPoint.TEXT_ID, 2000L).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new TextDomain("varchar", ConversionPoint.VARCHAR, 4000L, TextDomain.Length.mandatory((long)4000L, (boolean)true)));
        this.add((Domain)new TextDomain("varchar2", ConversionPoint.VARCHAR, 4000L, TextDomain.Length.mandatory((long)4000L, (boolean)true)));
        this.add((Domain)new TextDomain("nvarchar2", ConversionPoint.NVARCHAR, 2000L, TextDomain.Length.mandatory((long)2000L, (boolean)true)));
        this.add((Domain)new TextDomain("char", ConversionPoint.CHAR, 2000L, 1L, true, false));
        this.add((Domain)new TextDomain("nchar", ConversionPoint.NCHAR, 1000L, 1L, true, false));
        this.add(new TextDomain("sys.xmltype", ConversionPoint.XML, Integer.MAX_VALUE).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new TextDomain("xmltype", ConversionPoint.XML, Integer.MAX_VALUE).withOperationSupport(OperationSupport.SUPPORTS_LIKE_ONLY));
        this.add(new SimpleDomain("json", ConversionPoint.JSON).withOperationSupport(OperationSupport.SUPPORTS_LIKE_ONLY).withVersionRange(ORA_21));
        this.add((Domain)new UnknownDomain("bfile"));
        this.add((Domain)new UnknownDomain("uritype"));
    }
}

