/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.JSQuoteUnquotePropertiesIntentionBase;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSQuoteLiteralPropertiesIntention
extends JSQuoteUnquotePropertiesIntentionBase {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        if (project == null) {
            JSQuoteLiteralPropertiesIntention.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            JSQuoteLiteralPropertiesIntention.$$$reportNull$$$0(1);
        }
        String quote = JSCodeStyleSettings.getQuote((PsiElement)element2);
        for (JSProperty property : JSQuoteLiteralPropertiesIntention.collectProperties(element2, editor)) {
            PsiElement identifier = property.getNameIdentifier();
            if (PsiUtilCore.getElementType((PsiElement)identifier) != JSTokenTypes.IDENTIFIER) continue;
            identifier.replace(JSChangeUtil.createTokenElement((PsiElement)property, (IElementType)JSTokenTypes.STRING_LITERAL, (CharSequence)(quote + identifier.getText() + quote)));
        }
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"js.quote.unquote.intention.quote.family", (Object[])new Object[0]);
        if (string == null) {
            JSQuoteLiteralPropertiesIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected String getActionName() {
        return JavaScriptBundle.message((String)"js.quote.unquote.intention.quote", (Object[])new Object[0]);
    }

    @Override
    protected boolean canPerformAction(Collection<? extends JSProperty> properties2, Project project) {
        if (properties2.isEmpty()) {
            return false;
        }
        for (JSProperty jSProperty : properties2) {
            if (PsiUtilCore.getElementType((PsiElement)jSProperty.getNameIdentifier()) != JSTokenTypes.IDENTIFIER) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSQuoteLiteralPropertiesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSQuoteLiteralPropertiesIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

