/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap;

import com.intellij.javascript.debugger.sourcemap.ScriptMappingEntriesInLine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.sourcemap.MappingEntry;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0014\u0010\f\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/GeneratedLocationsCollector;", "", "sourceColumn", "", "<init>", "(I)V", "result", "", "Lcom/intellij/javascript/debugger/sourcemap/ScriptMappingEntriesInLine;", "add", "", "scriptMappings", "addAll", "scriptMappingsList", "", "getLocations", "", "Lorg/jetbrains/debugger/Location;", "vm", "Lorg/jetbrains/debugger/Vm;", "getSourceMappingsForColumn", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "lineMappings", "intellij.javascript.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nSourceMapHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceMapHelper.kt\ncom/intellij/javascript/debugger/sourcemap/GeneratedLocationsCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,251:1\n1374#2:252\n1460#2,2:253\n1563#2:255\n1634#2,3:256\n1462#2,3:259\n*S KotlinDebug\n*F\n+ 1 SourceMapHelper.kt\ncom/intellij/javascript/debugger/sourcemap/GeneratedLocationsCollector\n*L\n49#1:252\n49#1:253,2\n50#1:255\n50#1:256,3\n49#1:259,3\n*E\n"})
final class GeneratedLocationsCollector {
    private final int sourceColumn;
    @NotNull
    private final List<ScriptMappingEntriesInLine> result;

    public GeneratedLocationsCollector(int sourceColumn) {
        this.sourceColumn = sourceColumn;
        this.result = new ArrayList();
    }

    public final void add(@NotNull ScriptMappingEntriesInLine scriptMappings) {
        Intrinsics.checkNotNullParameter((Object)scriptMappings, (String)"scriptMappings");
        this.result.add(scriptMappings);
    }

    public final void addAll(@NotNull Iterable<ScriptMappingEntriesInLine> scriptMappingsList) {
        Intrinsics.checkNotNullParameter(scriptMappingsList, (String)"scriptMappingsList");
        CollectionsKt.addAll((Collection)this.result, scriptMappingsList);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Location> getLocations(@Nullable Vm vm) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.result;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            ScriptMappingEntriesInLine scriptMappingEntries = (ScriptMappingEntriesInLine)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = this.getSourceMappingsForColumn(scriptMappingEntries.getEntries(), this.sourceColumn);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Script script;
                MappingEntry mappingEntry = (MappingEntry)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                Object object = scriptMappingEntries.getScript();
                if (object == null) {
                    Vm vm2 = vm;
                    object = vm2 != null && (vm2 = vm2.getScriptManager()) != null ? vm2.findScriptByUrl(scriptMappingEntries.getUrlOrFromScript()) : null;
                }
                collection.add((script = object) != null ? new Location(script, it.getGeneratedLine(), it.getGeneratedColumn()) : new Location(scriptMappingEntries.getUrlOrFromScript(), it.getGeneratedLine(), it.getGeneratedColumn()));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<MappingEntry> getSourceMappingsForColumn(Iterable<? extends MappingEntry> lineMappings, int sourceColumn) {
        List result = new ArrayList();
        int prevSourceColumn = -1;
        for (MappingEntry mappingEntry : lineMappings) {
            if (mappingEntry.getSourceColumn() > sourceColumn && !((Collection)result).isEmpty()) break;
            if (mappingEntry.getSourceColumn() != prevSourceColumn) {
                result.clear();
                prevSourceColumn = mappingEntry.getSourceColumn();
            }
            result.add(mappingEntry);
        }
        return result;
    }
}

